/*
+-----------------------------------------------------------------------------
|  Project :  GSM-PS (6147)
|  Modul   :  ATI_SRC_TST
+-----------------------------------------------------------------------------
|  Copyright 2002 Texas Instruments Berlin, AG
|                 All rights reserved.
|
|                 This file is confidential and a trade secret of Texas
|                 Instruments Berlin, AG
|                 The receipt of or possession of this file does not convey
|                 any rights to reproduce or disclose its contents or to
|                 manufacture, use, or sell anything it may describe, in
|                 whole, or in part, without the specific written consent of
|                 Texas Instruments Berlin, AG.
+-----------------------------------------------------------------------------
|  Purpose :  this source is used for W32 tests
+-----------------------------------------------------------------------------
*/

#ifdef DTI

#ifndef ATI_SRC_TST_C
#define ATI_SRC_TST_C
#endif

#include "aci_all.h"
/*==== INCLUDES ===================================================*/
#include "line_edit.h"
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"
#include "dti.h"      /* functionality of the dti library */

#include "aci_lst.h"
#include "dti_conn_mng.h"
#ifdef UART
#include "psa_uart.h"
#include "cmh_uart.h"
#endif
#ifdef FF_PSI
#include "psa_psi.h"
#include "cmh_psi.h"
#endif /*FF_PSI*/
#include "aci_io.h"
#include "aci_mem.h"
#include "aci.h"
#include "ati_io.h"

#define  ATI_SRC_TST_GLOBALS
#include "ati_src_tst.h"

#include "sap_dti.h"
#include "ati_int.h"
#ifdef UART
#include "ati_src_uart.h"
#endif
#ifdef FF_PSI
#include "ati_src_psi.h"
#endif /*FF_PSI*/
#ifdef FF_ATI_BAT
#include "ati_bat.h"
#endif /* FF_ATI_BAT */

/*==== CONSTANTS ==================================================*/

/*==== TYPES ======================================================*/

/*==== EXPORT =====================================================*/

/*==== VARIABLES ==================================================*/

/*==== FUNCTIONS ==================================================*/

EXTERN void uart_src_test_sendString (UBYTE *string, USHORT string_len,
                             T_ACI_DTI_PRC     *src_infos,
                             T_ATI_OUTPUT_TYPE output_type);


/*=================================================================*/

/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : ati_src_tst             |
|                                 ROUTINE : ati_src_tst_result_cb   |
+-------------------------------------------------------------------+

  PURPOSE :
*/
GLOBAL void ati_src_tst_result_cb (UBYTE              src_id,
                                   T_ATI_OUTPUT_TYPE  output_type,
                                   UBYTE              *output,
                                   USHORT             output_len)
{
#ifdef UART
  T_ACI_DTI_PRC *src_infos = NULL;
#endif
#ifdef FF_PSI
  T_ACI_DTI_PRC_PSI *src_infos_psi = NULL;
#endif /*FF_PSI*/
  if( output_len EQ 0 )
  {
    /* if length is 0, then do not send (happens if some
     formatting characters, e.g CR or LF have been sent: they are irrelevant
     for this source...) */
    return;
  }

#ifdef RMV_01_04_03
#ifdef FF_TWO_UART_PORTS
  /* disable output to UART on data channel */
  if (src_id EQ UART_DATA_CHANNEL)
  {
    return;
  }
#endif
#endif

#ifdef UART
  src_infos = find_element (uart_src_params, (UBYTE)src_id, cmhUARTtest_srcId);
#endif

#ifdef FF_PSI
  src_infos_psi = find_element (psi_src_params, src_id, cmhPSItest_srcId);
#endif /*FF_PSI*/
#if 0
  if (src_infos EQ NULL)
  {
    TRACE_EVENT_P1("[ERR] uart_src_result_cb: src_id=%d not found", src_id) ;
    return;
  }
#endif

  if (IS_ECHO_OUTPUT (output_type) AND !IS_CONFIRM_OUTPUT (output_type))
  {
    return;
  }
  else
  {
    if(
#ifdef UART
        (src_infos EQ NULL)
#else
        TRUE
#endif
        AND
#ifdef FF_PSI
        (src_infos_psi EQ NULL)
#else
        TRUE
#endif
    )
    {
      PALLOC (aci_cmd_ind, ACI_CMD_IND);

      TRACE_FUNCTION ("ati_src_tst_result_cb ()");

/*    aci_cmd_ind->cmd_len = output_len; */
/*
 * SKA 2002-09-11 to make the TST source V.25 ter compatible, but don't change
 * existing test cases, remove the '\r' which we inserted in aci_aci_cmd_req
 * and reduce the length by one
 */
      if (*(output+output_len-1) EQ '\r')
      {
        *(output+output_len-1) = '\0'; /* remove the '\r' */
        --output_len;
      }

      aci_cmd_ind->cmd_len = output_len;
      strncpy ((CHAR*)aci_cmd_ind->cmd_seq, output, output_len);

      trace_cmd_line ("ATI TST Output", (char *)output, src_id, output_len);

      PSENDX (ACI, aci_cmd_ind);
    }
#ifdef UART
    else if (src_infos NEQ NULL)
    {
      uart_src_test_sendString(output, output_len, src_infos, output_type);
    }
#endif
#ifdef FF_PSI
    else /*PSI src*/
    {
      psi_src_test_sendString(output, output_len, src_infos_psi, output_type);
    }
#endif /*FF_PSI*/
  }
}

/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)       MODULE  : ati_src_tst               |
|                               ROUTINE : ati_src_tst_line_state_cb |
+-------------------------------------------------------------------+

  PURPOSE : register the test source for W32 tests at the ATI
*/
GLOBAL void ati_src_tst_line_state_cb (UBYTE                 src_id,
                                       T_ATI_LINE_STATE_TYPE line_state_type,
                                       ULONG                 line_state_param)
{
  TRACE_FUNCTION ("ati_src_tst_line_state_cb ()");

  switch (line_state_type)
  {
    case ATI_LINE_STATE_OUTPUT_TYPE:
      TRACE_EVENT_P1 ("[DBG] ati_src_tst_line_state_cb (): ATI_LINE_STATE_OUTPUT_TYPE = %d", line_state_param);
      break;

    case ATI_LINE_STATE_DCD:
      TRACE_EVENT_P1 ("[DBG] ati_src_tst_line_state_cb (): ATI_LINE_STATE_DCD = %d", line_state_param);
      break;

    case ATI_LINE_STATE_RNG:  /* TODO */
    {
      T_IO_RING_PARAMS rng_params;

      memcpy (&rng_params, (T_IO_RING_PARAMS*)line_state_param,
              sizeof(T_IO_RING_PARAMS));

      TRACE_EVENT_P1 ("[DBG] ati_src_tst_line_state_cb (): ATI_LINE_STATE_RNG = %d", rng_params.ring_stat);

      break;
    }

    default:
      TRACE_EVENT_P1 ("[WRN] ati_src_tst_line_state_cb (): UNKNOWN line_state_type = %d", line_state_type);
      break;
  }
}


/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : ati_src_tst             |
|                                 ROUTINE : ati_src_tst_init        |
+-------------------------------------------------------------------+

  PURPOSE : register the test source for W32 tests at the ATI
*/

GLOBAL void ati_src_tst_init ( UBYTE cmd_src )
{
  int i;
  static BOOL initialzed = FALSE;
  TRACE_FUNCTION ("ati_src_tst_init ()");

  if (initialzed EQ FALSE)
  {
    for (i=0; i<MAX_TST_SRC; i++)
    {
      tst_src_id[i] = 0;
    }
    initialzed = TRUE;
  }

  tst_src_id[cmd_src - 1] = ati_init (ATI_SRC_TYPE_TST,
                                      ati_src_tst_result_cb,
                                      ati_src_tst_line_state_cb);

  TRACE_EVENT_P1 ("ati_src_tst_init: srcId=%d", tst_src_id[cmd_src - 1]);
#ifndef FF_ATI_BAT
  if (tst_src_id[cmd_src - 1]<CMD_SRC_MAX)
  {
    if (tst_src_id[cmd_src - 1]==CMD_SRC_LCL)
      aci_cmd_src_mode_set(tst_src_id[cmd_src - 1],CMD_MODE_ACI);
    else
      aci_cmd_src_mode_set(tst_src_id[cmd_src - 1],CMD_MODE_ATI);
  }
#endif
  ati_switch_mode(tst_src_id[cmd_src - 1], ATI_CMD_MODE);
}

/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : ati_src_tst             |
|                                 ROUTINE : ati_src_tst_get_src_id  |
+-------------------------------------------------------------------+

  PURPOSE : get the test source for W32 tests at the ATI
*/

GLOBAL UBYTE ati_src_tst_get_src_id ( UBYTE cmd_src )
{

  TRACE_FUNCTION ("ati_src_tst_get_src_id ()");

  if ( cmd_src EQ CMD_SRC_UNKNOWN )
  {
    cmd_src = CMD_SRC_EXT;
    while ( cmd_src < MAX_TST_SRC && tst_src_id[cmd_src - 1] NEQ DTI_MNG_ID_NOTPRESENT )
    {
      cmd_src++;
    }

    if ( cmd_src > MAX_TST_SRC || cmd_src EQ CMD_SRC_UNKNOWN )
    {
      return DTI_MNG_ID_NOTPRESENT;
    }

    ati_src_tst_init( cmd_src );
  }

  return tst_src_id[cmd_src - 1];
}

/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : ati_src_tst             |
|                                 ROUTINE : ati_src_tst_finit       |
+-------------------------------------------------------------------+

  PURPOSE : deregister the test source for W32 tests at the ATI
*/

GLOBAL void ati_src_tst_finit (void)
{
  SHORT i = 0;

  TRACE_FUNCTION ("ati_src_tst_finit ()");

  for ( i = 0; i < MAX_TST_SRC AND tst_src_id[i] NEQ DTI_MNG_ID_NOTPRESENT; i++)
  {
    ati_finit (tst_src_id[i]);
    tst_src_id[i] = DTI_MNG_ID_NOTPRESENT;
  }
}

/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : ati_src_tst             |
|                                 ROUTINE : ati_src_tst_proc_cmd    |
+-------------------------------------------------------------------+

  PURPOSE : for W32 tests
*/

GLOBAL BOOL ati_src_tst_proc_cmd (T_ACI_CMD_REQ *aci_cmd_req)
{
  T_ATI_SRC_PARAMS *src_params = find_element (ati_src_list, tst_src_id[aci_cmd_req->cmd_src - 1], search_ati_src_id);

  if ( tst_src_id[aci_cmd_req->cmd_src - 1] NEQ DTI_MNG_ID_NOTPRESENT )
  {
    /*
     * SKA 2002-09-11 disable echoing, else no test case pass
     * the strange tst_src_id[aci_cmd_req->cmd_src - 1] has to be explained by BRZ
     */
    ati_user_output_cfg[tst_src_id[aci_cmd_req->cmd_src - 1]].atE = 0;

    if (src_params->text_mode EQ CMD_MODE)
    {
      TRACE_FUNCTION ("ati_src_tst_proc_cmd () CMD MODE");

      if (strchr (aci_cmd_req->cmd_seq, '\r'))
      {
        aci_cmd_req->cmd_seq[aci_cmd_req->cmd_len] = '\0';
      }
      else
      {
        aci_cmd_req->cmd_seq[aci_cmd_req->cmd_len] = '\r';     /* make it V.25 ter compatible */
        aci_cmd_req->cmd_seq[(aci_cmd_req->cmd_len) + 1] = '\0';
        aci_cmd_req->cmd_len++;
      }
    }
    else /* text has to be terminated by Ctrl-Z */
    {
      TRACE_FUNCTION ("ati_src_tst_proc_cmd () TEXT MODE");

      if (aci_cmd_req->cmd_seq[aci_cmd_req->cmd_len] NEQ 0x1a)  /* Ctrl-Z */
      {
        aci_cmd_req->cmd_seq[aci_cmd_req->cmd_len] = 0x1a;     /* make it V.25 ter compatible */
        aci_cmd_req->cmd_seq[(aci_cmd_req->cmd_len) + 1] = '\0';
        aci_cmd_req->cmd_len++;
      }
      else
      {
        aci_cmd_req->cmd_seq[aci_cmd_req->cmd_len] = '\0';
      }
    }

    return (ati_execute (tst_src_id[aci_cmd_req->cmd_src - 1],
                         aci_cmd_req->cmd_seq,
                         aci_cmd_req->cmd_len));
  }
  else
  {
    TRACE_EVENT("ATI TST Input: wrong src_id");
    return FALSE;
  }
}


/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : ati_src_tst             |
|                                 ROUTINE : ati_src_tst_abort       |
+-------------------------------------------------------------------+

  PURPOSE : for W32 tests
*/
GLOBAL BOOL ati_src_tst_abort (UBYTE src_id)
{
  TRACE_FUNCTION ("ati_src_tst_abort ()");

  return (ati_abort(tst_src_id[src_id - 1]));
}


/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : ati_src_tst             |
|                                 ROUTINE : ati_src_tst_sendString  |
+-------------------------------------------------------------------+

  PURPOSE : Provides the test-source output over ACI_CMD_IND.
            Removes the separator and generates one ACI_CMD_IND
            for every separated message.

*/
GLOBAL void ati_src_tst_sendString(T_desc2 *data, UBYTE src_id)
{
  CHAR *string, *pch_start, *pch_end;

  TRACE_FUNCTION ("ati_src_tst_sendString ()");

  ACI_MALLOC(string, data->len + 1);
  strncpy(string, data->buffer, data->len);
  string[data->len] = '\0';

  pch_start = string;

  while ( NULL NEQ (pch_end = strchr(pch_start, ATI_TEST_SRC_SEPARATOR)) )
  {
    *pch_end = '\0';

    /* send message to the test interface*/
    {
      PALLOC (aci_cmd_ind, ACI_CMD_IND);

      aci_cmd_ind->cmd_len = strlen(pch_start);
      strncpy ((CHAR*)aci_cmd_ind->cmd_seq, pch_start, aci_cmd_ind->cmd_len);

      trace_cmd_line ("ATI TST Output", pch_start, src_id, aci_cmd_ind->cmd_len);

      PSENDX (ACI, aci_cmd_ind);
    }

    pch_start = pch_end + 1;
  }
  ACI_MFREE(string);
}
#endif /* DTI */
