/* 
+----------------------------------------------------------------------------- 
|  Project :  GSM-PS (6147)
|  Modul   :  ATI_SRC_LC
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  
+----------------------------------------------------------------------------- 
*/ 

#if defined FF_EOTD
#ifndef ATI_SRC_LC_C
#define ATI_SRC_LC_C
#endif

#if defined (SMI)
#define ENTITY_SMI
#elif defined (MFW)
#define ENTITY_MFW
#else
#define ENTITY_ACI
#endif

#define ACI_MEMBER

/*==== INCLUDES ===================================================*/
#if 0
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "typedefs.h"
#include "pconst.cdg"
#include "mconst.cdg"
#include "message.h"
#include "ccdapi.h"
#include "vsi.h"
#include "custom.h"
#include "gsm.h"
#include "prim.h"
#include "cnf_aci.h"
#include "mon_aci.h"
#include "pei.h"
#include "tok.h"
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"

#include "aci_lst.h"
#include "dti_conn_mng.h"
#include "psa_uart.h"
#include "cmh_uart.h"
#include "aci_io.h"
#include "aci_mem.h"
#include "aci.h"
#include "ati_io.h"
#include "ati_src_lc.h"

#include "cmh_lc.h"
#endif

#include "aci_all.h"
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"
#include "dti.h"      /* functionality of the dti library */

#include "aci_lst.h"
#include "dti_conn_mng.h"
#ifdef UART
#include "psa_uart.h"
#include "cmh_uart.h"
#endif
#include "aci_io.h"
#include "aci_mem.h"
#include "aci.h"
#include "ati_io.h"
#include "ati_int.h"

#include "cmh_lc.h"
#include "ati_src_lc.h"

/*==== CONSTANTS ==================================================*/

/*==== TYPES ======================================================*/

/*==== EXPORT =====================================================*/
EXTERN CHAR  *parse(CHAR *b,CHAR *f, ...);
EXTERN T_ACI_LIST *ati_src_list;
/*==== VARIABLES ==================================================*/
LOCAL  BOOL CLPS_flag = FALSE;

/*==== FUNCTIONS ==================================================*/
GLOBAL void ati_src_lc_result_cb (UBYTE              src_id,
                                  T_ATI_OUTPUT_TYPE  output_type,
                                  UBYTE              *output,
                                  USHORT             output_len)
{
  T_ATI_SRC_PARAMS *src_params = 0;
  T_LOC_SERV_PARA *p_lsprm = 0;
  char    orig_addr[MAX_SMS_ADDR_DIG];        /* SMS originating address */
  char    mlc_source_addr[MAX_SMS_ADDR_DIG];  /* Mobile Location Center source address */
  UBYTE *pos_data = 0;
  T_ACI_SM_DATA sms_data;
  UBYTE sms_buf[30];
  static U8 sms_cnt = 0;


  TRACE_FUNCTION ("ati_src_lc_result_cb ()");

  memset (orig_addr, 0, sizeof(orig_addr));
  memset (mlc_source_addr, 0, sizeof(mlc_source_addr));
  p_lsprm = &locServPrm;

  /* search for LC source Id */
  src_params = find_element (ati_src_list, src_id, search_ati_src_id);
  if (src_params EQ NULL)
  {
    TRACE_EVENT ("[ERR] source ID not found");
    return;
  }
  else if( src_params->src_type NEQ ATI_SRC_TYPE_LC)
  {
    TRACE_EVENT ("[ERR] source ID is not from type LC");
    return;
  }
  /* check length of delivered string */
  if( output_len EQ 0 )
    return;

  /*
   * check client id ???
   *
   */


  /*        check E-OTD flag */
  if(location_service_flag EQ TRUE)
  {
      if(!strncmp((char *)output,"+CMT: ",6))
      {
          /* look for MLC source address in LC paramters */
          if (qAT_PlusCLSA(p_lsprm->lc_src_id,mlc_source_addr,NULL) EQ AT_CMPL)
          {/* compare stored MLC source address with SMS originated address */
              if(!strcmp(lc_orig_addr.address,mlc_source_addr))
              {
                   /* immediately position data request */
                   if(sAT_PlusCLPS(p_lsprm->lc_src_id,CLPS_LCS_ACT,lc_orig_addr.address,IMM_POS_DATA_REQ) NEQ AT_EXCT)
                   {
                      TRACE_EVENT ("[ERR] position data request failed");
                   }
                   else
                   {
                     src_params->curAtCmd = AT_CMD_CLPS;
                   }
              }
          }
        }
       else
       { /* CLPS indicates LC position data */
         if(strstr((char *)output,"%CLPS:") NEQ NULL)
         {
              memset(&sms_data.data,0,MAX_SM_LEN);
              memcpy(&sms_data.data,&aci_lc_data.position_data,aci_lc_data.pos_data_length);
                       sms_data.len = aci_lc_data.pos_data_length;

              strncpy((char *)sms_buf, (char *)&sms_data.data, 28);
              sms_buf[28] = 0;
              TRACE_EVENT_P1("SMS before send:%s...", sms_buf);
              TRACE_EVENT_P2("*** #%d SMS to %s", sms_cnt++, p_lsprm->mlcdest.address);


              sAT_PlusCSMP (p_lsprm->lc_src_id, TP_MTI_SMS_SUBMIT | TP_VPF_RELATIVE,
                            0xA7/*TP_VP_RELATIVE_DEFAULT*/, NULL, NULL, SMS_PID_DEFAULT, 0xF4);
#if 0
GLOBAL T_ACI_RETURN sAT_PlusCSMP ( T_ACI_CMD_SRC srcId,
                                   SHORT         fo,
                                   SHORT         vprel,
                                   T_ACI_VP_ABS* vpabs,
                                   SHORT         pid,
                                   SHORT         dcs )
#endif
              if (sAT_PlusCMGF (p_lsprm->lc_src_id, CMGF_MOD_Txt) NEQ AT_CMPL)
              {
                TRACE_ERROR("ati_src_lc_result_cb():[ERR] invalid return for sAT_PlusCMGF");
              }
              if (sAT_PlusCMGS_Gl (p_lsprm->lc_src_id,
                                   p_lsprm->mlcdest.address,
                                   &p_lsprm->mlcdest.toa,
                                   &sms_data,
                                   NULL,
                                   NULL,
                                   NULL,
                                   -1,
                                   NULL,
                                   NULL) NEQ AT_EXCT)
              {
                  TRACE_ERROR ("[ERR] sms position data failed");
              }
              else
              {
                 src_params->curAtCmd = AT_CMD_CMGS;
               }
         }
       }
  } /* E-OTD */
   return;
}


GLOBAL void ati_src_lc_line_state_cb (UBYTE                 src_id,
                                      T_ATI_LINE_STATE_TYPE line_state_type,
                                      ULONG                 line_state_param)
{
  char trcBuf[80];

  TRACE_FUNCTION ("ati_src_lc_line_state_cb ()");

  switch (line_state_type)
  {
    case ATI_LINE_STATE_OUTPUT_TYPE:
      sprintf (trcBuf, "[DBG] ati_src_tst_line_state_cb (): "\
               "ATI_LINE_STATE_OUTPUT_TYPE = %d", line_state_param);
      TRACE_EVENT (trcBuf);
      break;
    default:
      sprintf (trcBuf, "[WRN] ati_src_tst_line_state_cb (): "\
               "UNKNOWN line_state_type = %d", line_state_type);
      TRACE_EVENT (trcBuf);
      break;
  }
}


/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : ati_src_lc              |
|                                 ROUTINE : ati_src_lc_init         |
+-------------------------------------------------------------------+

  PURPOSE : register the location service source
*/

GLOBAL void ati_src_lc_init ( UBYTE cmd_src )
{
  T_LOC_SERV_PARA *lc_para = 0;

  TRACE_FUNCTION ("ati_src_lc_init ()");

  lc_para = &locServPrm;

  /* initialize LC parameters */


  /* register the location service source */
  lc_para->lc_src_id = ati_init (ATI_SRC_TYPE_LC,
                         ati_src_lc_result_cb,
                         ati_src_lc_line_state_cb);

  lclist_init();

  TRACE_EVENT_P1 ("ati_src_lc_init: srcId=%d", lc_para->lc_src_id);
}


/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : ati_src_lc              |
|                                 ROUTINE : ati_src_lc_finit        |
+-------------------------------------------------------------------+

  PURPOSE : deregister the location service source
*/

GLOBAL void ati_src_lc_finit (void)
{
  TRACE_FUNCTION ("ati_src_lc_finit ()");

  ati_finit (locServPrm.lc_src_id);

}



#endif /* FF_EOTD */

