/* 
+----------------------------------------------------------------------------- 
|  Project :  GSM-F&D (8411)
|  Modul   :  ATI
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  AT Command Interpreter: Location service related commands.
+----------------------------------------------------------------------------- 
*/ 

#ifndef ATI_LCS_C
#define ATI_LCS_C

#ifdef FF_EOTD

#undef DUMMY_ATI_STRINGS

#ifdef MFW
#define ENTITY_MFW
#else
#ifdef SMI
#define ENTITY_SMI
#else
#define ENTITY_ACI
#endif
#endif
#define ACI_MEMBER


#if 0
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "typedefs.h"
#include "pconst.cdg"
#include "mconst.cdg"
#include "message.h"
#include "ccdapi.h"
#include "vsi.h"
#include "custom.h"
#include "gsm.h"
#include "prim.h"
#include "cnf_aci.h"
#include "mon_aci.h"
#include "pei.h"
#include "tok.h"
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_io.h"
#include "aci_cmd.h"
#include "l4_tim.h"
#include "psa_uart.h"
#include "ati_io.h"
#include "aci.h"
#include "aci_mem.h"
#endif

#include "aci_all.h"
/*==== INCLUDES ===================================================*/
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"
#include "dti.h"      /* functionality of the dti library */

#include "aci_lst.h"
#include "dti_conn_mng.h"
#ifdef UART
#include "psa_uart.h"
#include "cmh_uart.h"
#endif
#include "aci_io.h"
#include "aci_mem.h"
#include "aci.h"
#include "ati_io.h"
#include "ati_int.h"

EXTERN T_ACI_LIST *ati_src_list;

/*==== EXPORT ==================================================*/
EXTERN CHAR  *cmdCmsError ( T_ACI_CMS_ERR e );
EXTERN CHAR  *cmdExtError (T_ACI_EXT_ERR e);
EXTERN CHAR  *parse(CHAR *b,CHAR *f, ...);

/*==============================================================*/


/*
+--------------------------------------------------------------------+
| PROJECT : GSM-F&D (8411)              MODULE  : ACI_CMD            |
| STATE   : code                        ROUTINE : setatPlusCLSA      |
+--------------------------------------------------------------------+

  PURPOSE : +CLSA command
            for test of location service
            set source and destination addresses of
            Mobile Location Center
*/

GLOBAL T_ATI_RSLT setatPlusCLSA   (char *cl, UBYTE srcId)
{
  T_ACI_RETURN  ret;
  char          mlcs[MAX_SMS_ADDR_DIG]; /* MLC source address */
  char          mlcd[MAX_SMS_ADDR_DIG]; /* MLC destination address */
  memset (mlcs, 0, sizeof(mlcs));
  memset (mlcd, 0, sizeof(mlcd));

  TRACE_FUNCTION("setatPlusCLSA()");

   /* parse source and destination address strings */
   cl = parse(cl,"qq",(LONG)MAX_SMS_ADDR_DIG,mlcs,(LONG)MAX_SMS_ADDR_DIG,mlcd);
   if (!cl OR (mlcs[0] EQ '\0') OR (mlcd[0] EQ '\0'))
   {
      cmdExtError(EXT_ERR_LCS_CmdNotRec);
      return ATI_FAIL;
   }
   /* store source and destination MLC addresses */
   ret=sAT_PlusCLSA(srcId,mlcs,mlcd);
   if (ret EQ AT_FAIL)
   {
     cmdCmeError(CME_ERR_Unknown);
     return ATI_FAIL;
   }

  return ATI_CMPL;
}


/*
+--------------------------------------------------------------------+
| PROJECT : GSM-F&D (8411)              MODULE  : ACI_CMD            |
| STATE   : code                        ROUTINE : queatPlusCLSA      |
+--------------------------------------------------------------------+

  PURPOSE : +CLSA command
            for test of location service
            query source and destination addresses of
            Service Mobile Location Center
*/

GLOBAL T_ATI_RSLT queatPlusCLSA   (char *cl, UBYTE srcId)
{
  char          mlcs[MAX_SMS_ADDR_DIG]; /* MLC source address */
  char          mlcd[MAX_SMS_ADDR_DIG]; /* MLC destination address */
  memset (mlcs, 0, sizeof(mlcs));
  memset (mlcd, 0, sizeof(mlcd));

  TRACE_FUNCTION("queatPlusCLSA()");

  if (qAT_PlusCLSA(srcId,mlcs,mlcd) EQ AT_CMPL)
  {
    sprintf(g_sa,"+CLSA:%s,%s",mlcs,mlcd);

    io_sendMessage(srcId, g_sa, ATI_NORMAL_OUTPUT);
  }
  else
  {
    cmdCmeError(CME_ERR_Unknown);
    return ATI_FAIL;
  }
  return ATI_CMPL;
}

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-F&D (8411)              MODULE  : ACI_CMD            |
| STATE   : code                        ROUTINE : setatPlusCLOM      |
+--------------------------------------------------------------------+

  PURPOSE : +CLOM command
            set feature flag Location Service
            handle list of LC clients
            store list in FFS
*/

GLOBAL T_ATI_RSLT setatPlusCLOM   (char *cl, UBYTE srcId)
{
  T_ACI_RETURN  ret;
  char          client_id[MAX_SMS_ADDR_DIG]; /* Client identifier */
  char          clom_set;

  TRACE_FUNCTION("setatPlusCLOM()");

  memset (client_id, 0, sizeof(client_id));

   /* parse CLOM setting and Client Id (optional) */
   cl = parse(cl,"xq",&clom_set,(LONG)MAX_SMS_ADDR_DIG,client_id);
   if (!cl)
   {
      cmdExtError(EXT_ERR_LCS_CmdNotRec);;
      return ATI_FAIL;
   }
   /* handle settings and store in FFS */
   ret=sAT_PlusCLOM(srcId,clom_set,client_id);
   if (ret EQ AT_FAIL)
   {
     cmdCmeError(CME_ERR_Unknown);
     return ATI_FAIL;
   }

  return ATI_CMPL;
}

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-F&D (8411)              MODULE  : ACI_CMD            |
| STATE   : code                        ROUTINE : queatPlusCLOM      |
+--------------------------------------------------------------------+

  PURPOSE : +CLOM command
            query current Operational Mode settings of
            Location Service
*/
/**************************/
EXTERN T_LOC_SERV_PARA   locServPrm;  /* list of LC clients */
EXTERN BOOL location_service_flag;
EXTERN BOOL eotd_periodic_update_flag;
/**************************/
GLOBAL T_ATI_RSLT queatPlusCLOM   (char *cl, UBYTE srcId)
{
  UBYTE num_clients;
  T_LOC_SERV_PARA *lc_client_list = 0;
  T_LOC_SERV_CLIENT *lc_client = 0;

  TRACE_FUNCTION("queatPlusCLOM()");
TRACE_EVENT_P4("num_client=%d location_service_flag=%d eotd_periodic_update_flag=%d clients=%08x",
                locServPrm.numb_lc_clients,
                location_service_flag,
                eotd_periodic_update_flag,
                locServPrm.clients);
if (locServPrm.clients)
{
  lc_client = locServPrm.clients;
  while (lc_client)
  {
    TRACE_EVENT_P4("client status=%d addr=%s ton=%d npi=%d", lc_client->client_status,
                    lc_client->client_id.address,
                    lc_client->client_id.toa.ton,
                    lc_client->client_id.toa.npi);
    lc_client = lc_client->next;
  }
  lc_client = 0;
}
TRACE_EVENT_P6("SC_sAddr=%s ton=%d npi=%d SC_dAddr=%s ton=%d npi=%d",
                locServPrm.mlcsrc.address,  locServPrm.mlcsrc.toa.ton,  locServPrm.mlcsrc.toa.npi,
                locServPrm.mlcdest.address, locServPrm.mlcdest.toa.ton, locServPrm.mlcdest.toa.npi);

  if (qAT_PlusCLOM(srcId,&num_clients,&lc_client_list) EQ AT_CMPL)
  {
    if(lc_client_list EQ NULL)
    {
        cmdCmeError(CME_ERR_Unknown);
        return ATI_FAIL;
    }
    if(!num_clients) /* list of clients is empty */
    {
        sprintf(g_sa,"+CLOM:%d",num_clients);
        io_sendMessage(srcId, g_sa, ATI_NORMAL_OUTPUT);
    }
    else
    {
        sprintf(g_sa,"+CLOM:%d",num_clients);
        lc_client = lc_client_list->clients;
        io_sendMessage(srcId, g_sa, ATI_NORMAL_OUTPUT);
        memset(g_sa,0,(KEY + 2*MAX_SMS_ADDR_DIG));
        while(num_clients)
        {
          if(lc_client->client_id.toa.ton EQ TON_International)
                sprintf(g_sa,"%d,+%s",lc_client->client_status,lc_client->client_id.address);
          else
               sprintf(g_sa,"%d,%s",lc_client->client_status,lc_client->client_id.address);
          lc_client = lc_client->next;
          io_sendMessage(srcId, g_sa, ATI_NORMAL_OUTPUT);
          memset(g_sa,0,(KEY + 2*MAX_SMS_ADDR_DIG));
          num_clients--;
      }
    }
  }
  else
  {
    cmdCmeError(CME_ERR_Unknown);
    return ATI_FAIL;
  }
  return ATI_CMPL;
}


/*
+--------------------------------------------------------------------+
| PROJECT : GSM-F&D (8411)              MODULE  : ACI_CMD                                  |
| STATE   : code                        ROUTINE : setatPlusCLPS                                     |
+--------------------------------------------------------------------+

  PURPOSE : +CLPS command
            set feature flag Periodic Update Timer
            set timer for specific LC client
            request position data
*/

GLOBAL T_ATI_RSLT setatPlusCLPS   (char *cl, UBYTE srcId)
{
  T_ACI_RETURN  ret;
  char          client_id[MAX_SMS_ADDR_DIG]; /* Client identifier */
  char          clps_set;
  T_ATI_SRC_PARAMS *src_params = find_element (ati_src_list, srcId, search_ati_src_id);
  USHORT         lc_timer = 0;

  TRACE_FUNCTION("setatPlusCLPS()");

  memset (client_id, 0, sizeof(client_id));

   /* parse CLPS setting,Client Id (optional) and Client timer (optional) */
   cl = parse(cl,"xqr",&clps_set,(LONG)MAX_SMS_ADDR_DIG,client_id,&lc_timer);
   if (!cl)
   {
      cmdExtError(EXT_ERR_LCS_CmdNotRec);
      return ATI_FAIL;
   }
   /* handle settings and store in FFS */
   ret=sAT_PlusCLPS(srcId,clps_set,client_id,lc_timer);
   if (ret EQ AT_FAIL)
   {
     cmdCmeError(CME_ERR_Unknown);
     return ATI_FAIL;
   }

  return ATI_CMPL;
}

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-F&D (8411)              MODULE  : ACI_CMD            |
| STATE   : code                        ROUTINE : queatPlusCLPS      |
+--------------------------------------------------------------------+

  PURPOSE : +CLPS command
            query periodic update settings
*/

GLOBAL T_ATI_RSLT queatPlusCLPS   (char *cl, UBYTE srcId)
{
  UBYTE num_clients,num_clients_test,num_per_clients=0;
  T_LOC_SERV_PARA *lc_client_list = 0;
  T_LOC_SERV_CLIENT *lc_client = 0;

  TRACE_FUNCTION("queatPlusCLPS()");

  if (qAT_PlusCLPS(srcId,&num_clients,&lc_client_list) EQ AT_CMPL)
  {
      if(lc_client_list EQ NULL)
      {
          cmdCmeError(CME_ERR_Unknown);
          return ATI_FAIL;
      }
      if(!num_clients) /* list of clients is empty */
      {
        sprintf(g_sa,"+CLPS:%d",num_clients);
        io_sendMessage(srcId, g_sa, ATI_NORMAL_OUTPUT);
      }
      else
      {
          lc_client = lc_client_list->clients;
          num_clients_test = num_clients;
          while(num_clients_test)
          {
              if(lc_client->period_upd_status EQ PERIODIC_UP_ACTIVE)
                  num_per_clients++;
              lc_client = lc_client->next;
              num_clients_test--;
          }

        sprintf(g_sa,"+CLPS:%d",num_per_clients);
        io_sendMessage(srcId, g_sa, ATI_NORMAL_OUTPUT);
        memset(g_sa,0,(KEY + 2*MAX_SMS_ADDR_DIG));
        lc_client = lc_client_list->clients;
        while(num_clients)
        {
          if(lc_client->client_id.toa.ton EQ TON_International)
          {
              if(lc_client->period_upd_status EQ PERIODIC_UP_ACTIVE)
                 sprintf(g_sa,"+%s,%d",lc_client->client_id.address,lc_client->period_upd_value);
          }
          else
          {
              if(lc_client->period_upd_status EQ PERIODIC_UP_ACTIVE)
                 sprintf(g_sa,"%s,%d",lc_client->client_id.address,lc_client->period_upd_value);
          }
          lc_client = lc_client->next;
          io_sendMessage(srcId, g_sa, ATI_NORMAL_OUTPUT);
          memset(g_sa,0,(KEY + 2*MAX_SMS_ADDR_DIG));
          num_clients--;
      }
    }
  }
  else
  {
    cmdCmeError(CME_ERR_Unknown);
    return ATI_FAIL;
  }
  return ATI_CMPL;
}

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-F&D (8411)                                    MODULE  : ACI_CMD            |
| STATE   : code                                                       ROUTINE : setatPlusCLSR      |
+--------------------------------------------------------------------+

  PURPOSE : +CLSR command
                  set user privacy data: notify, confirmation
                  request position data: currently not supported (RM 10-25-02)
                  set up call to client_id and/or to second address:
                  currently not supported (RM 10-25-02)
*/

GLOBAL T_ATI_RSLT setatPlusCLSR   (char *cl, UBYTE srcId)
{
  T_ACI_RETURN  ret;
  char          client_id[MAX_SMS_ADDR_DIG]; /* Client identifier */
  char          clsr_notify;
  char          clsr_confirmation;

  TRACE_FUNCTION("setatPlusCLSR()");

  memset (client_id, 0, sizeof(client_id));

  /* parse CLSR settings: Client notify state, Client confirmation state, Client Id  */
  cl = parse(cl,"xxq",&clsr_notify,&clsr_confirmation,(LONG)MAX_SMS_ADDR_DIG,client_id);
  if (!cl)
  {
    cmdExtError(EXT_ERR_LCS_CmdNotRec);
    return ATI_FAIL;
  }
  /* handle settings and store in FFS */
  ret=sAT_PlusCLSR(srcId,clsr_notify,clsr_confirmation,client_id);
  if (ret EQ AT_FAIL)
  {
    cmdCmeError(CME_ERR_Unknown);
    return ATI_FAIL;
  }
  return ATI_CMPL;
}

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-F&D (8411)              MODULE  : ACI_CMD            |
| STATE   : code                        ROUTINE : queatPlusCLSR      |
+--------------------------------------------------------------------+

  PURPOSE : +CLSR command
            query
*/

GLOBAL T_ATI_RSLT queatPlusCLSR   (char *cl, UBYTE srcId)
{
return ATI_CMPL;
}

#endif /* FF_EOTD */

#endif /* ATI_LCS_C */
