/*
+-----------------------------------------------------------------------------
|  Project :
|  Modul   :  \g23m-aci\aci\ati_bat.h
+-----------------------------------------------------------------------------
|  Copyright 2002 Texas Instruments Berlin, AG
|                 All rights reserved.
|
|                 This file is confidential and a trade secret of Texas
|                 Instruments Berlin, AG
|                 The receipt of or possession of this file does not convey
|                 any rights to reproduce or disclose its contents or to
|                 manufacture, use, or sell anything it may describe, in
|                 whole, or in part, without the specific written consent of
|                 Texas Instruments Berlin, AG.
+-----------------------------------------------------------------------------
|  Purpose :
+-----------------------------------------------------------------------------
*/
#ifndef ATI_BAT_H
#define ATI_BAT_H

#ifdef  ATI_BAT_GLOBALS
#define ATI_BAT_EXT         /* for the owner of a global */
#else
#define ATI_BAT_EXT extern  /* for the user of a global  */
#endif

#ifndef BAT_TYPES_H
#include "bat_types.h"
#endif

#ifdef FF_PSI
#ifndef PSA_PSI_H
#include "psa_psi.h"
#endif
#ifndef CMH_PSI_H
#include "cmh_psi.h"
#endif
#endif /*FF_PSI*/


#define ATI_BAT_MAX_INSTANCES CMD_SRC_MAX
#define ATI_BAT_MAX_CLIENTS 1

typedef struct
{
  T_BAT_instance  inst_hndl;
  T_BAT_client    uns_client_id; /* per instance one unsolicited response id is enough */
  T_BAT_client    client_id[ATI_BAT_MAX_CLIENTS];
  T_ATI_SRC_TYPE  src_type;  /* to figure out TST and UART sources */
} T_ATI_BAT_INSTANCE;

typedef struct
{
  BOOL                bat_lib_initialized;
  T_ATI_BAT_INSTANCE  instance[ATI_BAT_MAX_INSTANCES]; /* a bit overkill, but make it as easy as possible */
  T_BAT_config        config;  /* only one GDD_ACI channel for all ATI sources */
} T_ATI_BAT_GLOBS;


ATI_BAT_EXT T_ATI_BAT_GLOBS ati_bat_globs;

GLOBAL void ati_bat_reset        (void);
GLOBAL void ati_bat_open_client  (U8 src_id);
GLOBAL U16  ati_bat_get_client   (U8 src_id);
GLOBAL void ati_bat_close_client (U8 src_id);
GLOBAL BOOL ati_bat_all_clients_closed (void);
GLOBAL void ati_bat_lib_new      (U8 src_id, T_ATI_SRC_TYPE src_type);
GLOBAL void ati_bat_lib_init     (U8 src_id);
GLOBAL void ati_bat_lib_finit    (void);

#ifdef _SIMULATION_
void ati_bat_response_simulation(T_ACI_BAT_RES *res);
void Perform_ati_bat_maint(UBYTE srcId);
#endif

int Resp_AtOk (T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_AtConnect(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_AtNoCarrierFinal(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_PlusCmeError(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_PlusCmsError(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_AtChannelBusy(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_AtBusy(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_AtNoAnswer(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uAtNoCarrier(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCRING(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCCWV(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentALS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPercentALS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentATR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentBAND(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPercentBAND(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCACM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCAMM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCAOC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCBC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentCBHZ(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPercentCBHZ(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCBST(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentCCBS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCCFC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCCLK(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCCUG(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCCWA(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCCWA_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCDIP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCEER(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCFUN(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentCGAATT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCGACT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCGATT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentCGCLASS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCGCLASS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCGDCONT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCGPADDR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPlusCGPADDR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPercentCGPCO(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentCGPPP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCGQMIN(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCGQREQ(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentCGREG(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCGREG(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCGSMS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPlusCGSMS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPercentCHPL(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPercentCHPL_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCIMI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCIND(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCLAN(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPlusCLAN(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCLCK(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCLIP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCLIP_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCLIR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCLVL(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCLVL(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCMER(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCMGC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCMGL(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPercentCMGL(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCMGL_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCMGR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPercentCMGR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCMGR_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCMGS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCMGW(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCMOD(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCMUT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCMUX(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentCNAP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCNMI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCNUM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCNUM_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCOLP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCOLP_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentCOPS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPercentCOPS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCOPS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPlusCOPS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentCOPS_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPercentCOPS_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPercentCPALS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentCPALS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPercentCPALS_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentCPALS_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCPAS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCPBF(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPlusCPBF(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCPBF_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPlusCPBF_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCPBR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPlusCPBR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCPBR_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPlusCPBR_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentCPBS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCPBS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPlusCPBW(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPlusCPBW_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPercentCPCFU(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentCPHS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCPIN(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentCPINF(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentCPMB(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPercentCPMB(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPercentCPMBW(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPercentCPMBW_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPercentCPMB_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCPMS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCPMS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPercentCPNUMS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPercentCPNUMS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPercentCPNUMS_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPercentCPNUMS_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCPOL(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPlusCPOL(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCPOL_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPlusCPOL_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentCPOPN(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentCPRSM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCPUC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCPUC_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPercentCPVWI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentCREG(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPlusCRES(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCRLP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCRSM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_tPlusCSAS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCSCA(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCSCB(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCSCS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCSIM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCSMS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCSNS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentCSQ(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCSQ(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCSTA(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCSVM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentCTTY(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCTZU(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentCUST(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentSATCC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentDATA(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPercentDINF(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusDS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFAP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFBO(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFBS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFBU(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFCC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFCLASS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFCQ(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFCR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFCS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFCT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFEA(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFFC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFHS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFIE(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFIS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFIT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFLI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFLO(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFLP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFMS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFNS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFPA(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFPI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFPS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFPW(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFRQ(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFSA(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusFSP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusICF(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusIFC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentIMEI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusIPR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentPPP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentPVRF(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentRDL(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentRDLB(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentSATC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPercentSATE(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentSNCNT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusWS46(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPlusCLCC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCGMI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCGMM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCGMR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_sPlusCGSN(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uAtBusy(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uAtNoAnswer(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCBM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCBMI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentCCBS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCCCM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentCCCN(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCCWA(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCCWA_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCCWE(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCDIP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCDS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentCGEV(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCGEV(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentCGREG(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCGREG(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCLAE(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCLAV(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCLIP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCLIP_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCMT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCMTI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCMT_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentCNAP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCOLP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCOLP_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentCPI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentCPI_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentCPRI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentCPROAM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentCPVWI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentCREG(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentCSQ(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCSSI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentCSSN(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCSSU(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentCSTAT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentCTYI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCTZR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentCTZV(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCTZV(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentCTZV_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCUSD(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCUSD_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_PlusExtError(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusFHS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusILRR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentRDL(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentRDLB(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentSATA(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentSATI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentSATN(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentSIMEF(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentSIMINS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentSIMREM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_qPercentPBCF(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPercentSNCNT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);
int Resp_uPlusCDIP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p);

#endif /* ATI_BAT_H */
