/* 
+----------------------------------------------------------------------------- 
|  Project :  GSM-PS (6147)
|  Modul   :  ATI_SRC_TST
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  this source is used for W32 tests
+----------------------------------------------------------------------------- 
*/ 

#include "aci_all.h"
/*==== INCLUDES ===================================================*/
#include "line_edit.h"
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"
#include "dti.h"      /* functionality of the dti library */
#include "cmh_dti.h"

#include "aci_lst.h"
#include "dti_conn_mng.h"
#ifdef UART
#include "psa_uart.h"
#include "cmh_uart.h"
#endif
#ifdef FF_PSI
#include "psa_psi.h"
#include "cmh_psi.h"
#endif /*FF_PSI*/
#include "aci_io.h"
#include "aci_mem.h"
#include "aci.h"
#include "ati_io.h"
#include "sap_dti.h"

#include "ati_int.h"
#ifdef UART
#include "ati_src_uart.h"
#endif
#ifdef FF_PSI
#include "ati_src_psi.h"
#endif /*FF_PSI*/

#ifdef FF_FAX
#include "aci_fd.h"
#endif


#include "aci_bat_cmh.h"
#include "typedefs.h"
#include "gdd.h"
#include "gdd_aci.h"
#include "bat.h"
#include "bat_ctrl.h"
#include "bat_intern.h"
#include "cmh_sms.h"
#ifdef GPRS
#include "gaci_cmh.h"
#include "gaci_cmd.h"
#endif
#include "aci_bat.h"
#include "aci_bat_cb.h"

#define  ATI_BAT_GLOBALS
#include "ati_bat.h"

#include "cphs.h"
#include "aci_cphs.h"

#ifdef _SIMULATION_
#include "gdd_aci.h"
#endif


#define MAX_CEER_DESC_LTH (50)
#define MAGIC_EMPTY_APN "\x0ff" 
#define BAT_BIT_12 0x1000
#define HIGHEST_BAND_SUPPORTED (0x1F)

/*==== EXTERNS ==================================================*/

EXTERN CHAR  *cmdExtError (T_ACI_EXT_ERR e);
EXTERN void psi_InitCmdStruct (T_ACI_DTI_PRC_PSI *cmd_struct);
EXTERN void getCeerDesc(USHORT cause, char *desc);
EXTERN T_CAP_ID map_dti_cpblty (UBYTE dti_cpblty);

EXTERN void rCI_PercentCCCN ( T_ACI_FAC_DIR tDirection,
                              SHORT         cId,
                              T_fac_inf    *fie );

#ifdef SIM_TOOLKIT
EXTERN UBYTE sat[CMD_SRC_MAX];
#endif

EXTERN const T_CAP_NAME ati_cap_name[];
EXTERN UBYTE            cpmsCallType;

LOCAL const SMS_Memory sms_mem [] =

{
  {"ME",  SMS_STOR_Me},
  {"me",  SMS_STOR_Me},
  {"SM",  SMS_STOR_Sm},
  {"sm",  SMS_STOR_Sm},
  {0,0}
};

/*==== TYPES ======================================================*/
typedef struct
{
  int (*fptr)(T_ACI_DTI_PRC_PSI  *src_infos_psi,
              T_BAT_cmd_response *resp_p);     /* BAT Response wrapper func */
} BATResponse;

/*==== VARIABLES ==================================================*/

LOCAL BOOL cops_flag=FALSE;
LOCAL BOOL CLCC_flag=FALSE;
LOCAL CHAR *clan_buf=NULL;


#ifdef FF_ATI
  #define RSP_ATI(rspFoo) {Resp_##rspFoo}
#else
  #define RSP_ATI(rspFoo) {0}
#endif

#ifdef FAX_AND_DATA
  #define RSP_FAD(rspFoo) {Resp_##rspFoo}
#else
  #define RSP_FAD(rspFoo) {0}
#endif

#ifdef SIM_TOOLKIT
  #define RSP_STK(rspFoo) {Resp_##rspFoo}
#else
  #define RSP_STK(rspFoo) {0}
#endif

#ifdef GPRS
  #define RSP_GPR(rspFoo) {Resp_##rspFoo}
#else
  #define RSP_GPR(rspFoo) {0}
#endif

static BATResponse ResponseTab[] =
{
  RSP_ATI(AtOk),                     /* BAT_RES_AT_OK                  = 0x0,  */
  RSP_ATI(AtConnect),                /* BAT_RES_AT_CONNECT             = 0x1,  */
  RSP_ATI(AtNoCarrierFinal),         /* BAT_RES_AT_NO_CARRIER_FINAL    = 0x2,  */
  RSP_ATI(PlusCmeError),             /* BAT_RES_PLUS_CME_ERROR         = 0x3,  */
  RSP_ATI(PlusCmsError),             /* BAT_RES_PLUS_CMS_ERROR         = 0x4,  */
  RSP_ATI(AtBusy),                   /* BAT_RES_AT_BUSY                = 0x5,  */
  RSP_ATI(AtChannelBusy),            /* BAT_RES_AT_CHANNEL_BUSY        = 0x6,  */
  RSP_ATI(AtNoAnswer),               /* BAT_RES_AT_NO_ANSWER           = 0x7,  */
  RSP_ATI(PlusExtError),             /* BAT_RES_PLUS_EXT_ERROR         = 0x8,  */
  RSP_ATI(qPercentALS),              /* BAT_RES_QUE_PERCENT_ALS        = 0x9,  */
  RSP_ATI(tPercentALS),              /* BAT_RES_TST_PERCENT_ALS        = 0xa,  */
  RSP_ATI(qPercentATR),              /* BAT_RES_QUE_PERCENT_ATR        = 0xb,  */
  RSP_ATI(qPercentBAND),             /* BAT_RES_QUE_PERCENT_BAND       = 0xc,  */
  RSP_ATI(tPercentBAND),             /* BAT_RES_TST_PERCENT_BAND       = 0xd,  */
  RSP_ATI(qPlusCACM),                /* BAT_RES_QUE_PLUS_CACM          = 0xe,  */
  RSP_ATI(qPlusCAMM),                /* BAT_RES_QUE_PLUS_CAMM          = 0xf,  */
  RSP_ATI(sPlusCAOC),                /* BAT_RES_SET_PLUS_CAOC          = 0x10, */
  RSP_ATI(sPlusCBC),                 /* BAT_RES_SET_PLUS_CBC           = 0x11, */
  RSP_ATI(qPercentCBHZ),             /* BAT_RES_QUE_PERCENT_CBHZ       = 0x12, */
  RSP_ATI(tPercentCBHZ),             /* BAT_RES_TST_PERCENT_CBHZ       = 0x13, */
  RSP_ATI(qPlusCBST),                /* BAT_RES_QUE_PLUS_CBST          = 0x14, */
  RSP_ATI(qPercentCCBS),             /* BAT_RES_QUE_PERCENT_CCBS       = 0x15, */
  RSP_ATI(sPlusCCFC),                /* BAT_RES_SET_PLUS_CCFC          = 0x16, */
  RSP_ATI(qPlusCCLK),                /* BAT_RES_QUE_PLUS_CCLK          = 0x17, */
  RSP_ATI(qPlusCCUG),                /* BAT_RES_QUE_PLUS_CCUG          = 0x18, */
  RSP_ATI(sPlusCCWA),                /* BAT_RES_SET_PLUS_CCWA          = 0x19, */
  RSP_ATI(sPlusCCWA_W),              /* BAT_RES_SET_PLUS_CCWA_W        = 0x1a, */
  RSP_ATI(sPlusCEER),                /* BAT_RES_SET_PLUS_CEER          = 0x1b, */
  RSP_ATI(qPlusCFUN),                /* BAT_RES_QUE_PLUS_CFUN          = 0x1c, */
  RSP_GPR(qPercentCGAATT),           /* BAT_RES_QUE_PERCENT_CGAATT     = 0x1d, */
  RSP_GPR(qPlusCGACT),               /* BAT_RES_QUE_PLUS_CGACT         = 0x1e, */
  RSP_GPR(qPlusCGATT),               /* BAT_RES_QUE_PLUS_CGATT         = 0x1f, */
  RSP_GPR(qPercentCGCLASS),          /* BAT_RES_QUE_PERCENT_CGCLASS    = 0x20, */
  RSP_GPR(qPlusCGCLASS),             /* BAT_RES_QUE_PLUS_CGCLASS       = 0x21, */
  RSP_GPR(qPlusCGDCONT),             /* BAT_RES_QUE_PLUS_CGDCONT       = 0x22, */
  RSP_GPR(sPlusCGPADDR),             /* BAT_RES_SET_PLUS_CGPADDR       = 0x23, */
  RSP_GPR(tPlusCGPADDR),             /* BAT_RES_TST_PLUS_CGPADDR       = 0x24, */
  RSP_GPR(sPercentCGPCO),            /* BAT_RES_SET_PERCENT_CGPCO      = 0x25, */
  RSP_GPR(qPercentCGPPP),            /* BAT_RES_QUE_PERCENT_CGPPP      = 0x26, */
  RSP_GPR(qPlusCGQMIN),              /* BAT_RES_QUE_PLUS_CGQMIN        = 0x27, */
  RSP_GPR(qPlusCGQREQ),              /* BAT_RES_QUE_PLUS_CGQREQ        = 0x28, */
  RSP_GPR(qPercentCGREG),            /* BAT_RES_QUE_PERCENT_CGREG      = 0x29, */
  RSP_GPR(qPlusCGREG),               /* BAT_RES_QUE_PLUS_CGREG         = 0x2a, */
  RSP_GPR(qPlusCGSMS),               /* BAT_RES_QUE_PLUS_CGSMS         = 0x2b, */
  RSP_ATI(sPercentCHPL),             /* BAT_RES_SET_PERCENT_CHPL       = 0x2c, */
  RSP_ATI(sPercentCHPL_W),           /* BAT_RES_SET_PERCENT_CHPL_W     = 0x2d, */
  RSP_ATI(sPlusCIMI),                /* BAT_RES_SET_PLUS_CIMI          = 0x2e, */
  RSP_ATI(qPlusCIND),                /* BAT_RES_QUE_PLUS_CIND          = 0x2f, */
  RSP_ATI(qPlusCLAN),                /* BAT_RES_QUE_PLUS_CLAN          = 0x30, */
  RSP_ATI(tPlusCLAN),                /* BAT_RES_TST_PLUS_CLAN          = 0x31, */
  RSP_ATI(qPlusCLCC),                /* BAT_RES_QUE_PLUS_CLCC          = 0x32, */
  RSP_ATI(sPlusCLCK),                /* BAT_RES_SET_PLUS_CLCK          = 0x33, */
  RSP_ATI(qPlusCLIP),                /* BAT_RES_QUE_PLUS_CLIP          = 0x34, */
  RSP_ATI(qPlusCLIP_W),              /* BAT_RES_QUE_PLUS_CLIP_W        = 0x35, */
  RSP_ATI(qPlusCLIR),                /* BAT_RES_QUE_PLUS_CLIR          = 0x36, */
  RSP_ATI(sPlusCLVL),                /* BAT_RES_SET_PLUS_CLVL          = 0x37, */
  RSP_ATI(qPlusCLVL),                /* BAT_RES_QUE_PLUS_CLVL          = 0x38, */
  RSP_ATI(qPlusCMER),                /* BAT_RES_QUE_PLUS_CMER          = 0x39, */
  RSP_ATI(sPlusCMGC),                /* BAT_RES_SET_PLUS_CMGC          = 0x3a, */
  RSP_ATI(sPlusCMGL),                /* BAT_RES_SET_PLUS_CMGL          = 0x3b, */
  RSP_ATI(sPlusCMGL_W),              /* BAT_RES_SET_PLUS_CMGL_W        = 0x3c, */
  RSP_ATI(sPlusCMGR),                /* BAT_RES_SET_PLUS_CMGR          = 0x3d, */
  RSP_ATI(sPlusCMGR_W),              /* BAT_RES_SET_PLUS_CMGR_W        = 0x3e, */
  RSP_ATI(sPlusCMGS),                /* BAT_RES_SET_PLUS_CMGS          = 0x3f, */
  RSP_ATI(sPlusCMGW),                /* BAT_RES_SET_PLUS_CMGW          = 0x40, */
  RSP_ATI(qPlusCMOD),                /* BAT_RES_QUE_PLUS_CMOD          = 0x41, */
  RSP_ATI(qPlusCMUT),                /* BAT_RES_QUE_PLUS_CMUT          = 0x42, */
  RSP_ATI(qPlusCMUX),                /* BAT_RES_QUE_PLUS_CMUX          = 0x43, */
  RSP_ATI(qPercentCNAP),             /* BAT_RES_QUE_PERCENT_CNAP       = 0x44, */
  RSP_ATI(qPlusCNMI),                /* BAT_RES_QUE_PLUS_CNMI          = 0x45, */
  RSP_ATI(sPlusCNUM),                /* BAT_RES_SET_PLUS_CNUM          = 0x46, */
  RSP_ATI(sPlusCNUM_W),              /* BAT_RES_SET_PLUS_CNUM_W        = 0x47, */
  RSP_ATI(qPlusCOLP),                /* BAT_RES_QUE_PLUS_COLP          = 0x48, */
  RSP_ATI(qPlusCOLP_W),              /* BAT_RES_QUE_PLUS_COLP_W        = 0x49, */
  RSP_ATI(qPercentCOPS),             /* BAT_RES_QUE_PERCENT_COPS       = 0x4a, */
  RSP_ATI(tPercentCOPS),             /* BAT_RES_TST_PERCENT_COPS       = 0x4b, */
  RSP_ATI(qPlusCOPS),                /* BAT_RES_QUE_PLUS_COPS          = 0x4c, */
  RSP_ATI(tPlusCOPS),                /* BAT_RES_TST_PLUS_COPS          = 0x4d, */
  RSP_ATI(qPercentCOPS_W),           /* BAT_RES_QUE_PERCENT_COPS_W     = 0x4e, */
  RSP_ATI(tPercentCOPS_W),           /* BAT_RES_TST_PERCENT_COPS_W     = 0x4f, */
  RSP_ATI(sPercentCPALS),            /* BAT_RES_SET_PERCENT_CPALS      = 0x50, */
  RSP_ATI(qPercentCPALS),            /* BAT_RES_QUE_PERCENT_CPALS      = 0x51, */
  RSP_ATI(sPercentCPALS_W),          /* BAT_RES_SET_PERCENT_CPALS_W    = 0x52, */
  RSP_ATI(qPercentCPALS_W),          /* BAT_RES_QUE_PERCENT_CPALS_W    = 0x53, */
  RSP_ATI(sPlusCPAS),                /* BAT_RES_SET_PLUS_CPAS          = 0x54, */
  RSP_ATI(sPlusCPBF),                /* BAT_RES_SET_PLUS_CPBF          = 0x55, */
  RSP_ATI(tPlusCPBF),                /* BAT_RES_TST_PLUS_CPBF          = 0x56, */
  RSP_ATI(sPlusCPBF_W),              /* BAT_RES_SET_PLUS_CPBF_W        = 0x57, */
  RSP_ATI(tPlusCPBF_W),              /* BAT_RES_TST_PLUS_CPBF_W        = 0x58, */
  RSP_ATI(sPlusCPBR),                /* BAT_RES_SET_PLUS_CPBR          = 0x59, */
  RSP_ATI(tPlusCPBR),                /* BAT_RES_TST_PLUS_CPBR          = 0x5a, */
  RSP_ATI(sPlusCPBR_W),              /* BAT_RES_SET_PLUS_CPBR_W        = 0x5b, */
  RSP_ATI(tPlusCPBR_W),              /* BAT_RES_TST_PLUS_CPBR_W        = 0x5c, */
  RSP_ATI(qPercentCPBS),             /* BAT_RES_QUE_PERCENT_CPBS       = 0x5d, */
  RSP_ATI(qPlusCPBS),                /* BAT_RES_QUE_PLUS_CPBS          = 0x5e, */
  RSP_ATI(tPlusCPBW),                /* BAT_RES_TST_PLUS_CPBW          = 0x5f, */
  RSP_ATI(tPlusCPBW_W),              /* BAT_RES_TST_PLUS_CPBW_W        = 0x60, */
  RSP_ATI(sPercentCPCFU),            /* BAT_RES_SET_PERCENT_CPCFU      = 0x61, */
  RSP_ATI(qPercentCPHS),             /* BAT_RES_QUE_PERCENT_CPHS       = 0x62, */
  RSP_ATI(qPlusCPIN),                /* BAT_RES_QUE_PLUS_CPIN          = 0x63, */
  RSP_ATI(qPercentCPINF),            /* BAT_RES_QUE_PERCENT_CPINF      = 0x64, */
  RSP_ATI(sPercentCPMB),             /* BAT_RES_SET_PERCENT_CPMB       = 0x65, */
  RSP_ATI(qPercentCPMB),             /* BAT_RES_QUE_PERCENT_CPMB       = 0x66, */
  RSP_ATI(tPercentCPMBW),            /* BAT_RES_TST_PERCENT_CPMBW      = 0x67, */
  RSP_ATI(tPercentCPMBW_W),          /* BAT_RES_TST_PERCENT_CPMBW_W    = 0x68, */
  RSP_ATI(sPercentCPMB_W),           /* BAT_RES_SET_PERCENT_CPMB_W     = 0x69, */
  RSP_ATI(sPlusCPMS),                /* BAT_RES_SET_PLUS_CPMS          = 0x6a, */
  RSP_ATI(qPlusCPMS),                /* BAT_RES_QUE_PLUS_CPMS          = 0x6b, */
  RSP_ATI(sPercentCPNUMS),           /* BAT_RES_SET_PERCENT_CPNUMS     = 0x6c, */
  RSP_ATI(tPercentCPNUMS),           /* BAT_RES_TST_PERCENT_CPNUMS     = 0x6d, */
  RSP_ATI(sPercentCPNUMS_W),         /* BAT_RES_SET_PERCENT_CPNUMS_W   = 0x6e, */
  RSP_ATI(tPercentCPNUMS_W),         /* BAT_RES_TST_PERCENT_CPNUMS_W   = 0x6f, */
  RSP_ATI(qPlusCPOL),                /* BAT_RES_QUE_PLUS_CPOL          = 0x70, */
  RSP_ATI(tPlusCPOL),                /* BAT_RES_TST_PLUS_CPOL          = 0x71, */
  RSP_ATI(qPlusCPOL_W),              /* BAT_RES_QUE_PLUS_CPOL_W        = 0x72, */
  RSP_ATI(tPlusCPOL_W),              /* BAT_RES_TST_PLUS_CPOL_W        = 0x73, */
  RSP_ATI(qPercentCPOPN),            /* BAT_RES_QUE_PERCENT_CPOPN      = 0x74, */
  RSP_ATI(qPercentCPRSM),            /* BAT_RES_QUE_PERCENT_CPRSM      = 0x75, */
  RSP_ATI(qPlusCPUC),                /* BAT_RES_QUE_PLUS_CPUC          = 0x76, */
  RSP_ATI(qPlusCPUC_W),              /* BAT_RES_QUE_PLUS_CPUC_W        = 0x77, */
  RSP_ATI(sPercentCPVWI),            /* BAT_RES_SET_PERCENT_CPVWI      = 0x78, */
  RSP_ATI(qPercentCREG),             /* BAT_RES_QUE_PERCENT_CREG       = 0x79, */
  RSP_ATI(tPlusCRES),                /* BAT_RES_TST_PLUS_CRES          = 0x7a, */
  RSP_ATI(qPlusCRLP),                /* BAT_RES_QUE_PLUS_CRLP          = 0x7b, */
  RSP_ATI(sPlusCRSM),                /* BAT_RES_SET_PLUS_CRSM          = 0x7c, */
  RSP_ATI(tPlusCSAS),                /* BAT_RES_TST_PLUS_CSAS          = 0x7d, */
  RSP_ATI(qPlusCSCA),                /* BAT_RES_QUE_PLUS_CSCA          = 0x7e, */
  RSP_ATI(qPlusCSCB),                /* BAT_RES_QUE_PLUS_CSCB          = 0x7f, */
  RSP_ATI(qPlusCSCS),                /* BAT_RES_QUE_PLUS_CSCS          = 0x80, */
  RSP_ATI(sPlusCSIM),                /* BAT_RES_SET_PLUS_CSIM          = 0x81, */
  RSP_ATI(qPlusCSMS),                /* BAT_RES_QUE_PLUS_CSMS          = 0x82, */
  RSP_ATI(qPlusCSNS),                /* BAT_RES_QUE_PLUS_CSNS          = 0x83, */
  RSP_ATI(qPercentCSQ),              /* BAT_RES_QUE_PERCENT_CSQ        = 0x84, */
  RSP_ATI(sPlusCSQ),                 /* BAT_RES_SET_PLUS_CSQ           = 0x85, */
  RSP_ATI(qPlusCSTA),                /* BAT_RES_QUE_PLUS_CSTA          = 0x86, */
  RSP_ATI(qPlusCSVM),                /* BAT_RES_QUE_PLUS_CSVM          = 0x87, */
  RSP_ATI(qPercentCTTY),             /* BAT_RES_QUE_PERCENT_CTTY       = 0x88, */
  RSP_ATI(qPlusCTZU),                /* BAT_RES_QUE_PLUS_CTZU          = 0x89, */
  RSP_ATI(qPercentCUST),             /* BAT_RES_QUE_PERCENT_CUST       = 0x8a, */
  RSP_ATI(qPercentDATA),             /* BAT_RES_QUE_PERCENT_DATA       = 0x8b, */
  RSP_ATI(sPercentDINF),             /* BAT_RES_SET_PERCENT_DINF       = 0x8c, */
  RSP_FAD(qPlusDS),                  /* BAT_RES_QUE_PLUS_DS            = 0x8d, */
  RSP_FAD(qPlusFAP),                 /* BAT_RES_QUE_PLUS_FAP           = 0x8e, */
  RSP_FAD(qPlusFBO),                 /* BAT_RES_QUE_PLUS_FBO           = 0x8f, */
  RSP_FAD(qPlusFBS),                 /* BAT_RES_QUE_PLUS_FBS           = 0x90, */
  RSP_FAD(qPlusFBU),                 /* BAT_RES_QUE_PLUS_FBU           = 0x91, */
  RSP_FAD(qPlusFCC),                 /* BAT_RES_QUE_PLUS_FCC           = 0x92, */
  RSP_FAD(qPlusFCLASS),              /* BAT_RES_QUE_PLUS_FCLASS        = 0x93, */
  RSP_FAD(qPlusFCQ),                 /* BAT_RES_QUE_PLUS_FCQ           = 0x94, */
  RSP_FAD(qPlusFCR),                 /* BAT_RES_QUE_PLUS_FCR           = 0x95, */
  RSP_FAD(qPlusFCS),                 /* BAT_RES_QUE_PLUS_FCS           = 0x96, */
  RSP_FAD(qPlusFCT),                 /* BAT_RES_QUE_PLUS_FCT           = 0x97, */
  RSP_FAD(qPlusFEA),                 /* BAT_RES_QUE_PLUS_FEA           = 0x98, */
  RSP_FAD(qPlusFFC),                 /* BAT_RES_QUE_PLUS_FFC           = 0x99, */
  RSP_FAD(qPlusFHS),                 /* BAT_RES_QUE_PLUS_FHS           = 0x9a, */
  RSP_FAD(qPlusFIE),                 /* BAT_RES_QUE_PLUS_FIE           = 0x9b, */
  RSP_FAD(qPlusFIS),                 /* BAT_RES_QUE_PLUS_FIS           = 0x9c, */
  RSP_FAD(qPlusFIT),                 /* BAT_RES_QUE_PLUS_FIT           = 0x9d, */
  RSP_FAD(qPlusFLI),                 /* BAT_RES_QUE_PLUS_FLI           = 0x9e, */
  RSP_FAD(qPlusFLO),                 /* BAT_RES_QUE_PLUS_FLO           = 0x9f, */
  RSP_FAD(qPlusFLP),                 /* BAT_RES_QUE_PLUS_FLP           = 0xa0, */
  RSP_FAD(qPlusFMS),                 /* BAT_RES_QUE_PLUS_FMS           = 0xa1, */
  RSP_FAD(qPlusFNS),                 /* BAT_RES_QUE_PLUS_FNS           = 0xa2, */
  RSP_FAD(qPlusFPA),                 /* BAT_RES_QUE_PLUS_FPA           = 0xa3, */
  RSP_FAD(qPlusFPI),                 /* BAT_RES_QUE_PLUS_FPI           = 0xa4, */
  RSP_FAD(qPlusFPS),                 /* BAT_RES_QUE_PLUS_FPS           = 0xa5, */
  RSP_FAD(qPlusFPW),                 /* BAT_RES_QUE_PLUS_FPW           = 0xa6, */
  RSP_FAD(qPlusFRQ),                 /* BAT_RES_QUE_PLUS_FRQ           = 0xa7, */
  RSP_FAD(qPlusFSA),                 /* BAT_RES_QUE_PLUS_FSA           = 0xa8, */
  RSP_FAD(qPlusFSP),                 /* BAT_RES_QUE_PLUS_FSP           = 0xa9, */
  RSP_ATI(qPlusICF),                 /* BAT_RES_QUE_PLUS_ICF           = 0xaa, */
  RSP_ATI(qPlusIFC),                 /* BAT_RES_QUE_PLUS_IFC           = 0xab, */
  RSP_ATI(qPercentIMEI),             /* BAT_RES_QUE_PERCENT_IMEI       = 0xac, */
  RSP_ATI(qPlusIPR),                 /* BAT_RES_QUE_PLUS_IPR           = 0xad, */
  RSP_ATI(qPercentPBCF),             /* BAT_RES_QUE_PERCENT_PBCF       = 0xae, */
  RSP_ATI(qPercentPPP),              /* BAT_RES_QUE_PERCENT_PPP        = 0xaf, */
  RSP_ATI(qPercentPVRF),             /* BAT_RES_QUE_PERCENT_PVRF       = 0xb0, */
  RSP_ATI(qPercentRDL),              /* BAT_RES_QUE_PERCENT_RDL        = 0xb1, */
  RSP_ATI(qPercentRDLB),             /* BAT_RES_QUE_PERCENT_RDLB       = 0xb2, */
  RSP_STK(qPercentSATC),             /* BAT_RES_QUE_PERCENT_SATC       = 0xb3, */
  RSP_STK(qPercentSATCC),            /* BAT_RES_QUE_PERCENT_SATCC      = 0xb4, */
  RSP_STK(sPercentSATE),             /* BAT_RES_SET_PERCENT_SATE       = 0xb5, */
  RSP_ATI(qPlusWS46),                /* BAT_RES_QUE_PLUS_WS46          = 0xb6, */
  RSP_ATI(qPlusCDIP),                 /* BAT_RES_QUE_PLUS_CDIP         = 0xb7, */
  RSP_ATI(sPercentCMGR),             /* BAT_RES_SET_PERCENT_CMGR       = 0xb8 ,*/
  RSP_ATI(sPercentCMGL),              /* BAT_RES_SET_PERCENT_CMGL       = 0xb9, */
  RSP_ATI(sPlusCGMI),                /*BAT_RES_SET_PLUS_CGMI          = 0xba, */
  RSP_ATI(sPlusCGMM),                /*BAT_RES_SET_PLUS_CGMM          = 0xbb, */
  RSP_ATI(sPlusCGMR),                /*BAT_RES_SET_PLUS_CGMR         = 0xbc, */
  RSP_ATI(sPlusCGSN)                /*BAT_RES_SET_PLUS_CGSN          = 0xbd, */
};

static BATResponse UnsResponseTab[] =
{
  RSP_ATI(uAtBusy),           /* BAT_RES_UNS_AT_BUSY            = 0x1000, */ 
  RSP_ATI(uAtNoAnswer),       /* BAT_RES_UNS_AT_NO_ANSWER       = 0x1001, */ 
  RSP_ATI(uPlusCBM),          /* BAT_RES_UNS_PLUS_CBM           = 0x1002, */ 
  RSP_ATI(uPlusCBMI),         /* BAT_RES_UNS_PLUS_CBMI          = 0x1003, */ 
  RSP_ATI(uPercentCCBS),      /* BAT_RES_UNS_PERCENT_CCBS       = 0x1004, */ 
  RSP_ATI(uPlusCCCM),         /* BAT_RES_UNS_PLUS_CCCM          = 0x1005, */ 
  RSP_ATI(uPercentCCCN),      /* BAT_RES_UNS_PERCENT_CCCN       = 0x1006, */ 
  RSP_ATI(uPlusCCWA),         /* BAT_RES_UNS_PLUS_CCWA          = 0x1007, */ 
  RSP_ATI(uPlusCCWA_W),       /* BAT_RES_UNS_PLUS_CCWA_W        = 0x1008, */ 
  RSP_ATI(uPlusCCWE),         /* BAT_RES_UNS_PLUS_CCWE          = 0x1009, */ 
  RSP_ATI(uPlusCDIP),         /* BAT_RES_UNS_PLUS_CDIP          = 0x100a, */
  RSP_ATI(uPlusCDS),          /* BAT_RES_UNS_PLUS_CDS           = 0x100b, */
  RSP_ATI(uPlusCCWV),         /* BAT_RES_UNS_PLUS_CCWV          = 0x100c, */  
  RSP_GPR(uPercentCGEV),      /* BAT_RES_UNS_PERCENT_CGEV       = 0x100d, */ 
  RSP_GPR(uPlusCGEV),         /* BAT_RES_UNS_PLUS_CGEV          = 0x100e, */ 
  RSP_GPR(uPercentCGREG),     /* BAT_RES_UNS_PERCENT_CGREG      = 0x100f, */ 
  RSP_GPR(uPlusCGREG),        /* BAT_RES_UNS_PLUS_CGREG         = 0x1010, */ 
  RSP_ATI(uPlusCLAE),         /* BAT_RES_UNS_PLUS_CLAE          = 0x1011, */ 
  RSP_ATI(uPlusCLAV),         /* BAT_RES_UNS_PLUS_CLAV          = 0x1012, */ 
  RSP_ATI(uPlusCLIP),         /* BAT_RES_UNS_PLUS_CLIP          = 0x1013, */ 
  RSP_ATI(uPlusCLIP_W),       /* BAT_RES_UNS_PLUS_CLIP_W        = 0x1014, */ 
  RSP_ATI(uPlusCMT),          /* BAT_RES_UNS_PLUS_CMT           = 0x1015, */ 
  RSP_ATI(uPlusCMTI),         /* BAT_RES_UNS_PLUS_CMTI          = 0x1016, */ 
  RSP_ATI(uPlusCMT_W),        /* BAT_RES_UNS_PLUS_CMT_W         = 0x1017, */ 
  RSP_ATI(uPercentCNAP),      /* BAT_RES_UNS_PERCENT_CNAP       = 0x1018, */ 
  RSP_ATI(uPlusCOLP),         /* BAT_RES_UNS_PLUS_COLP          = 0x1019, */ 
  RSP_ATI(uPlusCOLP_W),       /* BAT_RES_UNS_PLUS_COLP_W        = 0x101a, */ 
  RSP_ATI(uPercentCPI),       /* BAT_RES_UNS_PERCENT_CPI        = 0x101b, */ 
  RSP_ATI(uPercentCPI_W),     /* BAT_RES_UNS_PERCENT_CPI_W      = 0x101c, */ 
  RSP_ATI(uPercentCPRI),      /* BAT_RES_UNS_PERCENT_CPRI       = 0x101d, */ 
  RSP_ATI(uPercentCPROAM),    /* BAT_RES_UNS_PERCENT_CPROAM     = 0x101e, */ 
  RSP_ATI(uPercentCPVWI),     /* BAT_RES_UNS_PERCENT_CPVWI      = 0x101f, */ 
  RSP_ATI(uPlusCR),           /* BAT_RES_UNS_PLUS_CR            = 0x1020, */ 
  RSP_ATI(uPercentCREG),      /* BAT_RES_UNS_PERCENT_CREG       = 0x1021, */
  RSP_ATI(uPlusCRING),        /* BAT_RES_UNS_PLUS_CRING         = 0x1022, */ 
  RSP_ATI(uPercentCSQ),       /* BAT_RES_UNS_PERCENT_CSQ        = 0x1023, */ 
  RSP_ATI(uPlusCSSI),         /* BAT_RES_UNS_PLUS_CSSI          = 0x1024, */ 
  RSP_ATI(uPercentCSSN),      /* BAT_RES_UNS_PERCENT_CSSN       = 0x1025, */ 
  RSP_ATI(uPlusCSSU),         /* BAT_RES_UNS_PLUS_CSSU          = 0x1026, */ 
  RSP_ATI(uPercentCSTAT),     /* BAT_RES_UNS_PERCENT_CSTAT      = 0x1027, */ 
  RSP_ATI(uPercentCTYI),      /* BAT_RES_UNS_PERCENT_CTYI       = 0x1028, */ 
  RSP_ATI(uPlusCTZR),         /* BAT_RES_UNS_PLUS_CTZR          = 0x1029, */ 
  RSP_ATI(uPercentCTZV),      /* BAT_RES_UNS_PERCENT_CTZV       = 0x102a, */ 
  RSP_ATI(uPlusCTZV),         /* BAT_RES_UNS_PLUS_CTZV          = 0x102b, */ 
  RSP_ATI(uPercentCTZV_W),    /* BAT_RES_UNS_PERCENT_CTZV_W     = 0x102c, */ 
  RSP_ATI(uPlusCUSD),         /* BAT_RES_UNS_PLUS_CUSD          = 0x102d, */ 
  RSP_ATI(uPlusCUSD_W),       /* BAT_RES_UNS_PLUS_CUSD_W        = 0x102e, */ 
  RSP_ATI(uAtNoCarrier),      /* BAT_RES_UNS_AT_NO_CARRIER      = 0x102f, */ 
  RSP_ATI(uPlusFHS),          /* BAT_RES_UNS_PLUS_FHS           = 0x1030, */ 
  RSP_ATI(uPlusILRR),         /* BAT_RES_UNS_PLUS_ILRR          = 0x1031, */ 
  RSP_ATI(uPercentRDL),       /* BAT_RES_UNS_PERCENT_RDL        = 0x1032, */ 
  RSP_ATI(uPercentRDLB),      /* BAT_RES_UNS_PERCENT_RDLB       = 0x1033, */ 
  RSP_STK(uPercentSATA),      /* BAT_RES_UNS_PERCENT_SATA       = 0x1034, */ 
  RSP_STK(uPercentSATI),      /* BAT_RES_UNS_PERCENT_SATI       = 0x1035, */ 
  RSP_STK(uPercentSATN),      /* BAT_RES_UNS_PERCENT_SATN       = 0x1036, */ 
  RSP_ATI(uPercentSIMEF),     /* BAT_RES_UNS_PERCENT_SIMEF      = 0x1037, */ 
  RSP_ATI(uPercentSIMINS),    /* BAT_RES_UNS_PERCENT_SIMINS     = 0x1038, */ 
  RSP_ATI(uPercentSIMREM),    /* BAT_RES_UNS_PERCENT_SIMREM     = 0x1039, */ 
  RSP_ATI(uPercentSNCNT)      /* BAT_RES_UNS_PERCENT_SNCNT      = 0x103a, */
};

void ati_bat_inst_sig_cb(T_BAT_signal signal);
#ifdef _SIMULATION_
int ati_bat_resp_cb_simulation     (T_BAT_client client, T_BAT_cmd_response *response);
int ati_bat_uns_resp_cb_simulation (T_BAT_client client, T_BAT_cmd_response *response);
LOCAL BOOL asynch_resp = FALSE;
#endif
int  ati_bat_resp_cb    (T_BAT_client client, T_BAT_cmd_response *response);
int  ati_bat_uns_resp_cb(T_BAT_client client, T_BAT_cmd_response *response);

void ati_bat_sig_cb     (T_BAT_client client, T_BAT_signal signal);

/* ========================================================================================== */


/* Get PSI Source Info */
void Get_psi_src_info(T_ACI_DTI_PRC_PSI **psi_src_info)
{
  /*   Use the function 'find_element()' to search for the PSI
    source that has the correct command source ID. */
  
  *psi_src_info=find_element(psi_src_params,srcId_cb,cmhPSItest_srcId);
}
  
/* Some ATI maintenance is needed for BAT */

void Perform_ati_bat_maint(UBYTE srcId)
{  
  T_ATI_SRC_PARAMS *src_params = find_element (ati_src_list, srcId, search_ati_src_id);

  src_params->curAtCmd = AT_CMD_NONE;
  ledit_ctrl (srcId,LEDIT_CTRL_CMPL, NULL);
  src_params->cmd_state = CMD_IDLE;
  cmdErrStr   = NULL;

#ifdef _SIMULATION_
  asynch_resp = FALSE;
#endif
}

/* BAT instance_signal_cb */
void ati_bat_inst_sig_cb(T_BAT_signal signal)
{
  TRACE_FUNCTION ("ati_bat_inst_sig_cb ()");

  /* Result tells application if instance is successfully created/deleted */
}

#ifdef _SIMULATION_
/* this function is called by sig_dti_data_received_ind() */
void ati_bat_response_simulation(T_ACI_BAT_RES *res)
{
  TRACE_EVENT("ati_bat_response_simulation(): simulation of asynchronous response");
  if (BITFIELD_CHECK(res->response->ctrl_response, BAT_BIT_12) ||    /* 0x1000 */
      res->response->ctrl_response EQ BAT_RES_UNS_PLUS_CRING            ||
      res->response->ctrl_response EQ BAT_RES_UNS_PLUS_CCWV)
  {
    ati_bat_uns_resp_cb(res->client, res->response);
  }
  else
  {
    ati_bat_resp_cb(res->client, res->response);
  }
  if (asynch_resp EQ FALSE)
  {
    res->response = NULL;
  }
}

int ati_bat_resp_cb_simulation (T_BAT_client client, T_BAT_cmd_response *response)
{
  T_ACI_DTI_PRC_PSI *psi_src_info=find_element(psi_src_params,srcId_cb,cmhPSItest_srcId);
  psi_src_info->res.client   = client;
  psi_src_info->res.response = response;
  if (psi_src_info->bat_client[psi_src_info->active_client].curCmd EQ (T_BAT_ctrl_params)-1)
  {
    ati_bat_resp_cb(client,response);
  }
  else
  {
    ati_bat_resp_cb(client,response);
//    TRACE_EVENT("ati_bat_resp_cb_simulation(): prepare simulation of asynchronous response");
//    asynch_resp = TRUE;
  }
  return 0; 
}

int ati_bat_uns_resp_cb_simulation (T_BAT_client client, T_BAT_cmd_response *response)
{
  T_ACI_DTI_PRC_PSI *psi_src_info=find_element(psi_src_params,srcId_cb,cmhPSItest_srcId);
  psi_src_info->res.client   = client;
  psi_src_info->res.response = response;
  if (psi_src_info->bat_client[psi_src_info->active_client].curCmd EQ (T_BAT_ctrl_params)-1)
  {
    ati_bat_uns_resp_cb(client,response);
  }
  else
  {
    ati_bat_uns_resp_cb(client,response);
//    TRACE_EVENT("ati_bat_uns_resp_cb_simulation(): prepare simulation of asynchronous response");
//    asynch_resp = TRUE;
  }
  return 0; 
}
#endif _SIMULATION_ 

/* BAT unsolicited_result_cb */
int ati_bat_uns_resp_cb (T_BAT_client client, T_BAT_cmd_response *response)
{
  int ret = 0;
  T_ACI_DTI_PRC_PSI *psi_src_info;
  U16 index = 0;

  TRACE_FUNCTION ("ati_bat_uns_resp_cb ()");

  Get_psi_src_info(&psi_src_info);

  if (psi_src_info)
  {
  if (response)
  {  
    T_BAT_cmd_response *resp_p = response;

    if (resp_p->ctrl_response EQ BAT_RES_UNS_PLUS_CRING   ||  /* Cases where Ids < 0x1000 */
        resp_p->ctrl_response EQ BAT_RES_UNS_PLUS_CCWV)
    {
      index = (U16)resp_p->ctrl_response;

      if (ResponseTab[index].fptr)
      {
        ret = ResponseTab[index].fptr(psi_src_info, resp_p);
      }
      else
      {
        ACI_ERR_DESC( ACI_ERR_CLASS_Cme, CME_ERR_OpNotAllow);
      }
    }
    else     /* Cases where Ids >= 0x1000 */
    {
      index = ((U16)resp_p->ctrl_response - BAT_BIT_12);

      if (UnsResponseTab[index].fptr)
      {
        ret = UnsResponseTab[index].fptr(psi_src_info, resp_p);
      }
      else
      {
        ACI_ERR_DESC( ACI_ERR_CLASS_Cme, CME_ERR_OpNotAllow);
      }
    }
  }
  
#ifdef _SIMULATION_  
    if (asynch_resp EQ FALSE)
#endif 
      Perform_ati_bat_maint(psi_src_info->srcId);
  }
  return 0;  
}

/* BAT response_cb */
int ati_bat_resp_cb (T_BAT_client client, T_BAT_cmd_response *response)
{
  int ret = 0;
  T_ACI_DTI_PRC_PSI *psi_src_info;
  U16 index;

  TRACE_FUNCTION ("ati_bat_resp_cb()");

  Get_psi_src_info(&psi_src_info);

  if (psi_src_info)
  {
  /* Check if response is complete */
  if (response)
  {  
    T_BAT_cmd_response *resp_p = response;

    index = (U16)resp_p->ctrl_response;
      TRACE_EVENT_P1("ati_bat_resp_cb(): resp_p->ctrl_response = 0x%04X", resp_p->ctrl_response);
    if (ResponseTab[index].fptr)
    {
      ret = ResponseTab[index].fptr(psi_src_info, resp_p);
    }
    else
    {
      ACI_ERR_DESC( ACI_ERR_CLASS_Cme, CME_ERR_OpNotAllow);
    }
  }
#ifdef _SIMULATION_  
  if (asynch_resp EQ FALSE)
#endif    
    Perform_ati_bat_maint(psi_src_info->srcId);
  }
  return 0;  /* Ok for now */
}


/* BAT signal_cb */
void ati_bat_sig_cb(T_BAT_client client, T_BAT_signal signal)
{
  TRACE_FUNCTION ("ati_bat_sig_cb ()");
}


GLOBAL void ati_bat_lib_init (U8 src_id)
{
  U8  num_instances = ATI_BAT_MAX_INSTANCES;         
  U8 *mem;
  
  /* allocate memory for maintaining the instances */
  ACI_MALLOC(mem, num_instances * BAT_INSTANCE_HEADER_SIZE);
  
  if (0 != bat_init (mem, num_instances))
  {
    TRACE_ERROR("bat_init failure");
    return;
  }
  ati_bat_globs.bat_lib_initialized = TRUE;

  if (GDD_OK != gdd_aci_func.gdd_init(src_id, 0, CMD_SRC_MAX))
  {
    TRACE_ERROR("gdd_aci_init failure");
    return;
  } 
}

/* because the ATI src_id is the only identifier, we create for every ATI source
   a BAT Lib instance, but with only one client */
GLOBAL void ati_bat_lib_new (U8 src_id, T_ATI_SRC_TYPE src_type)
{ 
  T_GDD_SIGNAL signal = {GDD_SIGTYPE_SEND_BUF_AVAILABLE};
  U8  num_clients = ATI_BAT_MAX_CLIENTS;
  U8 *mem;

  T_ACI_DTI_PRC_PSI *cmd_struct;


  if (src_type NEQ ATI_SRC_TYPE_PSI)
  {
    /* because BAT has been designed for PSI connections only, we must fake one.
       in the real life  psi_new_source() creates such a thing */
    ACI_MALLOC(cmd_struct, sizeof(T_ACI_DTI_PRC_PSI));
  
    psi_InitCmdStruct(cmd_struct);

    cmd_struct->srcId = src_id;
    cmd_struct->devId = 0xBACDBACD; /* to distinguish from DIO_DATA_PKT used in acibat_test suite */
    cmd_struct->dlci  = 0;

    if (insert_list (psi_src_params, cmd_struct) NEQ TRUE)
    {
      TRACE_ERROR ("ati_bat_open_client(): failed to create PSI source");
      return;
    }
  }

  aci_cmd_src_mode_set(src_id,CMD_MODE_BAT);
  ati_bat_globs.instance[src_id].src_type = src_type;
  gdd_aci_remember_src_id(src_id);
  
  /* allocate memory for maintaining the clients in the instance */
  ACI_MALLOC(mem, BAT_INSTANCE_SIZE + (num_clients * BAT_CLIENT_SIZE));

  if ((bat_new(&(ati_bat_globs.instance[src_id].inst_hndl),
               mem,
               num_clients, 
               &(ati_bat_globs.config),
               ati_bat_inst_sig_cb)) NEQ 0)
  {
    TRACE_ERROR("bat_new failure");
    return;
  }

  /* simulate an asynch response from GDD to BAT Lib to tell BAT Lib that GDD has an open channel */
  signal.sig = GDD_SIGTYPE_SEND_BUF_AVAILABLE;
  bat_gdd_signal_cb(gdd_aci_get_con_handle(src_id), signal);
}


GLOBAL void ati_bat_lib_finit (void)
{
  int i = 0;
  if (ati_bat_globs.bat_lib_initialized)
  {
    for (i=0; i<ATI_BAT_MAX_INSTANCES; i++)
    {
      if (ati_bat_globs.instance[i].src_type NEQ ATI_SRC_TYPE_UNKNOWN)
      {
        if (aci_cmd_src_mode_get(i) EQ CMD_MODE_BAT)
        {
        bat_delete(ati_bat_globs.instance[i].inst_hndl); 
        }
        ati_bat_globs.instance[i].client_id[0]= 0xFF; 
        ati_bat_globs.instance[i].uns_client_id = 0xFF;
        ati_bat_globs.instance[i].src_type = ATI_SRC_TYPE_UNKNOWN;
      }
    }
    bat_deinit();
    ati_bat_globs.bat_lib_initialized = FALSE;
  }
}


GLOBAL void ati_bat_open_client (U8 src_id)
{
  T_ACI_DTI_PRC_PSI *src_infos_psi;

  src_infos_psi = find_element (psi_src_params, src_id, cmhPSItest_srcId);

  if (src_infos_psi EQ NULL)
  {
    TRACE_ERROR ("ati_bat_open_client(): failed to get PSI source");
    return;
  }

  aci_cmd_src_mode_set(src_id,CMD_MODE_BAT);
  
  /* all ATI sources use the same response callback */
  if ((bat_open(ati_bat_globs.instance[src_id].inst_hndl,
                &(ati_bat_globs.instance[src_id].client_id[0]),
#ifdef _SIMULATION_
                ati_bat_resp_cb_simulation,
#else
                ati_bat_resp_cb,
#endif
                ati_bat_sig_cb)) NEQ 0)
  {
    TRACE_ERROR("bat_open failure");
    return;
  }
  /* all ATI sources use the same unsolicited response callback */
  if ((bat_uns_open(ati_bat_globs.instance[src_id].inst_hndl,
                    &(ati_bat_globs.instance[src_id].uns_client_id),
#ifdef _SIMULATION_
                    ati_bat_uns_resp_cb_simulation)) NEQ 0)
#else
                    ati_bat_uns_resp_cb)) NEQ 0)
#endif

  {
    TRACE_ERROR("bat_uns_open failure");
    return;
  }
}


GLOBAL U16 ati_bat_get_client (U8 src_id)
{
  /* currently we have only one client per instance, else need a mux_src_id */
  if (ati_bat_globs.instance[src_id].client_id[0] NEQ 0xFF)
  {
    return (ati_bat_globs.instance[src_id].client_id[0]);
  }
  TRACE_ERROR("ati_bat_get_client(): no BAT client");
  return (0xFF);
}


GLOBAL void ati_bat_close_client (U8 src_id)
{
  if (ati_bat_globs.bat_lib_initialized)
  {
    /* currently we have only one client per instance, else need a mux_src_id */
    if (ati_bat_globs.instance[src_id].client_id[0] NEQ 0xFF)
    {
      bat_close(ati_bat_globs.instance[src_id].client_id[0]);
      ati_bat_globs.instance[src_id].client_id[0] = 0xFF;
    }
  }
}


GLOBAL BOOL ati_bat_all_clients_closed (void)
{
  int i,k;
  for (i=0; i<ATI_BAT_MAX_INSTANCES; i++)
  {
    for (k=0; k<ATI_BAT_MAX_CLIENTS; k++)
    {
      if (ati_bat_globs.instance[i].client_id[k] NEQ 0xFF)
      {
        return (FALSE);
      }
    }
  }
  return (TRUE);
}


GLOBAL void ati_bat_reset (void)
{
  int i,k;
  
  for (i=0; i<ATI_BAT_MAX_INSTANCES; i++)
  {
    ati_bat_globs.instance[i].src_type = ATI_SRC_TYPE_UNKNOWN;
    ati_bat_globs.instance[i].uns_client_id = 0xFF;
    for (k=0; k<ATI_BAT_MAX_CLIENTS; k++)
    {
      ati_bat_globs.instance[i].client_id[k] = 0xFF;
    }
  }
  
  ati_bat_globs.bat_lib_initialized = FALSE;
  ati_bat_globs.config.adapter.gdd_if = gdd_aci_func;
  ati_bat_globs.config.adapter.cap.dio_cap.mtu_size = 300; /*GDD_DIO_MTU_SIZE*/
  ati_bat_globs.config.device = DEVICE_PACKET;
  ati_bat_globs.config.l2p.protocol_id = L2P_SP_PSI;
}


/***************************************************************************/       
/* Response Function Definitions Start Here */
/***************************************************************************/

int Resp_AtOk (T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_AtOk ()");

  /*
   *   If we have been receiving COPS responses, this OK signals
   *   the end of them, so clear the flag.
   */
  cops_flag=FALSE;
  CLCC_flag=FALSE;

  if (clan_buf)
  {
    io_sendMessage(srcId_cb,g_sa,ATI_NORMAL_OUTPUT);
    clan_buf=NULL;
  }

#ifdef _SIMULATION_
  {
    T_ATI_SRC_PARAMS *src_params = find_element (ati_src_list, src_infos_psi->srcId, search_ati_src_id);
    T_ACI_AT_CMD cmdId = src_params->curAtCmd;
    if (ledit_ctrl(src_params->src_id,LEDIT_CTRL_MORE_CMDS, NULL) EQ LEDIT_CMPL)
    {
      rCI_OK(cmdId);

      return 0;
    }
  }
#endif

  io_sendConfirm(src_infos_psi->srcId, cmdAtError(atOk), ATI_NORMAL_OUTPUT);

  Perform_ati_bat_maint(src_infos_psi->srcId);

  return 0; /* Ok */
}

int Resp_AtConnect(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_ACI_BS_SPEED speed;
  T_ATI_SRC_PARAMS *src_params = find_element (ati_src_list, src_infos_psi->srcId, search_ati_src_id);

  TRACE_FUNCTION ("Resp_AtConnect()");
  /*
   *   We're in trouble if we don't have 'src_params', as we need
   *   to know the command ID.
   */
  if (src_params==NULL)
  {
    TRACE_EVENT("No src_params in CONNECT.");
    return 1; /* Indicate error */
  }

  /*
   *   rCI_CONNECT() only cares about the speed, not the rate adaption /
   *   modulation type.
   */
  switch(resp_p->response.ptr_at_connect->data_rate)
  {
    default:
    case BAT_AT_CONNECT_RATE_NOT_PRESENT: speed=BS_SPEED_NotPresent;  break;
    case BAT_AT_CONNECT_RATE_300:         speed=BS_SPEED_300_V110;    break;
    case BAT_AT_CONNECT_RATE_1200:        speed=BS_SPEED_1200_V110;   break;
    case BAT_AT_CONNECT_RATE_2400:        speed=BS_SPEED_2400_V110;   break;
    case BAT_AT_CONNECT_RATE_4800:        speed=BS_SPEED_4800_V110;   break;
    case BAT_AT_CONNECT_RATE_9600:        speed=BS_SPEED_9600_V110;   break;
    case BAT_AT_CONNECT_RATE_14400:       speed=BS_SPEED_14400_V110;  break;
    case BAT_AT_CONNECT_RATE_19200:       speed=BS_SPEED_19200_V110;  break;
    case BAT_AT_CONNECT_RATE_38400:       speed=BS_SPEED_38400_V110;  break;
  }

  /*
   *   BAT does not provide the call ID, the current command or the
   *   flow control flag. rCI_CONNECT() doesn't care about the call ID,
   *   so we can set that to 0. I'm not sure about flow control, setting
   *   it to FALSE seems safest.
   */
  rCI_CONNECT(src_params->curAtCmd,speed,0,FALSE);
  return 0; /* Ok */
}

int Resp_AtNoCarrierFinal(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_ATI_SRC_PARAMS *src_params = find_element (ati_src_list, src_infos_psi->srcId, search_ati_src_id);
  TRACE_FUNCTION ("Resp_AtNoCarrierFinal()");

  /*
   *   We're in trouble if we don't have 'src_params', as we need
   *   to know the command ID.
   */
  if (src_params==NULL)
  {
    TRACE_EVENT("No src_params in NO_CARRIER_FINAL.");
    return 1; /* Indicate error */
  }

  /*
   *   BAT does not provide the call ID or the current command.
   *   rCI_NO_CARRIER() doesn't care about the call ID,
   *   so we can set that to 0.
   */
  rCI_NO_CARRIER(src_params->curAtCmd,0);
  return 0; /* Ok */
}

int Resp_PlusCmeError(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_PlusCmeError()");

  io_sendConfirm(src_infos_psi->srcId,
                 cmdCmeError(resp_p->response.ptr_plus_cme_error->error),
                 ATI_ERROR_OUTPUT);

  return 0; /* Ok */
}

int Resp_PlusCmsError(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_PlusCmsError()");

  io_sendConfirm(src_infos_psi->srcId, 
                 cmdCmsError(resp_p->response.ptr_plus_cms_error->err), 
                 ATI_ERROR_OUTPUT);

  return 0; /* Ok */
}

int Resp_AtBusy(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_ATI_SRC_PARAMS *src_params = find_element (ati_src_list, src_infos_psi->srcId, search_ati_src_id);
  TRACE_FUNCTION ("Resp_AtBusy()");
  /*
   *   We're in trouble if we don't have 'src_params', as we need
   *   to know the command ID.
   */
  if (src_params==NULL)
  {
    TRACE_EVENT("No src_params in BUSY.");
    return 1; /* Indicate error */
  }

  /*
   *   BAT does not provide the call ID or the current command.
   *   rCI_BUSY() doesn't care about the call ID,
   *   so we can set that to -1 safely.
   */
  rCI_BUSY(src_params->curAtCmd,-1);
  return 0; /* Ok */
}

int Resp_AtNoAnswer(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_ATI_SRC_PARAMS *src_params = find_element (ati_src_list, src_infos_psi->srcId, search_ati_src_id);
  TRACE_FUNCTION ("Resp_AtNoAnswer()");

  /*
   *   We're in trouble if we don't have 'src_params', as we need
   *   to know the command ID.
   */
  if (src_params==NULL)
  {
    TRACE_EVENT("No src_params in NO_ANSWER.");
    return 1; /* Indicate error */
  }

  /*
   *   BAT does not provide the call ID or the current command.
   *   rCI_NO_ANSWER() doesn't care about the call ID,
   *   so we can set that to -1 safely.
   */
  rCI_NO_ANSWER(src_params->curAtCmd,-1);

  return 0; /* Ok */
}

int Resp_AtChannelBusy(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
}


int Resp_uAtNoCarrier(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uAtNoCarrier()");

  return 0; /* Ok */
}

int Resp_uPlusCRING(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_ACI_CRING_MOD mode;
  T_ACI_CRING_TYP type1;
  T_ACI_CRING_TYP type2;
  T_BAT_res_uns_plus_cring *cring;

  TRACE_FUNCTION ("Resp_uPlusCRING()");
  /*
   *   Get a pointer to the CRING structure for convenience.
   */
  cring=resp_p->response.ptr_plus_cring;

  /*
   *   This relies on T_ACI_CRING_TYP being the same as
   *   T_BAT_cring_type/T_BAT_plus_cring_type2.
   */
  type1=(T_ACI_CRING_TYP)cring->type1;
  type2=(T_ACI_CRING_TYP)cring->type2;

  /*
   *   This relies on T_ACI_CRING_MOD being the same as
   *   T_BAT_plus_cring_alt.
   */
  mode=(T_ACI_CRING_MOD)cring->alt;

  rCI_PlusCRING(mode,type1,type2);
  return 0; /* Ok */
}

int Resp_uPlusCCWV(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPlusCCWV() ");

  rCI_PlusCCWV((T_ACI_CCWV_CHRG)resp_p->response.ptr_plus_ccwv->bat_dummy );

  return 0; /* Ok */
}

int Resp_qPercentALS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPercentALS() ");

  resp_disp((UBYTE)src_infos_psi->srcId, NULL,"b",resp_p->response.ptr_que_percent_als->mode); 
  return 0; /* Ok */
}

int Resp_tPercentALS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  char *me = "%ALS";
  TRACE_FUNCTION ("Resp_tPercentALS() ");
  
  if (resp_p->response.ptr_tst_percent_als->mode EQ BAT_P_ALS_MOD_SPEECH)
    sprintf(g_sa,"%s: (0)", me);
  if (resp_p->response.ptr_tst_percent_als->mode EQ BAT_P_ALS_MOD_AUX_SPEECH)
    sprintf(g_sa,"%s: (1)", me);
  if (resp_p->response.ptr_tst_percent_als->mode EQ (BAT_P_ALS_MOD_SPEECH | BAT_P_ALS_MOD_AUX_SPEECH))
    sprintf(g_sa,"%s: (0,1)", me);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT); 

  return 0; /* Ok */
}

int Resp_qPercentATR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_que_percent_atr *atr;
  UBYTE i;
  TRACE_FUNCTION ("Resp_qPercentATR()");  
  
  atr=resp_p->response.ptr_que_percent_atr;
  i=sprintf(g_sa,"%s%d,","%ATR: ",atr->phase);
  utl_binToHex(atr->atr,atr->c_atr,g_sa+i);
  io_sendMessage(src_infos_psi->srcId,g_sa,ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_qPercentBAND(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_que_percent_band band;
  TRACE_FUNCTION ("Resp_qPercentBAND()"); 
  
  band= *(resp_p->response.ptr_que_percent_band);
  if( band.band EQ 0x00 OR band.mode EQ BAND_MODE_Auto )
  {
    sprintf(g_sa, "%s: %d", "%BAND", band.mode);
  }
  else
  {
    sprintf(g_sa, "%s: %d,%d", "%BAND", band.mode, band.band);
  }
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_tPercentBAND(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  UBYTE           c_set_bit = 0;
  USHORT          pos       = 0;
  UBYTE           i, tested_filter_byte, highest_set_bit_only=0;
  
  TRACE_FUNCTION ("Resp_tPercentBAND() ");

  /* initialization of the string */
  pos += sprintf(g_sa, "%s: (0-%d)", "%BAND", resp_p->response.ptr_tst_percent_band->mode);
  pos += sprintf( g_sa+pos, ",(" );

  if(resp_p->response.ptr_tst_percent_band->band EQ 0x00)
  {
    /* no particular settings from manufacturer */
    pos += sprintf( g_sa+pos, "1-%d)", HIGHEST_BAND_SUPPORTED );
  }
  else
  {
    /* search holes between highest bit and lowest bit */
    for( i=0; i<8 ; i++ )
    {
      tested_filter_byte = 0x01 << i;
    
      if( (resp_p->response.ptr_tst_percent_band->band & tested_filter_byte) )
      {
        highest_set_bit_only = tested_filter_byte;
        c_set_bit++;
      }
    }
    
    if(c_set_bit) /* alignment at the end */
    {
      c_set_bit--;
    }

    if( highest_set_bit_only EQ (0x01 << c_set_bit) )
    {
      /* there is no hole in the supported values, form 1 to max_value */
      pos += sprintf( g_sa+pos, "1-%d)", resp_p->response.ptr_tst_percent_band->band);
    }
    else
    {
      for(i=1 ; i<=resp_p->response.ptr_tst_percent_band->band; i++)  /* bands_bitfield is obviously the highest possible value */
      {
        if( (i & resp_p->response.ptr_tst_percent_band->band) EQ i )
        { 
          pos += sprintf( g_sa+pos, "%d,", i);
        }
        if(pos>MAX_CMD_LEN-5) /* -5 to have some buffer */
        {
          TRACE_EVENT("output buffer is too short !!!");
          break;
        }
      }
      pos--; /* erase last comma */
      sprintf( g_sa+pos, ")");
    }  
  }       

  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  
  return 0; /* Ok */
}

int Resp_qPlusCACM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  LONG         acm = 0L;
  TRACE_FUNCTION ("Resp_qPlusCACM()");  
  
  acm=resp_p->response.ptr_que_plus_cacm->acm;
  sprintf(g_sa,"+CACM: \"%06X\"", acm);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_qPlusCAMM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  LONG acmmax      = 0L;
  TRACE_FUNCTION ("Resp_qPlusCAMM()");   
  
  acmmax=resp_p->response.ptr_que_plus_camm->acmmax;
  sprintf (g_sa,"+CAMM: \"%06X\"", acmmax);
  io_sendMessage ((UBYTE)src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_sPlusCAOC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  LONG          ccm  = 0L;
  TRACE_FUNCTION ("Resp_sPlusCAOC() ");  
  ccm=resp_p->response.ptr_set_plus_caoc->ccm;
  sprintf (g_sa,"+CAOC: \"%06X\"", ccm);
  io_sendMessage ((UBYTE)src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_sPlusCBC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{  
  TRACE_FUNCTION ("Resp_sPlusCBC()");
 
  sprintf(g_sa, "+CBC: %d,%d",resp_p->response.ptr_set_plus_cbc->bsc, resp_p->response.ptr_set_plus_cbc->bcl );
  io_sendMessage((UBYTE)src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_qPercentCBHZ(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPercentCBHZ() Not Implemented");

  return 0; /* Ok */
}

int Resp_tPercentCBHZ(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_tPercentCBHZ() Not Implemented");

  return 0; /* Ok */
}

int Resp_qPlusCBST(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCBST()");
  resp_disp((UBYTE)src_infos_psi->srcId, NULL,"eee",&resp_p->response.ptr_que_plus_cbst->speed,
    &resp_p->response.ptr_que_plus_cbst->name,&resp_p->response.ptr_que_plus_cbst->ce);
  return 0; /* Ok */
}

int Resp_qPercentCCBS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_ACI_CCBS_IND ind;
  T_ACI_CCBS_STAT status;
  T_ACI_CCBS_SET setting;
  T_BAT_res_que_percent_ccbs *ccbs;
  TRACE_FUNCTION ("Resp_qPercentCCBS()");
  /*
  *   Get a pointer to the CCBS structure for convenience.
  */
  ccbs=resp_p->response.ptr_que_percent_ccbs;

  /*
  *   This relies on T_ACI_CCBS_IND being identical to
  *   T_BAT_percent_ccbs_ind and T_ACI_CCBS_STAT being identical
  *   to T_BAT_percent_ccbs_stat.
  */
  ind=(T_ACI_CCBS_IND)ccbs->ind;
  status=(T_ACI_CCBS_STAT)ccbs->stat;

  /*
  *   The main reason for zeroing this memory is to ensure we
  *   end up with zero-terminated 'number' and 'subaddress'
  *   strings.
  */
  memset(&setting,0,sizeof(T_ACI_CCBS_SET));

  setting.idx=(SHORT)ccbs->idx;

  if ((ccbs->v_number==TRUE) && (ccbs->c_number<MAX_B_SUBSCR_NUM_LEN))
    memcpy(setting.number,ccbs->number,ccbs->c_number);

  setting.type=toa_demerge((SHORT)ccbs->type);

  if ((ccbs->v_subaddr==TRUE) && (ccbs->c_subaddr<MAX_SUBADDR_LEN))
    memcpy(setting.subaddr,ccbs->subaddr,ccbs->c_subaddr);

  setting.satype=tos_demerge((SHORT)ccbs->satype);

  /*
  *   This relies on T_ACI_CLASS being identical to T_BAT_bearer_class
  *   and T_ACI_ALRT_PATTERN being identical to T_BAT_percent_ccbs_ptn.
  */
  setting.class_type=(T_ACI_CLASS)ccbs->bearer_class;
  setting.alrtPtn=(T_ACI_ALRT_PTRN)ccbs->ptn;

  rCI_PercentCCBS(ind,status,&setting,TRUE);

  return 0; /* Ok */
}

int Resp_sPlusCCFC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_ACI_CCFC_SET setting = {0}, *set_p = &setting;
  
  TRACE_FUNCTION ("Resp_sPlusCCFC()");

  /* Load from BAT response structure before calling rCI_... */
  set_p->clsstat.status = (T_ACI_STATUS)resp_p->response.ptr_set_plus_ccfc->status;
  set_p->clsstat.class_type = (T_ACI_CLASS)resp_p->response.ptr_set_plus_ccfc->bearer_class;

  if(resp_p->response.ptr_set_plus_ccfc->v_number)
  {
    memcpy(set_p->number,
           (U8 *)resp_p->response.ptr_set_plus_ccfc->number,
           resp_p->response.ptr_set_plus_ccfc->c_number);
  }

  if(resp_p->response.ptr_set_plus_ccfc->type NEQ 0)
  {
    set_p->type=toa_demerge(resp_p->response.ptr_set_plus_ccfc->type);
  }

  if(resp_p->response.ptr_set_plus_ccfc->v_subaddr)
  {
    memcpy(set_p->subaddr,
           (U8 *)resp_p->response.ptr_set_plus_ccfc->subaddr,
           resp_p->response.ptr_set_plus_ccfc->c_subaddr);
  }

  if(resp_p->response.ptr_set_plus_ccfc->satype NEQ 0)
  {
    set_p->satype=tos_demerge(resp_p->response.ptr_set_plus_ccfc->satype);
  }

  set_p->time = (SHORT)resp_p->response.ptr_set_plus_ccfc->time;

  rCI_PlusCCFC(set_p);

  return 0; /* Ok */
}

int Resp_qPlusCCLK(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_que_plus_cclk *cclk;
  char sign;
  int tz;
  TRACE_FUNCTION ("Resp_qPlusCCLK()");
  /*
  *   Get a pointer to the CCLK structure for convenience.
  */
  cclk=resp_p->response.ptr_que_plus_cclk;
  tz=(char)cclk->time_zone;
  #ifndef _SIMULATION_
  #ifdef FF_TIMEZONE
    if (tz<0)
    {
      sign='-';
      tz=tz*(-1);
    }
    else
    {
      sign='+';
    }

  #endif /*FF_TIMEZONE*/
  #else
    sign='-';
    tz=tz*(-1);
  #endif /*_SIMULATION_*/

  #if defined(_SIMULATION_) || defined(FF_TIMEZONE)
    sprintf(
      g_sa,
      "%d/%d/%d,%d:%d:%d%c%d",
      cclk->year,
      cclk->month,
      cclk->day,
      cclk->hour,
      cclk->minutes,
      cclk->seconds,
      sign,
      tz);
  #else
    sprintf(
      g_sa,
      "%d/%d/%d,%d:%d:%d",
      cclk->year,
      cclk->month,
      cclk->day,
      cclk->hour,
      cclk->minutes,
      cclk->seconds);
  #endif
      io_sendMessage(src_infos_psi->srcId,g_sa,ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_qPlusCCUG(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCCUG()");
  resp_disp (src_infos_psi->srcId,NULL,"eee",&resp_p->response.ptr_que_plus_ccug->n,
    &resp_p->response.ptr_que_plus_ccug->index,&resp_p->response.ptr_que_plus_ccug->info);
  return 0; /* Ok */
}

int Resp_sPlusCCWA(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_sPlusCCWA() Not implemented no callback which fills set response not present");
 
  return 0; /* Ok */
}

int Resp_sPlusCCWA_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_sPlusCCWA_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_qPlusCDIP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_que_plus_cdip *cdip;

  TRACE_FUNCTION ("Resp_qPlusCDIP() Not Implemented");

  cdip = resp_p->response.ptr_que_plus_cdip;

  /* from ati_cc.c use bat params here! */
  resp_disp(src_infos_psi->srcId, NULL, "be", &ati_user_output_cfg[src_infos_psi->srcId].CDIP_stat, &cdip->m);

  return 0; /* Ok */
}

int Resp_sPlusCEER(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_set_plus_ceer *ceer;
  char desc[MAX_CEER_DESC_LTH];
  USHORT cause;
  TRACE_FUNCTION ("Resp_sPlusCEER()");
  /*
  *   Get a pointer to the CEER structure for convenience.
  */
  ceer=resp_p->response.ptr_set_plus_ceer;

  cause=CAUSE_MAKE(
    ceer->definedby,
    ceer->originatingside,
    ceer->originatingentity,
    ceer->causevalue);
    
  getCeerDesc(cause, desc);

  if (desc[0]==0)
  {
    /*
    *   No description text is available
    */
    sprintf( g_sa, "+CEER: %d,%d,%d,%d",
      ceer->definedby,
      ceer->originatingside,
      ceer->originatingentity,
      ceer->causevalue);
  }
  else
  {
    /*
    *   Description text is available
    */
    sprintf( g_sa, "+CEER: %d,%d,%d,%d,%s",
      ceer->definedby,
      ceer->originatingside,
      ceer->originatingentity,
      ceer->causevalue,
      desc);
  }
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_qPlusCFUN(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCFUN()");

  sprintf(g_sa,
          "%s: %d","+CFUN",
          resp_p->response.ptr_que_plus_cfun->fun);
  
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

#ifdef GPRS
int Resp_qPercentCGAATT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPercentCGAATT()");
  sprintf(g_sa,"%s: %d,%d", "%CGAATT",
  resp_p->response.ptr_que_percent_cgaatt->att_m,
  resp_p->response.ptr_que_percent_cgaatt->det_m);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_qPlusCGACT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_que_plus_cgact *cgact;
  TRACE_FUNCTION ("Resp_qPlusCGACT()");
  /*
  *   Get a pointer to the CGACT structure for convenience.
  */
  cgact=resp_p->response.ptr_que_plus_cgact;
  sprintf(
    g_sa,
    "+CGACT: %hd,%d",
    cgact->cid,
    (cgact->state==BAT_CGACT_STATE_ACTIVATED) ? 1:0);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_qPlusCGATT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCGATT()");
  sprintf(g_sa,"+CGATT: %d",resp_p->response.ptr_que_plus_cgatt->state);
  io_sendMessage(src_infos_psi->srcId,g_sa,ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_qPercentCGCLASS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  char *classes[] = {"A","B","BG","BC","BX","CG","CC"};
  TRACE_FUNCTION ("Resp_qPercentCGCLASS()");    
  if(resp_p->response.ptr_que_percent_cgclass->p_mobile_class NEQ 
     resp_p->response.ptr_que_percent_cgclass->current_mobile_class)
    {
      sprintf(g_sa,"%s: \"%s\",\"%s\"", "%CGCLASS", classes[resp_p->response.ptr_que_percent_cgclass->p_mobile_class],
              classes[resp_p->response.ptr_que_percent_cgclass->current_mobile_class]);
    }
    else
    {
      sprintf(g_sa,"%s: \"%s\"", "%CGCLASS", classes[resp_p->response.ptr_que_percent_cgclass->p_mobile_class]);
    }
    io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);  
  return 0; /* Ok */
}

int Resp_qPlusCGCLASS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  char *me="+CGCLASS: ";
  char *classes[] = {"A","B","CG","CC"};
  TRACE_FUNCTION ("Resp_qPlusCGCLASS()");
  sprintf(g_sa,"%s\"%s\"", me, classes[resp_p->response.ptr_que_plus_cgclass->mobile_class]);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_qPlusCGDCONT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  char *me="+CGDCONT: ";
  T_BAT_res_que_plus_cgdcont *cgdcont;
  U8 apn[BAT_MAX_APN_LEN+1];
  U8 pdp_addr[BAT_MAX_PDP_ADD+1];
  CHAR *type;
  TRACE_FUNCTION ("Resp_qPlusCGDCONT()");
 /*
  *   Get a pointer to the CGDCONT structure for convenience.
  */
  cgdcont=resp_p->response.ptr_que_plus_cgdcont;
  memset(apn,0,sizeof(apn));
  memset(pdp_addr,0,sizeof(pdp_addr));
  /*
  *   Make these into null terminated strings.
  */
  memcpy(apn,cgdcont->apn,cgdcont->c_apn);
  memcpy(pdp_addr,cgdcont->pdp_addr,cgdcont->c_pdp_addr);
  type=(cgdcont->pdp_type==BAT_PDP_TYPE_IPV4) ? "IP":"";

  if (!strcmp(apn, MAGIC_EMPTY_APN))
  {
    sprintf(g_sa,"%s%hd,\"%s\",\"\",\"%s\",%hd,%hd",
      me,
      cgdcont->cid,
      type,
      pdp_addr,
      cgdcont->d_comp,
      cgdcont->h_comp);
  }
  else if (apn[0]==0)
  {
    sprintf(g_sa,"%s%hd,\"%s\",,\"%s\",%hd,%hd",
      me,
      cgdcont->cid,
      type,
      pdp_addr,
      cgdcont->d_comp,
      cgdcont->h_comp);
  }
  else
  {
    sprintf(g_sa,"%s%hd,\"%s\",\"%s\",\"%s\",%hd,%hd",
      me,
      cgdcont->cid,
      type,
      apn,
      pdp_addr,
      cgdcont->d_comp,
      cgdcont->h_comp);
  }
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_sPlusCGPADDR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_set_plus_cgpaddr *cgpaddr;
  TRACE_FUNCTION ("Resp_sPlusCGPADDR() ");
  /*
  *   Get a pointer to the CGPADDR structure for convenience.
  */
  cgpaddr=resp_p->response.ptr_set_plus_cgpaddr;
  if (cgpaddr->c_pdp_addr)
  {
    U8 pa[BAT_MAX_PDP_ADD+1]; 
    memset(pa,0,sizeof(pa));
    memcpy(pa,cgpaddr->pdp_addr,cgpaddr->c_pdp_addr);
    sprintf(g_sa,"+CGPADDR: %hd,\"%s\"",cgpaddr->cid,pa);
  }
  else
  {
    sprintf(g_sa,"+CGPADDR: %hd",cgpaddr->cid);
  }      
  io_sendMessage(src_infos_psi->srcId,g_sa,ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_tPlusCGPADDR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_tst_plus_cgpaddr *cgpaddr;
  int pos=0;
  UBYTE n;
  TRACE_FUNCTION ("Resp_tPlusCGPADDR() ");
   /*
  *   Get a pointer to the CGPADDR structure for convenience.
  */
  cgpaddr=resp_p->response.ptr_tst_plus_cgpaddr;

  pos=sprintf(g_sa,"+CGPADDR: (");

  for (n=0;n<cgpaddr->c_cid;n++)
  {
    if (n!=0)
    {
      g_sa[pos]=',';
      pos++;
    }

    pos+=sprintf(g_sa+pos,"%hd",cgpaddr->cid[n]);
  }
  g_sa[pos]=')';
  pos++;
  g_sa[pos]=0;
  io_sendMessage(src_infos_psi->srcId,g_sa,ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_sPercentCGPCO(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_set_percent_cgpco *cgpco;
  U8 pco[BAT_MAX_CGPCO_PCO_LEN+1];
  TRACE_FUNCTION ("Resp_sPercentCGPCO()");
  /*
  *   Get a pointer to the CGPCO structure for convenience.
  */
  cgpco=resp_p->response.ptr_set_percent_cgpco;
  /*
  *   Get a zero-terminated version of the pco string.
  */
  memset(pco,0,sizeof(pco));
  memcpy(pco,cgpco->pco,cgpco->c_pco);
  sprintf(g_sa,"%s\"%s\",%d","%CGPCO: ",pco,cgpco->cid);
  io_sendMessage(src_infos_psi->srcId,g_sa,ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_qPercentCGPPP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPercentCGPPP()");

  sprintf (g_sa, "%s: %d", "%CGPPP", resp_p->response.ptr_que_percent_cgppp->protocol);
  io_sendMessage (src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_qPlusCGQMIN(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_que_plus_cgqmin *cgqmin;
  UBYTE precedence;
  UBYTE delay;
  UBYTE reliability;
  UBYTE peak;
  UBYTE mean;
  TRACE_FUNCTION ("Resp_qPlusCGQMIN()");
   /*
  *   Get a pointer to the CGQMIN structure for convenience.
  */
  cgqmin=resp_p->response.ptr_que_plus_cgqmin;

  precedence=(UBYTE)cgqmin->precedence;
  delay=(UBYTE)cgqmin->delay;
  reliability=(UBYTE)cgqmin->reliability;
  peak=(UBYTE)cgqmin->peak;
  mean=(UBYTE)cgqmin->mean;

  if (precedence==(UBYTE)BAT_PRECEDENCE_NOT_PRESENT)
    precedence=GPRS_QOS_OMITTED;

  if (delay==(UBYTE)BAT_DELAY_NOT_PRESENT)
    delay=GPRS_QOS_OMITTED;

  if (reliability==(UBYTE)BAT_RELIABILITY_NOT_PRESENT)
    reliability=GPRS_QOS_OMITTED;

  if (peak==(UBYTE)BAT_PEAK_NOT_PRESENT)
    peak=GPRS_QOS_OMITTED;

  if (mean==(UBYTE)BAT_MEAN_NOT_PRESENT)
    mean=GPRS_QOS_OMITTED;

  sprintf(
    g_sa,
    "%s%hd,%d,%d,%d,%d,%d",
    "+CGQMIN: ",
    cgqmin->cid,
    precedence,
    delay,
    reliability,
    peak,
    mean);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT); 
  return 0; /* Ok */
}

int Resp_qPlusCGQREQ(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_que_plus_cgqreq *cgqreq;
  UBYTE precedence;
  UBYTE delay;
  UBYTE reliability;
  UBYTE peak;
  UBYTE mean;
  TRACE_FUNCTION ("Resp_qPlusCGQREQ()");
   /*
  *   Get a pointer to the CGQREQ structure for convenience.
  */
  cgqreq=resp_p->response.ptr_que_plus_cgqreq;

  precedence=(UBYTE)cgqreq->precedence;
  delay=(UBYTE)cgqreq->delay;
  reliability=(UBYTE)cgqreq->reliability;
  peak=(UBYTE)cgqreq->peak;
  mean=(UBYTE)cgqreq->mean;

  if (precedence==(UBYTE)BAT_PRECEDENCE_NOT_PRESENT)
    precedence=GPRS_QOS_OMITTED;

  if (delay==(UBYTE)BAT_DELAY_NOT_PRESENT)
    delay=GPRS_QOS_OMITTED;

  if (reliability==(UBYTE)BAT_RELIABILITY_NOT_PRESENT)
    reliability=GPRS_QOS_OMITTED;

  if (peak==(UBYTE)BAT_PEAK_NOT_PRESENT)
    peak=GPRS_QOS_OMITTED;

  if (mean==(UBYTE)BAT_MEAN_NOT_PRESENT)
    mean=GPRS_QOS_OMITTED;

  sprintf(g_sa,"%s%hd,%d,%d,%d,%d,%d",
    "+CGQREQ: ",
    cgqreq->cid,
    precedence,
    delay,
    reliability,
    peak,
    mean);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_qPercentCGREG(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_P_CGREG_STAT  stat;
  USHORT          lac, cid;
  T_ATI_CREG_MOD  mode;
  SHORT           pos;
  T_BAT_res_que_percent_cgreg *cgreg;
  TRACE_FUNCTION ("Resp_qPercentCGREG()");
  /*
  *   Get a pointer to the CGREG structure for convenience.
  */
  cgreg=resp_p->response.ptr_que_percent_cgreg;
  stat=(T_P_CGREG_STAT)cgreg->stat;
  lac=(USHORT)cgreg->lac;
  cid=(USHORT)cgreg->ci;

  mode=ati_gprs_user_output_cfg[(src_infos_psi->srcId)].percent_cgreg.mod_lac_cid.pres_mode;
  pos=sprintf(g_sa,"%s: %d,%d","%CGREG",mode,stat);
  if ((mode==CREG_MOD_LOC_INF_ON) || (mode==CREG_MOD_LOC_INF_ON_CTXACT))
  {
    if ((stat==P_CGREG_STAT_REG_HOME) || (stat==P_CGREG_STAT_REG_ROAM))
      pos += sprintf(g_sa+pos, ",\"%04X\",\"%04X\"", lac, cid);
    else if (mode==CREG_MOD_LOC_INF_ON_CTXACT)
      pos += sprintf(g_sa+pos, ",,");   /* if CTXACT follows so lac and cid are ommitted */
  }
  if (mode==CREG_MOD_LOC_INF_ON_CTXACT)
    sprintf(g_sa+pos,(cgreg->state==BAT_P_CGREG_STATE_STAT_1) ? ",1" : ",0");
  io_sendMessage(src_infos_psi->srcId,g_sa,ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_qPlusCGREG(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_CGREG_STAT stat;
  USHORT          lac, cid;
  T_ATI_CREG_MOD  mode;
  SHORT           pos;
  T_BAT_res_que_plus_cgreg *cgreg;
  TRACE_FUNCTION ("Resp_qPlusCGREG()");
   /*
  *   Get a pointer to the CGREG structure for convenience.
  */
  cgreg=resp_p->response.ptr_que_plus_cgreg;
  stat=(T_P_CGREG_STAT)cgreg->stat;
  lac=(USHORT)cgreg->lac;
  cid=(USHORT)cgreg->ci;
  mode=ati_gprs_user_output_cfg[src_infos_psi->srcId].plus_cgreg.mod_lac_cid.pres_mode;
  pos=sprintf(g_sa, "+CGREG: %d,%d", mode, stat);
  if (mode==CREG_MOD_LOC_INF_ON)
  {
    if((stat==CGREG_STAT_REG_HOME) || (stat==CGREG_STAT_REG_ROAM))
      sprintf(g_sa+pos, ",\"%04X\",\"%04X\"", lac, cid);
  }

  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_qPlusCGSMS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  char *me="+CGSMS: ";
  TRACE_FUNCTION ("Resp_qPlusCGSMS()");

  sprintf(g_sa,"%s%hd", me, (T_CGSMS_SERVICE)resp_p->response.ptr_que_plus_cgsms->service);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

#endif /* GPRS */

int Resp_sPercentCHPL(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_set_percent_chpl *chpl;
  CHAR str[BAT_MAX_CHPL_OPER_LEN+1];
  TRACE_FUNCTION ("Resp_sPercentCHPL()");
  /*
  *   Get a pointer to the CHPL structure for convenience.
  */
  chpl=resp_p->response.ptr_set_percent_chpl;
  /*
  *   Make a zero-terminated version of the operator string.
  */
  memset(str,0,sizeof(str));
  memcpy(str,chpl->oper,chpl->c_oper);
  /*
  *   This relies on the BAT representation of the numeric
  *   format being the same as the ATI representation.
  */
  sprintf(g_sa,"%s: %s","%CHPL",str);
  io_sendMessage (src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_sPercentCHPL_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_sPercentCHPL_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_sPlusCIMI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  CHAR imsi[MAX_IMSI_LEN+1];    
  TRACE_FUNCTION ("Resp_sPlusCIMI()");  
  
  utl_binToHex(resp_p->response.ptr_set_plus_cimi->imsi, 
               resp_p->response.ptr_set_plus_cimi->c_imsi,imsi);
  sprintf(g_sa,"%s",imsi);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_qPlusCIND(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCIND() ");
  resp_disp(src_infos_psi->srcId, NULL,"ee", &resp_p->response.ptr_que_plus_cind->signal,
                               &resp_p->response.ptr_que_plus_cind->smsfull);

  return 0; /* Ok */
}

int Resp_qPlusCLAN(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_que_plus_clan *clan;
  CHAR code[BAT_MAX_CLAN_CODE_LEN+1];
  TRACE_FUNCTION ("Resp_qPlusCLAN()");
  /*
  *   Get a pointer to the CLAN structure for convenience.
  */
  clan=resp_p->response.ptr_que_plus_clan;
  memset(code,0,sizeof(code));
  memcpy(code,clan->code,clan->c_code);
  sprintf(g_sa,"+CLAN: %s",code);
  io_sendMessage(src_infos_psi->srcId,g_sa,ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_tPlusCLAN(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_tst_plus_clan *clan;
  CHAR code[BAT_MAX_CLAN_CODE_LEN+1];
  TRACE_FUNCTION ("Resp_tPlusCLAN() ");
  /*
  *   Get a pointer to the CLAN structure for convenience.
  */
  clan=resp_p->response.ptr_tst_plus_clan;
  memset(code,0,sizeof(code));
  memcpy(code,clan->code,clan->c_code);
  if (clan_buf==NULL)
  {
    clan_buf=g_sa;
    clan_buf+=sprintf(clan_buf,"+CLAN: ");
  }
  else
  {
    *clan_buf++=',';
  }
  clan_buf+=sprintf(clan_buf,"%s",code);
  return 0; /* Ok */
}

int Resp_sPlusCLCK(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  SHORT               pos;  
  TRACE_FUNCTION ("Resp_sPlusCLCK()");
  
  pos = sprintf(g_sa,"+CLCK: ");  
  pos += sprintf(g_sa+pos,"%d,",resp_p->response.ptr_set_plus_clck->status); 
  if (resp_p->response.ptr_set_plus_clck->bearer_class NEQ BAT_CLASS_NOT_PRESENT)
  {
    pos += sprintf(g_sa+pos,"%d,",resp_p->response.ptr_set_plus_clck->bearer_class);
  }
  ci_remTrailCom(g_sa, pos);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_qPlusCLIP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCLIP() ");
  resp_disp(src_infos_psi->srcId,NULL,"be",&ati_user_output_cfg[src_infos_psi->srcId].CLIP_stat,
                               &resp_p->response.ptr_que_plus_clip->m);
  return 0; /* Ok */
}

int Resp_qPlusCLIP_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCLIP_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_qPlusCLIR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  char *me         = "+CLIR: ";
  TRACE_FUNCTION ("Resp_qPlusCLIR()");
  sprintf(g_sa,"%s%d,%d",me,resp_p->response.ptr_que_plus_clir->n,
                          resp_p->response.ptr_que_plus_clir->m);
  io_sendMessage(src_infos_psi->srcId,g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_sPlusCLVL(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_sPlusCLVL() ");
  /* Output nothing as input is bat_dummy*/
  
  return 0; /* Ok */
}

int Resp_qPlusCLVL(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCLVL()");
  
  sprintf ( g_sa, "+CLVL: %d", resp_p->response.ptr_que_plus_clvl->level );
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_qPlusCMER(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCMER() not implemented");

  return 0; /* Ok */
}

int Resp_sPlusCMGC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_MNSMS_COMMAND_CNF mnsms_command_cnf;  
  TRACE_FUNCTION ("Resp_sPlusCMGC()");
  
  mnsms_command_cnf.tp_mr = resp_p->response.ptr_set_plus_cmgc->mr;
  mnsms_command_cnf.sms_sdu.l_buf= resp_p->response.ptr_set_plus_cmgc->c_ackpdu;
  memcpy(mnsms_command_cnf.sms_sdu.buf,resp_p->response.ptr_set_plus_cmgc->ackpdu,mnsms_command_cnf.sms_sdu.l_buf);
  
  rCI_PlusCMGCPdu(&mnsms_command_cnf);  
  return 0; /* Ok */
}

int Resp_sPlusCMGL(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_MNSMS_READ_CNF mnsms_read_cnf;  
  TRACE_FUNCTION ("Resp_sPlusCMGL()"); 
  
  mnsms_read_cnf.status  = resp_p->response.ptr_set_plus_cmgl->stat;  
  /*mnsms_read_cnf.rec_status = resp_p->response.ptr_set_plus_cmgl->stat;*/  
  mnsms_read_cnf.rec_num = (UBYTE)resp_p->response.ptr_set_plus_cmgl->sms_index;  
  mnsms_read_cnf.sms_sdu.l_buf = resp_p->response.ptr_set_plus_cmgl->c_pdu;
  memcpy(mnsms_read_cnf.sms_sdu.buf,resp_p->response.ptr_set_plus_cmgl->pdu,
         resp_p->response.ptr_set_plus_cmgl->c_pdu);  
  rCI_Plus_Percent_CMGLPdu(&mnsms_read_cnf, AT_CMD_CMGL);
  return 0; /* Ok */
}

int Resp_sPercentCMGL(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_MNSMS_READ_CNF mnsms_read_cnf;  
  TRACE_FUNCTION ("Resp_sPercentCMGL()"); 
  
  mnsms_read_cnf.status  = resp_p->response.ptr_set_percent_cmgl->stat;  
  mnsms_read_cnf.rec_num = (UBYTE)resp_p->response.ptr_set_percent_cmgl->sms_index;  
  mnsms_read_cnf.sms_sdu.l_buf = resp_p->response.ptr_set_percent_cmgl->c_pdu;
  memcpy(mnsms_read_cnf.sms_sdu.buf,resp_p->response.ptr_set_percent_cmgl->pdu,
         resp_p->response.ptr_set_percent_cmgl->c_pdu);  
  rCI_Plus_Percent_CMGLPdu(&mnsms_read_cnf, AT_CMD_P_CMGL);
  return 0; /* Ok */
}


int Resp_sPlusCMGL_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_sPlusCMGL_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_sPlusCMGR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_MNSMS_READ_CNF mnsms_read_cnf;
    
  TRACE_FUNCTION ("Resp_sPlusCMGR()");

  mnsms_read_cnf.status = resp_p->response.ptr_set_plus_cmgr->sms_stat;
  mnsms_read_cnf.sms_sdu.l_buf = resp_p->response.ptr_set_plus_cmgr->c_pdu;
  memcpy(mnsms_read_cnf.sms_sdu.buf,resp_p->response.ptr_set_plus_cmgr->pdu,
    resp_p->response.ptr_set_plus_cmgr->c_pdu);
  
  rCI_Plus_Percent_CMGRPdu(&mnsms_read_cnf, AT_CMD_CMGR);

  return 0; /* Ok */
}

int Resp_sPercentCMGR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_MNSMS_READ_CNF mnsms_read_cnf;
    
  TRACE_FUNCTION ("Resp_sPercentCMGR()");

  mnsms_read_cnf.status = resp_p->response.ptr_set_percent_cmgr->sms_stat;
  mnsms_read_cnf.sms_sdu.l_buf = resp_p->response.ptr_set_percent_cmgr->c_pdu;
  memcpy(mnsms_read_cnf.sms_sdu.buf,resp_p->response.ptr_set_percent_cmgr->pdu,
    resp_p->response.ptr_set_percent_cmgr->c_pdu);
  
  rCI_Plus_Percent_CMGRPdu(&mnsms_read_cnf, AT_CMD_P_CMGR);

  return 0; /* Ok */
}



int Resp_sPlusCMGR_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_sPlusCMGR_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_sPlusCMGS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_MNSMS_SUBMIT_CNF mnsms_submit_cnf;
  
  TRACE_FUNCTION ("Resp_sPlusCMGS()");

  /*
   *   Set up the bits of mnsms_submit_cnf that are used by
   *   rCI_PlusCMGSPdu().
   */
  mnsms_submit_cnf.tp_mr=resp_p->response.ptr_set_plus_cmgs->mr;
  mnsms_submit_cnf.sms_sdu.l_buf=0;

  rCI_PlusCMGS(&mnsms_submit_cnf);
  return 0; /* Ok */
}

int Resp_sPlusCMGW(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_sPlusCMGW()");

  rCI_PlusCMGW((UBYTE)resp_p->response.ptr_set_plus_cmgw->index);
  return 0; /* Ok */
}

int Resp_qPlusCMOD(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCMOD()");
  resp_disp (src_infos_psi->srcId, NULL, "e",&resp_p->response.ptr_que_plus_cmod->mode);
  return 0; /* Ok */
}

int Resp_qPlusCMUT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCMUT()");
  sprintf ( g_sa, "+CMUT: %d", resp_p->response.ptr_que_plus_cmut->n);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_qPlusCMUX(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCMUX() not implemented");
  
  return 0; /* Ok */
}

int Resp_qPercentCNAP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPercentCNAP() ");
  
  sprintf(g_sa, "%s%d,%d", "%CNAP: ", ati_user_output_cfg[src_infos_psi->srcId].cnap_mode,
    resp_p->response.ptr_que_percent_cnap->status);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT );
              
  return 0; /* Ok */
}

int Resp_qPlusCNMI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  char*          me   = "+CNMI: "; 
  
  TRACE_FUNCTION ("Resp_qPlusCNMI()");
  
  sprintf ( g_sa,"%s%d,%d,%d,%d,%d", me, at.CNMI_mode,
  resp_p->response.ptr_que_plus_cnmi->mt, resp_p->response.ptr_que_plus_cnmi->bm, 
  resp_p->response.ptr_que_plus_cnmi->ds, at.CNMI_bfr );
  io_sendMessage (src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT );

  return 0; /* Ok */
}

int Resp_sPlusCNUM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_ACI_CNUM_MSISDN msisdn[MAX_MSISDN];
  UBYTE n;
  T_BAT_res_set_plus_cnum *cnum;
  T_ACI_CNUM_MSISDN *ms;

  TRACE_FUNCTION ("Resp_sPlusCNUM()");

  /*
   *   Get a pointer to the CNUM structure for convenience.
   */
  cnum=resp_p->response.ptr_set_plus_cnum;

  /*
   *   Get a pointer to the output data for convenience.
   */
  ms=&msisdn[0];

  /*
   *   rCI_PlusCNUM() ignores the 'num' parameter which is supposed
   *   to indicate the number of items. Instead it assumes that its
   *   'msisdn' parameter is a pointer to an array of MAX_MSISDN
   *   items. We are providing only a single item so here we set
   *   all the other items in the array invalid.
   */
  for (n=1;n<MAX_MSISDN;n++)
      msisdn[n].vldFlag=FALSE;

  ms->vldFlag=TRUE;

  /*
   *   Convert the alphanumeric data into a null terminated string,
   *   which is what the ATI expects.
   */
  memset(ms->alpha,0,MAX_ALPHA_LEN);

  if (cnum->v_alpha==TRUE)
  {
    if (cnum->c_alpha>=MAX_ALPHA_LEN)
        memcpy(ms->alpha,cnum->alpha,MAX_ALPHA_LEN-1);
    else
        memcpy(ms->alpha,cnum->alpha,cnum->c_alpha);
  }

  /*
   *   Convert the number into a null terminated string,
   *   which is what the ATI expects.
   */
  memset(ms->number,0,MAX_PHB_NUM_LEN);

  if (cnum->c_number>=MAX_PHB_NUM_LEN)
      memcpy(ms->number,cnum->number,MAX_PHB_NUM_LEN-1);
  else
      memcpy(ms->number,cnum->number,cnum->c_number);

  ms->type=toa_demerge(cnum->type);

  /*
   *   These are not included in the BAT message, so set them
   *   all to 'not present'.
   */
  ms->speed=BS_SPEED_NotPresent;
  ms->service=CNUM_SERV_NotPresent;
  ms->itc=CNUM_ITC_NotPresent;

  rCI_PlusCNUM(msisdn,1);

  return 0; /* Ok */
}

int Resp_sPlusCNUM_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_sPlusCNUM_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_qPlusCOLP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  UBYTE             x = 0;
  
  TRACE_FUNCTION ("Resp_qPlusCOLP()");
  
  x = (at.flags.COLP_stat?1:0);
  resp_disp(src_infos_psi->srcId, NULL,"be",&x,
              &resp_p->response.ptr_que_plus_colp->m);

  return 0; /* Ok */
}

int Resp_qPlusCOLP_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCOLP_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_qPercentCOPS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  U8 oper[40] = {'\0'};
  TRACE_FUNCTION ("Resp_qPercentCOPS()");

  /* resp_p->response.ptr_que_percent_cops->oper is not NULL terminated */
  memcpy(oper,
         resp_p->response.ptr_que_percent_cops->oper,
         resp_p->response.ptr_que_percent_cops->c_oper);

  /* Added an empty comma and the service Status parameter */
  sprintf(g_sa,
          "%s: %d,%d,\"%s\",,%d","%COPS",
          resp_p->response.ptr_que_percent_cops->mode,
          resp_p->response.ptr_que_percent_cops->format,
          oper, /* resp_p->response.ptr_que_percent_cops->oper, */
          resp_p->response.ptr_que_percent_cops->service);

  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_tPercentCOPS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  char *cmdstr="%COPS";
  T_BAT_res_tst_percent_cops *cops;

  TRACE_FUNCTION ("Resp_tPercentCOPS()");
  /*
   *   Get a pointer to the BAT structure for convenience.
   */
  cops=resp_p->response.ptr_tst_percent_cops;

  if (cops_flag==FALSE)
  {
    cops_flag=TRUE;

    /*
     *   First operator.
     */
    sprintf(g_sa, "%s: (%d,\"%s\",\"%s\",\"%s\")",
            cmdstr,
            cops->status,
            cops->long_oper,
            cops->short_oper,
            cops->num_oper);
    io_sendMessage(src_infos_psi->srcId,g_sa,ATI_NORMAL_OUTPUT);
  }
  else
  {
    /*
     *   Subsequent operators.
     */
    sprintf(g_sa, ",(%d,\"%s\",\"%s\",\"%s\")",
            cops->status,
            cops->long_oper,
            cops->short_oper,
            cops->num_oper);
    io_sendMessage(src_infos_psi->srcId,g_sa,ATI_NORMAL_OUTPUT);
  }

  return 0; /* Ok */
}

int Resp_qPlusCOPS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_que_plus_cops *cops;
  TRACE_FUNCTION ("Resp_qPlusCOPS()");
  /*
  *   Get a pointer to the COPS structure for convenience.
  */
  cops=resp_p->response.ptr_que_plus_cops;
  if (cops->v_oper==TRUE)
  {
    U8 op[BAT_MAX_COPS_OPER_LEN+1];
    /*
    *   Create a zero-terminated version of the operator name.
    */
    memset(op,0,sizeof(op));
    memcpy(op,cops->oper,cops->c_oper);    
    sprintf(g_sa,"+COPS: %d,%d,\"%s\"",cops->mode,cops->format,op);
  }
  else
  {
    sprintf(g_sa,"+COPS: %d",cops->mode);
  }

  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_tPlusCOPS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  char *cmdstr;
  T_BAT_res_tst_plus_cops *cops;
  T_ATI_SRC_PARAMS *src_params = find_element (ati_src_list, src_infos_psi->srcId, search_ati_src_id);

  TRACE_FUNCTION ("Resp_tPlusCOPS()");
  /*
   *   We're in trouble if we don't have 'src_params', as we need
   *   to know the command ID.
   */
  if (src_params==NULL)
  {
    TRACE_EVENT("No src_params in COPS response.");
    return 1; /* Indicate error */
  }

  /*
   *   rBAT_PlusCOPS doubles for both %COPS and +COPS responses.
   */
  if (src_params->curAtCmd==AT_CMD_P_COPS)
      cmdstr = "%COPS";
  else
      cmdstr = "+COPS";

  /*
   *   Get a pointer to the BAT structure for convenience.
   */
  cops=resp_p->response.ptr_tst_plus_cops;

  if (cops_flag==FALSE)
  {
    cops_flag=TRUE;

    /*
     *   First operator.
     */
    sprintf(g_sa, "%s: (%d,\"%s\",\"%s\",\"%s\")",
            cmdstr,
            cops->status,
            cops->long_oper,
            cops->short_oper,
            cops->num_oper);

    io_sendMessage(src_infos_psi->srcId,g_sa,ATI_NORMAL_OUTPUT);
  }
  else
  {
    /*
     *   Subsequent operators.
     */
    sprintf(g_sa, ",(%d,\"%s\",\"%s\",\"%s\")",
            cops->status,
            cops->long_oper,
            cops->short_oper,
            cops->num_oper);

    io_sendMessage(src_infos_psi->srcId,g_sa,ATI_NORMAL_OUTPUT);
  }
  return 0; /* Ok */
}

int Resp_qPercentCOPS_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPercentCOPS_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_tPercentCOPS_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_tPercentCOPS_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_sPercentCPALS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  CHAR        msisdn_id[BAT_MAX_CPALS_MSISDN_ID_LEN + 1] ;
  TRACE_FUNCTION ("Resp_sPercentCPALS() ");

  utl_binToHex(resp_p->response.ptr_set_percent_cpals->msisdn_id,
               (SHORT)resp_p->response.ptr_set_percent_cpals->c_msisdn_id ,
                msisdn_id);
  
  sprintf(g_sa, "%s: %d,\"%s\"", "%CPALS", 
       resp_p->response.ptr_set_percent_cpals->lines, 
       msisdn_id);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_qPercentCPALS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPercentCPALS() ");

  sprintf(g_sa, "%s: %d", "%CPALS", 
       resp_p->response.ptr_que_percent_cpals->lines); 
       
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_sPercentCPALS_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_sPercentCPALS_W() not implemented");

  return 0; /* Ok */
}

int Resp_qPercentCPALS_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPercentCPALS_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_sPlusCPAS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_sPlusCPAS()");

  resp_disp(src_infos_psi->srcId, NULL, "e", &resp_p->response.ptr_set_plus_cpas->pas);
  return 0; /* Ok */
}

int Resp_sPlusCPBF(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_set_plus_cpbf *cpbf;
  USHORT pos;
  U8 num[BAT_MAX_CPBF_NUMBER_LEN+1];
  CHAR cvtd_text[2*BAT_MAX_CPBF_TEXT_LEN];
  USHORT len_cvtd_text;
  TRACE_FUNCTION ("Resp_sPlusCPBF()");
  /*
  *   Get a pointer to the CPBF structure for convenience.
  */
  cpbf=resp_p->response.ptr_set_plus_cpbf;
  memset(num,0,sizeof(num));
  memcpy(num,cpbf->number,cpbf->c_number);
  pos=sprintf(g_sa,"+CPBF: %d,\"%s\",%d,",cpbf->index,num,cpbf->type);
  utl_chsetFromSim(
    (UBYTE*)cpbf->text,
    (USHORT)cpbf->c_text,
    (UBYTE*)cvtd_text,
    sizeof(cvtd_text),
    &len_cvtd_text,
    GSM_ALPHA_Def);
  pos+=sprints(g_sa+pos,cvtd_text,len_cvtd_text);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_tPlusCPBF(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_tst_plus_cpbf *cpbf;
  TRACE_FUNCTION ("Resp_tPlusCPBF()");
  /*
  *   Get a pointer to the CPBF structure for convenience.
  */
  cpbf=resp_p->response.ptr_tst_plus_cpbf;
  resp_disp(src_infos_psi->srcId,NULL,"bb",(UBYTE *)&cpbf->nlength,(UBYTE *)&cpbf->tlength);
  return 0; /* Ok */
}

int Resp_sPlusCPBF_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  
  TRACE_FUNCTION ("Resp_sPlusCPBF_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_tPlusCPBF_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_tPlusCPBF_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_sPlusCPBR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  USHORT pos = 0;
  TRACE_FUNCTION ("Resp_sPlusCPBR()");

  if (resp_p->response.ptr_set_plus_cpbr->index NEQ ACI_NumParmNotPresent)
  {
    CHAR         cvtdText[4*MAX_ALPHA_LEN]  = {0x00};  /* need enough space for UCS2 strings */
    USHORT       lenCvtdText                = 0;

    pos=sprintf(g_sa,"+CPBR: %d,\"%s\",%d,",
                resp_p->response.ptr_set_plus_cpbr->index,
                resp_p->response.ptr_set_plus_cpbr->number,
                resp_p->response.ptr_set_plus_cpbr->type);

    utl_chsetFromSim((UBYTE*)resp_p->response.ptr_set_plus_cpbr->text,
                     resp_p->response.ptr_set_plus_cpbr->c_text,
                     (UBYTE*)cvtdText,
                     sizeof(cvtdText),
                     &lenCvtdText,
                     GSM_ALPHA_Def);

    pos+=sprints(g_sa+pos,cvtdText,lenCvtdText);
    io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  }

  return 0; /* Ok */
}

int Resp_tPlusCPBR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_tPlusCPBR()");

  sprintf(g_sa,"+CPBR: (%d-%d),%d,%d",
          resp_p->response.ptr_tst_plus_cpbr->index_f,
          resp_p->response.ptr_tst_plus_cpbr->index_l,
          resp_p->response.ptr_tst_plus_cpbr->nlength,
          resp_p->response.ptr_tst_plus_cpbr->tlength);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_sPlusCPBR_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_sPlusCPBR_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_tPlusCPBR_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_tPlusCPBR_W() Not Implemented");
  return 0; /* Ok */
}

int Resp_qPercentCPBS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  SHORT i;
  TRACE_FUNCTION ("Resp_qPercentCPBS()");

  for(i=0;phb_mem_names[i].name NEQ NULL;i++)
  {
    if (phb_mem_names[i].stor EQ resp_p->response.ptr_que_percent_cpbs->storage)
    {
      sprintf(g_sa,"%s: \"%s\",%d,%d,%d","%CPBS",
        phb_mem_names[i].name,
        resp_p->response.ptr_que_percent_cpbs->used,
        resp_p->response.ptr_que_percent_cpbs->total,
        resp_p->response.ptr_que_percent_cpbs->first);

      io_sendMessage((UBYTE)src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
      break;
    }
  }

  return(0); /* Ok */
}

int Resp_qPlusCPBS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  SHORT i;
  TRACE_FUNCTION ("Resp_qPlusCPBS()");

  for(i=0;phb_mem_names[i].name NEQ NULL;i++)
  {
    if (phb_mem_names[i].stor EQ resp_p->response.ptr_que_plus_cpbs->storage)
    {
      sprintf(g_sa,"+CPBS: \"%s\",%d,%d",
              phb_mem_names[i].name,
              resp_p->response.ptr_que_plus_cpbs->used,
              resp_p->response.ptr_que_plus_cpbs->total);
      io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
      break;
    }
  }

  return 0; /* Ok */
}

int Resp_tPlusCPBW(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_tPlusCPBW()");
  sprintf(g_sa,"%s(%d-%d),%d,%s,%d",
          "+CPBW: ",
          resp_p->response.ptr_tst_plus_cpbw->index1,
          resp_p->response.ptr_tst_plus_cpbw->index2,
          resp_p->response.ptr_tst_plus_cpbw->nlength,
          "(128-201)",
          resp_p->response.ptr_tst_plus_cpbw->tlength);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_tPlusCPBW_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_tPlusCPBW_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_sPercentCPCFU(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_sPercentCPCFU()");

  if(resp_p->response.ptr_set_percent_cpcfu->status EQ BAT_P_CPCFU_STATUS_ACTIVATED)
  {
    sprintf(g_sa, "%s: %d,%d", "%CPCFU", CPHS_FLAG_ACTIVATED, 
                                   resp_p->response.ptr_set_percent_cpcfu->line);
  }
  else
  {
    sprintf(g_sa, "%s: %d", "%CPCFU", CPHS_FLAG_DEACTIVATED);
  }

  io_sendMessage((UBYTE)src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_qPercentCPHS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPercentCPHS() ");

  sprintf(g_sa, "%s%d", "%CPHS: ", 
                    resp_p->response.ptr_que_percent_cphs->init_mode);
  io_sendMessage((UBYTE)src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_qPlusCPIN(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCPIN() ");

  rCI_PlusCPIN(resp_p->response.ptr_que_plus_cpin->code);
        
  return 0; /* Ok */
}

int Resp_qPercentCPINF(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPercentCPINF()");

  if (resp_p->response.ptr_que_percent_cpinf->c_csp > 0)
  {
    if (resp_p->response.ptr_que_percent_cpinf->c_csp2 > 0)
    {
      sprintf(g_sa, "%s: %d,\"%04X\",\"%s\",\"%s\"", "%CPINF",
              resp_p->response.ptr_que_percent_cpinf->phase, 
              resp_p->response.ptr_que_percent_cpinf->sst,
              resp_p->response.ptr_que_percent_cpinf->csp,
              resp_p->response.ptr_que_percent_cpinf->csp2);
    }
    else
    {
      sprintf(g_sa, "%s: %d,\"%04X\",\"%s\"", "%CPINF",
              resp_p->response.ptr_que_percent_cpinf->phase, 
              resp_p->response.ptr_que_percent_cpinf->sst,
              resp_p->response.ptr_que_percent_cpinf->csp);
    }

  }
  else
  {
    sprintf(g_sa, "%s: %d,\"%04X\"", "%CPINF",
          resp_p->response.ptr_que_percent_cpinf->phase, 
          resp_p->response.ptr_que_percent_cpinf->sst);
  }
  io_sendMessage((UBYTE)src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_qPercentCPMB(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPercentCPMB()");

  sprintf(g_sa,"%s: %d","%CPMB",resp_p->response.ptr_que_percent_cpmb->first);
  io_sendMessage((UBYTE)src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return(0); /* Ok */
}

int Resp_sPercentCPMB(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  CHAR       number[BAT_MAX_CPMB_NUMBER_LEN + 1] = {'\0'};
  CHAR*      p_number;
  CHAR       alpha_id[BAT_MAX_CPMB_ALPHA_ID_LEN + 1] = {'\0'};
  CHAR*      p_alpha_id;
  T_BAT_res_set_percent_cpmb *cpmb;
    
  TRACE_FUNCTION ("Resp_sPercentCPMB()");

  /*
  *   Get a pointer to the CPMB structure for convenience.
  */
  cpmb=resp_p->response.ptr_set_percent_cpmb;

  /*
  *   Don't output anything if there is no actual number. This is in line
  *   with the existing ATI implementation (see setatPercentCPMB()) and
  *   is necessary in order to pass tests such as ACI583.
  */
  if (cpmb->v_number EQ FALSE)
    return(0);

  p_number = number;
  p_alpha_id = alpha_id ;
  
  /*
  *   Zero the arrays to ensure that we end up with null-terminated
  *   strings following the memcpy.
  */
  memset(number,0,sizeof(number));
  memset(alpha_id,0,sizeof(alpha_id));
  
  if ((cpmb->v_number NEQ FALSE) AND (cpmb->c_number<=BAT_MAX_CPMB_NUMBER_LEN))
    memcpy(number,cpmb->number,cpmb->c_number);    
  else
    p_number = NULL;

  if ((cpmb->v_alpha_id NEQ FALSE) AND (cpmb->c_alpha_id<=BAT_MAX_CPMB_ALPHA_ID_LEN))
    memcpy(alpha_id,cpmb->alpha_id,cpmb->c_alpha_id);
  else
    p_alpha_id = NULL;
  
  sprintf(g_sa,"%s: %d,%d,\"%s\",%d,\"%s\"", "%CPMB", 
              resp_p->response.ptr_set_percent_cpmb->record_id, 
              resp_p->response.ptr_set_percent_cpmb->line,
              p_number,
              resp_p->response.ptr_set_percent_cpmb->type,
              p_alpha_id);
  io_sendMessage((UBYTE)src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_tPercentCPMBW(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  char           *me = "%CPMBW: ";
  TRACE_FUNCTION ("Resp_tPercentCPMBW() ");

  sprintf(g_sa,"%s(%d-%d),%d,%s,%d",me,
     resp_p->response.ptr_tst_percent_cpmbw->min_rec_id,
     resp_p->response.ptr_tst_percent_cpmbw->max_rec_id,
     resp_p->response.ptr_tst_percent_cpmbw->nlength,
     "(128-201)",
     resp_p->response.ptr_tst_percent_cpmbw->tlength);
    io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_tPercentCPMBW_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_tPercentCPMBW_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_sPercentCPMB_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_sPercentCPMB_W() Not Implemented");

  return 0; /* Ok */
}


int Resp_sPlusCPMS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_ACI_SMS_STOR_OCC mem1;
  T_ACI_SMS_STOR_OCC mem2;
  T_ACI_SMS_STOR_OCC mem3;

  TRACE_FUNCTION ("Resp_sPlusCPMS() ");

  mem1.mem   = (T_ACI_SMS_STOR)resp_p->response.ptr_set_plus_cpms->mem1;
  mem1.total = (SHORT)resp_p->response.ptr_set_plus_cpms->total1;
  mem1.used  = (SHORT)resp_p->response.ptr_set_plus_cpms->used1;

  mem2.mem   = (T_ACI_SMS_STOR)resp_p->response.ptr_set_plus_cpms->mem2;
  mem2.total = (SHORT)resp_p->response.ptr_set_plus_cpms->total2;
  mem2.used  = (SHORT)resp_p->response.ptr_set_plus_cpms->used2;

  mem3.mem   = (T_ACI_SMS_STOR)resp_p->response.ptr_set_plus_cpms->mem3;
  mem3.total = (SHORT)resp_p->response.ptr_set_plus_cpms->total3;
  mem3.used  = (SHORT)resp_p->response.ptr_set_plus_cpms->used3;
 
  rCI_PlusCPMS  (&mem1, &mem2, &mem3);

  return 0; /* Ok */
}

int Resp_qPlusCPMS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  CHAR* me         = "+CPMS: ";
  int   i          = 0;
  CHAR  memstr1[3] = {0};
  CHAR  memstr2[3] = {0};
  CHAR  memstr3[3] = {0};
  BOOL  f1         = TRUE;
  BOOL  f2         = TRUE;
  BOOL  f3         = TRUE;
    
  TRACE_FUNCTION ("Resp_qPlusCPMS() ");
  
  if ( cpmsCallType EQ QAT_CALL )
  {
    for ( i=0; sms_mem[i].name != NULL; i++ )
    {
      if ( ( sms_mem[i].stor EQ resp_p->response.ptr_que_plus_cpms->mem1) AND f1 )
      {
        strcpy ( memstr1, sms_mem[i].name );
        f1 = FALSE;
      }

      if ( ( sms_mem[i].stor EQ resp_p->response.ptr_que_plus_cpms->mem2) AND f2 )
      {
        strcpy ( memstr2, sms_mem[i].name );
        f2 = FALSE;
      }

      if ( ( sms_mem[i].stor EQ resp_p->response.ptr_que_plus_cpms->mem3) AND f3 )
      {
        strcpy ( memstr3, sms_mem[i].name );
        f3 = FALSE;
      }
    }
    sprintf ( g_sa, "%s\"%s\",%d,%d,\"%s\",%d,%d,\"%s\",%d,%d",
              me, memstr1, resp_p->response.ptr_que_plus_cpms->used1, resp_p->response.ptr_que_plus_cpms->total1,
                  memstr2, resp_p->response.ptr_que_plus_cpms->used2, resp_p->response.ptr_que_plus_cpms->total2,
                  memstr3, resp_p->response.ptr_que_plus_cpms->used3, resp_p->response.ptr_que_plus_cpms->total3);
  }
  else
  {
    sprintf ( g_sa, "%s%d,%d,%d,%d,%d,%d",
              me, resp_p->response.ptr_que_plus_cpms->used1, resp_p->response.ptr_que_plus_cpms->total1,
                  memstr2, resp_p->response.ptr_que_plus_cpms->used2, resp_p->response.ptr_que_plus_cpms->total2,
                  memstr3, resp_p->response.ptr_que_plus_cpms->used3, resp_p->response.ptr_que_plus_cpms->total3);
  }

  io_sendMessage ( src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT );
  
  cpmsCallType = NONE_CALL; 
  return 0; /* Ok */
    
}

int Resp_sPercentCPNUMS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_sPercentCPNUMS() ");

  sprintf(g_sa, "%s%d,\"%s\",\"%s\",%d,%d,%d", "%CPNUMS: ",
              resp_p->response.ptr_set_percent_cpnums->element_id,
              resp_p->response.ptr_set_percent_cpnums->alpha_tag, 
              resp_p->response.ptr_set_percent_cpnums->number, 
              resp_p->response.ptr_set_percent_cpnums->index_level, 
              resp_p->response.ptr_set_percent_cpnums->premium_flag,
              resp_p->response.ptr_set_percent_cpnums->network_flag);

  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_tPercentCPNUMS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  CHAR  alpha_tag[BAT_MAX_CPNUMS_ALPHA_TAG_LEN + 1];
  CHAR  number[BAT_MAX_CPNUMS_NUMBER_LEN + 1];
  
  TRACE_FUNCTION ("Resp_tPercentCPNUMS() ");

  utl_binToHex(resp_p->response.ptr_set_percent_cpnums->alpha_tag,
               (SHORT)resp_p->response.ptr_set_percent_cpnums->c_alpha_tag,
               alpha_tag);
  
  utl_binToHex(resp_p->response.ptr_set_percent_cpnums->number,
               (SHORT)resp_p->response.ptr_set_percent_cpnums->c_number,
               number);
  
  sprintf(g_sa, "%s%d,\"%s\",\"%s\",%d,%d,%d", "%CPNUMS: ",
              resp_p->response.ptr_tst_percent_cpnums->element_id,
              alpha_tag, number,
              resp_p->response.ptr_tst_percent_cpnums->index_level,
              resp_p->response.ptr_tst_percent_cpnums->premium_flag,
              resp_p->response.ptr_tst_percent_cpnums->network_flag);

  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_sPercentCPNUMS_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_sPercentCPNUMS_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_tPercentCPNUMS_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_tPercentCPNUMS_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_qPlusCPOL(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_ACI_CPOL_OPDESC op[2];
  T_BAT_res_que_plus_cpol *cpol;

  TRACE_FUNCTION ("Resp_qPlusCPOL()");

  /*
   *   Get a pointer to the CPOL structure for convenience.
   */
  cpol=resp_p->response.ptr_que_plus_cpol;

  /*
   *   This represents a termination of the list of operators
   *   as far as rCI_PlusCPOL() is concerned. In this case
   *   our list contains only a single operator.
   */
  op[1].index=ACI_NumParmNotPresent;

  /*
   *   Convert the operator name into a null terminated string,
   *   which is what the ATI expects.
   */
  memset(op[0].oper,0,MAX_ALPHA_OPER_LEN);
  if (cpol->c_oper>=MAX_ALPHA_OPER_LEN)
      memcpy(op[0].oper,cpol->oper,MAX_ALPHA_OPER_LEN-1);
  else
      memcpy(op[0].oper,cpol->oper,cpol->c_oper);

  /*
   *   This relies on T_ACI_CPOL_FRMT being identical to
   *   T_BAT_plus_cpol_format.
   */
  op[0].format=(T_ACI_CPOL_FRMT)cpol->format;

  op[0].index=(SHORT)cpol->index;

  rCI_PlusCPOL(
               ACI_NumParmNotPresent,
               ACI_NumParmNotPresent,
               op,
               ACI_NumParmNotPresent);
  return 0; /* Ok */
}

int Resp_tPlusCPOL(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_tPlusCPOL()");

  rCI_PlusCPOL((SHORT)resp_p->response.ptr_tst_plus_cpol->index1,
               (SHORT)resp_p->response.ptr_tst_plus_cpol->index2,
               NULL,
               ACI_NumParmNotPresent);

  return 0; /* Ok */
}

int Resp_qPlusCPOL_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCPOL_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_tPlusCPOL_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_tPlusCPOL_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_qPercentCPOPN(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{ 
  CHAR long_name[BAT_MAX_CPOPN_LONG_NAME_LEN + 1];
  CHAR short_name[BAT_MAX_CPOPN_SHORT_NAME_LEN + 1];
  
  TRACE_FUNCTION ("Resp_qPercentCPOPN() ");
  
  utl_binToHex(resp_p->response.ptr_que_percent_cpopn->long_name,
               (SHORT)resp_p->response.ptr_que_percent_cpopn->c_long_name,
                long_name);
  
  if(resp_p->response.ptr_que_percent_cpopn->v_short_name)
  utl_binToHex(resp_p->response.ptr_que_percent_cpopn->short_name,
               (SHORT)resp_p->response.ptr_que_percent_cpopn->c_short_name,
                short_name);

  if ( resp_p->response.ptr_que_percent_cpopn->v_short_name)
  {
    sprintf(g_sa, "%s: \"%s\",\"%s\"", "%CPOPN", long_name, short_name);
  }
  else
  {
    sprintf(g_sa, "%s: \"%s\"", "%CPOPN", long_name);
  }
  io_sendMessage((UBYTE)src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_qPercentCPRSM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  char *me = "%CPRSM";
  TRACE_FUNCTION ("Resp_qPercentCPRSM()");

  sprintf(g_sa,"%s: %d", me, resp_p->response.ptr_que_percent_cprsm->mode);
  io_sendMessage((UBYTE)src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_qPlusCPUC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  char         currency     [BAT_MAX_CPUC_CURRENCY_LEN+1]       = {0x00};
  char         cvtdCurrency [2*BAT_MAX_CPUC_CURRENCY_LEN+1]     = {0x00};
  USHORT       lenCurrency                      = 0;
  USHORT       lenCvtdCurrency                  = 0;
  USHORT       pos                              = 0;
  char         ppu          [BAT_MAX_CPUC_PPU_LEN+1]    = {0x00};
  
  TRACE_FUNCTION ("Resp_qPlusCPUC()");
  utl_binToHex(resp_p->response.ptr_que_plus_cpuc->currency,
              (SHORT)resp_p->response.ptr_que_plus_cpuc->c_currency,
              currency);
  utl_binToHex(resp_p->response.ptr_que_plus_cpuc->ppu,
              (SHORT)resp_p->response.ptr_que_plus_cpuc->c_ppu,
               ppu);
  utl_chsetFromGsm((UBYTE*)currency,
                   (USHORT)strlen(currency),
                   (UBYTE*)cvtdCurrency,
                   sizeof(cvtdCurrency),
                   &lenCvtdCurrency,
                   GSM_ALPHA_Def);
  pos = sprintf(g_sa,"+CPUC: ");
  pos += sprints(g_sa+pos,cvtdCurrency,lenCvtdCurrency);
  pos += sprintf(g_sa+pos,",\"%s\"",ppu);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_qPlusCPUC_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCPUC_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_sPercentCPVWI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_sPercentCPVWI()");

  if(resp_p->response.ptr_set_percent_cpvwi->status EQ BAT_P_CPVWI_FLAG_ACTIVATED)

    sprintf(g_sa, "%s: %d,%d", "%CPVWI", resp_p->response.ptr_set_percent_cpvwi->status,
                                       resp_p->response.ptr_set_percent_cpvwi->line);
  else
    sprintf(g_sa, "%s: %d", "%CPVWI", resp_p->response.ptr_set_percent_cpvwi->status);
  
  io_sendMessage((UBYTE)src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  

  return 0; /* Ok */
}

int Resp_qPercentCREG(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_ATI_CREG_MOD  mode;
  T_ACI_CREG_STAT stat;
  short           pos;
  TRACE_FUNCTION ("Resp_qPercentCREG() ");
/*
  r_plus_percent_CREG  ( src_infos_psi->srcId,
                         resp_p->response.ptr_que_percent_creg->stat,
                         (USHORT)resp_p->response.ptr_que_percent_creg->lac,
                         (USHORT)resp_p->response.ptr_que_percent_creg->ci,
                         PercentCREG_CMD,
                         resp_p->response.ptr_que_percent_creg->gprs_ind,
                         FALSE );
*/

  mode = ati_user_output_cfg[src_infos_psi->srcId].percent_creg.mod_lac_cid.pres_mode;
  stat = resp_p->response.ptr_que_percent_creg->stat; 

  pos = sprintf(g_sa, "%s: %d,%d", "%CREG", mode, stat);
  
  if ((mode EQ CREG_MOD_LOC_INF_ON)  AND
      (stat EQ CREG_STAT_Reg  OR  stat EQ CREG_STAT_Roam))
  {
    pos += sprintf(g_sa+pos, ",\"%04X\",\"%04X\"", 
                   (USHORT)resp_p->response.ptr_que_percent_creg->lac, 
                   (USHORT)resp_p->response.ptr_que_percent_creg->ci);
  }
  else
  {
    pos += sprintf(g_sa+pos, ",,");
  }
  
  sprintf(g_sa+pos,",%d", resp_p->response.ptr_que_percent_creg->gprs_ind);

  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_tPlusCRES(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_tPlusCRES() some error no min filed present!!!");

  sprintf ( g_sa, "+CRES: (%d-%d)",resp_p->response.ptr_tst_plus_cres->max,
                            /*need a min filed*/
                                   resp_p->response.ptr_tst_plus_cres->max);
  io_sendMessage (src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT );

  return 0; /* Ok */
}

int Resp_qPlusCRLP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCRLP()");
  
  resp_disp(src_infos_psi->srcId,NULL,"ssss",&(resp_p->response.ptr_que_plus_crlp->iws),
                             &(resp_p->response.ptr_que_plus_crlp->mws),
                             &(resp_p->response.ptr_que_plus_crlp->t1),
                             &(resp_p->response.ptr_que_plus_crlp->n2));

  return 0; /* Ok */
}

int Resp_sPlusCRSM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_set_plus_crsm *crsm;

  TRACE_FUNCTION ("Resp_sPlusCRSM() ");
  /*
  *   Get a pointer to the CRSM structure for convenience.
  */
  crsm=resp_p->response.ptr_set_plus_crsm;
  rCI_PlusCRSM(
    (SHORT)crsm->sw1,
    (SHORT)crsm->sw2,
    (SHORT)crsm->c_response,
    (UBYTE *)crsm->response);
  return 0; /* Ok */
}

int Resp_tPlusCSAS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_tPlusCSAS() ");

  sprintf ( g_sa, "+CSAS: (0-%d)", resp_p->response.ptr_tst_plus_csas->max - 1 );
  io_sendMessage (src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT );

  return 0; /* Ok */
}

int Resp_qPlusCSCA(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  CHAR          sca[MAX_SMS_NUM_LEN] = {'\0'};
  T_ACI_TOA     tosca;
  TRACE_FUNCTION ("Resp_qPlusCSCA() ");
 
/*  utl_binToHex(resp_p->response.ptr_que_plus_csca->sca, 
              (SHORT)resp_p->response.ptr_que_plus_csca->c_sca,
              sca);
*/ 
  if (resp_p->response.ptr_que_plus_csca->c_sca > 0)
  {
    memcpy(sca,
           resp_p->response.ptr_que_plus_csca->sca,
           (SHORT)resp_p->response.ptr_que_plus_csca->c_sca);
  }
 
  tosca=toa_demerge((SHORT)resp_p->response.ptr_que_plus_csca->tosca);
  sprintf(g_sa, "+CSCA: \"%s%s\",%d", (tosca.ton EQ TON_International)?"+":"", 
                             sca, resp_p->response.ptr_que_plus_csca->tosca);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_qPlusCSCB(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  int  i, pos;
  char mids_str[6*BAT_MAX_IDENTS+1]={'\0'};
  char dcss_str[4*BAT_MAX_IDENTS+1]={'\0'};
    
  TRACE_FUNCTION ("Resp_qPlusCSCB()");
   
  /* assemble the string for message identifiers */
  pos = i = 0;
  while ((resp_p->response.ptr_que_plus_cscb->mids[i]   NEQ 0xFFFF)
    AND  (resp_p->response.ptr_que_plus_cscb->mids[i+1] NEQ 0xFFFF)
    AND  (i < BAT_MAX_IDENTS-1))
  {
    if (resp_p->response.ptr_que_plus_cscb->mids[i] EQ resp_p->response.ptr_que_plus_cscb->mids[i+1])
    {
      pos += sprintf ( mids_str + pos, "%d,", resp_p->response.ptr_que_plus_cscb->mids[i] );
    }
    else
    {
      pos += sprintf ( mids_str + pos, "%d-%d,", resp_p->response.ptr_que_plus_cscb->mids[i], 
                                                 resp_p->response.ptr_que_plus_cscb->mids[i+1] );
    }
    i += 2;
  }

  if (pos > 0) /* remove the last ',' */
  {
    mids_str[pos-1] = '\0';
  }

  /* assemble the string for data coding schemes */
  pos = i = 0;
  
  while ((resp_p->response.ptr_que_plus_cscb->dcss[i]   NEQ 0xFF)
    AND  (resp_p->response.ptr_que_plus_cscb->dcss[i+1] NEQ 0xFF)
    AND  (i < BAT_MAX_IDENTS-1))
  {
    if (resp_p->response.ptr_que_plus_cscb->dcss[i] EQ resp_p->response.ptr_que_plus_cscb->dcss[i+1])
    {
      pos += sprintf(dcss_str + pos, "%d,", resp_p->response.ptr_que_plus_cscb->dcss[i]);
    }
    else
    {
      pos += sprintf(dcss_str + pos, "%d-%d,", resp_p->response.ptr_que_plus_cscb->dcss[i], 
                                               resp_p->response.ptr_que_plus_cscb->dcss[i+1]);
    }
    i += 2;
  }
  
  if (pos > 0) /* remove the last ',' */
  {
    dcss_str[pos-1] = '\0';
  }

  sprintf(g_sa,"+CSCB: %d,\"%s\",\"%s\"",resp_p->response.ptr_que_plus_cscb->mode,mids_str,dcss_str);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_qPlusCSCS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCSCS()");

  strcpy ( g_sa, "+CSCS: ");

  switch (resp_p->response.ptr_que_plus_cscs->cs)
  {
    case (BAT_CSCS_CS_IRA     ): strcat (g_sa,"\"IRA\""    ); break;
    case (BAT_CSCS_CS_PCDN    ): strcat (g_sa,"\"PCDN\""   ); break;
    case (BAT_CSCS_CS_8859_1  ): strcat (g_sa,"\"8859-1\"" ); break;
    case (BAT_CSCS_CS_PCCP_437): strcat (g_sa,"\"PCCP437\""); break;
    case (BAT_CSCS_CS_GSM     ): strcat (g_sa,"\"GSM\""    ); break;
    case (BAT_CSCS_CS_HEX     ): strcat (g_sa,"\"HEX\""    ); break;
    case (BAT_CSCS_CS_UCS2    ): strcat (g_sa,"\"UCS2\""   ); break;

    default:
      /*
       *   It's probably best to do nothing at all at this point. An
       *   error message would just confuse the issue as aci_bat_wrapper()
       *   will cause an OK to be sent and we can't stop it now.
       *   Shouldn't get here anyway.
       */
      cmdErrStr=NULL;
      return(0);
  }

  io_sendMessage(src_infos_psi->srcId,g_sa,ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_sPlusCSIM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_set_plus_csim *csim;
  
  TRACE_FUNCTION ("Resp_sPlusCSIM()");
  /*
  *   Get a pointer to the CSIM structure for convenience.
  */
  csim=resp_p->response.ptr_set_plus_csim;
  rCI_PlusCSIM(
    (SHORT)csim->c_response,
    (UBYTE *)csim->response);
  return 0; /* Ok */
}

int Resp_qPlusCSMS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCSMS()");
  sprintf(g_sa,"+CSMS: %d,%d,%d,%d",resp_p->response.ptr_que_plus_csms->service,
      resp_p->response.ptr_que_plus_csms->mt,resp_p->response.ptr_que_plus_csms->mo,
      resp_p->response.ptr_que_plus_csms->bm);
  io_sendMessage(src_infos_psi->srcId,g_sa, ATI_NORMAL_OUTPUT);
  
  return 0; /* Ok */
}

int Resp_qPlusCSNS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCSNS()");
  resp_disp (src_infos_psi->srcId, NULL,"e",&resp_p->response.ptr_que_plus_csns->mode);

  return 0; /* Ok */
}

int Resp_qPercentCSQ(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPercentCSQ()");
  sprintf (g_sa, "%s %d, %d, %d", "%CSQ: ",resp_p->response.ptr_que_percent_csq->rssi,
  resp_p->response.ptr_que_percent_csq->ber, resp_p->response.ptr_que_percent_csq->actlevel);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_sPlusCSQ(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_sPlusCSQ()");

  sprintf (g_sa, "+CSQ: %d,%d ", resp_p->response.ptr_set_plus_csq->rssi,
                                 resp_p->response.ptr_set_plus_csq->ber );
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_qPlusCSTA(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCSTA()");  
  resp_disp(src_infos_psi->srcId, NULL,"s",&resp_p->response.ptr_que_plus_csta->type);

  return 0; /* Ok */
}

int Resp_qPlusCSVM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  CHAR num[BAT_MAX_CSVM_NUMBER_LEN+1];
  
  TRACE_FUNCTION ("Resp_qPlusCSVM()");
  /*
  *   Get a pointer to the CSVM structure for convenience.
  */  
  memset(num,0,sizeof(num));  
  utl_binToHex(resp_p->response.ptr_que_plus_csvm->number,
               resp_p->response.ptr_que_plus_csvm->c_number, num);
  sprintf(g_sa,"+CSVM: %d,\"%s\",%d",resp_p->response.ptr_que_plus_csvm->mode,
          num,resp_p->response.ptr_que_plus_csvm->type);  
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_qPercentCTTY(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPercentCTTY()");
  if (resp_p->response.ptr_que_percent_ctty->trx EQ CTTY_TRX_Unknown)
      resp_disp (src_infos_psi->srcId,NULL,"ee", 
                 &resp_p->response.ptr_que_percent_ctty->req, 
                 &resp_p->response.ptr_que_percent_ctty->m);
    else
      resp_disp (src_infos_psi->srcId, NULL ,"eee", &resp_p->response.ptr_que_percent_ctty->req, 
                         &resp_p->response.ptr_que_percent_ctty->m, &resp_p->response.ptr_que_percent_ctty->trx);

  return 0; /* Ok */
}

int Resp_qPlusCTZU(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusCTZU() ");
  sprintf(g_sa,"+CTZU: %d", resp_p->response.ptr_que_plus_ctzu->onoff);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_qPercentCUST(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPercentCUST()");
  sprintf(g_sa,"%CUST: %d", resp_p->response.ptr_que_percent_cust->mode);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_qPercentSATCC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPercentSATCC()");
  sprintf(g_sa,"%%SATCC: %d", resp_p->response.ptr_que_percent_satcc->mode);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_qPercentDATA(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  char          *pktioName = "PKTIO";
  char*         des_name;
  char*         src_name;
  T_CAP_ID      capability = DEV_CPBLTY_NONE;
  
  TRACE_FUNCTION ("Resp_qPercentDATA() ");
  
  des_name = dti_entity_name[resp_p->response.ptr_que_percent_data->des_dev_name].name;
  src_name = dti_entity_name[resp_p->response.ptr_que_percent_data->src_dev_name].name;
  capability = map_dti_cpblty((U8)resp_p->response.ptr_que_percent_data->capability);

  #ifdef GPRS
  if (resp_p->response.ptr_que_percent_data->des_dev_name 
               EQ BAT_DEV_NAME_PKTIO)
  {
    des_name = pktioName;
  }

  if (resp_p->response.ptr_que_percent_data->src_dev_name 
               EQ BAT_DEV_NAME_PKTIO)
  {
    src_name = pktioName;
  }
  #endif

  sprintf (g_sa,"%s: %d,\"%s\",%d,%d,\"%s\",\"%s\",%d,%d,%d",
           "%DATA",
           resp_p->response.ptr_que_percent_data->mode,
           des_name, 
           resp_p->response.ptr_que_percent_data->des_dev_no, 
           resp_p->response.ptr_que_percent_data->des_sub_no, 
           ati_cap_name[capability].name,
           src_name, 
           resp_p->response.ptr_que_percent_data->src_dev_no, 
           resp_p->response.ptr_que_percent_data->src_sub_no, 
           resp_p->response.ptr_que_percent_data->cid);

  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  
  return 0; /* Ok */
}


int Resp_sPercentDINF(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_CAP_ID      capability   = DEV_CPBLTY_NONE;
  T_CAP_ID      cur_cap      = DEV_CPBLTY_NONE;
    
  TRACE_FUNCTION ("Resp_sPercentDINF() IMPLEMENTED but without outputing mode !");
  capability = map_dti_cpblty((U8)(resp_p->response.ptr_set_percent_dinf->cap));
  cur_cap    = map_dti_cpblty((U8)(resp_p->response.ptr_set_percent_dinf->cur_cap));

  sprintf (g_sa,"%s:\"%s\",%d,%d,\"%s\",\"%s\"", "%DINF",
  dti_entity_name[(resp_p->response.ptr_set_percent_dinf->dev_name)].name, 
                            resp_p->response.ptr_set_percent_dinf->dev_no, 
                            resp_p->response.ptr_set_percent_dinf->sub_no,
                            ati_cap_name[capability].name,
                            ati_cap_name[cur_cap].name
                            /*mode*/);
                            /* dont know how to get mode?? */
  /*shd we call qBAT_PercentDINF??*/

  io_sendMessage (src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; 
}


int Resp_qPlusDS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusDS()");
  resp_disp(src_infos_psi->srcId,NULL,"eels",&resp_p->response.ptr_que_plus_ds->dir,
                                             &resp_p->response.ptr_que_plus_ds->neg,
                                             &resp_p->response.ptr_que_plus_ds->p1,
                                             &resp_p->response.ptr_que_plus_ds->p2);
  return 0; /* Ok */
}

int Resp_qPlusFAP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFAP()");

  return 0; /* Ok */
}

int Resp_qPlusFBO(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFBO()");

  return 0; /* Ok */
}

int Resp_qPlusFBS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFBS()");

  return 0; /* Ok */
}

int Resp_qPlusFBU(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFBU()");

  return 0; /* Ok */
}

int Resp_qPlusFCC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFCC()");

  return 0; /* Ok */
}

int Resp_qPlusFCLASS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFCLASS()");

  return 0; /* Ok */
}

int Resp_qPlusFCQ(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFCQ()");

  return 0; /* Ok */
}

int Resp_qPlusFCR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFCR()");

  return 0; /* Ok */
}


int Resp_qPlusFCS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFCS()");

  return 0; /* Ok */
}

int Resp_qPlusFCT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFCT()");

  return 0; /* Ok */
}

int Resp_qPlusFEA(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFEA()");

  return 0; /* Ok */
}

int Resp_qPlusFFC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFFC()");

  return 0; /* Ok */
}

int Resp_qPlusFHS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFHS()");

  return 0; /* Ok */
}

int Resp_qPlusFIE(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFIE()");

  return 0; /* Ok */
}

int Resp_qPlusFIS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFIS()");

  return 0; /* Ok */
}

int Resp_qPlusFIT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFIT()");

  return 0; /* Ok */
}

int Resp_qPlusFLI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFLI()");

  return 0; /* Ok */
}

int Resp_qPlusFLO(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFLO()");

  return 0; /* Ok */
}

int Resp_qPlusFLP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFLP()");

  return 0; /* Ok */
}

int Resp_qPlusFMS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFMS()");

  return 0; /* Ok */
}

int Resp_qPlusFNS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFNS()");

  return 0; /* Ok */
}

int Resp_qPlusFPA(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFPA()");

  return 0; /* Ok */
}

int Resp_qPlusFPI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFPI()");

  return 0; /* Ok */
}

int Resp_qPlusFPS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFPS()");

  return 0; /* Ok */
}

int Resp_qPlusFPW(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFPW()");

  return 0; /* Ok */
}

int Resp_qPlusFRQ(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFRQ()");

  return 0; /* Ok */
}

int Resp_qPlusFSA(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFSA()");

  return 0; /* Ok */
}

int Resp_qPlusFSP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusFSP()");

  sprintf(g_sa,"+FSP:%d",resp_p->response.ptr_que_plus_fsp->poll);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_qPlusICF(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_ACI_BS_FRM format;
  T_ACI_BS_PAR parity;
  T_BAT_res_que_plus_icf *icf;
  TRACE_FUNCTION ("Resp_qPlusICF()");
  /*
  *   Get a pointer to the ICF structure for convenience.
  */
  icf=resp_p->response.ptr_que_plus_icf;
  /*
  *   This relies on T_ACI_BS_FRM being identical to
  *   T_BAT_framing_format and T_ACI_BS_PAR being identical
  *   to T_BAT_framing_parity.
  */
  format=(T_ACI_BS_FRM)icf->framing_format;
  parity=(T_ACI_BS_PAR)icf->framing_parity;  
  if ((format==BS_FRM_Dat8_Par1_St1) || (format==BS_FRM_Dat7_Par1_St1))
    resp_disp(src_infos_psi->srcId,NULL,"ee",&format,&parity);
  else
    resp_disp(src_infos_psi->srcId,NULL,"e",&format);

  return 0; /* Ok */
}

int Resp_qPlusIFC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusIFC()");
  sprintf(g_sa,"+IFC: %d,%d", resp_p->response.ptr_que_plus_ifc->by_te,
                              resp_p->response.ptr_que_plus_ifc->by_ta);    
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}


int Resp_qPercentIMEI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPercentIMEI()");
  sprintf ( g_sa,
            "%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d",
            (resp_p->response.ptr_que_percent_imei->tac1 >> 4) & 0x0F,
             resp_p->response.ptr_que_percent_imei->tac1 & 0x0F,

            (resp_p->response.ptr_que_percent_imei->tac2 >> 4) & 0x0F,
             resp_p->response.ptr_que_percent_imei->tac2 & 0x0F,

            (resp_p->response.ptr_que_percent_imei->tac3 >> 4) & 0x0F,
             resp_p->response.ptr_que_percent_imei->tac3 & 0x0F,

            (resp_p->response.ptr_que_percent_imei->fac  >> 4) & 0x0F,
             resp_p->response.ptr_que_percent_imei->fac  & 0x0F,

            (resp_p->response.ptr_que_percent_imei->snr1 >> 4) & 0x0F,
             resp_p->response.ptr_que_percent_imei->snr1 & 0x0F,

            (resp_p->response.ptr_que_percent_imei->snr2 >> 4) & 0x0F,
             resp_p->response.ptr_que_percent_imei->snr2 & 0x0F,

            (resp_p->response.ptr_que_percent_imei->snr3 >> 4) & 0x0F,
             resp_p->response.ptr_que_percent_imei->snr3 & 0x0F,

             resp_p->response.ptr_que_percent_imei->cd,
            (resp_p->response.ptr_que_percent_imei->svn >> 4) & 0x0F,
             resp_p->response.ptr_que_percent_imei->svn & 0x0F );

  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT );
  return 0; /* Ok */
}



int Resp_qPlusIPR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  int rate_value;
  TRACE_FUNCTION ("Resp_qPlusIPR()");
  switch (resp_p->response.ptr_que_plus_ipr->rate)
    {
      case BD_RATE_75:     rate_value = 75;     break;
      case BD_RATE_150:    rate_value = 150;    break;
      case BD_RATE_300:    rate_value = 300;    break;
      case BD_RATE_600:    rate_value = 600;    break;
      case BD_RATE_1200:   rate_value = 1200;   break;
      case BD_RATE_2400:   rate_value = 2400;   break;
      case BD_RATE_4800:   rate_value = 4800;   break;
      case BD_RATE_7200:   rate_value = 7200;   break;
      case BD_RATE_9600:   rate_value = 9600;   break;
      case BD_RATE_14400:  rate_value = 14400;  break;
      case BD_RATE_19200:  rate_value = 19200;  break;
      case BD_RATE_28800:  rate_value = 28800;  break;
      case BD_RATE_33900:  rate_value = 33900;  break;
      case BD_RATE_38400:  rate_value = 38400;  break;
      case BD_RATE_57600:  rate_value = 57600;  break;
      case BD_RATE_115200: rate_value = 115200; break;
      case BD_RATE_203125: rate_value = 203125; break;
      case BD_RATE_406250: rate_value = 406250; break;
      case BD_RATE_812500: rate_value = 812500; break;
      default:             rate_value = 0;      break;
    }
      sprintf(g_sa,"+IPR: %d", rate_value);
      io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_qPercentPBCF(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  CHAR *me="%PBCF: ";
  
  TRACE_FUNCTION ("Resp_qPercentPBCF()");
  sprintf(g_sa,"%s%d, %d, %d", me, resp_p->response.ptr_que_percent_pbcf->ldn,
                                 resp_p->response.ptr_que_percent_pbcf->lrn,
                                 resp_p->response.ptr_que_percent_pbcf->lmn);    
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_qPercentPPP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPercentPPP()");
  #define IPADDR_BYTE(b, a) (((a) >> ((b) * 8)) & 0xff)

  sprintf(g_sa, "%%PPP: %u.%u.%u.%u,%u.%u.%u.%u,%u.%u.%u.%u",
          IPADDR_BYTE(3, resp_p->response.ptr_que_percent_ppp->ipaddr),
          IPADDR_BYTE(2, resp_p->response.ptr_que_percent_ppp->ipaddr),
          IPADDR_BYTE(1, resp_p->response.ptr_que_percent_ppp->ipaddr),
          IPADDR_BYTE(0, resp_p->response.ptr_que_percent_ppp->ipaddr),
          IPADDR_BYTE(3, resp_p->response.ptr_que_percent_ppp->dns1),
          IPADDR_BYTE(2, resp_p->response.ptr_que_percent_ppp->dns1),
          IPADDR_BYTE(1, resp_p->response.ptr_que_percent_ppp->dns1),
          IPADDR_BYTE(0, resp_p->response.ptr_que_percent_ppp->dns1),
          IPADDR_BYTE(3, resp_p->response.ptr_que_percent_ppp->dns2),
          IPADDR_BYTE(2, resp_p->response.ptr_que_percent_ppp->dns2),
          IPADDR_BYTE(1, resp_p->response.ptr_que_percent_ppp->dns2),
          IPADDR_BYTE(0, resp_p->response.ptr_que_percent_ppp->dns2)) ;
  io_sendMessage (src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_qPercentPVRF(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_que_percent_pvrf *pvrf;
  CHAR *me="%PVRF: ";
  TRACE_FUNCTION ("Resp_qPercentPVRF()");
  /*
  *   Get a pointer to the PVRF structure for convenience.
  */
  pvrf=resp_p->response.ptr_que_percent_pvrf;

  sprintf(g_sa,"%s%d, %d, %d, %d, %d, %d",
    me,
    pvrf->pn1cnt,
    pvrf->pn2cnt,
    pvrf->pk1cnt,
    pvrf->pk2cnt,
    pvrf->ps1,
    pvrf->ps2);

  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_qPercentRDL(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPercentRDL() ");
  resp_disp (src_infos_psi->srcId, NULL,"b",&resp_p->response.ptr_que_percent_rdl->mode);
  return 0; /* Ok */
}

int Resp_qPercentRDLB(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  CHAR  number[MAX_CC_CALLED_NUMBER+1];
  UBYTE i,j;
  USHORT pos  = 0;
  TRACE_FUNCTION ("Resp_qPercentRDLB() ");
  memset(number,0,MAX_CC_CALLED_NUMBER+1);
  // resp_disp (srcId, cl,"b", &usr_notif); /* output user notification state */
    for(i=0; i<resp_p->response.ptr_que_percent_rdlb->c_number; i++) /* output black list */
    {
      for(j=0; j<resp_p->response.ptr_que_percent_rdlb->c_number; j++)
        {
          resp_p->response.ptr_que_percent_rdlb->number[j] = (resp_p->response.ptr_que_percent_rdlb->number[j] | 0x30);
        }
      utl_binToHex(resp_p->response.ptr_que_percent_rdlb->number,
                   resp_p->response.ptr_que_percent_rdlb->c_number, number);
      pos=sprintf(g_sa,"%s:\"%s\",%d","%RDLB",number,
                     (int)resp_p->response.ptr_que_percent_rdlb->type);
                
      io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
    }

  return 0; /* Ok */
}

#ifdef SIM_TOOLKIT
int Resp_qPercentSATC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  UBYTE            i;
  TRACE_FUNCTION ("Resp_qPercentSATC()");

  i=sprintf(g_sa,"%s: %d,", "%SATC", sat[src_infos_psi->srcId]);
  
    if (resp_p->response.ptr_que_percent_satc->c_satprfl)
    {
      utl_binToHex( resp_p->response.ptr_que_percent_satc->satprfl, 
                  resp_p->response.ptr_que_percent_satc->c_satprfl, g_sa +i );
    }

    i+=resp_p->response.ptr_que_percent_satc->c_satprfl*2;
    g_sa[i++]='"';
    g_sa[i]='\0';
    
    ci_remTrailCom(g_sa,(USHORT)strlen(g_sa));
    io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}
#endif /* SIM_TOOLKIT */

#ifdef GPRS
int Resp_qPercentSNCNT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPercentSNCNT() ");
  
  rCI_PercentSNCNT ((UBYTE)resp_p->response.ptr_uns_percent_sncnt->cid,
                    resp_p->response.ptr_uns_percent_sncnt->oct_up,
                    resp_p->response.ptr_uns_percent_sncnt->oct_down,
                    resp_p->response.ptr_uns_percent_sncnt->pkt_up,
                    resp_p->response.ptr_uns_percent_sncnt->pkt_down);

  return 0; /* Ok */
}
#endif /* GPRS */

int Resp_qPlusWS46(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_qPlusWS46() ");

  resp_disp(src_infos_psi->srcId, NULL,"e",
           &resp_p->response.ptr_que_plus_ws46->n);

  return 0; /* Ok */
}

int Resp_qPlusCLCC(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  SHORT pos = 0;
  char *me  = "+CLCC: ";
  USHORT              lenCvtdAlpha = 0;  
  CHAR                number[BAT_MAX_CLCC_NUMBER_LEN + 1];

  TRACE_FUNCTION ("Resp_qPlusCLCC() ");
  
  /* Call info is sent at a time, this flag will mark the start and end of this call list */
  if(CLCC_flag == FALSE)
      CLCC_flag = TRUE;
  
  if(resp_p->response.ptr_que_plus_clcc->idx EQ ACI_NumParmNotPresent)
      return 0;

  pos = sprintf(g_sa,"%s%d", me, resp_p->response.ptr_que_plus_clcc->idx);
  
  if (resp_p->response.ptr_que_plus_clcc->dir NEQ CLCC_DIR_NotPresent)
    pos += sprintf(g_sa+pos,",%d",resp_p->response.ptr_que_plus_clcc->dir);
  else
    pos += sprintf(g_sa+pos,",");
  if (resp_p->response.ptr_que_plus_clcc->stat NEQ CLCC_STAT_NotPresent)
    pos += sprintf(g_sa+pos,",%d",resp_p->response.ptr_que_plus_clcc->stat);
  else
    pos += sprintf(g_sa+pos,",");
  if (resp_p->response.ptr_que_plus_clcc->mode NEQ CLCC_MODE_NotPresent)
    pos += sprintf(g_sa+pos,",%d",resp_p->response.ptr_que_plus_clcc->mode);
  else
    pos += sprintf(g_sa+pos,",");
  if (resp_p->response.ptr_que_plus_clcc->mpty NEQ CLCC_MPTY_NotPresent)
    pos += sprintf(g_sa+pos,",%d",resp_p->response.ptr_que_plus_clcc->mpty);
  else
    pos += sprintf(g_sa+pos,",");

  if (resp_p->response.ptr_que_plus_clcc->number[0] NEQ 0x0)
  {     
    utl_binToHex(resp_p->response.ptr_que_plus_clcc->number, 
      resp_p->response.ptr_que_plus_clcc->c_number, number);
    pos += sprintf(g_sa+pos,",\"%s\",%d",number,(int)(resp_p->response.ptr_que_plus_clcc->type));   
  }
#ifdef NO_ASCIIZ /* Need to add other struct ?! */
    /*    if (resp_p->response.ptr_que_plus_clcc->c_alpha.len NEQ 0x0)
        {
            pos += sprintf(g_sa+pos,",");
            utl_chsetFromGsm ( resp_p->response.ptr_que_plus_clcc->alpha.data,
                               resp_p->response.ptr_que_plus_clcc->alpha.len,
                               (UBYTE*)cvtdAlpha,
                               sizeof(cvtdAlpha),
                               &lenCvtdAlpha,
                               GSM_ALPHA_Def );
            pos += sprints ( g_sa + pos, cvtdAlpha, lenCvtdAlpha );
          } */
#else  /* #ifdef NO_ASCIIZ */
  if (resp_p->response.ptr_que_plus_clcc->alpha[0] NEQ 0x0)
  {
    pos += sprintf(g_sa+pos,",");
    utl_chsetFromGsm ( (UBYTE*)resp_p->response.ptr_que_plus_clcc->alpha,
                       0,
                       (UBYTE*)cvtdAlpha,
                       sizeof(cvtdAlpha),
                       &lenCvtdAlpha,
                       GSM_ALPHA_Int );
    pos += sprints ( g_sa + pos, cvtdAlpha, lenCvtdAlpha );
  }
#endif /* #ifdef NO_ASCIIZ */
  ci_remTrailCom(g_sa, pos);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}


int Resp_uPlusCBM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_MMI_CBCH_IND  mmi_cbch_ind ;
  TRACE_FUNCTION ("Resp_uPlusCBM() ");

  mmi_cbch_ind.cbch_len = resp_p->response.ptr_res_plus_cbm->c_pdu;
  memcpy(resp_p->response.ptr_res_plus_cbm->pdu,
         mmi_cbch_ind.cbch_msg,
         resp_p->response.ptr_res_plus_cbm->c_pdu);
  
  return 0; /* Ok */
}

int Resp_uPlusCBMI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPlusCBMI() not implemented");

  return 0; /* Ok */
}

int Resp_uPercentCCBS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_ACI_CCBS_IND ind;
  T_ACI_CCBS_STAT status;
  T_ACI_CCBS_SET setting;
  T_BAT_res_uns_percent_ccbs *ccbs;
  TRACE_FUNCTION ("Resp_uPercentCCBS()");
  /*
  *   Get a pointer to the CCBS structure for convenience.
  */
  ccbs=resp_p->response.ptr_res_percent_ccbs;
  /*
  *   This relies on T_ACI_CCBS_IND being identical to
  *   T_BAT_percent_ccbs_ind and T_ACI_CCBS_STAT being identical
  *   to T_BAT_percent_ccbs_stat.
  */
  ind=(T_ACI_CCBS_IND)ccbs->ind;
  status=(T_ACI_CCBS_STAT)ccbs->stat;
  /*
  *   The main reason for zeroing this memory is to ensure we
  *   end up with zero-terminated 'number' and 'subaddress'
  *   strings.
  */
  memset(&setting,0,sizeof(T_ACI_CCBS_SET));
  setting.idx=(SHORT)ccbs->idx;
  if ((ccbs->v_number==TRUE) && (ccbs->c_number<MAX_B_SUBSCR_NUM_LEN))
    memcpy(setting.number,ccbs->number,ccbs->c_number);
  setting.type=toa_demerge((SHORT)ccbs->type);
  if ((ccbs->v_subaddr==TRUE) && (ccbs->c_subaddr<MAX_SUBADDR_LEN))
    memcpy(setting.subaddr,ccbs->subaddr,ccbs->c_subaddr);
  setting.satype=tos_demerge((SHORT)ccbs->satype);
  /*
  *   This relies on T_ACI_CLASS being identical to T_BAT_bearer_class
  *   and T_ACI_ALRT_PATTERN being identical to T_BAT_percent_ccbs_ptn.
  */
  setting.class_type=(T_ACI_CLASS)ccbs->bearer_class;
  setting.alrtPtn=(T_ACI_ALRT_PTRN)ccbs->ptn;
  rCI_PercentCCBS(ind,status,&setting,FALSE);
  return 0; /* Ok */
}

int Resp_uPlusCCCM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPlusCCCM()");
  rCI_PlusCCCM(&resp_p->response.ptr_res_plus_cccm->ccm);
  return 0; /* Ok */
}

int Resp_uPercentCCCN(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_fac_inf    fie;
  TRACE_FUNCTION ("Resp_uPercentCCCN() ");
  
  fie.l_fac = resp_p->response.ptr_res_percent_cccn->c_facility;
  memcpy(fie.fac,resp_p->response.ptr_res_percent_cccn->facility,
         fie.l_fac);
  
  rCI_PercentCCCN((T_ACI_FAC_DIR)resp_p->response.ptr_res_percent_cccn->direction,
                    (SHORT)resp_p->response.ptr_res_percent_cccn->cid,
                     &fie );

  return 0; /* Ok */
}

int Resp_uPlusCCWA(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_ACI_CLSSTAT clsStat;
  T_ACI_TOA     type ;  
  CHAR           number[BAT_MAX_CCWA_NUMBER_LEN+1]; 
  
  #ifdef NO_ASCIIZ
  T_ACI_PB_TEXT  alpha_text ;
  #else
  CHAR          * p_alpha;
  CHAR           alpha[BAT_MAX_CCWA_NUMBER_LEN+1]; 
  #endif
  
  TRACE_FUNCTION ("Resp_uPlusCCWA()");

  clsStat.class_type = resp_p->response.ptr_res_plus_ccwa->bearer_class;
  clsStat.status = STATUS_NotPresent;/*response structure has no info abt sttus*/
/*
  utl_binToHex(resp_p->response.ptr_res_plus_ccwa->number,
              (SHORT)resp_p->response.ptr_res_plus_ccwa->c_number,
               number);
*/
  memcpy(number,
         resp_p->response.ptr_res_plus_ccwa->number,
         (SHORT)resp_p->response.ptr_res_plus_ccwa->c_number);

  type = toa_demerge((SHORT)resp_p->response.ptr_res_plus_ccwa->type);
  
  #ifdef NO_ASCIIZ
  
  alpha_text.len = resp_p->response.ptr_res_plus_ccwa->c_alpha;
  memcpy(alpha_text.data, resp_p->response.ptr_res_plus_ccwa->alpha, alpha_text.len);

  rCI_PlusCCWA(resp_p->response.ptr_res_plus_ccwa->bearer_class EQ BAT_CCWA_CLASS_NOT_PRESENT 
                 ? NULL 
                 : &clsStat,
               number,
               &type,
               (U8)resp_p->response.ptr_res_plus_ccwa->cli,
               (T_ACI_CLASS)resp_p->response.ptr_res_plus_ccwa->bearer_class,
               alpha_text.len 
                 ? &alpha_text 
                 : NULL);
  #else

  p_alpha = alpha;
   if(resp_p->response.ptr_res_plus_ccwa.->v_alpha)
  {
     utl_binToHex(resp_p->response.ptr_res_plus_ccwa->alpha,
               (SHORT)resp_p->response.ptr_res_plus_ccwa->c_alpha,
                alpha);
  }
  else
  {
    p_alpha = NULL;
  }
  rCI_PlusCCWA(resp_p->response.ptr_res_plus_ccwa->bearer_class EQ BAT_CCWA_CLASS_NOT_PRESENT 
                 ? NULL
                 : &clsStat,
                           number,
                           &type,
                           (U8)resp_p->response.ptr_res_plus_ccwa->cli,
                           (T_ACI_CLASS)resp_p->response.ptr_res_plus_ccwa->bearer_class,
                           p_alpha);
  #endif
   
  return 0; /* Ok */
}

int Resp_uPlusCCWA_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPlusCCWA_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_uPlusCCWE(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPlusCCWE() contains bat dummy out put nothing");
  
  return 0; /* Ok */
}

int Resp_uPlusCDIP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_uns_plus_cdip *cdip;
  CHAR number[BAT_MAX_CDIP_NUMBER_LEN+1];
  T_ACI_TOA type;
  CHAR *sub_ptr;
  CHAR subaddr[BAT_MAX_SUBADDR_LENGTH+1];
  T_ACI_TOS *satype_ptr;
  T_ACI_TOS satype;

  TRACE_FUNCTION ("Resp_uPlusCDIP()");

  sub_ptr=NULL;
  satype_ptr=NULL;

  /*
   *   Get a pointer to the CDIP structure for convenience.
   */
  cdip = (T_BAT_res_uns_plus_cdip *)resp_p->response.ptr_res_plus_cdip;

  memset(number,0,sizeof(number));
  memcpy(number,cdip->number,BAT_MAX_CDIP_NUMBER_LEN);

  type=toa_demerge(cdip->type);

  if (cdip->v_subaddr)
  {
    memset(subaddr,0,sizeof(subaddr));
    memcpy(subaddr,cdip->subaddr,BAT_MAX_SUBADDR_LENGTH);
    sub_ptr=subaddr;

    satype=tos_demerge(cdip->satype);
    satype_ptr=&satype;
  }

  rCI_PlusCDIP(number,
               &type,
               sub_ptr,
               satype_ptr);
  return 0; /* Ok */
}

int Resp_uPlusCDS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_MNSMS_STATUS_IND  mnsms_status_ind;
  
  TRACE_FUNCTION ("Resp_uPlusCDS()");

  mnsms_status_ind.sms_sdu.l_buf = resp_p->response.ptr_res_plus_cds->c_pdu;
  memcpy(mnsms_status_ind.sms_sdu.buf,resp_p->response.ptr_res_plus_cds->pdu,
              resp_p->response.ptr_res_plus_cds->c_pdu);
         
  rCI_PlusCDSPdu(&mnsms_status_ind);
              
  return 0; /* Ok */
}

#ifdef GPRS
int Resp_uPercentCGEV(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_CGEREP_EVENT event;
  T_CGEREP_EVENT_REP_PARAM param;
  T_BAT_res_uns_percent_cgev *cgev;
  TRACE_FUNCTION ("Resp_uPercentCGEV()");
  /*
  *   Get a pointer to the CGEV structure for convenience.
  */
  cgev=resp_p->response.ptr_res_percent_cgev;

  memset(&param,0,sizeof(param));

  /*
  *   This relies on T_CGEREP_EVENT being identical to
  *   T_BAT_percent_cgev_evt.
  */
  event=(T_CGEREP_EVENT)cgev->evt;

  switch (event)
  {
    case CGEREP_EVENT_REJECT:
      if (cgev->v_pdp_addr==TRUE)
      {
        if (cgev->c_pdp_addr<MAX_PDP_ADDR_LEN)
          memcpy(param.reject.pdp_addr,cgev->pdp_addr,cgev->c_pdp_addr);
      }                
      break;

    case CGEREP_EVENT_NW_CLASS:
    case CGEREP_EVENT_ME_CLASS:
      /*
      *   This relies on T_PERCENT_CGCLASS being identical to
      *   T_BAT_p_mobile_class.
      */
      param.mobile_class=(T_PERCENT_CGCLASS)cgev->p_mobile_class;
      break;

    case CGEREP_EVENT_NW_REACT:
    case CGEREP_EVENT_NW_DEACT:
    case CGEREP_EVENT_ME_DEACT:
    case CGEREP_EVENT_NW_ACT:
    case CGEREP_EVENT_ME_ACT:
      if (cgev->v_pdp_addr==TRUE)
      {
        if (cgev->c_pdp_addr<MAX_PDP_ADDR_LEN)
          memcpy(param.act.pdp_addr,cgev->pdp_addr,cgev->c_pdp_addr);
      }                

      param.act.cid=(SHORT)cgev->cid;
      break;

    default:
      break;
  }
  rCI_PercentCGEV(event,&param);
  return 0; /* Ok */
}

int Resp_uPlusCGEV(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPlusCGEV() Not Implemented no res plus cgev structure filler found");

  return 0; /* Ok */
}

int Resp_uPercentCGREG(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_P_CGREG_STAT stat;
  USHORT lac;
  USHORT ci;
  T_BAT_res_uns_percent_cgreg *cgreg;
  TRACE_FUNCTION ("Resp_uPercentCGREG()");
  /*
  *   Get a pointer to the CGREG structure for convenience.
  */
  cgreg=resp_p->response.ptr_res_percent_cgreg;
  stat=(T_P_CGREG_STAT)cgreg->stat;
  lac=(USHORT)cgreg->lac;
  ci=(USHORT)cgreg->ci;
  rCI_PercentCGREG(stat,lac,ci,FALSE);
  return 0; /* Ok */
}

int Resp_uPlusCGREG(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPlusCGREG()");
  
  rCI_PlusCGREG((T_CGREG_STAT)resp_p->response.ptr_res_plus_cgreg->stat,
                (USHORT)resp_p->response.ptr_res_plus_cgreg->lac,
                (USHORT)resp_p->response.ptr_res_plus_cgreg->ci );

  return 0; /* Ok */
}
#endif /* GPRS */

int Resp_uPlusCLAE(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_uns_plus_clae *clae;
  T_ACI_LAN_SUP lang;
  CHAR code[BAT_MAX_CLAE_CODE_LEN+1];
  TRACE_FUNCTION ("Resp_uPlusCLAE()");
  /*
    *   Get a pointer to the CLAE structure for convenience.
    */
    clae=resp_p->response.ptr_res_plus_clae;
    memset(code,0,sizeof(code));
    memcpy(code,clae->code,clae->c_code);
    /*
    *   NB rCI_PlusCLAE only cares about the code string, so
    *   we don't need to populate 'lang' any further than this.
    */
    lang.str=code;
    rCI_PlusCLAE(&lang); 
  return 0; /* Ok */
}

int Resp_uPlusCLAV(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  CHAR code[BAT_MAX_CLAV_CODE_LEN + 1];
  
  TRACE_FUNCTION ("Resp_uPlusCLAV() recheck");

  utl_binToHex(resp_p->response.ptr_res_plus_clav->code,
              (SHORT)resp_p->response.ptr_res_plus_clav->c_code,
              code) ;
  
  sprintf(g_sa,"+CLAN: %s",code);
  io_sendMessage(src_infos_psi->srcId,g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_uPlusCLIP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_uns_plus_clip *clip;
  CHAR number[BAT_MAX_CLIP_NUMBER_LEN+1];
  T_ACI_TOA type;
  U8 validity;
  CHAR *sub_ptr;
  CHAR subaddr[BAT_MAX_SUBADDR_LENGTH+1];
  T_ACI_TOS *satype_ptr;
  T_ACI_TOS satype;
#ifdef NO_ASCIIZ
  T_ACI_PB_TEXT *alpha_ptr;
  T_ACI_PB_TEXT alpha;
#else
  CHAR *alpha_ptr;
  CHAR alpha[BAT_MAX_PHB_NUM_LEN+1];
#endif

  TRACE_FUNCTION ("Resp_uPlusCLIP()");

  sub_ptr=NULL;
  satype_ptr=NULL;
  alpha_ptr=NULL;

  /*
   *   Get a pointer to the CLIP structure for convenience.
   */
  clip=resp_p->response.ptr_res_plus_clip;

  memset(number,0,sizeof(number));
  memcpy(number,clip->number,BAT_MAX_CLIP_NUMBER_LEN);

  type=toa_demerge(clip->type);

  if (clip->v_subaddr)
  {
    memset(subaddr,0,sizeof(subaddr));
    memcpy(subaddr,clip->subaddr,BAT_MAX_SUBADDR_LENGTH);
    sub_ptr=subaddr;

    satype=tos_demerge(clip->satype);
    satype_ptr=&satype;
  }

  if (clip->v_alpha)
  {
#ifdef NO_ASCIIZ

    memcpy(alpha.data,clip->alpha,MAX_PHB_NUM_LEN);

    if (clip->c_alpha>MAX_PHB_NUM_LEN)
        alpha.len=MAX_PHB_NUM_LEN;
    else
        alpha.len=clip->c_alpha;

    alpha.cs=CS_NotPresent;

    alpha_ptr=&alpha;

#else

    memset(alpha,0,sizeof(alpha));
    memcpy(alpha,clip->alpha,BAT_MAX_PHB_NUM_LEN);
    alpha_ptr=alpha;

#endif
  }

  validity=(U8)clip->cli;

  rCI_PlusCLIP(
               CLIP_STAT_NotPresent, /* <=== not always true, but BAT does not provide status infromation */
               number,
               &type,
               validity,
               sub_ptr,
               satype_ptr,
               alpha_ptr);

  return 0; /* Ok */
}

int Resp_uPlusCLIP_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPlusCLIP_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_uPlusCMT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_MNSMS_MESSAGE_IND mnsms_message_ind;
  T_BAT_res_uns_plus_cmt *cmt;

  TRACE_FUNCTION ("Resp_uPlusCMT()");
  /*
   *   Get a pointer to the CMT structure for convenience.
   */
  cmt=resp_p->response.ptr_res_plus_cmt;

  /*
   *   Check that the received BAT message is not too big. If it is,
   *   we discard it.
   */
  if (cmt->c_pdu>SIM_PDU_LEN)
  {
    TRACE_EVENT("BAT CMT too big");
  }
  else
  {
    /*
     *   Set up the bits of mnsms_message_ind that are used by
     *   rCI_PlusCMT().
     */
    memcpy(&mnsms_message_ind.sms_sdu.buf,cmt->pdu,cmt->c_pdu);
    mnsms_message_ind.sms_sdu.l_buf=cmt->c_pdu<<3;
    mnsms_message_ind.sms_sdu.o_buf=0;

    /*
     *   This is not part of the BAT response, so choose a sensible
     *   value.
     */
    mnsms_message_ind.status=REC_UNREAD;

    rCI_PlusCMT(&mnsms_message_ind);
  }
  return 0; /* Ok */
}

int Resp_uPlusCMTI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPlusCMTI() ");
  rCI_PlusCMTI((T_ACI_SMS_STOR)resp_p->response.ptr_res_plus_cmti->sms_mem,
               (UBYTE)resp_p->response.ptr_res_plus_cmti->sms_index);

  return 0; /* Ok */
}

int Resp_uPlusCMT_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPlusCMT_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_uPercentCNAP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  CHAR        name[BAT_MAX_CNAP_NAME_LEN + 1];
  
  UBYTE       pos = 0;
  
  TRACE_FUNCTION ("Resp_uPercentCNAP() Not implemented");
  
  if(resp_p->response.ptr_res_percent_cnap->v_name)
  {
    utl_binToHex(resp_p->response.ptr_res_percent_cnap->name,
              (SHORT)resp_p->response.ptr_res_percent_cnap->c_name,
               name) ;
  }
   
  pos += sprintf(g_sa+pos,"%s%d", "%CNAP: ", 
                  resp_p->response.ptr_res_percent_cnap->pres_mode);
  
  if(resp_p->response.ptr_res_percent_cnap->v_name)
  {
    pos += sprintf(g_sa+pos,",%hd,", resp_p->response.ptr_res_percent_cnap->dcs);

    switch(resp_p->response.ptr_res_percent_cnap->pres_mode)
    {
      case BAT_P_CNAP_PRES_NAME:
      case BAT_P_CNAP_PRES_NAME_RESTRICTED:
      {
        TRACE_EVENT("CNAP: name presentation is allowed or restrcited");
        pos += sprintf(g_sa+pos,"%d,\"%s\"",
               resp_p->response.ptr_res_percent_cnap->c_name),
               resp_p->response.ptr_res_percent_cnap->name;
        break;
      }
      case BAT_P_CNAP_PRES_RESTRICTED:
      case BAT_P_CNAP_PRES_NO_NAME:
      {
        TRACE_EVENT("CNAP: presentation is restricted or no name"); 
        break;
      }      
      default:
      {
        TRACE_ERROR("CNAP: wrong presentation mode");       
      }
     } 
  }
  io_sendIndication(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT );

  return 0; /* Ok */
}

int Resp_uPlusCOLP(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_uns_plus_colp *colp;
  CHAR *num_ptr;
  CHAR number[BAT_MAX_COLP_NUMBER_LEN+1];
  T_ACI_TOA *type_ptr;
  T_ACI_TOA type;
  CHAR *sub_ptr;
  CHAR subaddr[BAT_MAX_SUBADDR_LENGTH+1];
  T_ACI_TOS *satype_ptr;
  T_ACI_TOS satype;
#ifdef NO_ASCIIZ
  T_ACI_PB_TEXT *alpha_ptr;
  T_ACI_PB_TEXT alpha;
#else
  CHAR *alpha_ptr;
  CHAR alpha[BAT_MAX_COLP_ALPHA_LEN+1];
#endif

  TRACE_FUNCTION ("Resp_uPlusCOLP()");

  num_ptr=NULL;
  type_ptr=NULL;
  sub_ptr=NULL;
  satype_ptr=NULL;
  alpha_ptr=NULL;

  /*
   *   Get a pointer to the COLP structure for convenience.
   */
  colp=resp_p->response.ptr_res_plus_colp;

  if (colp->v_number)
  {
    memset(number,0,sizeof(number));
    memcpy(number,colp->number,BAT_MAX_COLP_NUMBER_LEN);
    num_ptr=number;

    type=toa_demerge(colp->type);
    type_ptr=&type;
  }

  if (colp->v_subaddr)
  {
    memset(subaddr,0,sizeof(subaddr));
    memcpy(subaddr,colp->subaddr,BAT_MAX_SUBADDR_LENGTH);
    sub_ptr=subaddr;

    satype=tos_demerge(colp->satype);
    satype_ptr=&satype;
  }

  if (colp->v_alpha)
  {
#ifdef NO_ASCIIZ

    memcpy(alpha.data,colp->alpha,MAX_PHB_NUM_LEN);

    if (colp->c_alpha>MAX_PHB_NUM_LEN)
        alpha.len=MAX_PHB_NUM_LEN;
    else
        alpha.len=colp->c_alpha;

    alpha.cs=CS_NotPresent;
    alpha_ptr=&alpha;

#else

    memset(alpha,0,sizeof(alpha));
    memcpy(alpha,colp->alpha,BAT_MAX_COLP_ALPHA_LEN);
    alpha_ptr=alpha;

#endif
  }

  rCI_PlusCOLP(
               COLP_STAT_NotPresent,
               num_ptr,
               type_ptr,
               sub_ptr,
               satype_ptr,
               alpha_ptr);

  return 0; /* Ok */
}

int Resp_uPlusCOLP_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPlusCOLP_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_uPercentCPI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_uns_percent_cpi *cpi;
  SHORT cId;
  T_ACI_CPI_MSG msgType;
  T_ACI_CPI_IBT ibt;
  T_ACI_CPI_TCH tch;
  USHORT cause;

  TRACE_FUNCTION ("Resp_uPercentCPI()");
  /*
   *   Get a pointer to the CPI structure for convenience.
   */
  cpi=resp_p->response.ptr_res_percent_cpi;

  cId=(SHORT)cpi->cid;

  /*
   *   This relies on T_ACI_CPI_MSG being equivalent to
   *   T_BAT_percent_cpi_msgtype.
   */
  msgType=(T_ACI_CPI_MSG)cpi->msgtype;

  /*
   *   This relies on T_ACI_CPI_IBT being equivalent to
   *   T_BAT_percent_cpi_ibt.
   */
  ibt=(T_ACI_CPI_IBT)cpi->ibt;
  /*
   *   This relies on T_ACI_CPI_TCH being equivalent to
   *   T_BAT_percent_cpi_tch.
   */
  tch=(T_ACI_CPI_TCH)cpi->tch;
  cause=(USHORT)cpi->cause;
  rCI_PercentCPI(cId,msgType,ibt,tch,cause);
  return 0; /* Ok */
}

int Resp_uPercentCPI_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPercentCPI_W() not implemented");

  return 0; /* Ok */
}

int Resp_uPercentCPRI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_uns_percent_cpri *cpri;
  TRACE_FUNCTION ("Resp_uPercentCPRI()");
  /*
  *   Get a pointer to the CPRI structure for convenience.
  */
  cpri=resp_p->response.ptr_res_percent_cpri;

  rCI_PercentCPRI((UBYTE)cpri->gsm_ciph,(UBYTE)cpri->gprs_ciph);

  return 0; /* Ok */
}

int Resp_uPercentCPROAM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPercentCPROAM()");
  
  rCI_PercentCPROAM((UBYTE)resp_p->response.ptr_res_percent_cproam->roam_status);

  return 0; /* Ok */
}

int Resp_uPercentCPVWI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPercentCPVWI() ");
  rCI_PercentCPVWI((UBYTE)resp_p->response.ptr_res_percent_cpvwi->status,
                     (USHORT)resp_p->response.ptr_res_percent_cpvwi->line);

  return 0; /* Ok */
}

int Resp_uPlusCR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  char service[BAT_MAX_CR_SERV_LEN]; 
  T_ACI_CR_SERV serv;
  
  TRACE_FUNCTION ("Resp_uPlusCR()");
 
  utl_binToHex(resp_p->response.ptr_res_plus_cr->serv, 
              (SHORT)resp_p->response.ptr_res_plus_cr->c_serv,
               service);
  
  if(!strcmp(service,"ASYNC"))
    serv=CR_SERV_Async;
  else if(!strcmp(service,"SYNC"))
    serv=CR_SERV_Sync;
  else if(!strcmp(service,"REL ASYNC"))
    serv=CR_SERV_RelAsync;
  else if(!strcmp(service,"REL SYNC"))
    serv=CR_SERV_RelSync;

  #ifdef GPRS
  else if(!strcmp(service,"GPRS"))
    serv=CR_SERV_GPRS;
  #endif

  else
    return 0;
 
  rCI_PlusCR( serv);

  return 0; /* Ok */
}

int Resp_uPercentCREG(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_BAT_res_uns_percent_creg *creg;
  T_ACI_CREG_STAT status;
  USHORT lac;
  USHORT cid;
  T_ACI_P_CREG_GPRS_IND gprs_ind;

  TRACE_FUNCTION ("Resp_uPercentCREG()");

  /*
   *   Get a pointer to the CREG structure for convenience.
   */
  creg=resp_p->response.ptr_res_percent_creg;

  /*
   *   This relies on T_ACI_CREG_STAT and T_BAT_percent_creg_stat being
   *   identical.
   */
  status=(T_ACI_CREG_STAT)creg->stat;

  lac=(USHORT)creg->lac;
  cid=(USHORT)creg->ci;

  /*
   *   This relies on T_ACI_P_CREG_GPRS_IND and T_BAT_percent_creg_gprs_ind
   *   being identical.
   */
  gprs_ind=(T_ACI_P_CREG_GPRS_IND)creg->gprs_ind;

  rCI_PercentCREG(status,lac,cid,gprs_ind);
  return 0; /* Ok */
}

int Resp_uPercentCSQ(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPercentCSQ() ");
  
  rCI_PercentCSQ((UBYTE)resp_p->response.ptr_res_percent_csq->rssi, 
                 (UBYTE)resp_p->response.ptr_res_percent_csq->ber, 
                 (UBYTE)resp_p->response.ptr_res_percent_csq->actlevel);

  return 0; /* Ok */
}

int Resp_uPlusCSSI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPlusCSSI()");

  rCI_PlusCSSI((T_ACI_CSSI_CODE)resp_p->response.ptr_res_plus_cssi->code1,
                   (SHORT)resp_p->response.ptr_res_plus_cssi->index);
                            
  return 0; /* Ok */
}

int Resp_uPercentCSSN(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_fac_inf    fie;
  TRACE_FUNCTION ("Resp_uPercentCSSN() ");

  fie.l_fac = resp_p->response.ptr_res_percent_cssn->c_facility;
  memcpy(fie.fac,resp_p->response.ptr_res_percent_cssn->facility,BAT_MAX_CSSN_FACILITY_LEN);
  
  rCI_PercentCSSN (resp_p->response.ptr_res_percent_cssn->direction,
                   resp_p->response.ptr_res_percent_cssn->trans_type,
                             &fie );
  return 0; /* Ok */
}

int Resp_uPlusCSSU(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  char *me="+CSSU: ";
  char number[BAT_MAX_CSSU_NUMBER_LEN+1];
  char subaddr[BAT_MAX_SUBADDR_LENGTH+1];
  char* p_number;
  char* p_subaddr; 
  T_ACI_TOA      type ;
  T_ACI_TOS      satype ;
  SHORT pos=0;
  TRACE_FUNCTION ("Resp_uPlusCSSU()");

  p_number = number;
  p_subaddr = subaddr;

  type = toa_demerge((SHORT)resp_p->response.ptr_res_plus_cssu->type);
  satype = tos_demerge((SHORT)resp_p->response.ptr_res_plus_cssu->satype);
  
  if(resp_p->response.ptr_res_plus_cssu->v_number)
    {
      utl_binToHex(resp_p->response.ptr_res_plus_cssu->number, 
                (SHORT)resp_p->response.ptr_res_plus_cssu->c_number, 
                 number);
    }
  else
    p_number = NULL;
      
  if(resp_p->response.ptr_res_plus_cssu->v_subaddr)
    {
      utl_binToHex(resp_p->response.ptr_res_plus_cssu->subaddr, 
                (SHORT)resp_p->response.ptr_res_plus_cssu->c_subaddr, 
                 subaddr);
    }
  else
    p_subaddr=NULL; 

  rCI_PlusCSSU((T_ACI_CSSU_CODE)resp_p->response.ptr_res_plus_cssu->code2,
                 (SHORT)resp_p->response.ptr_res_plus_cssu->index,
                 p_number,
                 &type,
                 p_subaddr,
                 &satype)  ;
  
  return 0; /* Ok */
}

int Resp_uPercentCSTAT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  SHORT     pos   = 0;
  TRACE_FUNCTION ("Resp_uPercentCSTAT() ");

  pos = sprintf(g_sa,"%s: ","%CSTAT");
    
  switch(resp_p->response.ptr_res_percent_cstat->entity_id)
  {
  case BAT_P_CSTAT_ENT_ID_PBOOK:
    pos += sprintf(g_sa+pos,"PHB, %d",resp_p->response.ptr_res_percent_cstat->status);
    break;
  case BAT_P_CSTAT_ENT_ID_SMS :
    pos += sprintf(g_sa+pos,"SMS, %d",resp_p->response.ptr_res_percent_cstat->status);
    break;
  case BAT_P_CSTAT_ENT_ID_RDY :
    pos += sprintf(g_sa+pos,"RDY, %d",resp_p->response.ptr_res_percent_cstat->status);
    break;
  default:
    return 0;
  }
 
#ifndef _SIMULATION_ /* SKA: a lot of test cases do not expect  %CSTAT: xxx   unsolicited responses */
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
#endif
  
  return 0; /* Ok */
}

int Resp_uPercentCTYI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPercentCTYI()");
  
  rCI_PercentCTYI ((T_ACI_CTTY_NEG)resp_p->response.ptr_res_percent_ctyi->neg, 
      (T_ACI_CTTY_TRX)resp_p->response.ptr_res_percent_ctyi->trx);

  return 0; /* Ok */
}

int Resp_uPlusCTZR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPlusCTZR()");

  sprintf(g_sa,"+CTZR: %d", resp_p->response.ptr_res_plus_ctzr->tz);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);

  return 0; /* Ok */
}

int Resp_uPercentCTZV(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_MMR_INFO_IND mmr_info_ind;
  
  TRACE_FUNCTION ("Resp_uPercentCTZV() ");

  mmr_info_ind.time.year = resp_p->response.ptr_res_percent_ctzv->year;
  mmr_info_ind.time.month = resp_p->response.ptr_res_percent_ctzv->month;
  mmr_info_ind.time.day = resp_p->response.ptr_res_percent_ctzv->day;
  mmr_info_ind.time.hour = resp_p->response.ptr_res_percent_ctzv->hour;
  mmr_info_ind.time.minute = resp_p->response.ptr_res_percent_ctzv->minutes;
  mmr_info_ind.time.second = resp_p->response.ptr_res_percent_ctzv->seconds;

  rCI_PercentCTZV (&mmr_info_ind, (S32)resp_p->response.ptr_res_percent_ctzv->time_zone);
  
  return 0; /* Ok */
}

int Resp_uPlusCTZV(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPlusCTZV()");
  
  #ifdef FF_TIMEZONE
  rCI_PlusCTZV((S32)resp_p->response.ptr_res_plus_ctzv->tz);
  #else
  rCI_PlusCTZV(&((UBYTE)resp_p->response.ptr_res_plus_ctzv->tz));
  #endif

  return 0; /* Ok */
}

int Resp_uPercentCTZV_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPercentCTZV_W() Not Implemented");

  return 0; /* Ok */
}

int Resp_uPlusCUSD(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_ACI_CUSD_MOD m;
  T_BAT_res_uns_plus_cusd *cusd;
  T_ACI_USSD_DATA ussd;
  SHORT dcs;

  TRACE_FUNCTION ("Resp_uPlusCUSD()");

  /*
   *   Get a pointer to the CUSD structure for convenience.
   */
  cusd=resp_p->response.ptr_res_plus_cusd;

  /*
   *   If the string isn't valid, just ignore the message.
   */
  if (cusd->v_str==TRUE)
  {
    /*
     *   This assumes that T_ACI_CUSD_MOD and
     *   T_BAT_VAL_plus_cusd_m are equivalent.
     */
    m=(T_ACI_CUSD_MOD)cusd->m;

    dcs=(SHORT)cusd->dcs;

    /*
     *   Copy in as much data as the ACI structure can take.
     */
    memcpy(ussd.data,cusd->str,MAX_USSD_LEN);

    /*
     *   Set the length of the data. If there was too much for the
     *   ACI structure then the data will be truncated.
     */
    ussd.len=(cusd->c_str>MAX_USSD_LEN) ? MAX_USSD_LEN:cusd->c_str;

    rCI_PlusCUSD(m,&ussd,dcs);
  }
  return 0; /* Ok */
}


int Resp_uPlusCUSD_W(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPlusCUSD_W() Not implemented");
  
  return 0; /* Ok */
}

int Resp_PlusExtError(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPlusExtError()");

  /*
   * ACI_ERR_CLASS_Ext ("EXT ERROR: ...")is very often set on CMH level, 
   * but on ATI level it is overwritten with plain "ERROR".
   * Almost all test cases want to see plain "ERROR" only.
   * There are only 4 test cases, which want to see "EXT ERROR:..."
   * ACI1220, ACICC044, ACICC074 and ACICC107. Let these 4 FAIL
   * and all other let PASS by sending a plain "ERROR"
   */
#ifdef _SIMULATION_
  TRACE_EVENT("Resp_uPlusExtError(): overwrite EXT ERROR with plain ERROR to make TAP happy");
  io_sendConfirm (src_infos_psi->srcId, cmdAtError(atError), ATI_NORMAL_OUTPUT);
#else
  io_sendConfirm(src_infos_psi->srcId, 
                 cmdExtError(resp_p->response.ptr_res_plus_ext_error->err), 
                 ATI_ERROR_OUTPUT);
#endif
  return 0; /* Ok */
}

int Resp_uPlusFHS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPlusFHS() ");

  rCI_PlusFHS(resp_p->response.ptr_res_plus_fhs->status);
  
  return 0; /* Ok */
}

int Resp_uPlusILRR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  LONG val;
  TRACE_FUNCTION ("Resp_uPlusILRR()");

  if ( ati_user_output_cfg[src_infos_psi->srcId].ILRR_stat )
  {
    switch(resp_p->response.ptr_res_plus_ilrr->rate)
    {
      case(BAT_ILRR_RATE_300):   val=  300; break;
      case(BAT_ILRR_RATE_1200):  val= 1200; break;
      case(BAT_ILRR_RATE_2400):  val= 2400; break;
      case(BAT_ILRR_RATE_4800):  val= 4800; break;
      case(BAT_ILRR_RATE_9600):  val= 9600; break;
      case(BAT_ILRR_RATE_14400): val=14400; break;
      case(BAT_ILRR_RATE_19200): val=19200; break;
      case(BAT_ILRR_RATE_38400): val=38400; break;
      default:                   val=    1; break;
    }
    sprintf(g_sa,"+ILRR: %d,%d,%d",val,resp_p->response.ptr_res_plus_ilrr->framing_format
                                      ,resp_p->response.ptr_res_plus_ilrr->framing_parity);
    io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  }

  return 0; /* Ok */
}

int Resp_uPercentRDL(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPercentRDL()");

  rCI_PercentRDL (resp_p->response.ptr_res_percent_rdl->state );
  return 0; /* Ok */
}

int Resp_uPercentRDLB(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPercentRDLB()");

  rCI_PercentRDLB(resp_p->response.ptr_res_percent_rdlb->state);
  return 0; /* Ok */
}

#ifdef SIM_TOOLKIT 

int Resp_uPercentSATA(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPercentSATA()");

#ifdef FF_SAT_E
  rCI_PercentSATA(0,             /* cId not used */
                  resp_p->response.ptr_res_percent_sata->redial_timeout, &Addparm);
#else /*  FF_SAT_E */
  rCI_PercentSATA(0,             /* cId not used */
                  resp_p->response.ptr_res_percent_sata->redial_timeout);
#endif /*  FF_SAT_E */
  return 0; /* Ok */
}

int Resp_sPercentSATE(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_sPercentSATE()");

  rCI_PercentSATE((SHORT)resp_p->response.ptr_set_percent_sate->c_satrsp,
                  resp_p->response.ptr_set_percent_sate->satrsp);
  return 0; /* Ok */
}

int Resp_uPercentSATI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPercentSATI()");

  rCI_PercentSATI((SHORT)resp_p->response.ptr_res_percent_sati->c_satcmd,
                  resp_p->response.ptr_res_percent_sati->satcmd);
  return 0; /* Ok */
}

int Resp_uPercentSATN(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPercentSATN()");

  /* use SATN_CNTRL_BY_SIM_SS as this is required by the acisat test */
  rCI_PercentSATN((SHORT)resp_p->response.ptr_res_percent_satn->c_satcmd,
                  (UBYTE*)resp_p->response.ptr_res_percent_satn->satcmd,
                  SATN_CNTRL_BY_SIM_SS); 

  return 0; /* Ok */
}

int Resp_uPercentSIMEF(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  UBYTE n;
  T_BAT_res_uns_percent_simef *simef;
  SHORT ef[BAT_MAX_SIMEF_EF_LEN];

  /*
  *   Get a pointer to the SIMEF structure for convenience.
  */
  simef=resp_p->response.ptr_res_percent_simef;

  for (n=0;((n<simef->c_ef) AND (n<BAT_MAX_SIMEF_EF_LEN));n++)
  {
    ef[n]=(SHORT)simef->ef[n];
  }

  rCI_PercentSIMEF(ef,(UBYTE)simef->c_ef);

  return(0);
}

#endif /* SIM_TOOLKIT */

int Resp_uPercentSIMINS(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  T_ACI_CME_ERR err ;
  
  TRACE_FUNCTION ("Resp_uPercentSIMINS()");

 switch (resp_p->response.ptr_res_percent_simins->n)
  {
    case BAT_P_SIMINS_N_NO_PIN:
      err =CME_ERR_NotPresent;
      break;

    case BAT_P_SIMINS_N_SIM_PIN:
      err =CME_ERR_SimPinReq;
      break;

    case BAT_P_SIMINS_N_SIM_PUK:
      err=CME_ERR_SimPinReq;
      break;

    case BAT_P_SIMINS_N_SIM_FAIL:
      err=CME_ERR_SimFail;
      break;

    case BAT_P_SIMINS_N_SIM_BUSY:
      err=CME_ERR_SimBusy;
      break;

    case BAT_P_SIMINS_N_SIM_WRONG:
      err=CME_ERR_SimWrong;
      break;

    default:
      err=CME_ERR_Unknown;
      break;
  }
 
 rCI_PercentSIMINS ( err ) ;
  
 return 0; /* Ok */
}

int Resp_uPercentSIMREM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_uPercentSIMREM)()");
  /*
  *   This relies on T_ACI_SIMREM_TYPE being identical to
  *   T_BAT_percent_simrem_m.
  */
  rCI_PercentSIMREM(
    (T_ACI_SIMREM_TYPE)resp_p->response.ptr_res_percent_simrem->m);
  return 0; /* Ok */
}

int Resp_sPlusCGMI(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_sPlusCGMI()");  
  sprintf(g_sa,"%s",resp_p->response.ptr_set_plus_cgmi->manufacturer);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_sPlusCGMM(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
  TRACE_FUNCTION ("Resp_sPlusCGMM()");
  sprintf(g_sa,"%s",resp_p->response.ptr_set_plus_cgmm->model);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_sPlusCGMR(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{ 
  TRACE_FUNCTION ("Resp_sPlusCGMR()");
  sprintf(g_sa,"%s",resp_p->response.ptr_set_plus_cgmr->revision);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}

int Resp_sPlusCGSN(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{  
  TRACE_FUNCTION ("Resp_sPlusCGSN()");
  sprintf(g_sa,"%s",resp_p->response.ptr_set_plus_cgsn->sn);
  io_sendMessage(src_infos_psi->srcId, g_sa, ATI_NORMAL_OUTPUT);
  return 0; /* Ok */
}


int Resp_uPercentSNCNT(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
}

int Resp_uAtBusy(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
}

int Resp_uAtNoAnswer(T_ACI_DTI_PRC_PSI *src_infos_psi, T_BAT_cmd_response *resp_p)
{
}





