/* 
+----------------------------------------------------------------------------- 
|  Project :  
|  Modul   :  J:\g23m-aci\aci\aci_sc.h
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  
+----------------------------------------------------------------------------- 
*/ 
#ifndef ACI_SC_H
#define ACI_SC_H


#define SC_NONE_INSTANCE       0


typedef enum {  SC_INST_PPPS_NONE = SC_NONE_INSTANCE,
                SC_INST_PPPS = 1,
                SC_INST_PPPS_END                      } T_SC_INST_PPPS;

typedef enum {  SC_INST_PPPC_NONE = SC_NONE_INSTANCE,
                SC_INST_PPPC = SC_INST_PPPS_END,
                SC_INST_PPPC_END                      } T_SC_INST_PPPC;

typedef enum {  SC_INST_IP_NONE = SC_NONE_INSTANCE,
                SC_INST_IP = SC_INST_PPPC_END,
                SC_INST_IP_END                        } T_SC_INST_IP;

typedef enum {  SC_INST_GACI_NONE = SC_NONE_INSTANCE,
                SC_INST_GACI = SC_INST_IP_END,
                SC_INST_GACI_END                        } T_SC_INST_GACI;

typedef enum {  SC_SRC_NONE = 0,
                SC_SRC_PPPS,      /* PPP server */
                SC_SRC_PPPC,      /* PPP client */
                SC_SRC_IP,        /* IP  entity */
                SC_SRC_GACI,
                SC_SRC_MAX                            } T_SC_SRC;

typedef struct {  long  field;
                  UBYTE count;
                  UBYTE start;
                  UBYTE end;                          } T_SC_INST_INFO;

/*
**  connected Instances for GACI
*/
enum FOR_CONNECTION_TO_GACI{  MAX_CONNECTED_INSTANCES_TO_GACI = 
        SC_INST_PPPS_END + SC_INST_PPPC_END + SC_INST_IP_END -
        SC_INST_PPPS     - SC_INST_PPPC     - SC_INST_IP        };

#endif  /* ACI_SC_H */