#-----------------------------------------------------------------------------
#  Project :
#  Modul   :  j://g23m-aci/aci/ac.mak
#-----------------------------------------------------------------------------
#  Copyright 2002 Texas Instruments Berlin, AG
#                 All rights reserved.
#
#                 This file is confidential and a trade secret of Texas
#                 Instruments Berlin, AG
#                 The receipt of or possession of this file does not convey
#                 any rights to reproduce or disclose its contents or to
#                 manufacture, use, or sell anything it may describe, in
#                 whole, or in part, without the specific written consent of
#                 Texas Instruments Berlin, AG.
#-----------------------------------------------------------------------------
#|  Purpose :
#-----------------------------------------------------------------------------
#
#	Setting Directory for Layer4 Objects
#
OBJ := $(L23_OBJ_DIR)/aci

MY_OPTIONS = -D
#containing compileroptions specific for this library
SPECOPT = $(MMIOPT) $(FDOPT) $(BTOPT) $(CPHSOPT)

ifeq ($(PMODE),2)
SPECOPT += -DGPRS -DNEW_ENTITY
endif

ifeq ($(MMI),0)
INCLAYER4 = -I$(SRCACI) -I$(SRCKSD)
endif
ifeq ($(MMI),1)
INCLAYER4 = -I$(SRCSMI) -I$(SRCACI) -I$(SRCKSD) -I$(SRCMMI)
endif
ifeq ($(MMI),2)
INCLAYER4 = -I$(SRCMFW)  -I$(SRCACI)  -I$(SRCSMI) -I$(SRCKSD)
endif
ifeq ($(MMI),3)
INCLAYER4 = -I$(SRCACIA)  -I$(SRCACI)  -I$(SRCKSD)
endif

ifneq ($(BT),0)
INCLAYER4 += $(INCBTI)
endif

#ALR settings
ifeq ($(PMODE),0)
COPT1 += -uALR
else
COPT1 += -dALR
endif

#TTY settings
ifeq ($(FF_TTY),1)
COPT1 += -dFF_TTY
else
COPT1 += -uFF_TTY
endif

#
# Begin ACI: files that always have to be linked...
#
ATIOBJ += $(OBJ)/ati_bas.$(OBJ_TAIL) \
          $(OBJ)/ati_cc.$(OBJ_TAIL) \
          $(OBJ)/ati_cmd.$(OBJ_TAIL) \
          $(OBJ)/ati_csc.$(OBJ_TAIL) \
          $(OBJ)/ati_err.$(OBJ_TAIL) \
          $(OBJ)/ati_io.$(OBJ_TAIL) \
          $(OBJ)/ati_mm.$(OBJ_TAIL) \
          $(OBJ)/ati_phb.$(OBJ_TAIL) \
          $(OBJ)/ati_prs.$(OBJ_TAIL) \
          $(OBJ)/ati_ret.$(OBJ_TAIL) \
          $(OBJ)/ati_sim.$(OBJ_TAIL) \
          $(OBJ)/ati_sms.$(OBJ_TAIL) \
          $(OBJ)/ati_ss.$(OBJ_TAIL) \
          $(OBJ)/ati_mmi.$(OBJ_TAIL) \
          $(OBJ)/line_edit.$(OBJ_TAIL) \
          $(OBJ)/line_split.$(OBJ_TAIL) \
          $(OBJ)/ati_dti.$(OBJ_TAIL)

ATISRCOBJ += $(OBJ)/ati_src_uart.$(OBJ_TAIL) \
             $(OBJ)/ati_src_uart_io.$(OBJ_TAIL)

ATIEXTOBJ += $(OBJ)/ati_ext_mech.$(OBJ_TAIL)

ACIOBJ +=  $(OBJ)/aci_aci.$(OBJ_TAIL) \
           $(OBJ)/aci_mem.$(OBJ_TAIL) \
           $(OBJ)/aci_csf.$(OBJ_TAIL) \
           $(OBJ)/aci_pei.$(OBJ_TAIL) \
           $(OBJ)/aci_tim.$(OBJ_TAIL) \
           $(OBJ)/aci_util.$(OBJ_TAIL) \
           $(OBJ)/aci_lst.$(OBJ_TAIL) \
           $(OBJ)/dti_cntrl_mng.$(OBJ_TAIL) \
           $(OBJ)/phb.$(OBJ_TAIL) \
           $(OBJ)/aoc.$(OBJ_TAIL) \
           $(OBJ)/aci_mfw.$(OBJ_TAIL) \
           $(OBJ)/aci_slock.$(OBJ_TAIL)

CMHOBJ2 = $(OBJ)/cmh_ccf.$(OBJ_TAIL) \
          $(OBJ)/cmh_ccq.$(OBJ_TAIL) \
          $(OBJ)/cmh_ccr.$(OBJ_TAIL) \
          $(OBJ)/cmh_ccs.$(OBJ_TAIL) \
          $(OBJ)/cmh_dmy.$(OBJ_TAIL) \
          $(OBJ)/cmh_f.$(OBJ_TAIL) \
          $(OBJ)/cmh_mmir.$(OBJ_TAIL) \
          $(OBJ)/cmh_mmis.$(OBJ_TAIL) \
          $(OBJ)/cmh_mmit.$(OBJ_TAIL) \
          $(OBJ)/cmh_mmiq.$(OBJ_TAIL) \
          $(OBJ)/cmh_mmf.$(OBJ_TAIL) \
          $(OBJ)/cmh_mmq.$(OBJ_TAIL) \
          $(OBJ)/cmh_mmr.$(OBJ_TAIL) \
          $(OBJ)/cmh_mms.$(OBJ_TAIL) \
          $(OBJ)/cmh_mmt.$(OBJ_TAIL) \
          $(OBJ)/cmh_phbf.$(OBJ_TAIL) \
          $(OBJ)/cmh_phbq.$(OBJ_TAIL) \
          $(OBJ)/cmh_phbs.$(OBJ_TAIL) \
          $(OBJ)/cmh_phbt.$(OBJ_TAIL) \
          $(OBJ)/cmh_phbr.$(OBJ_TAIL) \
          $(OBJ)/cmh_simf.$(OBJ_TAIL) \
          $(OBJ)/cmh_simq.$(OBJ_TAIL) \
          $(OBJ)/cmh_simr.$(OBJ_TAIL) \
          $(OBJ)/cmh_sims.$(OBJ_TAIL) \
          $(OBJ)/cmh_smsf.$(OBJ_TAIL) \
          $(OBJ)/cmh_smsq.$(OBJ_TAIL) \
          $(OBJ)/cmh_smsr.$(OBJ_TAIL) \
          $(OBJ)/cmh_smss.$(OBJ_TAIL) \
          $(OBJ)/cmh_ssf.$(OBJ_TAIL) \
          $(OBJ)/cmh_ssq.$(OBJ_TAIL) \
          $(OBJ)/cmh_ssr.$(OBJ_TAIL) \
          $(OBJ)/cmh_sss.$(OBJ_TAIL) \
          $(OBJ)/cmh_tsts.$(OBJ_TAIL) \
          $(OBJ)/cmh_uartf.$(OBJ_TAIL) \
          $(OBJ)/cmh_uartr.$(OBJ_TAIL) \
          $(OBJ)/cmh_uarts.$(OBJ_TAIL) \
          $(OBJ)/cmh_dti.$(OBJ_TAIL)

PSAOBJ2 = $(OBJ)/psa_ccf.$(OBJ_TAIL) \
          $(OBJ)/psa_ccp.$(OBJ_TAIL) \
          $(OBJ)/psa_ccs.$(OBJ_TAIL) \
          $(OBJ)/psa_f.$(OBJ_TAIL) \
          $(OBJ)/psa_mmif.$(OBJ_TAIL) \
          $(OBJ)/psa_mmip.$(OBJ_TAIL) \
          $(OBJ)/psa_mmis.$(OBJ_TAIL) \
          $(OBJ)/psa_mmf.$(OBJ_TAIL) \
          $(OBJ)/psa_mmp.$(OBJ_TAIL) \
          $(OBJ)/psa_mms.$(OBJ_TAIL) \
          $(OBJ)/psa_simf.$(OBJ_TAIL) \
          $(OBJ)/psa_simp.$(OBJ_TAIL) \
          $(OBJ)/psa_sims.$(OBJ_TAIL) \
          $(OBJ)/psa_smsf.$(OBJ_TAIL) \
          $(OBJ)/psa_smsp.$(OBJ_TAIL) \
          $(OBJ)/psa_smss.$(OBJ_TAIL) \
          $(OBJ)/psa_ssf.$(OBJ_TAIL) \
          $(OBJ)/psa_ssp.$(OBJ_TAIL) \
          $(OBJ)/psa_sss.$(OBJ_TAIL) \
          $(OBJ)/psa_util.$(OBJ_TAIL) \
          $(OBJ)/psa_uartp.$(OBJ_TAIL) \
          $(OBJ)/psa_uarts.$(OBJ_TAIL) \
          $(OBJ)/psa_mtst.$(OBJ_TAIL)

SAPOBJ += $(OBJ)/sap_dti.$(OBJ_TAIL)

# don't include ACI's conc. SMS module for Riv
ifneq ($(MMI),3)
CONCOBJ = $(OBJ)/conc_sms.$(OBJ_TAIL)
else
CONCOBJ =
endif

# Begin KSD
KSDOBJ :=  $(OBJ)/ksd.$(OBJ_TAIL) \
           $(OBJ)/ksd_utl.$(OBJ_TAIL)

#
# End of files always to be linked: following depends on compiler option
#

# CPHS Module
ifeq ($(CPHS),1)
ACIOBJ += $(OBJ)/cphs.$(OBJ_TAIL) \
          $(OBJ)/cphs_aci.$(OBJ_TAIL)

ATIOBJ += $(OBJ)/ati_cphs.$(OBJ_TAIL)

CMHOBJ2 += $(OBJ)/cmh_cphs.$(OBJ_TAIL)
endif

#ifeq ($(SRVC),0) There is no specific file to be included for Voice Only...
#endif

# if FAX AND DATA version
ifeq ($(SRVC),1)

ATIOBJ += $(OBJ)/ati_fd.$(OBJ_TAIL)

CMHOBJ3 =  $(OBJ)/cmh_l2rf.$(OBJ_TAIL)\
           $(OBJ)/cmh_l2rq.$(OBJ_TAIL) \
           $(OBJ)/cmh_l2rr.$(OBJ_TAIL) \
           $(OBJ)/cmh_l2rs.$(OBJ_TAIL) \
           $(OBJ)/cmh_raf.$(OBJ_TAIL) \
           $(OBJ)/cmh_rar.$(OBJ_TAIL) \
           $(OBJ)/cmh_ras.$(OBJ_TAIL) \
           $(OBJ)/cmh_t30f.$(OBJ_TAIL) \
           $(OBJ)/cmh_t30r.$(OBJ_TAIL) \
           $(OBJ)/cmh_t30s.$(OBJ_TAIL) \
           $(OBJ)/cmh_t30q.$(OBJ_TAIL)

PSAOBJ3 = $(OBJ)/psa_l2rf.$(OBJ_TAIL) \
          $(OBJ)/psa_l2rp.$(OBJ_TAIL) \
          $(OBJ)/psa_l2rs.$(OBJ_TAIL) \
          $(OBJ)/psa_raf.$(OBJ_TAIL) \
          $(OBJ)/psa_rap.$(OBJ_TAIL) \
          $(OBJ)/psa_ras.$(OBJ_TAIL) \
          $(OBJ)/psa_t30f.$(OBJ_TAIL) \
          $(OBJ)/psa_t30p.$(OBJ_TAIL) \
          $(OBJ)/psa_t30s.$(OBJ_TAIL) \
          $(OBJ)/psa_tras.$(OBJ_TAIL) \
          $(OBJ)/psa_trap.$(OBJ_TAIL) \

endif
#endif FAX AND DATA

#SMS PDU mode settings
ifdef SMS_PDU_SUPPORT
COPT += -dSMS_PDU_SUPPORT
ATIOBJ += $(OBJ)/ati_pdu.$(OBJ_TAIL)
endif

# Sim apllication setting
ifeq ($(TK),1)
COPT1 += -dSIM_TOOLKIT

ATIOBJ += $(OBJ)/ati_sat.$(OBJ_TAIL)

ATISRCOBJ += $(OBJ)/ati_src_sat.$(OBJ_TAIL)

CMHOBJ1 = $(OBJ)/cmh_sats.$(OBJ_TAIL)\
          $(OBJ)/cmh_satr.$(OBJ_TAIL)\
          $(OBJ)/cmh_satq.$(OBJ_TAIL)

PSAOBJ1 = $(OBJ)/psa_satf.$(OBJ_TAIL)\
          $(OBJ)/psa_satp.$(OBJ_TAIL)\
          $(OBJ)/psa_sats.$(OBJ_TAIL)\
          $(OBJ)/cmh_satf.$(OBJ_TAIL)
else
COPT1 += -uSIM_TOOLKIT
endif
#endif Sim Application Toolkit

# BLUETOOTH
ifneq ($(BT),0)
ATISRCOBJ += $(OBJ)/ati_src_bt.$(OBJ_TAIL)
endif
#endif BLUETOOTH

# Engineering Mode
ifeq ($(EM),1)
ATIOBJ += $(OBJ)/ati_em.$(OBJ_TAIL) \
          $(OBJ)/ati_em_ret.$(OBJ_TAIL)

ACIOBJ += $(OBJ)/aci_em.$(OBJ_TAIL)

CMHOBJ2 += $(OBJ)/cmh_emq.$(OBJ_TAIL) \
           $(OBJ)/cmh_emr.$(OBJ_TAIL) \

SAPOBJ += $(OBJ)/sap_em.$(OBJ_TAIL)
endif
#endif Engineering Mode


ifeq ($(WAP),2)
ATISRCOBJ += $(OBJ)/ati_src_riv.$(OBJ_TAIL)

CMHOBJ4 = $(OBJ)/cmh_pppr.$(OBJ_TAIL) \
          $(OBJ)/cmh_pps.$(OBJ_TAIL)

PSAOBJ4 = $(OBJ)/psa_pppp.$(OBJ_TAIL) \
          $(OBJ)/psa_ppps.$(OBJ_TAIL) \
          $(OBJ)/psa_pppf_w.$(OBJ_TAIL) \
          $(OBJ)/psa_aaap.$(OBJ_TAIL) \
          $(OBJ)/psa_aaas.$(OBJ_TAIL)

ifneq ($(PMODE),2)
SAPOBJ += $(OBJ)/sap_ppp.$(OBJ_TAIL)
endif

endif
#endif WAP=2

ifeq ($(WAP),1)

CMHOBJ4 = $(OBJ)/cmh_ipar.$(OBJ_TAIL) \
          $(OBJ)/cmh_ipas.$(OBJ_TAIL) \
          $(OBJ)/cmh_pppr.$(OBJ_TAIL) \
          $(OBJ)/cmh_pps.$(OBJ_TAIL) \
          $(OBJ)/cmh_udpar.$(OBJ_TAIL) \
          $(OBJ)/cmh_udpas.$(OBJ_TAIL)

PSAOBJ4 = $(OBJ)/psa_ipap.$(OBJ_TAIL) \
          $(OBJ)/psa_ipas.$(OBJ_TAIL) \
          $(OBJ)/psa_pppp.$(OBJ_TAIL) \
          $(OBJ)/psa_ppps.$(OBJ_TAIL) \
          $(OBJ)/psa_pppf_w.$(OBJ_TAIL) \
          $(OBJ)/psa_udpap.$(OBJ_TAIL) \
          $(OBJ)/psa_udpas.$(OBJ_TAIL) \
          $(OBJ)/psa_tcpipf.$(OBJ_TAIL) \
          $(OBJ)/psa_wapp.$(OBJ_TAIL) \
          $(OBJ)/psa_waps.$(OBJ_TAIL)

ifneq ($(PMODE),2)
SAPOBJ += $(OBJ)/sap_ppp.$(OBJ_TAIL)
endif

endif
#endif WAP=1


# Add necessary GPRS modules when GPRS is requested
ifeq ($(PMODE),2)
ATIOBJ += $(OBJ)/ati_gprs.$(OBJ_TAIL)

ACIOBJ += $(OBJ)/gaci_srcc.$(OBJ_TAIL) \
          $(OBJ)/gaci.$(OBJ_TAIL) \
          $(OBJ)/gaci_ret.$(OBJ_TAIL)

CMHOBJ5 = $(OBJ)/cmh_gmmf.$(OBJ_TAIL) \
          $(OBJ)/cmh_gmmq.$(OBJ_TAIL) \
          $(OBJ)/cmh_gmmr.$(OBJ_TAIL) \
          $(OBJ)/cmh_gmms.$(OBJ_TAIL) \
          $(OBJ)/cmh_gpppf.$(OBJ_TAIL) \
          $(OBJ)/cmh_gpppr.$(OBJ_TAIL) \
          $(OBJ)/cmh_gppps.$(OBJ_TAIL) \
          $(OBJ)/cmh_snds.$(OBJ_TAIL) \
          $(OBJ)/cmh_sndr.$(OBJ_TAIL) \
          $(OBJ)/cmh_smf.$(OBJ_TAIL) \
          $(OBJ)/cmh_smq.$(OBJ_TAIL) \
          $(OBJ)/cmh_smr.$(OBJ_TAIL) \
          $(OBJ)/cmh_sms.$(OBJ_TAIL) \
          $(OBJ)/cmh_smt.$(OBJ_TAIL)

PSAOBJ5 = $(OBJ)/psa_gmmf.$(OBJ_TAIL) \
          $(OBJ)/psa_gmmp.$(OBJ_TAIL) \
          $(OBJ)/psa_gmms.$(OBJ_TAIL) \
          $(OBJ)/psa_gpppf.$(OBJ_TAIL) \
          $(OBJ)/psa_gpppp.$(OBJ_TAIL) \
          $(OBJ)/psa_gppps.$(OBJ_TAIL) \
          $(OBJ)/psa_sndp.$(OBJ_TAIL) \
          $(OBJ)/psa_snds.$(OBJ_TAIL) \
          $(OBJ)/psa_smf.$(OBJ_TAIL) \
          $(OBJ)/psa_smp.$(OBJ_TAIL) \
          $(OBJ)/psa_sms.$(OBJ_TAIL)

SAPOBJ += $(OBJ)/sap_ppp.$(OBJ_TAIL)

ifneq  ($(PKTI),0) # PKTIO requires GPRS
CMHOBJ5 += $(OBJ)/cmh_pktio.$(OBJ_TAIL)

PSAOBJ5 += $(OBJ)/psa_pktios.$(OBJ_TAIL) \
           $(OBJ)/psa_pktiop.$(OBJ_TAIL)
endif

endif

#EOTD objects
ifeq ($(EOTD),1)

ATIOBJ += $(OBJ)/ati_lcs.$(OBJ_TAIL) \
          $(OBJ)/ati_src_lc.$(OBJ_TAIL)

CMHOBJ2 += $(OBJ)/cmh_lcq.$(OBJ_TAIL) \
           $(OBJ)/cmh_lcs.$(OBJ_TAIL)

PSAOBJ2 += $(OBJ)/psa_lc.$(OBJ_TAIL)

endif

#
# End ACI
#


#
# Creating aci.lib
#

# (The contents of $(CMHOBJ) and $(PSAOBJ) have grown so big that the archiver
# command line was too long when compiling with WAP. Therefore I split
# $(CMHOBJ) and $(PSAOBJ) into five parts. This change is also reflected in the
# compilation rule below. The DUMMY_OBJ is needed in order not to call
# the archiver with an empty object file list if one of the CMHOBJn is
# empty, which can easily be the case. [ni 2001-08-23])

DUMMY_OBJ = $(OBJ)/aci_dummy.$(OBJ_TAIL)

#LINK_ACIOBJ := $(patsubst $(OBJ)/%,./%,$(ACIOBJ))
#LINK_ATIOBJ := $(patsubst $(OBJ)/%,./%,$(ATIOBJ))
#LINK_ATISRCOBJ := $(patsubst $(OBJ)/%,./%,$(ATISRCOBJ))
#LINK_CMHOBJ1 := $(patsubst $(OBJ)/%,./%,$(CMHOBJ1))
#LINK_CMHOBJ2 := $(patsubst $(OBJ)/%,./%,$(CMHOBJ2))
#LINK_CMHOBJ3 := $(patsubst $(OBJ)/%,./%,$(CMHOBJ3))
#LINK_CMHOBJ4 := $(patsubst $(OBJ)/%,./%,$(CMHOBJ4))
#LINK_CMHOBJ5 := $(patsubst $(OBJ)/%,./%,$(CMHOBJ5))
#LINK_PSAOBJ := $(patsubst $(OBJ)/%,./%,$(PSAOBJ))
#LINK_SAPOBJ := $(patsubst $(OBJ)/%,./%,$(SAPOBJ))
#LINK_CONCOBJ := $(patsubst $(OBJ)/%,./%,$(CONCOBJ))
#LINK_KSDOBJ := $(patsubst $(OBJ)/%,./%,$(KSDOBJ))


$(TOP_DIR)/$(ACI_LIB) : $(OBJ) $(ATIOBJ) $(ACIOBJ) $(ATISRCOBJ) $(ATIEXTOBJ) \
    $(CMHOBJ1) $(CMHOBJ2) $(CMHOBJ3) $(CMHOBJ4) $(CMHOBJ5) $(DUMMY_OBJ) \
    $(PSAOBJ1) $(PSAOBJ2) $(PSAOBJ3) $(PSAOBJ4) $(PSAOBJ5) \
    $(SAPOBJ) $(CONCOBJ) $(KSDOBJ)
	-$(PERL) $(CONDAT_DIR)/int/bin/make_ver.pl
	$(COPY_CMD) ver.$(OBJ_TAIL) $(subst /,$(SLASH),$(OBJ)/ver.$(OBJ_TAIL))
	cd $(subst /,$(SLASH),$(OBJ)) $(DELIMITER) $(AR) r $(TOP_DIR)/$(ACI_LIB) $(patsubst $(OBJ)/%,%,$(ACIOBJ)) ver.$(OBJ_TAIL)
	cd $(subst /,$(SLASH),$(OBJ)) $(DELIMITER) $(AR) r $(TOP_DIR)/$(ACI_LIB) $(patsubst $(OBJ)/%,%,$(ATIOBJ))
	cd $(subst /,$(SLASH),$(OBJ)) $(DELIMITER) $(AR) r $(TOP_DIR)/$(ACI_LIB) $(patsubst $(OBJ)/%,%,$(ATISRCOBJ))
	cd $(subst /,$(SLASH),$(OBJ)) $(DELIMITER) $(AR) r $(TOP_DIR)/$(ACI_LIB) $(patsubst $(OBJ)/%,%,$(ATIEXTOBJ))
	cd $(subst /,$(SLASH),$(OBJ)) $(DELIMITER) $(AR) r $(TOP_DIR)/$(ACI_LIB) $(DUMMY_OBJ) $(patsubst $(OBJ)/%,%,$(CMHOBJ1))
	cd $(subst /,$(SLASH),$(OBJ)) $(DELIMITER) $(AR) r $(TOP_DIR)/$(ACI_LIB) $(DUMMY_OBJ) $(patsubst $(OBJ)/%,%,$(CMHOBJ2))
	cd $(subst /,$(SLASH),$(OBJ)) $(DELIMITER) $(AR) r $(TOP_DIR)/$(ACI_LIB) $(DUMMY_OBJ) $(patsubst $(OBJ)/%,%,$(CMHOBJ3))
	cd $(subst /,$(SLASH),$(OBJ)) $(DELIMITER) $(AR) r $(TOP_DIR)/$(ACI_LIB) $(DUMMY_OBJ) $(patsubst $(OBJ)/%,%,$(CMHOBJ4))
	cd $(subst /,$(SLASH),$(OBJ)) $(DELIMITER) $(AR) r $(TOP_DIR)/$(ACI_LIB) $(DUMMY_OBJ) $(patsubst $(OBJ)/%,%,$(CMHOBJ5))
	cd $(subst /,$(SLASH),$(OBJ)) $(DELIMITER) $(AR) r $(TOP_DIR)/$(ACI_LIB) $(DUMMY_OBJ) $(patsubst $(OBJ)/%,%,$(PSAOBJ1))
	cd $(subst /,$(SLASH),$(OBJ)) $(DELIMITER) $(AR) r $(TOP_DIR)/$(ACI_LIB) $(DUMMY_OBJ) $(patsubst $(OBJ)/%,%,$(PSAOBJ2))
	cd $(subst /,$(SLASH),$(OBJ)) $(DELIMITER) $(AR) r $(TOP_DIR)/$(ACI_LIB) $(DUMMY_OBJ) $(patsubst $(OBJ)/%,%,$(PSAOBJ3))
	cd $(subst /,$(SLASH),$(OBJ)) $(DELIMITER) $(AR) r $(TOP_DIR)/$(ACI_LIB) $(DUMMY_OBJ) $(patsubst $(OBJ)/%,%,$(PSAOBJ4))
	cd $(subst /,$(SLASH),$(OBJ)) $(DELIMITER) $(AR) r $(TOP_DIR)/$(ACI_LIB) $(DUMMY_OBJ) $(patsubst $(OBJ)/%,%,$(PSAOBJ5))
	cd $(subst /,$(SLASH),$(OBJ)) $(DELIMITER) $(AR) r $(TOP_DIR)/$(ACI_LIB) $(DUMMY_OBJ) $(patsubst $(OBJ)/%,%,$(SAPOBJ))
	cd $(subst /,$(SLASH),$(OBJ)) $(DELIMITER) $(AR) r $(TOP_DIR)/$(ACI_LIB) $(DUMMY_OBJ) $(patsubst $(OBJ)/%,%,$(CONCOBJ))
	cd $(subst /,$(SLASH),$(OBJ)) $(DELIMITER) $(AR) r $(TOP_DIR)/$(ACI_LIB) $(DUMMY_OBJ) $(patsubst $(OBJ)/%,%,$(KSDOBJ))

$(OBJ):
	mkdir $(subst /,$(SLASH),$(OBJ))

clean:
	$(REMOVE) $(subst /,$(SLASH),$(OBJ))

$(ACIOBJ): $(OBJ)/%.$(OBJ_TAIL) : $(SRCACI)/%.c
	echo -D$(NCONFIG) >  cmd
	echo -D$(NTRACE) >> cmd
	echo -D$(NWARN) >> cmd
	echo -DDTI2 >> cmd
	echo $(MY_OPTIONS) >> cmd
	echo $(SPECOPT) >> cmd
	echo $(COPT) >>  cmd
	echo $(COPT1) >> cmd
	echo $(COTAR) >> cmd
	echo $(FDOPT) >> cmd
	echo $(INCDRV1) >> cmd
	echo -I$(ICOM) >> cmd
	echo $(INCDRV2) >> cmd
	echo -I$(ICDG) >> cmd
	echo -I$(SRCACIEXT) >> cmd
	echo -I$(SRCATIEXT) >> cmd
	echo -I$(SRCACIDTIMNG) >> cmd
	echo $(INCLAYER4) >> cmd
	echo -fr$(OBJ) >> cmd
	$(CC_PRE) $^ -@cmd
	$(CC_INT) $(addsuffix .pp,$(basename $^))
	$(CC_COM) $(addsuffix .pp_,$(basename $^)) -@cmd

$(ATIOBJ): $(OBJ)/%.$(OBJ_TAIL) : $(SRCACI)/%.c
	echo -D$(NCONFIG) >  cmd
	echo -D$(NTRACE) >> cmd
	echo -D$(NWARN) >> cmd
	echo -DDTI2 >> cmd
	echo $(MY_OPTIONS) >> cmd
	echo $(SPECOPT) >> cmd
	echo $(COPT) >> cmd
	echo $(COPT1) >> cmd
	echo $(COTAR) >> cmd
	echo $(FDOPT) >> cmd
	echo $(INCDRV1) >> cmd
	echo -I$(ICOM) >> cmd
	echo $(INCDRV2) >> cmd
	echo -I$(ICDG) >> cmd
	echo -I$(SRCACIEXT) >> cmd
	echo -I$(SRCATIEXT) >> cmd
	echo -I$(SRCACIDTIMNG) >> cmd
	echo $(INCLAYER4) >> cmd
	echo -fr$(OBJ) >> cmd
	$(CC_PRE) $^ -@cmd
	$(CC_INT) $(addsuffix .pp,$(basename $^))
	$(CC_COM) $(addsuffix .pp_,$(basename $^)) -@cmd

$(ATISRCOBJ): $(OBJ)/%.$(OBJ_TAIL) : $(SRCACI)/%.c
	echo -D$(NCONFIG) >  cmd
	echo -D$(NTRACE) >> cmd
	echo -D$(NWARN) >> cmd
	echo -DDTI2 >> cmd
	echo $(MY_OPTIONS) >> cmd
	echo $(SPECOPT) >> cmd
	echo $(COPT) >> cmd
	echo $(COPT1) >> cmd
	echo $(COTAR) >> cmd
	echo $(FDOPT) >> cmd
	echo $(INCDRV1) >> cmd
	echo -I$(ICOM) >> cmd
	echo $(INCDRV2) >> cmd
	echo -I$(ICDG) >> cmd
	echo -I$(SRCACIEXT) >> cmd
	echo -I$(SRCATIEXT) >> cmd
	echo -I$(SRCACIDTIMNG) >> cmd
	echo $(INCLAYER4) >> cmd
	echo -fr$(OBJ) >> cmd
	$(CC_PRE) $^ -@cmd
	$(CC_INT) $(addsuffix .pp,$(basename $^))
	$(CC_COM) $(addsuffix .pp_,$(basename $^)) -@cmd

$(ATIEXTOBJ): $(OBJ)/%.$(OBJ_TAIL) : $(SRCATIEXT)/%.c
	echo -D$(NCONFIG) >  cmd
	echo -D$(NTRACE) >> cmd
	echo -D$(NWARN) >> cmd
	echo -DDTI2 >> cmd
	echo $(MY_OPTIONS) >> cmd
	echo $(SPECOPT) >> cmd
	echo $(COPT) >> cmd
	echo $(COPT1) >> cmd
	echo $(COTAR) >> cmd
	echo $(FDOPT) >> cmd
	echo $(INCDRV1) >> cmd
	echo -I$(ICOM) >> cmd
	echo $(INCDRV2) >> cmd
	echo -I$(ICDG) >> cmd
	echo -I$(SRCACIEXT) >> cmd
	echo -I$(SRCATIEXT) >> cmd
	echo -I$(SRCACIDTIMNG) >> cmd
	echo $(INCLAYER4) >> cmd
	echo -fr$(OBJ) >> cmd
	$(CC_PRE) $^ -@cmd
	$(CC_INT) $(addsuffix .pp,$(basename $^))
	$(CC_COM) $(addsuffix .pp_,$(basename $^)) -@cmd

$(KSDOBJ): $(OBJ)/%.$(OBJ_TAIL) : $(SRCKSD)/%.c
	echo -D$(NCONFIG) >  cmd
	echo -D$(NTRACE) >> cmd
	echo -D$(NWARN) >> cmd
	echo $(MY_OPTIONS) >> cmd
	echo $(SPECOPT) >> cmd
	echo $(COPT) >> cmd
	echo $(COPT1) >> cmd
	echo $(COTAR) >> cmd
	echo $(FDOPT) >> cmd
	echo $(INCDRV1) >> cmd
	echo -I$(ICOM) >> cmd
	echo $(INCDRV2) >> cmd
	echo -I$(ICDG) >> cmd
	echo -I$(SRCACIEXT) >> cmd
	echo -I$(SRCATIEXT) >> cmd
	echo -I$(SRCACIDTIMNG) >> cmd
	echo $(INCLAYER4) >> cmd
	echo -fr$(OBJ) >> cmd
	$(CC_PRE) $^ -@cmd
	$(CC_INT) $(addsuffix .pp,$(basename $^))
	$(CC_COM) $(addsuffix .pp_,$(basename $^)) -@cmd

# See comment above on CMHOBJn and DUMMY_OBJ.
$(CMHOBJ1) $(CMHOBJ2) $(CMHOBJ3) $(CMHOBJ4) $(CMHOBJ5) $(DUMMY_OBJ): \
    $(OBJ)/%.$(OBJ_TAIL) : $(SRCACI)/%.c
	echo -D$(NCONFIG) >  cmd
	echo -D$(NTRACE) >> cmd
	echo -D$(NWARN) >> cmd
	echo -DDTI2 >> cmd
	echo $(MY_OPTIONS) >> cmd
	echo $(SPECOPT) >> cmd
	echo $(COPT) >> cmd
	echo $(COPT1) >> cmd
	echo $(COTAR) >> cmd
	echo $(FDOPT) >> cmd
	echo $(INCDRV1) >> cmd
	echo -I$(ICOM) >> cmd
	echo $(INCDRV2) >> cmd
	echo -I$(ICDG) >> cmd
	echo -I$(SRCACIEXT) >> cmd
	echo -I$(SRCATIEXT) >> cmd
	echo -I$(SRCACIDTIMNG) >> cmd
	echo $(INCLAYER4) >> cmd
	echo -fr$(OBJ) >> cmd
	$(CC_PRE) $^ -@cmd
	$(CC_INT) $(addsuffix .pp,$(basename $^))
	$(CC_COM) $(addsuffix .pp_,$(basename $^)) -@cmd

$(PSAOBJ1) $(PSAOBJ2) $(PSAOBJ3) $(PSAOBJ4) $(PSAOBJ5): \
    $(OBJ)/%.$(OBJ_TAIL) : $(SRCACI)/%.c
	echo -D$(NCONFIG) >  cmd
	echo -D$(NTRACE) >> cmd
	echo -D$(NWARN) >> cmd
	echo -DDTI2 >> cmd
	echo $(MY_OPTIONS) >> cmd
	echo $(SPECOPT) >> cmd
	echo $(COPT) >> cmd
	echo $(COPT1) >> cmd
	echo $(COTAR) >> cmd
	echo $(FDOPT) >> cmd
	echo $(INCDRV1) >> cmd
	echo -I$(ICOM) >> cmd
	echo $(INCDRV2) >> cmd
	echo -I$(ICDG) >> cmd
	echo -I$(SRCACIEXT) >> cmd
	echo -I$(SRCATIEXT) >> cmd
	echo -I$(SRCACIDTIMNG) >> cmd
	echo $(INCLAYER4) >> cmd
	echo -fr$(OBJ) >> cmd
	$(CC_PRE) $^ -@cmd
	$(CC_INT) $(addsuffix .pp,$(basename $^))
	$(CC_COM) $(addsuffix .pp_,$(basename $^)) -@cmd

$(SAPOBJ): $(OBJ)/%.$(OBJ_TAIL) : $(SRCACI)/%.c
	echo -D$(NCONFIG) >  cmd
	echo -D$(NTRACE) >> cmd
	echo -D$(NWARN) >> cmd
	echo -DDTI2 >> cmd
	echo $(MY_OPTIONS) >> cmd
	echo $(SPECOPT) >> cmd
	echo $(COPT) >> cmd
	echo $(COPT1) >> cmd
	echo $(COTAR) >> cmd
	echo $(FDOPT) >> cmd
	echo $(INCDRV1) >> cmd
	echo -I$(ICOM) >> cmd
	echo $(INCDRV2) >> cmd
	echo -I$(ICDG) >> cmd
	echo -I$(SRCACIEXT) >> cmd
	echo -I$(SRCATIEXT) >> cmd
	echo -I$(SRCACIDTIMNG) >> cmd
	echo $(INCLAYER4) >> cmd
	echo -fr$(OBJ) >> cmd
	$(CC_PRE) $^ -@cmd
	$(CC_INT) $(addsuffix .pp,$(basename $^))
	$(CC_COM) $(addsuffix .pp_,$(basename $^)) -@cmd

$(CONCOBJ): $(OBJ)/%.$(OBJ_TAIL) : $(SRCACI)/%.c
	echo -D$(NCONFIG) >  cmd
	echo -D$(NTRACE) >> cmd
	echo -D$(NWARN) >> cmd
	echo $(MY_OPTIONS) >> cmd
	echo $(SPECOPT) >> cmd
	echo $(COPT) >> cmd
	echo $(COPT1) >> cmd
	echo $(COTAR) >> cmd
	echo $(FDOPT) >> cmd
	echo $(INCDRV1) >> cmd
	echo -I$(ICOM) >> cmd
	echo $(INCDRV2) >> cmd
	echo -I$(ICDG) >> cmd
	echo -I$(SRCACIEXT) >> cmd
	echo -I$(SRCATIEXT) >> cmd
	echo -I$(SRCACIDTIMNG) >> cmd
	echo $(INCLAYER4) >> cmd
	echo -fr$(OBJ) >> cmd
	$(CC_PRE) $^ -@cmd
	$(CC_INT) $(addsuffix .pp,$(basename $^))
	$(CC_COM) $(addsuffix .pp_,$(basename $^)) -@cmd
