@PUSHD %TESTROOT%\int\bin
@if x%_4ver% == x goto Need4NT


@iff not x%MSGDOCDIR% == x then
	@if not exist %MSGDOCDIR% mkdir %MSGDOCDIR%
	@copy /U %TESTROOT%\com\doc\msg\*.* %MSGDOCDIR%
@endiff


@iff not x%SAPDOCDIR% == x then
	@if not exist %SAPDOCDIR% mkdir %SAPDOCDIR%
	@copy /U %TESTROOT%\ms\doc\sap\*.* %SAPDOCDIR%	
@endiff


@set OPT=

@rem ALR and GTI are considered to be mutually exclusive;
@rem therefore the maximum number of arguments currently supported is 3
@rem for example makcdg [|ALR|GTI] [GPRS] [TARGET] [NO_SDL] [NO_SYMBOLS]
 
@if %1 == ALR  .OR. %2 == ALR .OR. %3 == ALR .OR. %4 == ALR .OR. %5 == ALR set OPT=ALR=1
@if %1 == GPRS .OR. %2 == GPRS .OR. %3 == GPRS .OR. %4 == GPRS .OR. %5 == GPRS set OPT=%OPT% GPRS=
@if %1 == GTI .OR. %2 == GTI .OR. %3 == GTI .OR. %4 == GTI .OR. %5 == GTI set OPT=%OPT% FF_GTI=

@rem make ALR and GPRS the default, if neither ALR, GTI, or GPRS are being explicitly specified!!!
@if %@index[%OPT,ALR] == -1 .AND. %@index[%OPT,FF_GTI] == -1 .AND. %@index[%OPT,GPRS] == -1 set OPT=ALR=1 GPRS=

@set CCDGEN_OPT_TEMP= -a2
@rem default is alignment for PC = INTEL = a2
@if %1 == ARM .OR. %2 == ARM .OR. %3 == ARM .OR. %4 == ARM .OR. %5 == ARM set CCDGEN_OPT_TEMP= -a2
@set CCDGEN_OPT_MAKCDG=%CCDGEN_OPT_TEMP%
 
@set CCDGEN_OPT_TEMP= -s
@rem default is symbols (for PC) = -s
@if %1 == NO_SYMBOLS .OR. %2 == NO_SYMBOLS .OR. %3 == NO_SYMBOLS .OR. %4 == NO_SYMBOLS .OR. %5 == NO_SYMBOLS set CCDGEN_OPT_TEMP=
@set CCDGEN_OPT_MAKCDG=%CCDGEN_OPT_MAKCDG% %CCDGEN_OPT_TEMP%

@set CCDGEN_OPT_TEMP= -l
@rem default is sdl (for PC) = -l
@if %1 == NO_SDL .OR. %2 == NO_SDL .OR. %3 == NO_SDL .OR. %4 == NO_SDL .OR. %5 == NO_SDL set CCDGEN_OPT_TEMP=
@set CCDGEN_OPT_MAKCDG=%CCDGEN_OPT_MAKCDG% %CCDGEN_OPT_TEMP%

@unset /Q CCDGEN_OPT_TEMP

@set OPT=%OPT% TDCLIB=1
@set CCDGEN_OPT_MAKCDG=%CCDGEN_OPT_MAKCDG% -gtdc

@if exist "%TESTROOT%\ms\doc\sap\dmya.sap" goto DUMMY
goto NODUMMY
:DUMMY
set OPT=%OPT% DMY=
:NODUMMY

@if exist "%TESTROOT%\ms\doc\sap\ip.sap" goto WAP
goto NOWAP
:WAP
set OPT=%OPT% WAP=
:NOWAP

@if exist "%TESTROOT%\ms\doc\sap\btp.sap" goto BT
goto NOBT
:BT
set OPT=%OPT% BT=
:NOBT

@if exist "%TESTROOT%\ms\doc\sap\t30.sap" GOTO FAX
set OPT=%OPT% VOICE=
:FAX

nmake %TESTROOT%\int\bin\makcdg.mak %OPT %CCDGEN_OPT
@pushd
strcheck -i -c%TESTROOT%\ms\CDGINC && @goto STR_SUCC
@echo strcheck failed - makcdg cancelled
@goto END
:STR_SUCC
@cdd %GPF%\CCD
gnumake -f ccddata.mk TARGET=nucwin [DEBUG=1]
gnumake -f ccddata.mk [DEBUG=1]
@popd

@pushd
@cdd %GPF%\util\tap
gnumake tcsl
@popd


@REM -- need config files in a generic config directory for WINDOWS stack build
@md \chipsetsw\system\deps_objs
@md \chipsetsw\system\deps_objs\berlin_simulation
@md \chipsetsw\system\deps_objs\berlin_simulation\config
@pushd
cdd \g23m
perl generate_nice_config_files.pl
@popd

goto END

:Need4NT
@echo "Error: 4DOS or 4NT is needed
@goto END


:END
@if NOT ISDIR %TESTROOT%\cdginc md %TESTROOT%\cdginc
@POPD
