#----------------------------------------------------------------------------- 
#  Project :  
#  Modul   :  J:\g23m\condat\frame\config\cnf.mak
#----------------------------------------------------------------------------- 
#  Copyright 2002 Texas Instruments Berlin, AG 
#                 All rights reserved. 
# 
#                 This file is confidential and a trade secret of Texas 
#                 Instruments Berlin, AG 
#                 The receipt of or possession of this file does not convey 
#                 any rights to reproduce or disclose its contents or to 
#                 manufacture, use, or sell anything it may describe, in 
#                 whole, or in part, without the specific written consent of 
#                 Texas Instruments Berlin, AG. 
#----------------------------------------------------------------------------- 
#|  Purpose :  
#----------------------------------------------------------------------------- 
#
#       Setting Directory for Frame Objects
#
OBJ := $(L23_OBJ_DIR)/cnf

CNFSRC=$(CONDAT_DIR)/Frame/CONFIG
IN2    =$(TI_DIR)/l1_std/hint
CONFIG =$(COMFSRC)/ConfigPS
INCCNF = -i$(GPF_DIR)/INC -i$(GPF_DIR)/INC/NUC -i$(GPF_DIR)/INC/NUC/ARM7
CFG_MOD = -dCONFIG_MODULE -dDATA_EXT_RAM

#EOTD settings
ifeq ($(EOTD),1)
COPT1 += -dFF_EOTD
endif


# necessary for gprscomp.c in order to not crash upon startup
COPT1 += -dNU_DEBUG


#
# Additional Configuration settings
#

#BOARD=$(BOARD)


CNFOBJ = $(OBJ)/gprscomp.$(OBJ_TAIL) $(OBJ)/custcomp.$(OBJ_TAIL) $(OBJ)/gprsinit.$(OBJ_TAIL) $(OBJ)/gprsdrv.$(OBJ_TAIL) 

#
# compressed tracing
#
ifeq ($(CTRACE),1)
COMPTRACE := CTRACE
endif

$(TOP_DIR)/$(CNF_LIB) : $(OBJ) $(CNFOBJ)
	$(AR) r $(TOP_DIR)/$(CNF_LIB) $(CNFOBJ)

$(OBJ): 
	mkdir $(subst /,$(SLASH),$(OBJ))
	
clean: 
	$(REMOVE) $(subst /,$(SLASH),$(OBJ))




$(CNFOBJ): $(OBJ)/%.obj : $(CNFSRC)/%.c
	echo -D$(NCONFIG) >  cmd
	echo -D$(COMPTRACE) >>  cmd
	echo -D$(NTRACE) >> cmd
	echo -DBOARD=$(BOARD) >> cmd
	echo $(COPF) >> cmd
	echo $(COPT) >> cmd
	echo $(COPT1) >> cmd
	echo $(COTAR) >> cmd
	echo $(FDOPT) >> cmd
	echo $(INCCNF) >> cmd
	echo $(CFG_MOD) >> cmd
	echo $(INCDRV2) >> cmd
	echo -i$(CONFIG) >> cmd
	echo -i$(ICDG) >> cmd
	echo -i$(ICOM) >> cmd
	echo -i$(SRCCF) >> cmd
	echo -fr$(OBJ) >> cmd
	$(CC_PRE) $^ -@cmd
	$(CC_INT) $(addsuffix .pp,$(basename $^))
	$(CC_COM) $(addsuffix .pp_,$(basename $^)) -@cmd
