/* 
+----------------------------------------------------------------------------- 
|  Project :  GSM-PS
|  Modul   :  PCM
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  This Modul defines the functions for the permanent
|             memory configuration driver.
+----------------------------------------------------------------------------- 
*/ 
/********************************************************************************
 $History: pcm.c

	Jun 14, 2005 REF: MMI-FIX-30439 x0018858
   	Description: The homezone/cityzone tags were not being displayed properly.
   	Solution: Modified to save the tags properly in caches and also made the 
	appropriate modifications to update the same properly during mobility.

********************************************************************************/

#ifndef PCM_C
#define PCM_C

#ifdef WIN32

/*
 * SIMULATION VERSION (Windows)
 */
/*==== INCLUDES ===================================================*/
#define ENTITY_CST

#if defined (NEW_FRAME)

#include <string.h>
#include "typedefs.h"
#include "vsi.h"
#include "custom.h"
#include "gdi.h"
#include "pcm.h"
#include "gsm.h"

#else

#include <string.h>
#include "stddefs.h"
#include "custom.h"
#include "gdi.h"
#include "pcm.h"
#include "gsm.h"
#include "vsi.h"

#endif
/*==== EXPORT =====================================================*/
#if defined (NEW_FRAME)
EXTERN USHORT cst_handle;
#endif
/*==== VARIABLES ==================================================*/

/*
 * Flag whether the 'e2prom content' is read
 */
UBYTE pcm_read = FALSE;

UBYTE std = 1;            /* default is GSM 900 using windows */
static UBYTE act_std = 0; /* to check for changes */
// set treshold for initial power measurements (= -106 dBm)
USHORT min_rxlev = 20;

/*==== FUNCTIONS ==================================================*/

/*==== CONSTANTS ==================================================*/

/*
 * GSM 900 Variant
 */
static UBYTE pcm_content_gsm_900 [] =
{
  /* MSCAP    */   0xAA, 0x01,          /* checksum & version */
                      /*actual values supported by the MS*/
                      /*0xB7, 0xC7, 0x00,*/
                      0x31, 0x00, 0x00,
                      0x00, 0x00, 0x00,
     /* IMEI     */   0xAA, 0x01,          /* checksum & version */
                      0x31, 0x75, 0x09,
                      0x42, 0x86, 0x11,
                      0x22, 0x87,
     /* RFCAP    */   0xAA, 0x01,          /* checksum & version */
     /* set frequency bands */
     0x01, /* 900 */
     /* supported frequency bands */
     0x1F, /*850/EGSM/PCS1900/DCS1800/GSM900*/
     /* power 1 900/1800 */
     0x41, /*    4   1 */
     /* power 2 1900/850 */
     0x14, /*    1    4 */
     /* power 3 400/Edge */
     0x00, /* 0       0*/
     /* Multislot cap and classes GSM */
     0x00,
     /* Multislot cap and classes EDGE */
     0x00,
     /* Multislot cap and classes HSCSD */
     0x00,
     /* Multislot cap and classes GPRS */
     0x50,
     /* Multislot cap and classes ECSD */
     0x00,
     /* Multislot cap and classes EGPRS */
     0x00,
     /*capablities 1*/
     0xa5, /* ES_IND | MT_PP_SMS | CMSP | MAC_SUPPORT*/
     /*capablities 1*/
     0x05, /* UCS2_TREAT | SS_SCREEN */
     /* switch measure value*/
     0x00,
     /* A5/n */
     0x80, /*A5_1 | A5_2 (A5_1 only here) */ 
     /* positioning */
     0x00,
     /* MSSUP    */   0xAA, 0x01,          /* checksum & version */
                      0xB7, 0x46,
                      0x47, 0x1E, 0x00,


     /* EFcgmi   */   0xAA, 0x01,          /* checksum & version */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '>',    0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,

     /*Iden. Information 1 */   0xAA, 0x01, /* checksum & version */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '1',    '>',    0xff,
      0xff,   0xff,   0xff,   0xff,

      /*Iden. Information 2 */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '2',    '>',    0xff,
      0xff,   0xff,   0xff,   0xff,

      /* MBN    */    0xAA, 0x01,          /* checksum & version */
      /* EFmbn (record 1) */
      0x4c,   0x49,   0x4e,   0x31,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x03,   0xff,
      0x12,   0xf1,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 2) */
      0x4c,   0x49,   0x4e,   0x32,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x04,   0xff,
      0x11,   0x11,   0x11,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 3) */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x00,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 4) */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x00,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,

      /* VMN    */    0xAA,   0x01,          /* checksum & version */
      0x30,   0x33,   0x30,   0x33,   0x39,   0x30,   0x39,   0x34,   //EFvmn
      0x33,   0x33,   0x36,   0x37,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0x81,

      //EFclng
      /* CLNG    */    0xAA,   0x01,          /* checksum & version */
                       'a',  'u',


     /* SMSPRFL  */   0xAA, 0x01,          /* checksum & version */
     /* EFsmsprfl record 1 */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,

     /* EFsmsprfl record 2 */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,

     /* PLMN     */   0xAA, 0x01,          /* checksum & version */
                      0x02, 0x2B,
                      0x00, 0x37,
                      0x5A, 0x57,
                      0x41, 0x4E,
                      0x5A, 0x49,
                      0x47, 0x20,
                      0x54, 0x45,
                      0x4C, 0x45,
                      0x4B, 0x4F,
                      0x4D, 0x20,
                      0x00, 0x43,
                      0x4F, 0x4D,
                      0x5A, 0x45,
                      0x48, 0x4E,
                      0x20, 0x20,
                      0x00, 0x43,
                      0x4F, 0x4D,
                      0x01, 0x06,
                      0x00, 0x02,
                      0x44, 0x2D,
                      0x5A, 0x57,
                      0x45, 0x49,
                      0x20, 0x50,
                      0x52, 0x49,
                      0x56, 0x41,
                      0x54, 0xff,
                      0xff, 0xff,
                      0xff, 0xff,
                      0xff, 0xff,
                      0x44, 0x2D,
                      0x5A, 0x57,
                      0x45, 0x49,
                      0xff, 0xff,
                      0xff, 0xff,
     /* BCCHINFO  */  0xAA, 0x01,          /* checksum & version */
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      /* MSSET     */ 0xAA, 0x01,          /* checksum & version */
                      0x20, 0x20, 0x05,    /* buzzer             */
                      0x24,                /* audio              */
                      0x00,                /* miscellaneous      */
                      0x89,                /* display            */
                      0x00,                /* language           */
                      0xFF, 0xFF, 0xFF,    /* recentLdxRef       */
      /* simlck */    0xAA, 0x01,          /* checksum & version */
                      0x00,   0x00,   0x00,   0x0f,
                      0x31,   0x32,   0x33,   0x34,   0x35,   0x36,   0x37,   0x38,
                      0x21,   0x43,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0x0f,
                      0x22,   0x00,   0x22,   0x01,   0x23,   0x15,   0x22,   0x35,
                      0x24,   0x25,   0x11,   0x22,   0x46,   0x55,   0x66,
                      0x00,   0x00,
      /* ALS    */    0xAA, 0x01,          /* checksum & version */
                      0x01, 0x00,
      /* locGPRS */   0xAA, 0x01,          /* checksum & version */
                      0xFF, 0xFF, 0xFF, 0xFF,             /* P-TMSI */
                      0xFF, 0xFF, 0xFF,                   /* P-TMSI Signature */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, /* RAI */
                      0xFF,                               /* Update Status */
      /* KcGPRS */    0xAA, 0x01,          /* checksum & version */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, /* Kc */
                      0x07,                                           /* CKSN */
      /* IMSI-GPRS */ 0xAA, 0x01,          /* checksum & version */
                      0xFF,                                           /* IMSI length */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF  /* IMSI */
};

/*
 * DCS 1800 Variant
 */
static UBYTE pcm_content_dcs_1800 [] =
{
     /* MSCAP    */   0xAA, 0x01,          /* checksum & version */
                      /*actual values supported by the MS*/
                      /*0xB7, 0xC7, 0x00,*/
                      0x03, 0x03, 0x00,
                      0x00, 0x00, 0x00,
     /* IMEI     */   0xAA, 0x01,          /* checksum & version */
                      0x31, 0x75, 0x09,
                      0x42, 0x86, 0x11,
                      0x22, 0x87,
     /* RFCAP    */   0xAA, 0x01,          /* checksum & version */
                      0x02, 0x1F, 0x41, 0x14,
                      0x00, 0x00, 0x00, 0x00,
                      0x50, 0x00, 0x00, 0xa5,
                      0x05, 0x00, 0x80, 0x00,
     /* MSSUP    */   0xAA, 0x01,          /* checksum & version */
                      0xB7, 0x46,
                      0x47,  0x1E, 0x00,


     /* EFcgmi   */   0xAA, 0x01,          /* checksum & version */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '>',    0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,

     /*Iden. Information 1 */   0xAA, 0x01, /* checksum & version */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '1',    '>',    0xff,
      0xff,   0xff,   0xff,   0xff,

      /*Iden. Information 2 */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '2',    '>',    0xff,
      0xff,   0xff,   0xff,   0xff,

      /* MBN    */    0xAA, 0x01,          /* checksum & version */
      /* EFmbn (record 1) */
      0x4c,   0x49,   0x4e,   0x31,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x03,   0xff,
      0x12,   0xf1,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 2) */
      0x4c,   0x49,   0x4e,   0x32,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x04,   0xff,
      0x11,   0x11,   0x11,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 3) */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x00,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 4) */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x00,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,

      /* VMN    */    0xAA,   0x01,          /* checksum & version */
      0x30,   0x33,   0x30,   0x33,   0x39,   0x30,   0x39,   0x34,   //EFvmn
      0x33,   0x33,   0x36,   0x37,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0x81,

      //EFclng
      /* CLNG    */    0xAA,   0x01,          /* checksum & version */
                       'a',  'u',

     /* SMSPRFL  */   0xAA, 0x01,             /* checksum & version */
     /* EFsmsprfl record 1 */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,

     /* EFsmsprfl record 2 */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,

     /* PLMN     */   0xAA, 0x01,          /* checksum & version */
                      0xff, 0xff,
                      0xff, 0xff,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x01, 0x06,
                      0x00, 0x02,
                      0x44, 0x2D,
                      0x5A, 0x57,
                      0x45, 0x49,
                      0x20, 0x50,
                      0x52, 0x49,
                      0x56, 0x41,
                      0x54, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x44, 0x2D,
                      0x5A, 0x57,
                      0x45, 0x49,
                      0x00, 0x00,
                      0x00, 0x00,
     /* BCCHINFO  */  0xAA, 0x01,          /* checksum & version */
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      /* MSSET     */ 0xAA, 0x01,          /* checksum & version */
                      0x20, 0x20, 0x05,    /* buzzer             */
                      0x24,                /* audio              */
                      0x00,                /* miscellaneous      */
                      0x89,                /* display            */
                      0x00,                /* language           */
                      0xFF, 0xFF, 0xFF,    /* recentLdxRef       */
      /* simlck */    0xAA, 0x01,          /* checksum & version */
                      0x00,   0x00,   0x00,   0x0f,
                      0x31,   0x32,   0x33,   0x34,   0x35,   0x36,   0x37,   0x38,
                      0x21,   0x43,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0x0f,
                      0x22,   0x00,   0x22,   0x01,   0x23,   0x15,   0x22,   0x35,
                      0x24,   0x25,   0x11,   0x22,   0x46,   0x55,   0x66,
                      0x00,   0x00,
      /* ALS    */    0xAA, 0x01,          /* checksum & version */
                      0x00, 0x00,
      /* locGPRS */   0xAA, 0x01,          /* checksum & version */
                      0xFF, 0xFF, 0xFF, 0xFF,             /* P-TMSI */
                      0xFF, 0xFF, 0xFF,                   /* P-TMSI Signature */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, /* RAI */
                      0xFF,                               /* Update Status */
      /* KcGPRS */    0xAA, 0x01,          /* checksum & version */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, /* Kc */
                      0x07,                                           /* CKSN */
      /* IMSI-GPRS */ 0xAA, 0x01,          /* checksum & version */
                      0xFF,                                           /* IMSI length */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, /* IMSI */
      /* SMS */       0xAA, 0x01,          /* checksum & version */
                      0x03,                /* record 1: MT, unread */
                      0x04, 0x91, 0x21, 0x43, 0xF5, 0x04, 0x06, /* DELIVER_7CL1 of SMS TCs */
                      0x81, 0x89, 0x67, 0x45, 0x40, 0xF1, 0x89, 0x10,
                      0x70, 0x21, 0x43, 0x65, 0x40, 0x09, 0x41, 0xE1,
                      0x90, 0x58, 0x34, 0x1E, 0x91, 0x49, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0x05,                /* record 2: MO, sent */
                      0x04, 0x91, 0x21, 0x43, 0xF5, 0x01, 0xFF, /* MO_INIT of SMS TCs */
                      0x06, 0x91, 0x56, 0x34, 0x12, 0x40, 0xF2, 0x09,
                      0x41, 0xE1, 0x90, 0x58, 0x34, 0x1E, 0x91, 0x49,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0x00,                /* record 3: empty */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

/*
 * PCS 1900 Variant
 */
static UBYTE pcm_content_pcs_1900 [] =
{
  /* MSCAP    */   0xAA, 0x01,          /* checksum & version */
                      /*actual values supported by the MS*/
                      /*0xB7, 0xC7, 0x00,*/
                      0x07, 0x47, 0x00,
                      0x00, 0x00, 0x00,
     /* IMEI     */   0xAA, 0x01,          /* checksum & version */
                      0x31, 0x75, 0x09,
                      0x42, 0x86, 0x11,
                      0x22, 0x87,
     /* RFCAP    */   0xAA, 0x01,          /* checksum & version */
                      0x04, 0x1F, 0x41, 0x14,
                      0x00, 0x00, 0x00, 0x00,
                      0x50, 0x00, 0x00, 0xa5,
                      0x05, 0x00, 0x80, 0x00,
     /* MSSUP    */   0xAA, 0x01,          /* checksum & version */
                      0xB7, 0x46,
                      0x47, 0x1F, 0x00,


     /* EFcgmi   */   0xAA, 0x01,          /* checksum & version */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '>',    0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,

     /*Iden. Information 1 */   0xAA, 0x01, /* checksum & version */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '1',    '>',    0xff,
      0xff,   0xff,   0xff,   0xff,

      /*Iden. Information 2 */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '2',    '>',    0xff,
      0xff,   0xff,   0xff,   0xff,

     /* MBN      */    0xAA, 0x01,          /* checksum & version */
      /* EFmbn (record 1) */
      0x4c,   0x49,   0x4e,   0x31,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x03,   0xff,
      0x12,   0xf1,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 2) */
      0x4c,   0x49,   0x4e,   0x32,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x04,   0xff,
      0x11,   0x11,   0x11,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 3) */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x00,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 4) */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x00,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,

      /* VMN    */    0xAA,   0x01,          /* checksum & version */
      0x30,   0x33,   0x30,   0x33,   0x39,   0x30,   0x39,   0x34,   //EFvmn
      0x33,   0x33,   0x36,   0x37,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0x81,

      //EFclng
      /* CLNG    */    0xAA,   0x01,          /* checksum & version */
                       'a',  'u',

     /* SMSPRFL  */   0xAA, 0x01,          /* checksum & version */
     /* EFsmsprfl record 1 */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,

     /* EFsmsprfl record 2 */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,

     /* PLMN     */   0xAA, 0x01,          /* checksum & version */
                      0xff, 0xff,
                      0xff, 0xff,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x01, 0x06,
                      0x00, 0x02,
                      0x44, 0x2D,
                      0x5A, 0x57,
                      0x45, 0x49,
                      0x20, 0x50,
                      0x52, 0x49,
                      0x56, 0x41,
                      0x54, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x44, 0x2D,
                      0x5A, 0x57,
                      0x45, 0x49,
                      0x00, 0x00,
                      0x00, 0x00,
     /* BCCHINFO  */  0xAA, 0x01,          /* checksum & version */
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      /* MSSET     */ 0xAA, 0x01,          /* checksum & version */
                      0x20, 0x20, 0x05,    /* buzzer             */
                      0x24,                /* audio              */
                      0x00,                /* miscellaneous      */
                      0x89,                /* display            */
                      0x00,                /* language           */
                      0xFF, 0xFF, 0xFF,    /* recentLdxRef       */
      /* simlck */    0xAA, 0x01,          /* checksum & version */
                      0x00,   0x00,   0x00,   0x0f,
                      0x31,   0x32,   0x33,   0x34,   0x35,   0x36,   0x37,   0x38,
                      0x21,   0x43,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0x0f,
                      0x22,   0x00,   0x22,   0x01,   0x23,   0x15,   0x22,   0x35,
                      0x24,   0x25,   0x11,   0x22,   0x46,   0x55,   0x66,
                      0x00,   0x00,
      /* ALS    */    0xAA, 0x01,          /* checksum & version */
                      0x00, 0x00,
      /* locGPRS */   0xAA, 0x01,          /* checksum & version */
                      0xFF, 0xFF, 0xFF, 0xFF,             /* P-TMSI */
                      0xFF, 0xFF, 0xFF,                   /* P-TMSI Signature */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, /* RAI */
                      0xFF,                               /* Update Status */
      /* KcGPRS */    0xAA, 0x01,          /* checksum & version */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, /* Kc */
                      0x07,                                           /* CKSN */
      /* IMSI-GPRS */ 0xAA, 0x01,          /* checksum & version */
                      0xFF,                                           /* IMSI length */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, /* IMSI */
      /* SMS */       0xAA, 0x01,          /* checksum & version */
                      0x00,                /* record 1: empty */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0x00,                /* record 2: empty */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0x00,                /* record 3: empty */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

/*
 * Dualband Version
 */
static UBYTE pcm_content_dualband [] =
{
     /* MSCAP    */   0xAA, 0x01,          /* checksum & version */
                      /*actual values supported by the MS*/
                      /*0xB7, 0xC7, 0x00,*/
                      0x05, 0x45, 0x00,
                      0x00, 0x00, 0x00,
     /* IMEI     */   0xAA, 0x01,          /* checksum & version */
                      0x31, 0x75, 0x09,
                      0x42, 0x86, 0x11,
                      0x22, 0x87,
     /* RFCAP    */   0xAA, 0x01,          /* checksum & version */
                      0x03, 0x1F, 0x41, 0x14,
                      0x00, 0x00, 0x00, 0x00,
                      0x50, 0x00, 0x00, 0xa5,
                      0x05, 0x00, 0x80, 0x00,
     /* MSSUP    */   0xAA, 0x01,          /* checksum & version */
                      0xB7, 0x46,
                      0x47, 0x1F, 0x00,


     /* EFcgmi   */   0xAA, 0x01,          /* checksum & version */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '>',    0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,

     /*Iden. Information 1 */   0xAA, 0x01, /* checksum & version */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '1',    '>',    0xff,
      0xff,   0xff,   0xff,   0xff,

      /*Iden. Information 2 */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '2',    '>',    0xff,
      0xff,   0xff,   0xff,   0xff,

     /* MBN      */    0xAA, 0x01,          /* checksum & version */
      /* EFmbn (record 1) */
      0x4c,   0x49,   0x4e,   0x31,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x03,   0xff,
      0x12,   0xf1,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 2) */
      0x4c,   0x49,   0x4e,   0x32,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x04,   0xff,
      0x11,   0x11,   0x11,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 3) */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x00,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 4) */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x00,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,

      /* VMN    */    0xAA,   0x01,          /* checksum & version */
      0x30,   0x33,   0x30,   0x33,   0x39,   0x30,   0x39,   0x34,   //EFvmn
      0x33,   0x33,   0x36,   0x37,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0x81,

      //EFclng
      /* CLNG    */    0xAA,   0x01,          /* checksum & version */
                       'a',  'u',

      /* SMSPRFL  */   0xAA, 0x01,          /* checksum & version */
     /* EFsmsprfl record 1 */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,

     /* EFsmsprfl record 2 */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,

     /* PLMN     */   0xAA, 0x01,          /* checksum & version */
                      0xff, 0xff,
                      0xff, 0xff,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x01, 0x06,
                      0x00, 0x02,
                      0x44, 0x2D,
                      0x5A, 0x57,
                      0x45, 0x49,
                      0x20, 0x50,
                      0x52, 0x49,
                      0x56, 0x41,
                      0x54, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x44, 0x2D,
                      0x5A, 0x57,
                      0x45, 0x49,
                      0x00, 0x00,
                      0x00, 0x00,
     /* BCCHINFO  */  0xAA, 0x01,          /* checksum & version */
                     /*EGSM*/
                      0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x40, 0x00, 0x00,
      /* MSSET     */ 0xAA, 0x01,          /* checksum & version */
                      0x20, 0x20, 0x05,    /* buzzer             */
                      0x24,                /* audio              */
                      0x00,                /* miscellaneous      */
                      0x89,                /* display            */
                      0x00,                /* language           */
                      0xFF, 0xFF, 0xFF,    /* recentLdxRef       */
      /* simlck */    0xAA, 0x01,          /* checksum & version */
                      0x00,   0x00,   0x00,   0x0f,
                      0x31,   0x32,   0x33,   0x34,   0x35,   0x36,   0x37,   0x38,
                      0x21,   0x43,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0x0f,
                      0x22,   0x00,   0x22,   0x01,   0x23,   0x15,   0x22,   0x35,
                      0x24,   0x25,   0x11,   0x22,   0x46,   0x55,   0x66,
                      0x00,   0x00,
      /* ALS    */    0xAA, 0x01,          /* checksum & version */
                      0x00, 0x00,
      /* locGPRS */   0xAA, 0x01,          /* checksum & version */
                      0xFF, 0xFF, 0xFF, 0xFF,             /* P-TMSI */
                      0xFF, 0xFF, 0xFF,                   /* P-TMSI Signature */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, /* RAI */
                      0xFF,                               /* Update Status */
      /* KcGPRS */    0xAA, 0x01,          /* checksum & version */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, /* Kc */
                      0x07,                                           /* CKSN */
      /* IMSI-GPRS */ 0xAA, 0x01,          /* checksum & version */
                      0xFF,                                           /* IMSI length */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, /* IMSI */
      /* SMS */       0xAA, 0x01,          /* checksum & version */
                      0x03,                /* record 1: MT, unread */
                      0x04, 0x91, 0x21, 0x43, 0xF5, 0x04, 0x06, /* DELIVER_7CL1 of SMS TCs */
                      0x81, 0x89, 0x67, 0x45, 0x40, 0xF1, 0x89, 0x10,
                      0x70, 0x21, 0x43, 0x65, 0x40, 0x09, 0x41, 0xE1,
                      0x90, 0x58, 0x34, 0x1E, 0x91, 0x49, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0x05,                /* record 2: MO, sent */
                      0x04, 0x91, 0x21, 0x43, 0xF5, 0x01, 0xFF, /* MO_INIT of SMS TCs */
                      0x06, 0x91, 0x56, 0x34, 0x12, 0x40, 0xF2, 0x09,
                      0x41, 0xE1, 0x90, 0x58, 0x34, 0x1E, 0x91, 0x49,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0x07,                /* record 3: MO, unsent */
                      0x04, 0x91, 0x21, 0x43, 0xF5, 0x19, 0x08, /* MO_ABS of SMS TCs */
                      0x05, 0xA1, 0x89, 0x67, 0xF5, 0x40, 0xF0, 0x89,
                      0x10, 0x70, 0x21, 0x43, 0x65, 0x40, 0x09, 0xD2,
                      0x29, 0xB5, 0x6A, 0xBD, 0x62, 0xB3, 0x5A, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

/*
 * AMR Version
 */
static UBYTE pcm_content_amr [] =
{
     /* MSCAP    */   0xAA, 0x01,          /* checksum & version */
                      /*actual values supported by the MS*/
                      /*0xB7, 0xC7, 0x00,*/
                      0x37, 0x47, 0x00,
                      0x00, 0x00, 0x00,
     /* IMEI     */   0xAA, 0x01,          /* checksum & version */
                      0x31, 0x75, 0x09,
                      0x42, 0x86, 0x11,
                      0x22, 0x87,
     /* RFCAP    */   0xAA, 0x01,          /* checksum & version */
                      0x0B, 0x1F, 0x41, 0x14,
                      0x00, 0x00, 0x00, 0x00,
                      0x50, 0x00, 0x00, 0xa5,
                      0x05, 0x00, 0x80, 0x00,
     /* MSSUP    */   0xAA, 0x01,          /* checksum & version */
                      0xB7, 0x46,
                      0x47, 0x1F, 0x00,


     /* EFcgmi   */   0xAA, 0x01,          /* checksum & version */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '>',    0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,

     /*Iden. Information 1 */   0xAA, 0x01, /* checksum & version */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '1',    '>',    0xff,
      0xff,   0xff,   0xff,   0xff,

      /*Iden. Information 2 */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '2',    '>',    0xff,
      0xff,   0xff,   0xff,   0xff,

     /* MBN      */    0xAA, 0x01,          /* checksum & version */
      /* EFmbn (record 1) */
      0x4c,   0x49,   0x4e,   0x31,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x03,   0xff,
      0x12,   0xf1,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 2) */
      0x4c,   0x49,   0x4e,   0x32,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x04,   0xff,
      0x11,   0x11,   0x11,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 3) */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x00,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 4) */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x00,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,

      /* VMN    */    0xAA,   0x01,          /* checksum & version */
      0x30,   0x33,   0x30,   0x33,   0x39,   0x30,   0x39,   0x34,   //EFvmn
      0x33,   0x33,   0x36,   0x37,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0x81,

      //EFclng
      /* CLNG    */    0xAA,   0x01,          /* checksum & version */
                       'a',  'u',

     /* SMSPRFL  */   0xAA, 0x01,          /* checksum & version */
     /* EFsmsprfl record 1 */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,

     /* EFsmsprfl record 2 */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,

     /* PLMN     */   0xAA, 0x01,          /* checksum & version */
                      0xff, 0xff,
                      0xff, 0xff,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x01, 0x06,
                      0x00, 0x02,
                      0x44, 0x2D,
                      0x5A, 0x57,
                      0x45, 0x49,
                      0x20, 0x50,
                      0x52, 0x49,
                      0x56, 0x41,
                      0x54, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x44, 0x2D,
                      0x5A, 0x57,
                      0x45, 0x49,
                      0x00, 0x00,
                      0x00, 0x00,
     /* BCCHINFO  */  0xAA, 0x01,          /* checksum & version */
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      /* MSSET     */ 0xAA, 0x01,          /* checksum & version */
                      0x20, 0x20, 0x05,    /* buzzer             */
                      0x24,                /* audio              */
                      0x00,                /* miscellaneous      */
                      0x89,                /* display            */
                      0x00,                /* language           */
                      0xFF, 0xFF, 0xFF,    /* recentLdxRef       */
      /* simlck */    0xAA, 0x01,          /* checksum & version */
                      0x00,   0x00,   0x00,   0x0f,
                      0x31,   0x32,   0x33,   0x34,   0x35,   0x36,   0x37,   0x38,
                      0x21,   0x43,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0x0f,
                      0x22,   0x00,   0x22,   0x01,   0x23,   0x15,   0x22,   0x35,
                      0x24,   0x25,   0x11,   0x22,   0x46,   0x55,   0x66,
                      0x00,   0x00,
      /* ALS    */    0xAA, 0x01,          /* checksum & version */
                      0x00, 0x00,
      /* locGPRS */   0xAA, 0x01,          /* checksum & version */
                      0xFF, 0xFF, 0xFF, 0xFF,             /* P-TMSI */
                      0xFF, 0xFF, 0xFF,                   /* P-TMSI Signature */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, /* RAI */
                      0xFF,                               /* Update Status */
      /* KcGPRS */    0xAA, 0x01,          /* checksum & version */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, /* Kc */
                      0x07,                                           /* CKSN */
      /* IMSI-GPRS */ 0xAA, 0x01,          /* checksum & version */
                      0xFF,                                           /* IMSI length */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF  /* IMSI */
};

/*
 * Dualband Extended Version (GSM 900 + E-GSM + DCS 1800)
 */
static UBYTE pcm_content_dualband_ext [] =
{
     /* MSCAP    */   0xAA, 0x01,          /* checksum & version */
                      /*actual values supported by the MS*/
                      /*0xB7, 0xC7, 0x00,*/
                      0x05, 0xC7, 0x80,
                      0x00, 0x00, 0x00,
     /* IMEI     */   0xAA, 0x01,          /* checksum & version */
                      0x31, 0x75, 0x09,
                      0x42, 0x86, 0x11,
                      0x22, 0x87,
     /* RFCAP    */   0xAA, 0x01,          /* checksum & version */
                      0x0B, 0x1F, 0x41, 0x14,
                      0x00, 0x00, 0x00, 0x00,
                      0x50, 0x00, 0x00, 0xa5,
                      0x05, 0x00, 0x80, 0x00,
     /* MSSUP    */   0xAA, 0x01,          /* checksum & version */
                      0xB7, 0x46,
                      0x47, 0x1E, 0x00,


      /* EFcgmi   */   0xAA, 0x01,          /* checksum & version */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '>',    0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,

     /*Iden. Information 1 */   0xAA, 0x01, /* checksum & version */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '1',    '>',    0xff,
      0xff,   0xff,   0xff,   0xff,

      /*Iden. Information 2 */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '2',    '>',    0xff,
      0xff,   0xff,   0xff,   0xff,

      /* MBN    */    0xAA, 0x01,          /* checksum & version */
      /* EFmbn (record 1) */
      0x4c,   0x49,   0x4e,   0x31,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x03,   0xff,
      0x12,   0xf1,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 2) */
      0x4c,   0x49,   0x4e,   0x32,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x04,   0xff,
      0x11,   0x11,   0x11,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 3) */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x00,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 4) */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x00,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,

      /* VMN    */    0xAA,   0x01,          /* checksum & version */
      0x30,   0x33,   0x30,   0x33,   0x39,   0x30,   0x39,   0x34,   //EFvmn
      0x33,   0x33,   0x36,   0x37,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0x81,

      //EFclng
      /* CLNG    */    0xAA,   0x01,          /* checksum & version */
                       'a',  'u',

     /* SMSPRFL  */   0xAA, 0x01,          /* checksum & version */
     /* EFsmsprfl record 1 */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,

     /* EFsmsprfl record 2 */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,

     /* PLMN     */   0xAA, 0x01,          /* checksum & version */
                      0xff, 0xff,
                      0xff, 0xff,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x01, 0x06,
                      0x00, 0x02,
                      0x44, 0x2D,
                      0x5A, 0x57,
                      0x45, 0x49,
                      0x20, 0x50,
                      0x52, 0x49,
                      0x56, 0x41,
                      0x54, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x44, 0x2D,
                      0x5A, 0x57,
                      0x45, 0x49,
                      0x00, 0x00,
                      0x00, 0x00,
#define NEW_STORED_BCCHINFO
#if defined(NEW_STORED_BCCHINFO)
     /* BCCHINFO  */  0xAA, 0x01,          /* checksum & version */
                      /*EGSM*/
                      0x8f, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, /* 527 */
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x42, 0x43, 0x43, 0x48, /* MAGIC_WORD_BCCHINFO (new format) */
                      0x00, 0x00, /* superfluous */
#else   /* NEW_STORED_BCCHINFO */
     /* BCCHINFO  */  0xAA, 0x01,          /* checksum & version */
                      /*EGSM*/
                      0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x40, 0x00, 0x00,
#endif  /* NEW_STORED_BCCHINFO */
      /* MSSET     */ 0xAA, 0x01,          /* checksum & version */
                      0x20, 0x20, 0x05,    /* buzzer             */
                      0x24,                /* audio              */
                      0x00,                /* miscellaneous      */
                      0x89,                /* display            */
                      0x00,                /* language           */
                      0xFF, 0xFF, 0xFF,    /* recentLdxRef       */
      /* simlck */    0xAA, 0x01,          /* checksum & version */
                      0x00,   0x00,   0x00,   0x0f,
                      0x31,   0x32,   0x33,   0x34,   0x35,   0x36,   0x37,   0x38,
                      0x21,   0x43,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0x0f,
                      0x22,   0x00,   0x22,   0x01,   0x23,   0x15,   0x22,   0x35,
                      0x24,   0x25,   0x11,   0x22,   0x46,   0x55,   0x66,
                      0x00,   0x00,
      /* ALS    */    0xAA, 0x01,          /* checksum & version */
                      0x00, 0x00,
      /* locGPRS */   0xAA, 0x01,          /* checksum & version */
                      0xFF, 0xFF, 0xFF, 0xFF,             /* P-TMSI */
                      0xFF, 0xFF, 0xFF,                   /* P-TMSI Signature */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, /* RAI */
                      0xFF,                               /* Update Status */
      /* KcGPRS */    0xAA, 0x01,          /* checksum & version */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, /* Kc */
                      0x07,                                           /* CKSN */
      /* IMSI-GPRS */ 0xAA, 0x01,          /* checksum & version */
                      0xFF,                                           /* IMSI length */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF  /* IMSI */
};

 /*
 * Single band GSm 850 US Version
 */
static UBYTE pcm_content_gsm_850 [] =
{
     /* MSCAP    */   0xAA, 0x01,          /* checksum & version */
                      /*actual values supported by the MS*/
                      /*0xB7, 0xC7, 0x00,*/
                      0x07, 0x45, 0x00,
                      0x00, 0x00, 0x00,
     /* IMEI     */   0xAA, 0x01,          /* checksum & version */
                      0x31, 0x75, 0x09,
                      0x42, 0x86, 0x11,
                      0x22, 0x87,
     /* RFCAP    */   0xAA, 0x01,          /* checksum & version */
                      0x10, 0x1F, 0x41, 0x14,
                      0x00, 0x00, 0x00, 0x00,
                      0x50, 0x00, 0x00, 0xa5,
                      0x05, 0x00, 0x80, 0x00,
     /* MSSUP    */   0xAA, 0x01,          /* checksum & version */
                      0xB7, 0x46,
                      0x47, 0x1F, 0x00,


    /* EFcgmi   */   0xAA, 0x01,          /* checksum & version */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '>',    0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,

     /*Iden. Information 1 */   0xAA, 0x01, /* checksum & version */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '1',    '>',    0xff,
      0xff,   0xff,   0xff,   0xff,

      /*Iden. Information 2 */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '2',    '>',    0xff,
      0xff,   0xff,   0xff,   0xff,

      /* MBN    */    0xAA, 0x01,          /* checksum & version */
      /* EFmbn (record 1) */
      0x4c,   0x49,   0x4e,   0x31,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x03,   0xff,
      0x12,   0xf1,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 2) */
      0x4c,   0x49,   0x4e,   0x32,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x04,   0xff,
      0x11,   0x11,   0x11,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 3) */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x00,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 4) */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x00,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,

      /* VMN    */    0xAA,   0x01,          /* checksum & version */
      0x30,   0x33,   0x30,   0x33,   0x39,   0x30,   0x39,   0x34,   //EFvmn
      0x33,   0x33,   0x36,   0x37,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0x81,

      /* EFclng */
      /* CLNG    */    0xAA,   0x01,          /* checksum & version */
                       'a',  'u',

     /* SMSPRFL  */   0xAA, 0x01,          /* checksum & version */
     /* EFsmsprfl record 1 */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,

     /* EFsmsprfl record 2 */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,

     /* PLMN     */   0xAA, 0x01,          /* checksum & version */
                      0x02, 0x2B,
                      0x00, 0x37,
                      0x54, 0x52,
                      0x49, 0x50,
                      0x4c, 0x45,
                      0x2d, 0x20,
                      0x54, 0x45,
                      0x4C, 0x45,
                      0x4B, 0x4F,
                      0x4D, 0x20,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x54, 0x52,
                      0x49, 0x50,
                      0x4c, 0x45,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x01, 0x06,
                      0x00, 0x02,
                      0x44, 0x2D,
                      0x5A, 0x57,
                      0x45, 0x49,
                      0x20, 0x50,
                      0x52, 0x49,
                      0x56, 0x41,
                      0x54, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x44, 0x2D,
                      0x5A, 0x57,
                      0x45, 0x49,
                      0x00, 0x00,
                      0x00, 0x00,
     /* BCCHINFO  */  0xAA, 0x01,          /* checksum & version */
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ,
      /* MSSET     */ 0xAA, 0x01,          /* checksum & version */
                      0x20, 0x20, 0x05,    /* buzzer             */
                      0x24,                /* audio              */
                      0x00,                /* miscellaneous      */
                      0x89,                /* display            */
                      0x00,                /* language           */
                      0xFF, 0xFF, 0xFF,    /* recentLdxRef       */
      /* simlck */    0xAA, 0x01,          /* checksum & version */
                      0x00,   0x00,   0x00,   0x0f,
                      0x31,   0x32,   0x33,   0x34,   0x35,   0x36,   0x37,   0x38,
                      0x21,   0x43,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0x0f,
                      0x22,   0x00,   0x22,   0x01,   0x23,   0x15,   0x22,   0x35,
                      0x24,   0x25,   0x11,   0x22,   0x46,   0x55,   0x66,
                      0x00,   0x00,
      /* ALS    */    0xAA, 0x01,          /* checksum & version */
                      0x00, 0x00,
      /* locGPRS */   0xAA, 0x01,          /* checksum & version */
                      0xFF, 0xFF, 0xFF, 0xFF,             /* P-TMSI */
                      0xFF, 0xFF, 0xFF,                   /* P-TMSI Signature */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, /* RAI */
                      0xFF,                               /* Update Status */
      /* KcGPRS */    0xAA, 0x01,          /* checksum & version */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, /* Kc */
                      0x07,                                           /* CKSN */
      /* IMSI-GPRS */ 0xAA, 0x01,          /* checksum & version */
                      0xFF,                                           /* IMSI length */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF  /* IMSI */
};
 /*
 * Dualband US Version
 */
static UBYTE pcm_content_dual_us [] =
{
     /* MSCAP    */   0xAA, 0x01,          /* checksum & version */
                      /*actual values supported by the MS*/
                      /*0xB7, 0xC7, 0x00,*/
                      0x07, 0x45, 0x00,
                      0x00, 0x00, 0x00,
     /* IMEI     */   0xAA, 0x01,          /* checksum & version */
                      0x31, 0x75, 0x09,
                      0x42, 0x86, 0x11,
                      0x22, 0x87,
     /* RFCAP    */   0xAA, 0x01,          /* checksum & version */
                      0x14, 0x1F, 0x41, 0x14,
                      0x00, 0x00, 0x00, 0x00,
                      0x50, 0x00, 0x00, 0xa5,
                      0x05, 0x00, 0x80, 0x00,
     /* MSSUP    */   0xAA, 0x01,          /* checksum & version */
                      0xB7, 0x46,
                      0x47, 0x1F, 0x00,


    /* EFcgmi   */   0xAA, 0x01,          /* checksum & version */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '>',    0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,

     /*Iden. Information 1 */   0xAA, 0x01, /* checksum & version */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '1',    '>',    0xff,
      0xff,   0xff,   0xff,   0xff,

      /*Iden. Information 2 */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '2',    '>',    0xff,
      0xff,   0xff,   0xff,   0xff,

      /* MBN    */    0xAA, 0x01,          /* checksum & version */
      /* EFmbn (record 1) */
      0x4c,   0x49,   0x4e,   0x31,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x03,   0xff,
      0x12,   0xf1,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 2) */
      0x4c,   0x49,   0x4e,   0x32,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x04,   0xff,
      0x11,   0x11,   0x11,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 3) */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x00,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 4) */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x00,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,

      /* VMN    */    0xAA,   0x01,          /* checksum & version */
      0x30,   0x33,   0x30,   0x33,   0x39,   0x30,   0x39,   0x34,   //EFvmn
      0x33,   0x33,   0x36,   0x37,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0x81,

      /* EFclng */
      /* CLNG    */    0xAA,   0x01,          /* checksum & version */
                       'a',  'u',

     /* SMSPRFL  */   0xAA, 0x01,          /* checksum & version */
     /* EFsmsprfl record 1 */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,

     /* EFsmsprfl record 2 */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,

     /* PLMN     */   0xAA, 0x01,          /* checksum & version */
                      0x02, 0x2B,
                      0x00, 0x37,
                      0x54, 0x52,
                      0x49, 0x50,
                      0x4c, 0x45,
                      0x2d, 0x20,
                      0x54, 0x45,
                      0x4C, 0x45,
                      0x4B, 0x4F,
                      0x4D, 0x20,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x54, 0x52,
                      0x49, 0x50,
                      0x4c, 0x45,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x01, 0x06,
                      0x00, 0x02,
                      0x44, 0x2D,
                      0x5A, 0x57,
                      0x45, 0x49,
                      0x20, 0x50,
                      0x52, 0x49,
                      0x56, 0x41,
                      0x54, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x44, 0x2D,
                      0x5A, 0x57,
                      0x45, 0x49,
                      0x00, 0x00,
                      0x00, 0x00,
     /* BCCHINFO  */  0xAA, 0x01,          /* checksum & version */
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ,
      /* MSSET     */ 0xAA, 0x01,          /* checksum & version */
                      0x20, 0x20, 0x05,    /* buzzer             */
                      0x24,                /* audio              */
                      0x00,                /* miscellaneous      */
                      0x89,                /* display            */
                      0x00,                /* language           */
                      0xFF, 0xFF, 0xFF,    /* recentLdxRef       */
      /* simlck */    0xAA, 0x01,          /* checksum & version */
                      0x00,   0x00,   0x00,   0x0f,
                      0x31,   0x32,   0x33,   0x34,   0x35,   0x36,   0x37,   0x38,
                      0x21,   0x43,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0x0f,
                      0x22,   0x00,   0x22,   0x01,   0x23,   0x15,   0x22,   0x35,
                      0x24,   0x25,   0x11,   0x22,   0x46,   0x55,   0x66,
                      0x00,   0x00,
      /* ALS    */    0xAA, 0x01,          /* checksum & version */
                      0x00, 0x00,
      /* locGPRS */   0xAA, 0x01,          /* checksum & version */
                      0xFF, 0xFF, 0xFF, 0xFF,             /* P-TMSI */
                      0xFF, 0xFF, 0xFF,                   /* P-TMSI Signature */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, /* RAI */
                      0xFF,                               /* Update Status */
      /* KcGPRS */    0xAA, 0x01,          /* checksum & version */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, /* Kc */
                      0x07,                                           /* CKSN */
      /* IMSI-GPRS */ 0xAA, 0x01,          /* checksum & version */
                      0xFF,                                           /* IMSI length */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF  /* IMSI */
};
/*
 * Quadband Version
 */
static UBYTE pcm_content_quadband [] =
{
     /* MSCAP    */   0xAA, 0x01,          /* checksum & version */
                      /*actual values supported by the MS*/
                      /*0xB7, 0xC7, 0x00,*/
                      0x07, 0x45, 0x00,
                      0x00, 0x00, 0x00,
     /* IMEI     */   0xAA, 0x01,          /* checksum & version */
                      0x31, 0x75, 0x09,
                      0x42, 0x86, 0x11,
                      0x22, 0x87,
     /* RFCAP    */   0xAA, 0x01,          /* checksum & version */
                      0x00, 0x1F, 0x41, 0x14,
                      0x00, 0x00, 0x00, 0x00,
                      0x50, 0x00, 0x00, 0xa5,
                      0x05, 0x00, 0x80, 0x00,
     /* MSSUP    */   0xAA, 0x01,          /* checksum & version */
                      0xB7, 0x46,
                      0x47, 0x1F, 0x00,


    /* EFcgmi   */   0xAA, 0x01,          /* checksum & version */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '>',    0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,

     /*Iden. Information 1 */   0xAA, 0x01, /* checksum & version */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '1',    '>',    0xff,
      0xff,   0xff,   0xff,   0xff,

      /*Iden. Information 2 */
      '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',
      't',    'u',    'r',    'e',    'r',    '2',    '>',    0xff,
      0xff,   0xff,   0xff,   0xff,

      /* MBN    */    0xAA, 0x01,          /* checksum & version */
      /* EFmbn (record 1) */
      0x4c,   0x49,   0x4e,   0x31,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x03,   0xff,
      0x12,   0xf1,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 2) */
      0x4c,   0x49,   0x4e,   0x32,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x04,   0xff,
      0x11,   0x11,   0x11,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 3) */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x00,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      /* EFmbn (record 4) */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,
      0x00,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,

      /* VMN    */    0xAA,   0x01,          /* checksum & version */
      0x30,   0x33,   0x30,   0x33,   0x39,   0x30,   0x39,   0x34,   //EFvmn
      0x33,   0x33,   0x36,   0x37,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0x81,

      /* EFclng */
      /* CLNG    */    0xAA,   0x01,          /* checksum & version */
                       'a',  'u',

     /* SMSPRFL  */   0xAA, 0x01,          /* checksum & version */
     /* EFsmsprfl record 1 */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,

     /* EFsmsprfl record 2 */
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
      0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,

     /* PLMN     */   0xAA, 0x01,          /* checksum & version */
                      0x02, 0x2B,
                      0x00, 0x37,
                      0x54, 0x52,
                      0x49, 0x50,
                      0x4c, 0x45,
                      0x2d, 0x20,
                      0x54, 0x45,
                      0x4C, 0x45,
                      0x4B, 0x4F,
                      0x4D, 0x20,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x54, 0x52,
                      0x49, 0x50,
                      0x4c, 0x45,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x01, 0x06,
                      0x00, 0x02,
                      0x44, 0x2D,
                      0x5A, 0x57,
                      0x45, 0x49,
                      0x20, 0x50,
                      0x52, 0x49,
                      0x56, 0x41,
                      0x54, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x00, 0x00,
                      0x44, 0x2D,
                      0x5A, 0x57,
                      0x45, 0x49,
                      0x00, 0x00,
                      0x00, 0x00,
     /* BCCHINFO  */  0xAA, 0x01,          /* checksum & version */
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                      0x00, 0x00, 0x00, 0x00, 0x00, 0x00 ,
      /* MSSET     */ 0xAA, 0x01,          /* checksum & version */
                      0x20, 0x20, 0x05,    /* buzzer             */
                      0x24,                /* audio              */
                      0x00,                /* miscellaneous      */
                      0x89,                /* display            */
                      0x00,                /* language           */
                      0xFF, 0xFF, 0xFF,    /* recentLdxRef       */
      /* simlck */    0xAA, 0x01,          /* checksum & version */
                      0x00,   0x00,   0x00,   0x0f,
                      0x31,   0x32,   0x33,   0x34,   0x35,   0x36,   0x37,   0x38,
                      0x21,   0x43,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,   0xdf,
                      0x0f,
                      0x22,   0x00,   0x22,   0x01,   0x23,   0x15,   0x22,   0x35,
                      0x24,   0x25,   0x11,   0x22,   0x46,   0x55,   0x66,
                      0x00,   0x00,
      /* ALS    */    0xAA, 0x01,          /* checksum & version */
                      0x00, 0x00,
      /* locGPRS */   0xAA, 0x01,          /* checksum & version */
                      0xFF, 0xFF, 0xFF, 0xFF,             /* P-TMSI */
                      0xFF, 0xFF, 0xFF,                   /* P-TMSI Signature */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, /* RAI */
                      0xFF,                               /* Update Status */
      /* KcGPRS */    0xAA, 0x01,          /* checksum & version */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, /* Kc */
                      0x07,                                           /* CKSN */
      /* IMSI-GPRS */ 0xAA, 0x01,          /* checksum & version */
                      0xFF,                                           /* IMSI length */
                      0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF  /* IMSI */
};


typedef struct
{
  char    * identifier;
  USHORT    start;
  USHORT    length;
  USHORT    records;
} T_PCM_DESCRIPTION;

#define LEN_MSCAP     (SIZE_EF_MSCAP    * NR_EF_MSCAP  + 2)
#define LEN_IMEI      (SIZE_EF_IMEI     * NR_EF_IMEI   + 2)
#define LEN_RFCAP     (SIZE_EF_RFCAP    * NR_EF_RFCAP  + 2)
#define LEN_MSSUP     (SIZE_EF_MSSUP    * NR_EF_MSSUP  + 2)
#define LEN_CGMI      (SIZE_EF_CGMI     * NR_EF_CGMI   + 2)
#define LEN_INF0      (SIZE_EF_INF0     * NR_EF_INF0   + 2)
#define LEN_MBN       (SIZE_EF_MBN      * NR_EF_MBN    + 2)
#define LEN_VMN       (SIZE_EF_VMN      * NR_EF_VMN    + 2)
#define LEN_CLNG      (SIZE_EF_CLNG     * NR_EF_CLNG   + 2)

#define LEN_SMSPRFL   (SIZE_EF_SMSPRFL  * NR_EF_SMSPRFL+ 2)
#define LEN_PLMN      (SIZE_EF_PLMN     * NR_EF_PLMN   + 2)
#define LEN_BCCHINFO  (SIZE_EF_BCCHINFO * NR_EF_BCCHINFO+ 2)
#define LEN_MSSET     (SIZE_EF_MSSET    * NR_EF_MSSET  + 2)
#define LEN_SIMLCK    (SIZE_EF_SIMLCK   * NR_EF_SIMLCK + 2) // VO
#define LEN_ALS       (SIZE_EF_ALS      * NR_EF_ALS  + 2)
#define LEN_LOCGPRS   (SIZE_EF_LOCGPRS  * NR_EF_LOCGPRS + 2)
#define LEN_KCGPRS    (SIZE_EF_KCGPRS   * NR_EF_KCGPRS + 2)
#define LEN_IMSIGPRS  (SIZE_EF_IMSIGPRS * NR_EF_IMSIGPRS + 2)
/* only present for STD = 3 and 4 */
#define LEN_EF_SMS    (SIZE_EF_SMS      * NR_EF_SMS + 2)

#define START_MSCAP     0
#define START_IMEI      (START_MSCAP    + LEN_MSCAP)
#define START_RFCAP     (START_IMEI     + LEN_IMEI)
#define START_MSSUP     (START_RFCAP    + LEN_RFCAP)
#define START_CGMI      (START_MSSUP    + LEN_MSSUP)
#define START_INF0      (START_CGMI     + LEN_CGMI)
#define START_MBN       (START_INF0     + LEN_INF0)
#define START_VMN       (START_MBN      + LEN_MBN)
#define START_CLNG      (START_VMN      + LEN_VMN)
#define START_SMSPRFL   (START_CLNG     + LEN_CLNG)
#define START_PLMN      (START_SMSPRFL  + LEN_SMSPRFL)
#define START_BCCHINFO  (START_PLMN     + LEN_PLMN)
#define START_MSSET     (START_BCCHINFO + LEN_BCCHINFO)
#define START_SIMLCK    (START_MSSET    + LEN_MSSET)  // VO
#define START_ALS       (START_SIMLCK   + LEN_SIMLCK)
#define START_LOCGPRS   (START_ALS      + LEN_ALS)
#define START_KCGPRS    (START_LOCGPRS  + LEN_LOCGPRS)
#define START_IMSIGPRS  (START_KCGPRS   + LEN_KCGPRS)

#define PCM_SIZE        (START_IMSIGPRS + LEN_IMSIGPRS)
/* only present for STD = 3 and 4 */
#define START_SMS       (START_IMSIGPRS + LEN_IMSIGPRS)
#define PCM_SIZE_SMS    (START_SMS      + LEN_EF_SMS)

#define PCM_SIZE_MAX    (PCM_SIZE_SMS)

/*
 * RAM for the copy of PCM data
 */
static UBYTE pcm_mem [PCM_SIZE_MAX];

/*
 * Default description table
 */
static const T_PCM_DESCRIPTION pcm_table_def[] =
{
{ "MSCAP"   , START_MSCAP,    SIZE_EF_MSCAP   +2, NR_EF_MSCAP    },
{ "IMEI"    , START_IMEI,     SIZE_EF_IMEI    +2, NR_EF_IMEI     },
{ "RFCAP"   , START_RFCAP,    SIZE_EF_RFCAP   +2, NR_EF_RFCAP    },
{ "MSSUP"   , START_MSSUP,    SIZE_EF_MSSUP   +2, NR_EF_MSSUP    },
{ "CGMI"    , START_CGMI,     SIZE_EF_CGMI    +2, NR_EF_CGMI     },
{ "INF0"    , START_INF0,     SIZE_EF_INF0    +2, NR_EF_INF0     },
{ "MBN"     , START_MBN,      SIZE_EF_MBN     +2, NR_EF_MBN      },
{ "VMN"     , START_VMN,      SIZE_EF_VMN     +2, NR_EF_VMN      },
{ "CLNG"    , START_CLNG,     SIZE_EF_CLNG    +2, NR_EF_CLNG     },

{ "SMSPRFL" , START_SMSPRFL,  SIZE_EF_SMSPRFL +2, NR_EF_SMSPRFL  },
{ "PLMN"    , START_PLMN,     SIZE_EF_PLMN    +2, NR_EF_PLMN     },
{ "BCCHINF" , START_BCCHINFO, SIZE_EF_BCCHINFO+2, NR_EF_BCCHINFO },
{ "MSSET"   , START_MSSET,    SIZE_EF_MSSET   +2, NR_EF_MSSET    },
{ "SIMLCK"  , START_SIMLCK,   SIZE_EF_SIMLCK  +2, NR_EF_SIMLCK   }, // VO
{ "ALS"     , START_ALS,      SIZE_EF_ALS     +2, NR_EF_ALS      },
{ "LOCGPRS" , START_LOCGPRS,  SIZE_EF_LOCGPRS +2, NR_EF_LOCGPRS  },
{ "KCGPRS"  , START_KCGPRS,   SIZE_EF_KCGPRS  +2, NR_EF_KCGPRS   },
{ "IMSIGPRS", START_IMSIGPRS, SIZE_EF_IMSIGPRS+2, NR_EF_IMSIGPRS },
{ NULL      , 0,              0,                  0              }
};

/*
 * Description table with SMS memory
 */
static const T_PCM_DESCRIPTION pcm_table_sms[] =
{
{ "MSCAP"   , START_MSCAP,    SIZE_EF_MSCAP   +2, NR_EF_MSCAP    },
{ "IMEI"    , START_IMEI,     SIZE_EF_IMEI    +2, NR_EF_IMEI     },
{ "RFCAP"   , START_RFCAP,    SIZE_EF_RFCAP   +2, NR_EF_RFCAP    },
{ "MSSUP"   , START_MSSUP,    SIZE_EF_MSSUP   +2, NR_EF_MSSUP    },
{ "CGMI"    , START_CGMI,     SIZE_EF_CGMI    +2, NR_EF_CGMI     },
{ "INF0"    , START_INF0,     SIZE_EF_INF0    +2, NR_EF_INF0     },
{ "MBN"     , START_MBN,      SIZE_EF_MBN     +2, NR_EF_MBN      },
{ "VMN"     , START_VMN,      SIZE_EF_VMN     +2, NR_EF_VMN      },
{ "CLNG"    , START_CLNG,     SIZE_EF_CLNG    +2, NR_EF_CLNG     },

{ "SMSPRFL" , START_SMSPRFL,  SIZE_EF_SMSPRFL +2, NR_EF_SMSPRFL  },
{ "PLMN"    , START_PLMN,     SIZE_EF_PLMN    +2, NR_EF_PLMN     },
{ "BCCHINF" , START_BCCHINFO, SIZE_EF_BCCHINFO+2, NR_EF_BCCHINFO },
{ "MSSET"   , START_MSSET,    SIZE_EF_MSSET   +2, NR_EF_MSSET    },
{ "SIMLCK"  , START_SIMLCK,   SIZE_EF_SIMLCK  +2, NR_EF_SIMLCK   }, // VO
{ "ALS"     , START_ALS,      SIZE_EF_ALS     +2, NR_EF_ALS      },
{ "LOCGPRS" , START_LOCGPRS,  SIZE_EF_LOCGPRS +2, NR_EF_LOCGPRS  },
{ "KCGPRS"  , START_KCGPRS,   SIZE_EF_KCGPRS  +2, NR_EF_KCGPRS   },
{ "IMSIGPRS", START_IMSIGPRS, SIZE_EF_IMSIGPRS+2, NR_EF_IMSIGPRS },
{ EF_SMS_ID , START_SMS,      SIZE_EF_SMS     +2, NR_EF_SMS      },
{ NULL      , 0,              0,                  0              }
};

static const T_PCM_DESCRIPTION *pcm_table;

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-PS (6103)       MODULE  : DRV_PCM                    |
| STATE   : code                ROUTINE : pcm_Init                   |
+--------------------------------------------------------------------+

  PURPOSE : Open the permanent configuration memory

*/

GLOBAL UBYTE pcm_Init (void)
{
  if (!pcm_read OR std NEQ act_std)
  {
    switch (std)
    {
      case 1:  /* GSM 900 */
        TRACE_EVENT ("std=1: GSM 900");
        memcpy (pcm_mem, pcm_content_gsm_900, sizeof (pcm_content_gsm_900));
        pcm_table = pcm_table_def;
        break;
      case 3:  /* PCS 1900 */
        TRACE_EVENT ("std=3: PCS 1900");
        memcpy (pcm_mem, pcm_content_pcs_1900, sizeof (pcm_content_pcs_1900));
        pcm_table = pcm_table_sms;
        break;
      case 4:  /* DCS 1800 */
        TRACE_EVENT ("std=4: DCS 1800");
        memcpy (pcm_mem, pcm_content_dcs_1800, sizeof (pcm_content_dcs_1800));
        pcm_table = pcm_table_sms;
        break;
      case 5:  /* Dualband */
        TRACE_EVENT ("std=5: DUALBAND");
        memcpy (pcm_mem, pcm_content_dualband, sizeof (pcm_content_dualband));
        pcm_table = pcm_table_sms;
        break;
      case 6:  /* Dualband Extended*/
        TRACE_EVENT ("std=6: DUALBAND EXTENDED");
        memcpy (pcm_mem, pcm_content_dualband_ext, sizeof (pcm_content_dualband_ext));
        pcm_table = pcm_table_def;
        break;
      case 7:  /* GSM 850 */
        TRACE_EVENT ("std=7: GSM 850 (same as GSM 900)");
        memcpy (pcm_mem, pcm_content_gsm_850, sizeof (pcm_content_gsm_850));
        pcm_table = pcm_table_def;
        break;
      case 8: /* DUALBAND US (GSM 850 + PCS 1900) */
        TRACE_EVENT ("std=8: DUALBAND US (GSM 850 + PCS 1900)");
        memcpy (pcm_mem, pcm_content_dual_us, sizeof (pcm_content_dual_us));
        pcm_table = pcm_table_def;
        break;
      case 30:  /* AMR*/
        TRACE_EVENT ("std=30: AMR");
        memcpy (pcm_mem, pcm_content_amr, sizeof (pcm_content_amr));
        pcm_table = pcm_table_def;
        break;
      case 33: /* QUADBAND (GSM 850, GSM 900, E-GSM, DCS 1800, PCS 1900) */
        TRACE_EVENT ("std=33: QUADBAND");
        memcpy (pcm_mem, pcm_content_quadband, sizeof (pcm_content_quadband));
        pcm_table = pcm_table_def;
        break;
      default:
        TRACE_EVENT_P1 ("std=%d: unknown configuration", std);
        TRACE_ERROR ("NO valid PCM configuration!");
        break;
    }
    pcm_read = TRUE;
    act_std = std;
    return DRV_OK;
  }
  return DRV_INITIALIZED;
}

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-PS (6103)       MODULE  : DRV_PCM                    |
| STATE   : code                ROUTINE : pcm_Exit                   |
+--------------------------------------------------------------------+

  PURPOSE : Closes the permanent configuration memory

*/

GLOBAL void pcm_Exit (void)
{
  pcm_Flush ();
  pcm_read = FALSE;
}

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-PS (6103)       MODULE  : DRV_PCM                    |
| STATE   : code                ROUTINE : pcm_ReadFile               |
+--------------------------------------------------------------------+

  PURPOSE : Read a transparent elementary field

*/

GLOBAL UBYTE pcm_ReadFile (UBYTE * in_FileName,
                           USHORT  in_BufferSize,
                           UBYTE * out_BufferPtr,
                           UBYTE * out_VersionPtr)
{
  UBYTE i;

  pcm_Init ();

  i = 0;
  while (pcm_table[i].identifier NEQ NULL)
  {
    /*
     * Check all available entries
     */
    if (!strcmp ((char *)in_FileName, pcm_table[i].identifier))
    {
      /*
       * entry is available, check size
       * buffer size + version + checksum must be equal entry length
       */
      if (in_BufferSize+2 NEQ pcm_table[i].length)
        return PCM_INVALID_SIZE;
      /*
       * Checksum is not checked
       * copy buffer and version
       */
      memcpy (out_BufferPtr, &pcm_mem [pcm_table[i].start+2],
              in_BufferSize);
      *out_VersionPtr = pcm_mem[pcm_table[i].start+1];
      return DRV_OK;
    }
    i++;
  }
  return PCM_INVALID_FILE;
}

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-PS (6103)       MODULE  : DRV_PCM                    |
| STATE   : code                ROUTINE : pcm_GetFileInfo            |
+--------------------------------------------------------------------+

  PURPOSE : Get information about a dedicated file.

*/

GLOBAL UBYTE pcm_GetFileInfo (UBYTE             * in_FileName,
                              pcm_FileInfo_Type * out_FileInfoPtr)
{
  UBYTE i;

  pcm_Init ();

  i = 0;
  while (pcm_table[i].identifier NEQ NULL)
  {
    /*
     * Check all available entries
     */
    if (!strcmp ((char *)in_FileName, pcm_table[i].identifier))
    {
      /*
       * entry is available,
       * fill file info
       */
      out_FileInfoPtr->FileLocation = &pcm_mem [pcm_table[i].start+2];
      out_FileInfoPtr->FileSize     = pcm_table[i].length-2;
      out_FileInfoPtr->Version      = pcm_mem [pcm_table[i].start+1];
      return DRV_OK;
    }
    i++;
  }
  return PCM_INVALID_FILE;
}

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-PS (6103)       MODULE  : DRV_PCM                    |
| STATE   : code                ROUTINE : pcm_ReadRecord             |
+--------------------------------------------------------------------+

  PURPOSE : Read a linear fixed elementary field

*/

GLOBAL UBYTE pcm_ReadRecord (UBYTE  * in_FileName,
                             USHORT   in_Record,
                             USHORT   in_BufferSize,
                             UBYTE  * out_BufferPtr,
                             UBYTE  * out_VersionPtr,
                             USHORT * out_MaxRecordsPtr)
{
  UBYTE i;

  pcm_Init ();

  i = 0;
  while (pcm_table[i].identifier NEQ NULL)
  {
    /*
     * check whether entry is available
     */
    if (!strcmp ((char *)in_FileName, pcm_table[i].identifier))
    {
      /*
       * entry is available, check size
       */
      if (in_BufferSize+2 NEQ pcm_table[i].length)
        return PCM_INVALID_SIZE;
      /*
       * check record number
       */
      if (in_Record EQ 0 OR
          in_Record > pcm_table[i].records)
        return PCM_INVALID_RECORD;

      /*
       * copy record content
       * read version number and max records
       */
      memcpy (out_BufferPtr, &pcm_mem [pcm_table[i].start+2+(in_Record-1) * in_BufferSize],
              in_BufferSize);
      * out_MaxRecordsPtr = pcm_table[i].records;
      * out_VersionPtr    = pcm_mem [pcm_table[i].start+1];
      return DRV_OK;
    }
    i++;
  }
  return PCM_INVALID_FILE;
}

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-PS (6103)       MODULE  : DRV_PCM                    |
| STATE   : code                ROUTINE : pcm_WriteFile              |
+--------------------------------------------------------------------+

  PURPOSE : Write a transparent elementary field

*/

GLOBAL UBYTE pcm_WriteFile (UBYTE * in_FileName,
                            USHORT  in_FileSize,
                            UBYTE * in_BufferPtr)
{
  UBYTE i;

  pcm_Init ();

  i = 0;
  while (pcm_table[i].identifier NEQ NULL)
  {
    /*
     * check whether entry is available
     */
    if (!strcmp ((char *)in_FileName, pcm_table[i].identifier))
    {
      /*
       * check file size
       */
      if (in_FileSize+2 NEQ pcm_table[i].length)
        return PCM_INVALID_SIZE;
      /*
       * store new buffer content
       */
      memcpy (&pcm_mem [pcm_table[i].start+2], in_BufferPtr,
              in_FileSize);
      return DRV_OK;
    }
    i++;
  }
  return PCM_INVALID_FILE;
}

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-PS (6103)       MODULE  : DRV_PCM                    |
| STATE   : code                ROUTINE : pcm_WriteRecord            |
+--------------------------------------------------------------------+

  PURPOSE : Write a linear fixed elementary field

*/

GLOBAL UBYTE pcm_WriteRecord (UBYTE * in_FileName,
                              USHORT  in_Record,
                              USHORT  in_BufferSize,
                              UBYTE * in_BufferPtr)
{
  UBYTE i;

  pcm_Init ();

  i = 0;
  while (pcm_table[i].identifier NEQ NULL)
  {
    /*
     * check all available entries
     */
    if (!strcmp ((char *)in_FileName, pcm_table[i].identifier))
    {
      /*
       * entry is available,
       * check entry size
       */
      if (in_BufferSize+2 NEQ pcm_table[i].length)
        return PCM_INVALID_SIZE;
      /*
       * check record number
       */
      if (in_Record EQ 0 OR
          in_Record > pcm_table[i].records)
        return PCM_INVALID_RECORD;

      /*
       * store data in record
       */
      memcpy (&pcm_mem [pcm_table[i].start+2+
              (in_Record-1) * in_BufferSize],
              in_BufferPtr,
              in_BufferSize);
      return DRV_OK;
    }
    i++;
  }
  return PCM_INVALID_FILE;
}

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-PS (6103)       MODULE  : DRV_PCM                    |
| STATE   : code                ROUTINE : pcm_Flush                  |
+--------------------------------------------------------------------+

  PURPOSE : Transfer changes to the PCM of the non volatile RAM.

*/

GLOBAL UBYTE pcm_Flush (void)
{
  if (pcm_read)
  {
    TRACE_EVENT_P1 ("pcm_flush: std=%d", std);
    switch (std)
    {
    case 1: /* GSM 900 */
      memcpy (pcm_content_gsm_900, pcm_mem, sizeof (pcm_content_gsm_900));
      break;
    case 3: /* PCS 1900 */
      memcpy (pcm_content_pcs_1900, pcm_mem, sizeof (pcm_content_pcs_1900));
      break;
    case 4: /* DCS 1800 */
      memcpy (pcm_content_dcs_1800, pcm_mem, sizeof (pcm_content_dcs_1800));
      break;
    case 5: /* Dualband */
      memcpy (pcm_content_dualband, pcm_mem, sizeof (pcm_content_dualband));
      break;
    case 6: /* Dualband Extended */
      memcpy (pcm_content_dualband_ext, pcm_mem, sizeof (pcm_content_dualband_ext));
      break;
    case 7:  /* GSM 850 */
      memcpy (pcm_content_gsm_900, pcm_mem, sizeof (pcm_content_gsm_900));
      break;
    case 8: /* DUALBAND US (GSM 850 + PCS 1900) */
      memcpy (pcm_content_dual_us, pcm_mem, sizeof (pcm_content_dual_us));
      break;
    case 30:  /* AMR*/
      memcpy (pcm_content_amr, pcm_mem, sizeof (pcm_content_amr));
      break;
    case 33: /* QUADBAND (GSM 850, GSM 900, E-GSM, DCS 1800, PCS 1900) */
      memcpy (pcm_content_quadband, pcm_mem, sizeof (pcm_content_quadband));
      break;
    default:
      TRACE_EVENT_P1 ("std=%d: unknown configuration", std);
      TRACE_ERROR ("NO valid PCM configuration!");
      break;
    }
  }
  return DRV_OK;
}

#else /* ifdef win32*/


/*==== INCLUDES ===================================================*/

#include <string.h>
#include "stddefs.h"
#include "gdi.h"
#include "pcm.h"
#include "pcm_amd.h"



/*==== VARIABLES ==================================================*/

/*
 * Flag whether the 'flash content' is read
 */
static UBYTE pcm_read;

UBYTE std;
// set treshold for initial power measurements (= -106 dBm)
USHORT min_rxlev = 20;

typedef struct
{
    char    * identifier;
    USHORT    start;
    USHORT    length;
    USHORT    records;
} T_PCM_DESCRIPTION;

#define LEN_MSCAP     (NR_EF_MSCAP    * SIZE_EF_MSCAP)    + 2
#define LEN_IMEI      (NR_EF_IMEI     * SIZE_EF_IMEI)     + 2
#define LEN_IMSI      (NR_EF_IMSI     * SIZE_EF_IMSI)     + 2
#define LEN_SMS       (NR_EF_SMS      * SIZE_EF_SMS)      + 2
#define LEN_CLASS2    (NR_EF_CLASS2   * SIZE_EF_CLASS2)   + 2
#define LEN_CLASS3    (NR_EF_CLASS3   * SIZE_EF_CLASS3)   + 2
#define LEN_MSSUP     (NR_EF_MSSUP    * SIZE_EF_MSSUP)    + 2
#define LEN_MSSET     (NR_EF_MSSET    * SIZE_EF_MSSET)    + 2
//	Jun 14, 2005 REF: MMI-FIX-30439 x0018858
#define LEN_HZCACHE   (NR_EF_HZCACHE  * SIZE_EF_HZCACHE)  + 2
#define LEN_LDN       (NR_EF_LDN      * SIZE_EF_LDN)      + 2
#define LEN_LRN       (NR_EF_LRN      * SIZE_EF_LRN)      + 2
#define LEN_LMN       (NR_EF_LMN      * SIZE_EF_LMN)      + 2
#define LEN_UPN       (NR_EF_UPN      * SIZE_EF_UPN)      + 2
#define LEN_MBN       (NR_EF_MBN      * SIZE_EF_MBN)      + 2
#define LEN_VMN       (NR_EF_VMN      * SIZE_EF_VMN)      + 2
#define LEN_CLNG      (NR_EF_CLNG     * SIZE_EF_CLNG)     + 2
#define LEN_CTIM      (NR_EF_CTIM     * SIZE_EF_CTIM)     + 2
#define LEN_CCNT      (NR_EF_CCNT     * SIZE_EF_CCNT)     + 2
#define LEN_ECC       (NR_EF_ECC      * SIZE_EF_ECC)      + 2
#define LEN_ORG       (NR_EF_ORG      * SIZE_EF_ORG)      + 2
#define LEN_CCP       (NR_EF_CCP      * SIZE_EF_CCP)      + 2
#define LEN_EXT1      (NR_EF_EXT1     * SIZE_EF_EXT1)     + 2
#define LEN_SIMLCK    (NR_EF_SIMLCK   * SIZE_EF_SIMLCK)   + 2
#define LEN_MAIN      (NR_EF_MAIN     * SIZE_EF_MAIN)     + 2
#define LEN_SFK       (NR_EF_SFK      * SIZE_EF_SFK)      + 2
#define LEN_FAULT     (NR_EF_FAULT    * SIZE_EF_FAULT)    + 2
#define LEN_DEBUG     (NR_EF_DEBUG    * SIZE_EF_DEBUG)    + 2
#define LEN_POWER     (NR_EF_POWER    * SIZE_EF_POWER)    + 2
#define LEN_KEYB      (NR_EF_KEYB     * SIZE_EF_KEYB)     + 2
#define LEN_RADIO     (NR_EF_RADIO    * SIZE_EF_RADIO)    + 2
#define LEN_CGMI      (NR_EF_CGMI     * SIZE_EF_CGMI)     + 2
#define LEN_CGMM      (NR_EF_CGMM     * SIZE_EF_CGMM)     + 2
#define LEN_CGMR      (NR_EF_CGMR     * SIZE_EF_CGMR)     + 2
#define LEN_CGSN      (NR_EF_CGSN     * SIZE_EF_CGSN)     + 2
#define LEN_SMSPRFL   (NR_EF_SMSPRFL  * SIZE_EF_SMSPRFL)  + 2
#define LEN_PLMN      (NR_EF_PLMN     * SIZE_EF_PLMN)     + 2
#define LEN_ALS       (NR_EF_ALS      * SIZE_EF_ALS)      + 2
#define LEN_BCCHINFO  (NR_EF_BCCHINFO * SIZE_EF_BCCHINFO) + 2
#define LEN_LOCGPRS   (NR_EF_LOCGPRS  * SIZE_EF_LOCGPRS)  + 2
#define LEN_KCGPRS    (NR_EF_KCGPRS   * SIZE_EF_KCGPRS)   + 2
#define LEN_IMSIGPRS  (NR_EF_IMSIGPRS * SIZE_EF_IMSIGPRS) + 2

#define START_MSCAP   0
#define START_IMEI    START_MSCAP     + LEN_MSCAP
#define START_IMSI    START_IMEI      + LEN_IMEI
#define START_SMS     START_IMSI      + LEN_IMSI
#define START_CLASS2  START_SMS       + LEN_SMS
#define START_CLASS3  START_CLASS2    + LEN_CLASS2
#define START_MSSUP   START_CLASS3    + LEN_CLASS3
#define START_MSSET   START_MSSUP     + LEN_MSSUP
//	Jun 14, 2005 REF: MMI-FIX-30439 x0018858
#define START_HZCACHE START_MSSET     + LEN_MSSET
#define START_LDN     START_HZCACHE   + LEN_HZCACHE
#define START_LRN     START_LDN       + LEN_LDN
#define START_LMN     START_LRN       + LEN_LRN
#define START_UPN     START_LMN       + LEN_LMN
#define START_MBN     START_UPN       + LEN_UPN
#define START_VMN     START_MBN       + LEN_MBN
#define START_CLNG    START_VMN       + LEN_VMN
#define START_CTIM    START_CLNG      + LEN_CLNG
#define START_CCNT    START_CTIM      + LEN_CTIM
#define START_ECC     START_CCNT      + LEN_CCNT
#define START_ORG     START_ECC       + LEN_ECC
#define START_CCP     START_ORG       + LEN_ORG
#define START_EXT1    START_CCP       + LEN_CCP
#define START_SIMLCK  START_EXT1      + LEN_EXT1
#define START_MAIN    START_SIMLCK    + LEN_SIMLCK
#define START_SFK     START_MAIN      + LEN_MAIN
#define START_FAULT   START_SFK       + LEN_SFK
#define START_DEBUG   START_FAULT     + LEN_FAULT
#define START_POWER   START_DEBUG     + LEN_DEBUG
#define START_KEYB    START_POWER     + LEN_POWER
#define START_RADIO   START_KEYB      + LEN_KEYB
#define START_CGMI    START_RADIO     + LEN_RADIO
#define START_CGMM    START_CGMI      + LEN_CGMI
#define START_CGMR    START_CGMM      + LEN_CGMM
#define START_CGSN    START_CGMR      + LEN_CGMR
#define START_SMSPRFL START_CGSN      + LEN_CGSN
#define START_PLMN    START_SMSPRFL   + LEN_SMSPRFL
#define START_ALS     START_PLMN      + LEN_PLMN
#define START_BCCHINFO  START_ALS       + LEN_ALS
#define START_LOCGPRS   START_BCCHINFO  + LEN_BCCHINFO
#define START_KCGPRS    START_LOCGPRS   + LEN_LOCGPRS
#define START_IMSIGPRS  START_KCGPRS    + LEN_KCGPRS


#define PCM_SIZE (START_IMSIGPRS + LEN_IMSIGPRS)

/*
 * RAM for the copy of PCM data
 */
UBYTE pcm_mem [PCM_SIZE];

static const T_PCM_DESCRIPTION pcm_table[] =
{
  {   "MSCAP"    , START_MSCAP,     SIZE_EF_MSCAP     +2, NR_EF_MSCAP    },
  {   "IMEI"     , START_IMEI,      SIZE_EF_IMEI      +2, NR_EF_IMEI     },
  {   "IMSI"     , START_IMSI,      SIZE_EF_IMSI      +2, NR_EF_IMSI     },
  {   "SMS "     , START_SMS,       SIZE_EF_SMS       +2, NR_EF_SMS      },
  {   "CLASS2"   , START_CLASS2,    SIZE_EF_CLASS2    +2, NR_EF_CLASS2   },
  {   "CLASS3"   , START_CLASS3,    SIZE_EF_CLASS3    +2, NR_EF_CLASS3   },
  {   "MSSUP"    , START_MSSUP,     SIZE_EF_MSSUP     +2, NR_EF_MSSUP    },
  {   "MSSET"    , START_MSSET,     SIZE_EF_MSSET     +2, NR_EF_MSSET    },
  {   "HZCACHE"  , START_HZCACHE,   SIZE_EF_HZCACHE   +2, NR_EF_HZCACHE  }, 	//Jun 14, 2005 REF: MMI-FIX-30439 x0018858
  {   "LDN"      , START_LDN,       SIZE_EF_LDN       +2, NR_EF_LDN      },
  {   "LRN"      , START_LRN,       SIZE_EF_LRN       +2, NR_EF_LRN      },
  {   "LMN"      , START_LMN,       SIZE_EF_LMN       +2, NR_EF_LMN      },
  {   "UPN"      , START_UPN,       SIZE_EF_UPN       +2, NR_EF_UPN      },
  {   "MBN"      , START_MBN,       SIZE_EF_MBN       +2, NR_EF_MBN      },
  {   "VMN"      , START_VMN,       SIZE_EF_VMN       +2, NR_EF_VMN      },
  {   "CLNG"     , START_CLNG,      SIZE_EF_CLNG      +2, NR_EF_CLNG     },
  {   "CTIM"     , START_CTIM,      SIZE_EF_CTIM      +2, NR_EF_CTIM     },
  {   "CCNT"     , START_CCNT,      SIZE_EF_CCNT      +2, NR_EF_CCNT     },
  {   "ECC"      , START_ECC,       SIZE_EF_ECC       +2, NR_EF_ECC      },
  {   "ORG"      , START_ORG,       SIZE_EF_ORG       +2, NR_EF_ORG      },
  {   "CCP"      , START_CCP,       SIZE_EF_CCP       +2, NR_EF_CCP      },
  {   "EXT1"     , START_EXT1,      SIZE_EF_EXT1      +2, NR_EF_EXT1     },
  {   "SIMLCK"   , START_SIMLCK,    SIZE_EF_SIMLCK    +2, NR_EF_SIMLCK   },
  {   "MAIN"     , START_MAIN,      SIZE_EF_MAIN      +2, NR_EF_MAIN     },
  {   "SFK"      , START_SFK,       SIZE_EF_SFK       +2, NR_EF_SFK      },
  {   "FAULT"    , START_FAULT,     SIZE_EF_FAULT     +2, NR_EF_FAULT    },
  {   "DEBUG"    , START_DEBUG,     SIZE_EF_DEBUG     +2, NR_EF_DEBUG    },
  {   "POWER"    , START_POWER,     SIZE_EF_POWER     +2, NR_EF_POWER    },
  {   "KEYB"     , START_KEYB,      SIZE_EF_KEYB      +2, NR_EF_KEYB     },
  {   "RADIO"    , START_RADIO,     SIZE_EF_RADIO     +2, NR_EF_RADIO    },
  {   "CGMI"     , START_CGMI,      SIZE_EF_CGMI      +2, NR_EF_CGMI     },
  {   "CGMM"     , START_CGMM,      SIZE_EF_CGMM      +2, NR_EF_CGMM     },
  {   "CGMR"     , START_CGMR,      SIZE_EF_CGMR      +2, NR_EF_CGMR     },
  {   "CGSN"     , START_CGSN,      SIZE_EF_CGSN      +2, NR_EF_CGSN     },
  {   "SMSPRFL"  , START_SMSPRFL,   SIZE_EF_SMSPRFL   +2, NR_EF_SMSPRFL  },
  {   "PLMN"     , START_PLMN,      SIZE_EF_PLMN      +2, NR_EF_PLMN     },
  {   "ALS"      , START_ALS,       SIZE_EF_ALS       +2, NR_EF_ALS      },
  {   "BCCHINF"  , START_BCCHINFO,  SIZE_EF_BCCHINFO  +2, NR_EF_BCCHINFO },
  {   "LOCGPRS"  , START_LOCGPRS,   SIZE_EF_LOCGPRS   +2, NR_EF_LOCGPRS  },
  {   "KCGPRS"   , START_KCGPRS,    SIZE_EF_KCGPRS    +2, NR_EF_KCGPRS   },
  {   "IMSIGPRS" , START_IMSIGPRS,  SIZE_EF_IMSIGPRS  +2, NR_EF_IMSIGPRS },
  {   NULL       , 0,               0                   , 0         }
};

static const UBYTE pcm_default_values[] =
{
#if STD==1                      // GSM 900 variant
#if defined (FAX_AND_DATA)
  0x81,   0xC7,   0x00,
#else
  0x01,   0x00,   0x00,
#endif
#endif

#if STD==3 || STD==4            // DCS 1800, PCS 1900
#if defined (FAX_AND_DATA)
  0x81,   0xC7,   0x00,
#else
#if defined (TM_SPECIAL)
  0x01,   0x00,   0x00,
#else
  0x07,   0x00,   0x00,
#endif
#endif
#endif

#if STD==5                      // Dualband GSM 900 / DCS 1800
#if defined (FAX_AND_DATA)
  0x81,   0xC7,   0x00,
#else
  0x07,   0x00,   0x00,
#endif
#endif

#if STD==6                          // Dualband GSM 900 / E-GSM / DCS 1800
#if defined (FAX_AND_DATA)
  0x81,   0xC7,   0x00,
#else
  0x07,   0x00,   0x00,
#endif
#endif

  0x00,   0x00,   0x00,

  0x44,   0x06,   0x91,   0x91,   0x57,   0x70,   0x95,   0x00,   // EFimei

  0x0f,                                                           // EFimsi
  0x44,   0x06,   0x91,   0x91,   0x57,   0x70,   0x95,   0xf0,

  0x10,   0x11,   0x12,   0x13,   0x14,   0x15,   0x16,   0x17,   // EFsms
  0x18,   0x19,   0x1a,   0x1b,   0x1c,   0x1d,   0x1e,   0x1f,
  0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,
  0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,
  0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,
  0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,
  0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,
  0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,
  0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,
  0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,
  0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,
  0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,
  0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,
  0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,
  0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,
  0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,
  0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,
  0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,
  0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,
  0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,
  0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,
  0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,   0x1f,


#if STD==1
  0x33,   0x18,   0x04,                                           // EFclass2
  0x00,   0x00,   0x10,                                           // EFclass3
#endif
#if STD==3 || STD==4
  0x30,   0x18,   0x04,                                           // EFclass2
  0x00,   0x00,   0x10,                                           // EFclass3
#endif
#if STD==5
  0x30,   0x18,   0x84,                                           // EFclass2
  0x50,   0x14,   0x10,                                           // EFclass3
#endif
#if STD==6
  0x30,   0x19,   0x84,                                           // EFclass2
  0x60,   0x14,   0x10,                                           // EFclass3
#endif

  0xB7,   0x46,   0x47,   0x1F,   0x00,                          // EFmssup

  0x30,   0x31,   0x32,   0x33,   0x34,   0x35,   0x36,   0x37,   // MSSET
  0x38,   0x39,
//	Jun 14, 2005 REF: MMI-FIX-30439 x0018858

  0xFF,   0xFF,   0xFF, // homezone record 1
  0xFF,   0xFF,   0xFF, // homezone record 2
  0xFF,   0xFF,   0xFF, // homezone record 3
  0xFF,   0xFF,   0xFF, // homezone record 4
  0xFF,   0xFF,   0xFF, // homezone record 5

  0x40,   0x41,   0x42,   0x43,   0x44,   0x45,   0x46,   0x47,   //EFldn
  0x48,   0x49,   0x4a,   0x4b,   0x4c,   0x4d,   0x4e,   0x4f,
  0x4f,   0x4f,   0x4f,   0x4f,   0x00,   0x00,

  0x50,   0x51,   0x52,   0x53,   0x54,   0x55,   0x56,   0x57,   //EFlrn
  0x58,   0x59,   0x5a,   0x5b,   0x5c,   0x5d,   0x5e,   0x5f,
  0x5f,   0x5f,   0x5f,   0x5f,   0x5f,   0x00,   0x00,

  0x40,   0x41,   0x42,   0x43,   0x44,   0x45,   0x46,   0x47,   //EFlmn
  0x48,   0x49,   0x4a,   0x4b,   0x4c,   0x4d,   0x4e,   0x4f,
  0x4f,   0x4f,   0x4f,   0x4f,   0x00,

  0x60,   0x61,   0x62,   0x63,   0x64,   0x65,   0x66,   0x67,   //EFupn
  0x68,   0x69,   0x6a,   0x6b,   0x6c,   0x6d,   0x6e,   0x6f,
  0x6f,   0x6f,   0x6f,   0x6f,   0x6f,   0x6f,   0x6f,   0x6f,

  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   //EFmbn (record 1)
  0xff,   0xff,
  0x00,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,

  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   //EFmbn (record 2)
  0xff,   0xff,
  0x00,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,

  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   //EFmbn (record 3)
  0xff,   0xff,
  0x00,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,

  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   //EFmbn (record 4)
  0xff,   0xff,
  0x00,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,

  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   //EFvmn (default is no number)
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   
  0xff,   0x91,                                                   /* default is international: 145: 0x91 */

  //EFclng
  /* CLNG    */     'a',  'u',                 /* checksum & version */

  0x70,   0x71,   0x72,   0x73,   0x74,   0x75,   0x76,   0x77,   //EFctim
  0x78,   0x79,   0x7a,   0x7b,   0x7c,   0x7d,   0x7e,   0x7f,
  0x7f,   0x7f,   0x7f,   0x7f,   0x7f,   0x7f,   0x7f,   0x7f,
  0x7f,   0x7f,   0x7f,   0x7f,   0x7f,   0x7f,   0x7f,   0x7f,
  0x7f,   0x7f,   0x7f,   0x7f,   0x7f,   0x7f,   0x7f,   0x7f,
  0x7f,   0x7f,   0x7f,   0x7f,   0x7f,   0x7f,   0x7f,   0x7f,

  0x80,   0x81,   0x82,   0x83,   0x84,   0x85,   0x86,   0x87,   //EFccnt
  0x88,   0x89,   0x8a,   0x8b,   0x8c,   0x8d,   0x8e,   0x8f,
  0x8f,   0x8f,   0x8f,   0x8f,   0x8f,   0x8f,   0x8f,   0x8f,
  0x8f,   0x8f,   0x8f,   0x8f,   0x8f,   0x8f,   0x8f,   0x8f,
  0x8f,   0x8f,   0x8f,   0x8f,   0x8f,   0x8f,   0x8f,   0x8f,
  0x8f,   0x8f,   0x8f,   0x8f,   0x8f,   0x8f,   0x8f,   0x8f,
  0x8f,   0x8f,   0x8f,   0x8f,

  0x90,   0x91,   0x92,   0x93,   0x94,   0x95,   0x96,   0x97,   //EFecc
  0x98,   0x99,   0x9a,   0x9b,   0x9c,   0x9d,   0x9e,

  0xa0,   0xa1,   0xa2,   0xa3,   0xa4,   0xa5,   0xa6,   0xa7,   //EForg
  0xa8,   0xa9,   0xaa,   0xab,   0xac,   0xad,   0xae,   0xaf,
  0xaf,   0xaf,   0xaf,   0xaf,   0xaf,   0x00,   0x00,

  0xb0,   0xb1,   0xb2,   0xb3,   0xb4,   0xb5,   0xb6,           //EFccp

  0xc0,   0xc1,   0xc2,   0xc3,   0xc4,   0xc5,   0xc6,   0xc7,   //EFext1
  0xc8,   0xc9,   0xca,   0xcb,   0xcc,

  0x00,   0x00,   0xd2,   0xd3,                                   //EFsimlck
  0x11,   0x11,   0x11,   0x11,   0x11,   0x11,   0x11,   0x11,
  0x21,   0x43,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0x0f,
  0x22,   0x24,   0x24,   0x24,   0x44,   0x15,   0x12,   0x45,
      0x22,   0x22,   0x22,   0x22,   0x44,   0x15,   0x66,
  0xff,     0xff,

  0xe0,   0xe1,   0xe2,   0xe3,   0xe4,   0xe5,   0xe6,   0xe7,   //EFmnt

  0xe8,   0xe9,   0xea,   0xeb,   0xec,   0xed,   0xee,   0xef,   //EFsfk

  0xf0,   0xf1,   0xf2,   0xf3,   0xf4,   0xf5,   0xf6,   0xf7,   //EFflt

  0xf8,   0xf9,   0xfa,   0xfb,   0xfc,   0xfd,   0xfe,   0xff,   //EFdbg

  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   //EFbat

  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   //EFkbd
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,

  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   //EFrdio

  '<',    'm',    'a',    'n',    'u',    'f',    'a',    'c',    /* EFcgmi */
  't',    'u',    'r',    'e',    'r',    '>',    0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,

  '<',    'm',    'o',    'd',    'e',    'l',    '>',    0xff,   /* EFcgmm */
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,

  '<',    'r',    'e',    'v',    'i',    's',    'i',    'o',    /* EFcgmr */
  'n',    '>',    0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,

  '<',    's',    'e',    'r',    'i',    'a',    'l',    ' ',    /* EFcgsn */
  'n',    'u',    'm',    'b',    'e',    'r',    '>',    0xff,
  0xff,   0xff,   0xff,   0xff,

  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   /* EFsmsprfl record 1 */
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,

  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   /* EFsmsprfl record 2 */
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,
  0xff,   0xff,   0xff,   0xff,   0xff,   0xff,   0xff,

  0xff,   0xff,   0xff,   0xff,   0x00,   0x00,   0x00,   0x00,   /* EFplmn record 1 */
  0x00,   0x00,   0x00,   0x00,   0x00,   0x00,   0x00,   0x00,
  0x00,   0x00,   0x00,   0x00,   0x00,   0x00,   0x00,   0x00,
  0x00,   0x00,   0x00,   0x00,   0x00,   0x00,   0x00,   0x00,
  0x00,   0x00,

  0xff,   0xff,   0xff,   0xff,   0x00,   0x00,   0x00,   0x00,   /* EFplmn record 2 */
  0x00,   0x00,   0x00,   0x00,   0x00,   0x00,   0x00,   0x00,
  0x00,   0x00,   0x00,   0x00,   0x00,   0x00,   0x00,   0x00,
  0x00,   0x00,   0x00,   0x00,   0x00,   0x00,   0x00,   0x00,
  0x00,   0x00,

  0x00,   0x00,                          /* alternate line service */

  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,          /* EFbcch  */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

  0xFF, 0xFF, 0xFF, 0xFF,                      /* locGPRS:  P-TMSI */
  0xFF, 0xFF, 0xFF,                        /* P-TMSI Signature */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF,                /* RAI */
  0xFF,                              /* Update Status */

  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,          /* KcGPRS: Kc */
  0x07,                              /* CKSN */

  0xFF,                                                           /* IMSI-GPRS:IMSI length */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF                  /* IMSI */
};

/*******************************************************************************
 *
 *                             compute_checksum
 * Purpose  : Calculate the checksum
 *
 * Arguments: In :  Start adresse of the record (checksum is the first
 *                  byte of the record)
 *                  Length of the record (bytes)
 *            Out:  none
 *
 * Returns  :   Checksum
 *
 *
 ******************************************************************************/

UBYTE compute_checksum (UBYTE *record_start, USHORT length)
{
    UBYTE Sum;
    int i=1;                /* exclude checksum */

    Sum=0;
    if (length > 0)
    {
        while (i < length)
        {
            Sum += (UBYTE)*(record_start+i);
            i ++;
        }
        Sum = (UBYTE)(0xFF - Sum);
        return (Sum);
    }
    else
        return 0xFF;
}



/*******************************************************************************
 *
 *                             pcm_Init
 * Purpose  :  Open the permanent configuration memory
 *
 * Arguments: In : none
 *            Out: none
 *
 * Returns  : DRV_OK
 *            DRV_INITIALIZED
 *
 ******************************************************************************/

UBYTE pcm_Init (void)
{
    int i;

    if (pcm_read == FALSE)
    {
        pcm_read = TRUE;

        std = STD;  /* target standard is defined by constant STD */
#if defined(_TARGET_)
        TRACE_EVENT_P1 ("pcm_init() std%d", std);
#endif  /* _TARGET_ */

        /*
         * A-Sample: The flash memory may be at address 0 or at address 0x100000.
         */

        /* unprotect flash */
        pcm_unprotect_flash ();

        pcm_init_flash_device ();

       /*
        * read flash memory and transfert data to RAM
        */
        pcm_read_flash(pcm_mem, PCM_SIZE);

       /*
        * verify checksums, if one is wrong write default values in RAM and
        * compute checksums again
        */
        i=0;
        while ((pcm_table[i].identifier NEQ NULL)
            && (pcm_mem[pcm_table[i].start] EQ compute_checksum (&pcm_mem[pcm_table[i].start],
                                 (pcm_table[i].length - 2)*pcm_table[i].records + 2) ))
        {
            i++;
        }
        if (pcm_table[i].identifier NEQ NULL)       /* at least one checksum is wrong */
        {
            i = 0;
            while (pcm_table[i].identifier NEQ NULL)
            {
                memcpy ((&pcm_mem[pcm_table[i].start]+2),
                         &pcm_default_values[pcm_table[i].start - 2*i],
                         (pcm_table[i].length - 2)*pcm_table[i].records);

                pcm_mem[pcm_table[i].start + 1] = 1;        /* version */

                pcm_mem[pcm_table[i].start] =
                        compute_checksum (&pcm_mem[pcm_table[i].start],
                                         ((pcm_table[i].length - 2)*pcm_table[i].records + 2));

                i++;
            }
        }

        return (DRV_OK);
    }
    else
        return (DRV_INITIALIZED);

}

 /*******************************************************************************
 *
 *                             pcm_Exit
 * Purpose  :  Closes the permanent configuration memory
 *
 * Arguments: In : none
 *            Out: none
 *
 * Returns  : none
 *
 ******************************************************************************/
void pcm_Exit (void)
{
    pcm_read = FALSE;
}



/*******************************************************************************
 *
 *                            pcm_ReadFile
 * Purpose  : Read a transparent elementary field
 *
 * Arguments: In :  Filename (string)
 *                  Size of the file
 *
 *            Out:  Buffer for file content
 *                  Pointer to File version
 *
 * Returns  : DRV_OK           read ok
 *            PCM_INVALID_SIZE invalid size of file
 *            PCM_INVALID_CKSM invalid checksum
 *            PCM_INVALID_FILE invalid name of file
 *            PCM_SUCCESS      read OK
 *
 ******************************************************************************/

UBYTE pcm_ReadFile (UBYTE * in_FileName,
                    USHORT  in_BufferSize,
                    UBYTE * out_BufferPtr,
                    UBYTE * out_VersionPtr)
{
    UBYTE i;
    int return_value;

    i=0;
    while (pcm_table[i].identifier NEQ NULL)
    {
       /*
        * Check all available entries
        */
        if (!strcmp ((char *)in_FileName, pcm_table[i].identifier))
        {
           /*
            * entry is available, check size
            * buffer size + version + checksum must be equal entry length
            */
            if (in_BufferSize+2 NEQ pcm_table[i].length)
                return PCM_INVALID_SIZE;

            return_value = DRV_OK;
            if (compute_checksum(&pcm_mem[pcm_table[i].start],pcm_table[i].length)
                    != pcm_mem[pcm_table[i].start])
                {
                memcpy ((&pcm_mem[pcm_table[i].start]+2),
                        &pcm_default_values[pcm_table[i].start - 2*i],
                        (pcm_table[i].length -2));
                pcm_mem[pcm_table[i].start + 1] = 1;        //version
                pcm_mem[pcm_table[i].start] =
                                compute_checksum(&pcm_mem[pcm_table[i].start] ,
                                                  pcm_table[i].length);
                return_value = PCM_INVALID_CKSM;
                }

            memcpy (out_BufferPtr, &pcm_mem [pcm_table[i].start+2],in_BufferSize);
            *out_VersionPtr = pcm_mem[pcm_table[i].start+1];
            return return_value;
        }
        i++;
    }
    return PCM_INVALID_FILE;
}

/*******************************************************************************
 *
 *                           pcm_GetFileInfo
 * Purpose  : Get information about a dedicated file.
 *
 * Arguments: In : Name of the file
 *            Out: Structure of informations about the file
 *
 * Returns  : PCM_INVALID_FILE invalid name of file
 *            DRV_OK           read OK
 *
 ******************************************************************************/

UBYTE pcm_GetFileInfo (UBYTE             * in_FileName,
                       pcm_FileInfo_Type * out_FileInfoPtr)
{
    UBYTE i;

    i=0;
    while (pcm_table[i].identifier NEQ NULL)
    {
       /*
        * Check all available entries
        */
        if (!strcmp ((char *)in_FileName, pcm_table[i].identifier))
        {
           /*
            * entry is available,
            * fill file info
            */
            out_FileInfoPtr->FileLocation = &pcm_mem [pcm_table[i].start+2];
            out_FileInfoPtr->FileSize     = pcm_table[i].length-2;
            out_FileInfoPtr->Version      = pcm_mem [pcm_table[i].start+1];
            return DRV_OK;
        }
        i++;
    }
    return PCM_INVALID_FILE;
}

/*******************************************************************************
 *
 *                           pcm_ReadRecord
 * Purpose  : Read a linear fixed elementary field.
 *
 * Arguments: In :  Name of the file
 *                  Record number
 *                  Size of the record
 *            Out:  Buffer for the record
 *                  Buffer for the file version
 *                  Number of records in the file
 *
 * Returns  : PCM_INVALID_SIZE   invalid size of file
 *            PCM_INVALID_RECORD invalid record number
 *            PCM_INVALID_CKSM   invalid checksum
 *            DRV_OK             read OK
 *
 ******************************************************************************/

UBYTE pcm_ReadRecord (UBYTE  * in_FileName,
                      USHORT   in_Record,
                      USHORT   in_BufferSize,
                      UBYTE  * out_BufferPtr,
                      UBYTE  * out_VersionPtr,
                      USHORT * out_MaxRecordsPtr)
{
    UBYTE i;
    int return_value;

    i=0;
    while (pcm_table[i].identifier NEQ NULL)
    {
       /*
        * check whether entry is available
        */
        if (!strcmp ((char *)in_FileName, pcm_table[i].identifier))
        {
           /*
            * entry is available, check size
            */
            if (in_BufferSize+2 NEQ pcm_table[i].length)
                return PCM_INVALID_SIZE;
           /*
            * check record number
            */
            if (in_Record EQ 0 OR in_Record > pcm_table[i].records)
                return PCM_INVALID_RECORD;

            return_value = DRV_OK;
            if (compute_checksum(&pcm_mem[pcm_table[i].start] ,
                                  in_BufferSize*pcm_table[i].records + 2)
                != pcm_mem[pcm_table[i].start])
            {
                memcpy ((&pcm_mem[pcm_table[i].start]+2),
                         &pcm_default_values[pcm_table[i].start - 2*i],
                         (in_BufferSize*pcm_table[i].records));

                pcm_mem[pcm_table[i].start + 1] = 1;        //version
                pcm_mem[pcm_table[i].start] =
                            compute_checksum(&pcm_mem[pcm_table[i].start] ,
                                              in_BufferSize*pcm_table[i].records+2);

                return_value = PCM_INVALID_CKSM;
            }

           /*
            * copy record content
            * read version number and max records
            */
            memcpy (out_BufferPtr,
                    &pcm_mem [pcm_table[i].start+2+(in_Record-1) * in_BufferSize],
                    in_BufferSize);
            * out_MaxRecordsPtr = pcm_table[i].records;
            * out_VersionPtr    = pcm_mem [pcm_table[i].start+1];
            return return_value;
        }
        i++;
    }
    return PCM_INVALID_FILE;

}

/*******************************************************************************
 *
 *                           pcm_WriteFile
 * Purpose  : Write a transparent elementary field in RAM
 *
 * Arguments: In :  Name of the file to write
 *                  Size of the file
 *                  Pointer to the file content
 *            Out:  none
 *
 * Returns  : PCM_INVALID_SIZE invalid size of file
 *            DRV_OK           write ok
 *            PCM_INVALID_FILE invalid name of file
 *
 ******************************************************************************/

UBYTE pcm_WriteFile (UBYTE * in_FileName,
                     USHORT  in_FileSize,
                     UBYTE * in_BufferPtr)
{
    UBYTE i;
    i=0;
    while (pcm_table[i].identifier NEQ NULL)
    {
       /*
        * check whether entry is available
        */
        if (!strcmp ((char *)in_FileName, pcm_table[i].identifier))
        {
           /*
            * check file size
            */
            if (in_FileSize+2 NEQ pcm_table[i].length)
                return PCM_INVALID_SIZE;
           /*
            * store new buffer content
            * checksum calc
            */
            memcpy (&pcm_mem [pcm_table[i].start+2], in_BufferPtr,in_FileSize);
            pcm_mem [pcm_table[i].start] =
                                compute_checksum(&pcm_mem [pcm_table[i].start],
                                                  pcm_table[i].length);

            return DRV_OK;
        }
        i++;
    }
    return PCM_INVALID_FILE;
}

/*******************************************************************************
 *
 *                           pcm_WriteRecord
 * Purpose  :  Write a linear fixed elementary field in RAM
 *
 * Arguments: In :  Name of the file to write
 *                  Record number
 *                  Size of the record
 *                  Pointer to the record content
 *            Out:  none
 *
 * Returns  : PCM_INVALID_SIZE   invalid size of record
 *            PCM_INVALID_RECORD invalid record number
 *            PCM_INVALID_FILE   invalid name of file
 *            DRV_OK             write OK
 *
 ******************************************************************************/

UBYTE pcm_WriteRecord (UBYTE * in_FileName,
                       USHORT  in_Record,
                       USHORT  in_BufferSize,
                       UBYTE * in_BufferPtr)
{
    UBYTE i;
    i=0;
    while (pcm_table[i].identifier NEQ NULL)
    {
       /*
        * check all available entries
        */
        if (!strcmp ((char *)in_FileName, pcm_table[i].identifier))
        {
           /*
            * entry is available,
            * check entry size
            */
            if (in_BufferSize+2 NEQ pcm_table[i].length)
                return PCM_INVALID_SIZE;
           /*
            * check record number
            */
            if (in_Record EQ 0 OR in_Record > pcm_table[i].records)
                return PCM_INVALID_RECORD;

           /*
            * store data in record
            */
            memcpy (&pcm_mem [pcm_table[i].start+2+(in_Record-1) * in_BufferSize],
                    in_BufferPtr,
                    in_BufferSize);

           /*
            * calculate checksum
            */
            pcm_mem [pcm_table[i].start] =
                    compute_checksum(&pcm_mem [pcm_table[i].start],
                                       in_BufferSize*pcm_table[i].records+2);

            return DRV_OK;
        }
        i++;
    }
    return PCM_INVALID_FILE;
}

/*******************************************************************************
 *
 *                           pcm_Flush
 * Purpose  :  Transfer changes to the PCM of the non volatile RAM.
 *             This fonction can only be called while interrupts
 *             are disabled
 *
 * Arguments: In : none
 *            Out: none
 *
 * Returns  : PCM_ERASE_ERROR erase failed
 *            DRV_OK          erase and write read OK
 *            PCM_WRITE_ERROR write failed
 *
 ******************************************************************************/

UBYTE pcm_Flush (void)
{
   long write_result,erase_result;

   UBYTE status;

   erase_result = pcm_erase_flash_sector();
   if (erase_result != PCM_ERASE_ERROR)
   {
     write_result = pcm_write_flash (pcm_mem, PCM_SIZE);
     return (write_result);
   }
   else
     return (erase_result);
}
/*******************************************************************************
 *
 *                          pcm_ReadParameter
 *
 * Purpose  : Reads a parameter specified by an index.
 *
 * Arguments: In : parameter: parameter index
 *            Out: none
 *
 * Returns  : The parameter
 *
 * Warning! If the parameter is wrong 0 is returned.
 *
 ******************************************************************************/

UINT16 pcm_ReadParameter (UBYTE parameter)
{
    UINT16 parameter_value;

    switch (parameter) {

    case PCM_SERIAL_CONFIG:

        parameter_value = pcm_read_parameter (PCM_FLASH_SERIAL_CONFIG);
        break;

    default:

        parameter_value = 0;
        break;
    }

    return (parameter_value);
}

#endif /* else, #ifdef WIN32 */
#endif /* #ifndef PCM_C */

