/* 
+----------------------------------------------------------------------------- 
|  Project :  
|  Modul   :  
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  
+----------------------------------------------------------------------------- 
*/ 

#ifdef _SIMULATION_
#ifndef _FFS_C_
#define _FFS_C_

#ifndef GPRS
#include "ffs/ffs.h"
#undef GPRS  /* ffs.h somehow defines GPRS: has to be undef ifndef GPRS */

#else /* GPRS */
#include "ffs/ffs.h"
#endif /* GPRS */

/******************************************************************************
 * Types
 ******************************************************************************/
/******************************************************************************
 * Function prototypes
 ******************************************************************************/

/* Call-back function prototypes */

T_FFS_REQ_ID ffs_fcreate_nb(const char *name, void *addr, T_FFS_SIZE size, T_RV_RETURN *cp)
{
  return EFFS_OK;
}

T_FFS_REQ_ID ffs_fupdate_nb(const char *name, void *addr, T_FFS_SIZE size, T_RV_RETURN *cp)
{
  return EFFS_OK;
}

T_FFS_REQ_ID ffs_fwrite_nb(const char *name, void *addr, T_FFS_SIZE size, T_RV_RETURN *cp)
{
  return EFFS_OK;
}

T_FFS_REQ_ID ffs_mkdir_nb(const char *name, T_RV_RETURN *cp)
{
  return EFFS_OK;
}

T_FFS_REQ_ID ffs_symlink_nb(const char *name, const char *actualpath, T_RV_RETURN *cp)
{
  return EFFS_OK;
}

T_FFS_REQ_ID ffs_remove_nb(const char *namestruct, T_RV_RETURN *cp)
{
  return EFFS_OK;
}

T_FFS_REQ_ID ffs_fcontrol_nb(const char *pathname, INT8 action, int param, T_RV_RETURN *cp)
{
  return EFFS_OK;
}

T_FFS_REQ_ID ffs_preformat_nb(UINT16 magic, T_RV_RETURN *cp)
{
  return EFFS_OK;
}

T_FFS_REQ_ID ffs_format_nb(const char *name, UINT16 magic, T_RV_RETURN *cp)
{
  return EFFS_OK;
}



/* No-call-back function prototypes */
T_FFS_RET ffs_fcreate(const char *name, void *addr, T_FFS_SIZE size)
{
  return EFFS_OK;
}

T_FFS_RET ffs_fupdate(const char *name, void *addr, T_FFS_SIZE size)
{
  return EFFS_OK;
}

T_FFS_RET ffs_fwrite(const char *name, void *addr, T_FFS_SIZE size)
{
  return EFFS_OK;
}

T_FFS_SIZE ffs_fread(const char *name, void *addr, T_FFS_SIZE size)
{
  return 0;
}

T_FFS_RET ffs_file_write(const char *name, void *addr, T_FFS_SIZE size, T_FFS_OPEN_FLAGS flags)
{
  return EFFS_OK;
}

T_FFS_SIZE ffs_file_read(const char *name, void *addr, T_FFS_SIZE size)
{
  return 0;
}

#if 0
T_FFS_RET ffs_mkdir(const char *name)
{
  return EFFS_OK;
}

T_FFS_SIZE ffs_opendir(const char *name, T_FFS_DIR *dir)
{
  return 0;
}

T_FFS_SIZE ffs_readdir (T_FFS_DIR *dir, char *name, T_FFS_SIZE size)
{
  return EFFS_OK;
}
#endif

T_FFS_RET ffs_symlink(const char *name, const char *actualpath)
{
  return EFFS_OK;
}

T_FFS_SIZE ffs_readlink(const char *name, char *addr, T_FFS_SIZE size)
{
  return 0;
}

#if 0
T_FFS_RET ffs_stat(const char *name, T_FFS_STAT *stat)
{
  return EFFS_OK;
}
#endif

T_FFS_RET ffs_linkstat(const char *name, T_FFS_STAT *stat)
{
  return EFFS_OK;
}

#if 0
T_FFS_RET ffs_remove(const char *name)
{
  return EFFS_OK;
}
#endif

T_FFS_RET ffs_fcontrol(const char *pathname, INT8 action, int param)
{
  return EFFS_OK;
}

T_FFS_RET ffs_query(INT8 query, void *p)
{
  return EFFS_OK;
}

T_FFS_RET ffs_preformat(UINT16 magic)
{
  return EFFS_OK;
}

T_FFS_RET ffs_format(const char *name, UINT16 magic)
{
  return EFFS_OK;
}
/*
effs_t ffs_init(void)
{
  return EFFS_OK;
}

effs_t ffs_exit(void)
{
  return EFFS_OK;
}
*/
#endif /*_FFS_C_*/
#endif /* _SIMULATION_ */