#ifndef _SEC_DRV_PRIM_H_
#define _SEC_DRV_PRIM_H_


/*******************************************
		Feature flags & constants
*******************************************/
// TODO: Set properly!
//#define SEC_TRACES_ENABLED
#define FFS_MODE_ENABLED			/* MEPD file is located in FFS */
#define NON_ENCRYPTED_MODE			/* MEPD file wont be encrypted */
//#define IMEI_FROM_OTP				/* IMEI is placed in OTP */
//#define FIRSTBOOT_ENABLED
//#define FIRSTBOOT_FFS_BACKUP_ENABLED	/* MEPD backup during firstboot is placed in FFS */
//#define FIRSTBOOT_RSA_ENABLED		/* RSA Part of external MEPD is decrypted */
//#define FIRSTBOOT_DES_ENABLED		/* DES encrypted data in external MEPD is decrypted */
//#define RSA_FROM_CERT_ENABLED		/* Key for RSA is taken from certificate */
//#define USE_RSAHEAP_FOR_FLASH		/* Use the RSA heap (SEC_DRV_RSA_HEAP) for flash writing algorithm */
//#define RSA_HEAP_IS_INTERNAL		/* Buffer for RSA heap is allocated as global array! */
//#define DSP_DES_KEY_ENABLED			/* DES key is taken from the DSP */


/* Flash interface constants */
extern volatile const UINT8 d_mepd_data;
#define SEC_BASE d_mepd_data		/* address on secure flash area goes here */
#define SEC_DEV_BASE SEC_BASE		/* address to offset the flashdrivers from */
#define SEC_FLASH_SIZE 8192			/* size of the flash sector */


/* RSA heap or Flash buffer constants */
#if defined(FIRSTBOOT_RSA_ENABLED) || (defined(USE_RSAHEAP_FOR_FLASH) && !defined(FFS_MODE_ENABLED))
#define RSA_HEAP_SIZE 8192
#ifndef RSA_HEAP_IS_INTERNAL
#error "we need a 8K RAM buffer for heap during RSA decryption"
#define SEC_DRV_RSA_HEAP	xxx		/* address from where we can use 8K during firstboot */
#else /* RSA_HEAP_IS_INTERNAL */
#define SEC_DRV_RSA_HEAP &sec_drv_buffer[0]
#endif /* RSA_HEAP_IS_INTERNAL */
#endif /* defined(FIRSTBOOT_RSA_ENABLED) || defined(USE_RSAHEAP_FOR_FLASH) */


#define SEC_PATTERN_INITIALIZED		0xAA
#define SEC_PATTERN_UNINITIALIZED	0x55

#define SEC_DRV_KEY_MAX_LEN 16
#define DES_KEY_SIZE 8
#define SHA1_SIZE 20
#define IMEI_SIZE 8
#define CRYPT_BLOCK_SIZE 8

#define FFS_MEPD_FILENAME "/MEPD_File.bin"
#define FLASH_BACKUP_NAME "/flash_backup.bin"
#define BACKUP_BUF_SIZE 128


/*******************************************
				Macros
*******************************************/
#define ALIGN_CRYPT_BLOCK(x) ((x%CRYPT_BLOCK_SIZE)? x+CRYPT_BLOCK_SIZE-(x%CRYPT_BLOCK_SIZE) : x)

#ifdef SEC_TRACES_ENABLED
#define TRACE(a) test_trace(a)
#define HEXTRACE(str, data, size) hex_trace(str, data, size)
extern void test_trace(const char *str);
extern void hex_trace(const char *str, const void *in, unsigned long int size);
#else
#define TRACE(a) ((void)(0))
#define HEXTRACE(str, data, size) ((void)(0))
#endif


/*******************************************
			Type definitions
*******************************************/
typedef struct
{
	UINT8 firstboot_pattern;
} T_SEC_DRV_GLOBAL_CONF;

typedef struct 
{
	UINT8 digit[SEC_DRV_KEY_MAX_LEN];
} T_SEC_DRV_KEY;


/*******************************************
				Prototypes
*******************************************/
extern INT8 sec_drv_fast_write;
void sec_drv_flash_backup(void);
void sec_drv_remove_backup(void);
void sec_drv_erase_flash(void);
void sec_drv_read_flash(UINT32 offset, void *pDest, UINT32 size);
void sec_drv_write_flash(UINT32 offset, const void *pSrc, UINT32 size);

extern BOOL sec_prim_get_global_conf(T_SEC_DRV_GLOBAL_CONF *pGlobalConf);
extern BOOL sec_prim_set_global_conf(const T_SEC_DRV_GLOBAL_CONF *pGlobalConf);

extern BOOL sec_prim_get_configuration(T_SEC_DRV_CONFIGURATION *pConf);
extern BOOL sec_prim_set_configuration(const T_SEC_DRV_CONFIGURATION *pConf);

extern BOOL sec_prim_get_key(int rec_num, T_SEC_DRV_KEY *pKey);
extern BOOL sec_prim_set_key(int rec_num, const T_SEC_DRV_KEY *pKey);

extern BOOL sec_prim_get_cat_header(int rec_num, T_SEC_DRV_CAT_HDR *pHdr);
extern BOOL sec_prim_set_cat_header(int rec_num, const T_SEC_DRV_CAT_HDR *pHdr);

extern BOOL sec_prim_get_cat_body(int rec_num, void *pBody, UINT16 size);
extern BOOL sec_prim_set_cat_body(int rec_num, const void *pBody, UINT16 size);

#endif /* _SEC_DRV_PRIM_H_ */
