#-----------------------------------------------------------------------------
#  Project :
#  Modul   :  comlib.mak
#-----------------------------------------------------------------------------
#  Copyright 2002 Texas Instruments Berlin, AG
#                 All rights reserved.
#
#                 This file is confidential and a trade secret of Texas
#                 Instruments Berlin, AG
#                 The receipt of or possession of this file does not convey
#                 any rights to reproduce or disclose its contents or to
#                 manufacture, use, or sell anything it may describe, in
#                 whole, or in part, without the specific written consent of
#                 Texas Instruments Berlin, AG.
#-----------------------------------------------------------------------------
#|  Purpose :
#-----------------------------------------------------------------------------
#
#	Setting Directory for COMLIB Objects
#
OBJ := $(L23_OBJ_DIR)/comlib

SRCCOMLIB=$(CONDAT_DIR)/com/src/comlib


COMLIBOBJ= $(OBJ)/cl_ribu.$(OBJ_TAIL) \
	$(OBJ)/cl_md5.$(OBJ_TAIL)

ifeq ($(PMODE),2)
COMLIBOBJ += $(OBJ)/cl_rlcmac.$(OBJ_TAIL)
endif


#
# ---------------- create COMLIB ---------------------
#

$(TOP_DIR)/$(COMLIB_LIB) : $(OBJ) $(COMLIBOBJ) 
	$(AR) r $(TOP_DIR)/$(COMLIB_LIB) $(COMLIBOBJ)

$(OBJ):
	mkdir $(subst /,$(SLASH),$(OBJ))

clean:
	$(REMOVE) $(subst /,$(SLASH),$(OBJ))

$(COMLIBOBJ): $(OBJ)/%.$(OBJ_TAIL) : $(SRCCOMLIB)/%.c
	echo -D$(NCONFIG) >  cmd
#	echo -DNTRACE >> cmd
	echo -D$(NWARN) >> cmd
	echo $(COPT) >> cmd
	echo $(COPT1) >> cmd
	echo $(COTAR) >> cmd
	echo -I$(ICOM) >> cmd
	echo -I$(INUC) >> cmd
	echo -I$(ICDG) >> cmd
	echo -I$(ISAP_INLINE) >> cmd
	echo -fr$(OBJ) >> cmd
	$(CC_PRE) $^ -@cmd
	$(CC_INT) $(addsuffix .pp,$(basename $^))
	$(CC_COM) $(addsuffix .pp_,$(basename $^)) -@cmd
