/* 
+----------------------------------------------------------------------------- 
|  Project :  GSM-PS (6147)
|  Modul   :  
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  
+----------------------------------------------------------------------------- 
*/ 

#ifndef __VDBAPI_H__
#define __VDBAPI_H__

/*
 * @todo anpassen an routing information
 */

/*
 * Number of protocol stack entities witch concurrently uses the VDB
 */
#define VDB_MAX_ENTITIES     8

/*
 * Identifiers for the protocol stack entities. To use at
 * initialisation of the VDB (vdb_init()).
 */
#define VDB_MMI  7
#define VDB_SIM  6
#define VDB_SMS  5
#define VDB_SS   4
#define VDB_CC   3
#define VDB_MM   2
#define VDB_RR   1
#define VDB_DL   0


/*
 * Return codes for the state parameter of the vdb_read_req()
 */
#define VDB_ENTITY_VALID 1
#define VDB_ENTITY_EMPTY 2
#define VDB_ENTITY_UNDEF 0

/*
 * Definition to mark the assi parameter invalid
 * for the function vdb_update_req()
 */
#define VDB_INVALID_SSI  ((ULONG)-1L)

/*
 * definition of the VDB related part of the destination adress
 * fragment of the primitives used in the base station.
 */

typedef struct
{
  UBYTE vdb_id;
  ULONG vdb_handle;
  ULONG search_ssi;
  ULONG send_ssi;
} T_DEST_ADDR;


/* == PROTOTYPES OF THE FUNCTIONAL VDB IMPLEMENTATION ============ */

EXTERN BOOL vdb_reset      (void);

EXTERN BOOL vdb_init       (UBYTE          entity,
                            UBYTE          vdb_id);

EXTERN void vdb_read_req   (T_DEST_ADDR  * da,
                            UBYTE          entity,
                            void         **entry,
                            UBYTE        * state);

EXTERN void vdb_update_req (T_DEST_ADDR  * da,
                            UBYTE          entity,
                            void         * entry,
                            ULONG          assi);

EXTERN void vdb_free_req   (T_DEST_ADDR  * da,
                            UBYTE          entity);

EXTERN void vdb_unlock_req (T_DEST_ADDR  * da);

/* == MACRODEFINITION FOR THE VARIOUS REALISATIONS OF THE VDB == */

#ifdef VDB_AS_A_MODULE

#define VDB_READ_REQ(l,d,e,v,s)  void * v; UBYTE s; vdb_read_req (d,e,&v,&s)
#define VDB_NET_READ_REQ(l,p,e,v,s)  void * v; UBYTE s; NET_TO_DEST(p);\
                                     vdb_read_req (&dest_addr,e,&v,&s)
#define VDB_UNLOCK_REQ(d)        vdb_unlock_req (d);
#define VDB_UPDATE_REQ(d,e,v,a)  vdb_update_req (d,e,v,a)
#define VDB_FREE_REQ(d,e)        vdb_free_req (d,e);

#else
#ifdef VDB_AS_A_SERVER
/*
 * opcodes may be defined by server stub
 */
#define READ_REQ   1
#define UPDATE_REQ 2
#define FREE_REQ   3

#define VDB_READ_REQ(l,d,e,v,s)  void * v; UCHAR s; vdb (READ_REQ,d,e,&v,&s)
#define VDB_NET_READ_REQ(l,p,e,v,s)  void * v; UCHAR s; NET_TO_DEST(p);\
                                     vdb (READ_REQ,&dest_addr,e,&v,&s)
#define VDB_UNLOCK_REQ(d)        vdb (UNLOCK_REQ, d)
#define VDB_UPDATE_REQ(d,e,v,a)  vdb (UPDATE_REQ, d,e,v,a)
#define VDB_FREE_REQ(d,e)        vdb (FREE_REQ,   d,e)

#else
#ifdef VDB_AS_A_PROCESS
/*
 * Not defined yet
 */
#define VDB_READ_REQ(l,d,e,v,s)  void l(); send_vdb_read_req (l,d,e); }\
                                 void l(T_DEST_ADDR * d, void **v, UBYTE *s) {
#define VDB_NET_READ_REQ(l,p,e,v,s)  void l(); NET_TO_DEST(p);\
                                     send_vdb_read_req (l,&dest_addr,e); }\
                                     void l(T_DEST_ADDR * d, void **v, UBYTE *s) {
#define VDB_UNLOCK_REQ(d)        send_vdb_read_req (d)
#define VDB_UPDATE_REQ(d,e,v,a)  send_vdb_update_req (d,e,v,a)
#define VDB_FREE_REQ(d,e)        send_vdb_free_req (d,e)

#endif
#endif
#endif

#endif

