#ifndef _SEC_DRV_H_
#define _SEC_DRV_H_


/*******************************************
				Constants
*******************************************/
/*
 * Maximum size of category body
 */
#define SEC_DRV_CAT_MAX_SIZE	256	/* MUST be 8-aligned! */


/*
 * Defines for the first 6 lock-categories
 */
enum E_SEC_DRV_CAT_NUM
{
	SEC_DRV_CAT_NUM_NW = 0,
	SEC_DRV_CAT_NUM_NS,
	SEC_DRV_CAT_NUM_SP,
	SEC_DRV_CAT_NUM_CP,
	SEC_DRV_CAT_NUM_SIM,
	SEC_DRV_CAT_NUM_AP
};


/* 
 * Define of the different flags that may be
 * set in the MEPD configuration
 */
enum E_SEC_DRV_CONF_FLAG
{
  SEC_DRV_HDR_FLAG_Truncation		= 0x0004,
	SEC_DRV_HDR_FLAG_ETSI_Flag		= 0x0008,
	SEC_DRV_HDR_FLAG_Spec_Lock_Key	= 0x0010,
	SEC_DRV_HDR_FLAG_LAM_Unlock		= 0x0020,
	SEC_DRV_HDR_FLAG_No_SIM_Unlock	= 0x0040,
	SEC_DRV_HDR_FLAG_Airtel_Ind		= 0x0080,
	SEC_DRV_HDR_FLAG_Unlock_Timer	= 0x0100
};


/*
 * Status defines for the different
 * lock-categories
 */
enum E_SEC_DRV_CAT_STATUS
{
	SEC_DRV_CAT_STAT_Unlocked = 0,
	SEC_DRV_CAT_STAT_PermUnlocked,
	SEC_DRV_CAT_STAT_Locked
};


/*
 * Different flags for the lock-categories
 */
enum E_SEC_DRV_CAT_FLAG
{
	SEC_DRV_CAT_FLAG_LinkLocked = 0x01,	/* if the category is dependent on a parent.
										   Disable locking/unlocking on its own! */
	SEC_DRV_CAT_FLAG_UseSeed    = 0x02	/* Use seed to generate key during first boot */
};


/*******************************************
			Type definitions
*******************************************/
/*
 * Possible return values for the diff. functions.
 */
typedef enum
{
	SEC_DRV_RET_NotPresent	= -1,
	SEC_DRV_RET_Ok			= 0,
	SEC_DRV_RET_KeyMismatch	= 1,
	SEC_DRV_RET_KeyWrong	= 2,
	SEC_DRV_RET_FCExeeded	= 3,
	SEC_DRV_RET_Unknown		= 4
} T_SEC_DRV_RETURN;


/*
 * Lock types for sec_rec_Unlock
 */
typedef enum
{
	TEMPORARY_UNLOCK,
	PERMANENT_UNLOCK
} T_SEC_DRV_UNLOCK_TYPE;


/*
 * MEPD Configuration.
 * Only read-access to this structure is provided.
 *
 * This is a read only structure for the client (ACI layer)
 */
typedef struct
{
	UINT16	Flags;			/* See E_SEC_DRV_CONF_FLAG */
	UINT16  AddNewIMSI;		/* Handled by ACI Layer */
	UINT8	NumCategories;
	UINT8	FC_Max;			/* Failure Counter maximum */
	UINT8	FC_Current;		/* Current value of the Failure Counter */
	UINT8	FC_Key_Length;
	UINT8	FC_Reset_Fail_Max;
	UINT8	FC_Reset_Fail_Current;
	UINT8	FC_Reset_Success_Max;
	UINT8	FC_Reset_Success_Current;
	UINT8	MNC_Len;		/* Handled by ACI Layer */
	UINT8	GID1_Len;		/* Handled by ACI Layer */
	UINT8	GID2_Len;		/* Handled by ACI Layer */
	UINT8	TypeAprovalSIM;	/* Handled by ACI Layer */
	UINT8	TestCPHS;		/* Handled by ACI Layer */
} T_SEC_DRV_CONFIGURATION;


/*
 * Header part for a lock-category
 *
 * This is a read only structure for the client (ACI layer)
 */
typedef struct
{
	UINT8	Status;			/* see E_SEC_DRV_CAT_STATUS */
	UINT8	Flags;			/* see E_SEC_DRV_CAT_FLAG */
	UINT16	Dependency;
	UINT16	DataLen;
	UINT8	KeyLength;
} T_SEC_DRV_CAT_HDR;


/*
 * MEPD Category.
 */
typedef struct
{
	T_SEC_DRV_CAT_HDR	Header;
	void				*pBody; /* pointer to array of client data */
} T_SEC_DRV_CATEGORY;


/*******************************************
				Prototypes
*******************************************/
/* sec_get_imei...  missing! use cl_get_imei in comlib instead */
extern T_SEC_DRV_RETURN sec_get_CFG(T_SEC_DRV_CONFIGURATION **ppConfiguration);
extern T_SEC_DRV_RETURN sec_cmp_KEY(UINT8 rec_num, const char *pKey, UINT8 key_len);
extern T_SEC_DRV_RETURN sec_set_KEY(UINT8 rec_num, const char *pOldKey, const char *pNewKey, UINT8 key_len);
extern T_SEC_DRV_RETURN sec_set_FC_KEY(const char *pOldKey, const char *pNewKey);
extern T_SEC_DRV_RETURN sec_get_REC(UINT8 rec_num, T_SEC_DRV_CATEGORY **ppCategory);
extern T_SEC_DRV_RETURN sec_set_REC(UINT8 rec_num, const T_SEC_DRV_CATEGORY *pCategory);
extern T_SEC_DRV_RETURN sec_rec_Unlock(UINT8 rec_num, T_SEC_DRV_UNLOCK_TYPE unlockType, const char *pKey, UINT8 key_len, UINT16 dependMask);
extern T_SEC_DRV_RETURN sec_rec_Lock(UINT8 rec_num, const char *pKey, UINT8 key_len, UINT16 dependMask);
extern T_SEC_DRV_RETURN sec_FC_Reset(const char *pKey, UINT8 key_len);
extern T_SEC_DRV_RETURN sec_FC_Increment(void);

#endif //_SEC_DRV_H_
