/* 
+----------------------------------------------------------------------------- 
|  Project :  GSM-MFW
|  Modul   :  
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  Types definitions for the permanent memory configuration
|             THIS PCM2.H IS A EXTENSION OF THE PCM.H
|             .
+----------------------------------------------------------------------------- 
*/ 

#ifndef DEF_PCM2
#define DEF_PCM2

#define PCM_SIZE 1111

/********************************************************************
 *
 * Parameters written in flash memory
 *
 ********************************************************************/


/********************************************************************
 *
 * Field Identitifer
 *
 ********************************************************************/

#define EF_set2_ID      "SET2"          /* User profiles            */  	 
#define EF_ctim2_ID     "CTIM2"         /* timer  calls             */ 
#define EF_sfk2_ID	    "SFK2"          /* Program.key information  */ 
#define EF_plmn2_ID     "PLMN2"         /* Last selec. manual PLMN identifier */ 
#define EF_mid_ID	    "MID"           /* Cell Broadcast MID attributes      */  
#define EF_t9_ID        "T9"            /* T9   */





/********************************************************************
 *
 * Field USER PROFILES
 *
 ********************************************************************/

typedef struct EFset2                    /* USER PROFILES       */
{
    UBYTE buzzExt1;                      /* buzzer              */
    UBYTE buzzExt2;                      /* buzzer              */
    UBYTE buzzExt3;                      /* buzzer              */
    UBYTE buzzExt4;                      /* buzzer              */
    UBYTE buzzExt5;                      /* buzzer              */
    UBYTE buzzExt6;                      /* buzzer              */
    UBYTE buzzExt7;                      /* buzzer              */
    UBYTE audioExt1;                     /* audio               */
    UBYTE audioExt2;                     /* audio               */
    UBYTE iconExt1;                      /* icon                */
    UBYTE iconExt2;                      /* icon                */
    UBYTE langExt;                       /* language of SMS     */
} EF_SET2;
                            
#define SIZE_EF_SET2 12            
#define NR_EF_SET2   1            

/*
 *  BuzzerExt1             
 */
#define callvol      0x0000000F,0        /* ringer volume for incoming calls*/
#define callvolm     0x0000000F
#define callvols     0
#define msgvol       0x000000F0,4        /* ringer volume for incoming messages */
#define msgvolm      0x000000F0
#define msgvols      4

/*
 *  BuzzerExt2             
 */
#define broavol      0x0000000F,0        /* ringer volume for incoming broadcast messages*/
#define broavolm     0x0000000F
#define broavols     0

/*
 *  BuzzerExt3             
 */
#define calltyp      0x000000FF,0        /* ringer type for incoming calls */
#define calltypm     0x000000FF
#define calltyps     0

/*
 *  BuzzerExt4             
 */
#define msgtyp       0x000000FF,0        /* ringer type for incoming messages*/
#define msgtypm      0x000000FF
#define msgtyps      0

/*
 *  BuzzerExt5             
 */
#define broatyp      0x000000FF,0        /* ringer for incoming broadcast messages*/
#define broatypm     0x000000FF
#define broatyps     0

/*
 *  BuzzerExt6             
 */
#define batw         0x00000001,0        /* low battery warning */
#define batwm        0x00000001
#define batws        0

/*
 *  AudioExt1             
 */
#define EarVolHn     0x00000007,0        /* Earpiece Volume Handsfree Kit */
#define EarVolHnm    0x00000007
#define EarVolHns    0

/*
 *  IconExt2             
 */
#define sms          0x00000001,0        /* SMS message */
#define smsm         0x00000001
#define smss         0
#define vmai         0x00000002,1        /* Voice mail */
#define vmaim        0x00000002
#define vmais        1
#define cfu          0x00000004,2        /* call forwarding unconditional */
#define cfum         0x00000004
#define cfus         2
#define silent       0x00000008,3        /* silent ringer */
#define silentm      0x00000008
#define silents      3
#define ring         0x00000010,4        /* ringer */
#define ringm        0x00000010
#define rings        4
#define vib          0x00000020,5        /* vibrator */
#define vibm         0x00000020
#define vibs         5
#define rinvi        0x00000040,6        /* ringer and vibrator */
#define rinvim       0x00000040
#define rinvis       6
#define keyp         0x00000080,7        /* keypad lock */
#define keypm        0x00000080
#define keyps        7

/*
 *  LanguageExt2             
 */
#define langSms      0x000000FF,0        /* language of SMS */
#define langSmsm     0x000000FF
#define langSmss     0


/********************************************************************
 *
 * FIELD CALL TIMER
 *
 ********************************************************************/

typedef struct EFctim2                   /* CALL TIMER */
{
    UBYTE InAccm[4];
    UBYTE OutAccm[4];
} EF_CTIM2;

#define SIZE_EF_CTIM 16
#define NR_EF_CTIM 1


/********************************************************************
 *
 * FIELD SPECIAL FUNCTION KEYS 2
 *
 ********************************************************************/

typedef struct EFsfk2                 /* SPECIAL FUNCTION KEYS 2 */
{
    UBYTE  keyboard;
    UBYTE  hotkeys;
} EF_SFK2; 
          
#define SIZE_EF_SFK2  3
#define NR_EF_SFK2    1

/* 
 * keyboard                        
 */
#define keylo        0x00000001,0        /* keyboard lock           */
#define keylom       0x00000001
#define keylos       0
#define answ         0x00000002,1        /* any key answer           */
#define answm        0x00000002
#define answs        1
#define cfu          0x00000004,2        /* call forwarding unconditional  */
#define cfum         0x00000004
#define cfus         2

/* 
 * hotkeys                        
 */


 /* have to define the hotkeys !*/




/********************************************************************
 *
 * FIELD LAST SELECTED MANUAL PLMN IDENTIFIER
 *
 ********************************************************************/

typedef struct EFplmn2        /* LAST SELECTED MANUAL PLMN IDENTIFIER   */
{
    UBYTE mccLast [2];          /* Mobile country code    */
    UBYTE mncLast [2];          /* Mobile network code   */
}EF_PLMN2;

#define SIZE_EF_PLMN2  6
#define NR_EF_PLMN2    1




/********************************************************************
 *
 * Field Cell Broadcast MID attributes
 *
 ********************************************************************/

typedef struct EFmid                  /* Cell Broadcast MID attributes */
{
    UBYTE msgId [2];
    UBYTE tag [10];
    UBYTE dcs [2];
}EF_MID;
       
#define SIZE_EF_MID 14
#define NR_EF_MID   1

/********************************************************************
 *
 * Field T9
 *
 ********************************************************************/

typedef struct EFt9                  /* T9 */
{
    UBYTE dict ;    /* dummy    */

}EF_T9;
       
#define SIZE_EF_T9 14
#define NR_EF_T9   1

 /* have to define T9  ! */


#endif

