/* 
+----------------------------------------------------------------------------- 
|  Project :  GSM-PS (6147)
|  Modul   :  
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  
+----------------------------------------------------------------------------- 
*/ 
#if !defined OFE_H
#define OFE_H

#include "vsi.h"


#define dmya_pei_create     ofe_dmya_pei_create
#define dmyb_pei_create     ofe_dmyb_pei_create
#define aci_pei_create      ofe_aci_pei_create
#define cst_pei_create      ofe_cst_pei_create
#define cc_pei_create       ofe_cc_pei_create
#define sim_pei_create      ofe_sim_pei_create
#define sms_pei_create      ofe_sms_pei_create
#define ss_pei_create       ofe_ss_pei_create
#define mm_pei_create       ofe_mm_pei_create
#define rr_pei_create       ofe_rr_pei_create
#define pl_pei_create       ofe_pl_pei_create
#define dl_pei_create       ofe_dl_pei_create
#define rlp_pei_create      ofe_rlp_pei_create
#define l2r_pei_create      ofe_l2r_pei_create
#define t30_pei_create      ofe_t30_pei_create
#define fad_pei_create      ofe_fad_pei_create
#define ra_pei_create       ofe_ra_pei_create
#define l1_pei_create       ofe_l1_pei_create

#define dmya_pei_init     ofe_dmya_pei_init
#define dmyb_pei_init     ofe_dmyb_pei_init
#define aci_pei_init      ofe_aci_pei_init
#define cst_pei_init      ofe_cst_pei_init
#define cc_pei_init       ofe_cc_pei_init
#define sim_pei_init      ofe_sim_pei_init
#define sms_pei_init      ofe_sms_pei_init
#define ss_pei_init       ofe_ss_pei_init
#define mm_pei_init       ofe_mm_pei_init
#define rr_pei_init       ofe_rr_pei_init
#define pl_pei_init       ofe_pl_pei_init
#define dl_pei_init       ofe_dl_pei_init
#define rlp_pei_init      ofe_rlp_pei_init
#define l2r_pei_init      ofe_l2r_pei_init
#define t30_pei_init      ofe_t30_pei_init
#define fad_pei_init      ofe_fad_pei_init
#define ra_pei_init       ofe_ra_pei_init
#define l1_pei_init       ofe_l1_pei_init

#define dmya_pei_primitive     ofe_dmya_pei_primitive
#define dmyb_pei_primitive     ofe_dmyb_pei_primitive
#define aci_pei_primitive      ofe_aci_pei_primitive
#define cst_pei_primitive      ofe_cst_pei_primitive
#define cc_pei_primitive       ofe_cc_pei_primitive
#define sim_pei_primitive      ofe_sim_pei_primitive
#define sms_pei_primitive      ofe_sms_pei_primitive
#define ss_pei_primitive       ofe_ss_pei_primitive
#define mm_pei_primitive       ofe_mm_pei_primitive
#define rr_pei_primitive       ofe_rr_pei_primitive
#define pl_pei_primitive       ofe_pl_pei_primitive
#define dl_pei_primitive       ofe_dl_pei_primitive
#define rlp_pei_primitive      ofe_rlp_pei_primitive
#define l2r_pei_primitive      ofe_l2r_pei_primitive
#define t30_pei_primitive      ofe_t30_pei_primitive
#define fad_pei_primitive      ofe_fad_pei_primitive
#define ra_pei_primitive       ofe_ra_pei_primitive
#define l1_pei_primitive       ofe_l1_pei_primitive

#define dmya_pei_config     ofe_dmya_pei_config
#define dmyb_pei_config     ofe_dmyb_pei_config
#define aci_pei_config      ofe_aci_pei_config
#define cst_pei_config      ofe_cst_pei_config
#define cc_pei_config       ofe_cc_pei_config
#define sim_pei_config      ofe_sim_pei_config
#define sms_pei_config      ofe_sms_pei_config
#define ss_pei_config       ofe_ss_pei_config
#define mm_pei_config       ofe_mm_pei_config
#define rr_pei_config       ofe_rr_pei_config
#define pl_pei_config       ofe_pl_pei_config
#define dl_pei_config       ofe_dl_pei_config
#define rlp_pei_config      ofe_rlp_pei_config
#define l2r_pei_config      ofe_l2r_pei_config
#define t30_pei_config      ofe_t30_pei_config
#define fad_pei_config      ofe_fad_pei_config
#define ra_pei_config       ofe_ra_pei_config
#define l1_pei_config       ofe_l1_pei_config

#define GET_STATE  OFE_GET_STATE
#define SET_STATE  OFE_SET_STATE

#define vsi_c_awake   ofe_vsi_c_awake
#define vsi_o_strace  ofe_vsi_o_strace
#define vsi_o_trace   ofe_vsi_o_trace
#define vsi_o_assert  ofe_vsi_o_assert
#define vsi_t_open    ofe_vsi_t_open
#define vsi_t_close   ofe_vsi_t_close
#define vsi_t_start   ofe_vsi_t_start
#define vsi_t_stop    ofe_vsi_t_stop
#define vsi_t_pstart  ofe_vsi_t_pstart
#define vsi_t_status  ofe_vsi_t_status
#define vsi_c_await   ofe_vsi_c_await

#ifdef NTRACE

  #define OFE_SET_STATE(PROCESS,STATE)    ENTITY_DATA->state[PROCESS] = STATE
  #define OFE_GET_STATE(PROCESS)          ENTITY_DATA->state[PROCESS]

#else

  #define OFE_SET_STATE(PROCESS,STATE)\
                ENTITY_DATA->state[PROCESS] =\
                vsi_o_strace (VSI_CALLER\
                              PROCESS_NAME[PROCESS],\
                              PROCESS##_NAME [ ENTITY_DATA->state[PROCESS] ],\
                              PROCESS##_NAME [              STATE          ],\
                                                            STATE              )

#define OFE_GET_STATE(PROCESS)\
                vsi_o_strace (VSI_CALLER\
                              PROCESS_NAME[PROCESS],\
                              PROCESS##_NAME [ ENTITY_DATA->state[PROCESS] ],\
                                                            NULL            ,\
                                               ENTITY_DATA->state[PROCESS]     )

#endif



#undef VSI_CALLER
#undef VSI_CALLER_SINGLE


#ifdef ENTITY_DMYA
extern USHORT DMYA_Handle;
#define VSI_CALLER  (USHORT)DMYA_Handle,
#define VSI_CALLER_SINGLE  (USHORT)DMYA_Handle
#endif

#ifdef ENTITY_DMYB
extern USHORT DMYB_Handle;
#define VSI_CALLER  (USHORT)DMYB_Handle,
#define VSI_CALLER_SINGLE  (USHORT)DMYB_Handle
#endif

#if defined ENTITY_SMI || ENTITY_ACI || ENTITY_MFW || ENTITY_MMI
extern USHORT ACI_Handle;
#define VSI_CALLER  (USHORT)(USHORT)ACI_Handle,
#define VSI_CALLER_SINGLE  (USHORT)ACI_Handle
#define SIM (USHORT)aci_hCommSIM 
#define MM (USHORT)aci_hCommMM 
#define CC (USHORT)aci_hCommCC 
#define SMS (USHORT)aci_hCommSMS 
#define SS (USHORT)aci_hCommSS 
#define PL (USHORT)aci_hCommPL 
#define SMI (USHORT)aci_hCommSMI
#define ACI (USHORT)aci_hCommACI
#define MMI (USHORT)aci_hCommMMI
#define RA (USHORT)aci_hCommRA 
#define L2R (USHORT)aci_hCommL2R 
#define T30 (USHORT)aci_hCommT30
#define pei_handle_signal aci_pei_handle_signal
#define mmi_pei_signal old_mmi_pei_signal
#define signalQueue MMIsignalQueue
#define signalIn MMIsignalIn
#define signalOut MMIsignalOut

#define PSIGNAL_SELF          OFE_PSIGNAL_SELF

#define OFE_PSIGNAL_SELF(A,B) { T_QMSG Message;\
                                USHORT com = vsi_c_open ( VSI_CALLER "ACI" );\
                                Message.MsgType = MSG_SIGNAL;\
                                Message.Msg.Signal.SigOPC = (USHORT)A;\
                                Message.Msg.Signal.SigBuffer = (void*)B;\
                                vsi_c_send ( VSI_CALLER com, &Message );}
#endif

#ifdef ENTITY_CST
extern USHORT CST_Handle;
#define VSI_CALLER  (USHORT)CST_Handle,
#define VSI_CALLER_SINGLE  (USHORT)CST_Handle
#define L1 (USHORT)cst_hCommL1
#endif

#ifdef ENTITY_CC
extern USHORT CC_Handle;
#define VSI_CALLER  (USHORT)CC_Handle,
#define VSI_CALLER_SINGLE  (USHORT)CC_Handle
#define MMI (USHORT)cc_hCommMMI
#define MM (USHORT)cc_hCommMM
#endif

#ifdef ENTITY_SMS
extern USHORT SMS_Handle;
#define VSI_CALLER  (USHORT)SMS_Handle,
#define VSI_CALLER_SINGLE  (USHORT)SMS_Handle
#define MMI (USHORT)sms_hCommMMI 
#define MM (USHORT)sms_hCommMM
#define SIM (USHORT)sms_hCommSIM 
#endif

#ifdef ENTITY_SIM
extern USHORT SIM_Handle;
#define VSI_CALLER  (USHORT)SIM_Handle,
#define VSI_CALLER_SINGLE  (USHORT)SIM_Handle
#define MMI (USHORT)sim_hCommMMI 
#define MM (USHORT)sim_hCommMM 
#define SMS (USHORT)sim_hCommSMS 
#endif

#ifdef ENTITY_SS
extern USHORT SS_Handle;
#define VSI_CALLER  (USHORT)SS_Handle,
#define VSI_CALLER_SINGLE  (USHORT)SS_Handle
#define MMI (USHORT)ss_hCommMMI
#define MM (USHORT)ss_hCommMM 
#endif

#ifdef ENTITY_MM
extern USHORT MM_Handle;
#define VSI_CALLER  (USHORT)MM_Handle,
#define VSI_CALLER_SINGLE  (USHORT)MM_Handle
#define MMI (USHORT)mm_hCommMMI 
#define CC (USHORT)mm_hCommCC 
#define SS (USHORT)mm_hCommSS 
#define SMS (USHORT)mm_hCommSMS 
#define RR (USHORT)mm_hCommRR 
#define DL (USHORT)mm_hCommDL 
#define SIM (USHORT)mm_hCommSIM
#endif

#ifdef ENTITY_RR
extern USHORT RR_Handle;
#define VSI_CALLER  (USHORT)RR_Handle,
#define VSI_CALLER_SINGLE  (USHORT)RR_Handle
#define DL (USHORT)rr_hCommDL 
#define MM (USHORT)rr_hCommMM 
#define PL (USHORT)rr_hCommPL 
#endif

#ifdef ENTITY_PL
extern USHORT PL_Handle;
#define VSI_CALLER  (USHORT)PL_Handle,
#define VSI_CALLER_SINGLE  (USHORT)PL_Handle
#define PL (USHORT)pl_hCommPL 
#define L1 (USHORT)pl_hCommL1 
#define DL (USHORT)pl_hCommDL 
#define RR (USHORT)pl_hCommRR 
#define MMI (USHORT)pl_hCommMMI 
#define CST (USHORT)pl_hCommCST 
#define vsi_t_sleep   ofe_vsi_t_sleep
#endif

#ifdef ENTITY_DL
extern USHORT DL_Handle;
#define VSI_CALLER  (USHORT)DL_Handle,
#define VSI_CALLER_SINGLE  (USHORT)DL_Handle
#define RR (USHORT)dl_hCommRR 
#define MM (USHORT)dl_hCommMM 
#define PL (USHORT)dl_hCommPL 
#endif

#ifdef ENTITY_RLP
extern USHORT RLP_Handle;
#define VSI_CALLER  (USHORT)RLP_Handle,
#define VSI_CALLER_SINGLE  (USHORT)RLP_Handle
#define L2R (USHORT)rlp_hCommL2R 
#define RA (USHORT)rlp_hCommRA
#define pei_handle_signal rlp_pei_handle_signal
#define rlp_pei_signal old_rlp_pei_signal
#define signalQueue RLPsignalQueue
#define signalIn RLPsignalIn
#define signalOut RLPsignalOut
#endif

#ifdef ENTITY_L2R
extern USHORT L2R_Handle;
#define VSI_CALLER  (USHORT)L2R_Handle,
#define VSI_CALLER_SINGLE  (USHORT)L2R_Handle
#define L2R (USHORT)l2r_hCommL2R 
#define RA (USHORT)l2r_hCommRA 
#define MMI (USHORT)l2r_hCommMMI 
#define RLP (USHORT)l2r_hCommRLP 
#define pei_handle_signal l2r_pei_handle_signal
#define l2r_pei_signal old_l2r_pei_signal
#define signalQueue L2RsignalQueue
#define signalIn L2RsignalIn
#define signalOut L2RsignalOut

#define PSIGNAL_SELF          OFE_PSIGNAL_SELF

#ifdef MEMORY_SUPERVISION
#define OFE_PSIGNAL_SELF(A,B) { T_QMSG Message;\
                                USHORT com = vsi_c_open ( VSI_CALLER "L2R" );\
                                Message.MsgType = MSG_SIGNAL;\
                                Message.Msg.Signal.SigOPC = (USHORT)A;\
                                Message.Msg.Signal.SigBuffer = (void*)B;\
                                vsi_c_send ( VSI_CALLER com, &Message, __FILE,__LINE__ );}
#else
#define OFE_PSIGNAL_SELF(A,B) { T_QMSG Message;\
                                USHORT com = vsi_c_open ( VSI_CALLER "L2R" );\
                                Message.MsgType = MSG_SIGNAL;\
                                Message.Msg.Signal.SigOPC = (USHORT)A;\
                                Message.Msg.Signal.SigBuffer = (void*)B;\
                                vsi_c_send ( VSI_CALLER com, &Message );}
#endif
#endif

#ifdef ENTITY_FAD
extern USHORT FAD_Handle;
#define VSI_CALLER  (USHORT)FAD_Handle,
#define VSI_CALLER_SINGLE  (USHORT)FAD_Handle
#define RA (USHORT)fad_hCommRA 
#define T30 (USHORT)fad_hCommT30 
#define pei_handle_signal fad_pei_handle_signal
#define fad_pei_signal old_fad_pei_signal
#define signalQueue FADsignalQueue
#define signalIn FADsignalIn
#define signalOut FADsignalOut
#endif

#ifdef ENTITY_T30
extern USHORT T30_Handle;
#define VSI_CALLER  (USHORT)T30_Handle,
#define VSI_CALLER_SINGLE  (USHORT)T30_Handle
#define MMI (USHORT)t30_hCommMMI 
#define FAD (USHORT)t30_hCommFAD 
#endif

#ifdef ENTITY_RA
extern USHORT RA_Handle;
#define VSI_CALLER  (USHORT)RA_Handle,
#define VSI_CALLER_SINGLE  (USHORT)RA_Handle
#define L2R (USHORT)ra_hCommL2R 
#define MMI (USHORT)ra_hCommMMI 
#define RLP (USHORT)ra_hCommRLP 
#define FAD (USHORT)ra_hCommFAD 

#define PSIGNAL               OFE_PSIGNAL

#ifdef MEMORY_SUPERVISION
#define OFE_PSIGNAL(A,B,C)    { T_QMSG Message;\
                                Message.MsgType = MSG_SIGNAL;\
                                Message.Msg.Signal.SigOPC = (USHORT)B;\
                                Message.Msg.Signal.SigBuffer = (void*)C;\
                                vsi_c_send ( VSI_CALLER A, &Message, __FILE__,__LINE__ );}
#else
#define OFE_PSIGNAL(A,B,C)    { T_QMSG Message;\
                                Message.MsgType = MSG_SIGNAL;\
                                Message.Msg.Signal.SigOPC = (USHORT)B;\
                                Message.Msg.Signal.SigBuffer = (void*)C;\
                                vsi_c_send ( VSI_CALLER A, &Message );}
#endif
#endif

#ifdef ENTITY_L1
extern USHORT L1_Handle;
#define VSI_CALLER  (USHORT)L1_Handle,
#define VSI_CALLER_SINGLE  (USHORT)L1_Handle
#define l1_pei_run  ofe_l1_pei_run
#endif

#endif
