/*
+-----------------------------------------------------------------------------
|  Project :  COMLIB
|  Modul   :  cl_shrd
+-----------------------------------------------------------------------------
|  Copyright 2002 Texas Instruments Berlin, AG
|                 All rights reserved.
|
|                 This file is confidential and a trade secret of Texas
|                 Instruments Berlin, AG
|                 The receipt of or possession of this file does not convey
|                 any rights to reproduce or disclose its contents or to
|                 manufacture, use, or sell anything it may describe, in
|                 whole, or in part, without the specific written consent of
|                 Texas Instruments Berlin, AG.
+-----------------------------------------------------------------------------
|  Purpose :  Definitions of global types used by common library functions
|             and the prototypes of those functions.
+-----------------------------------------------------------------------------
*/
/*
 *  Version 1.0
 */

/**********************************************************************************/
#ifndef CL_SHRD_H
#define CL_SHRD_H

/*====STRUCTURE DEFINITION=========================================*/

typedef struct
{
  UBYTE service_mode;
  U16   lac;
  U8    mcc [3];
  U8    mnc [3];
  USHORT cell_id;
}T_LOC_INFO;

typedef struct
{
  UBYTE me_status;
  UBYTE tm_adv;
}T_TIM_ADV;

typedef struct
{
  T_LOC_INFO location_info;
  T_TIM_ADV timing_advance;
}T_SHRD_DATA;

EXTERN T_SHRD_DATA *shared_data;
/*=================================================================*/

/*====FUNCTION PROTOTYPE===========================================*/

EXTERN void cl_shrd_init (T_HANDLE handle);
EXTERN void cl_shrd_exit (void);
EXTERN BOOL cl_shrd_get_loc (T_LOC_INFO *loc_info);
EXTERN void cl_shrd_set_loc (T_LOC_INFO *loc_info);
EXTERN BOOL cl_shrd_get_tim_adv(T_TIM_ADV *tim_adv);
EXTERN void cl_shrd_set_tim_adv(T_TIM_ADV *tim_adv);

/*=================================================================*/
#endif   /* CL_SHRD_H */