;/******************************************************************************
; *
; * BOOTLOADER.S
; *
; * This module initializes the system stack for the bootloader and calls the bootloader.
; * If the bootloader starts the function INT_Initialize is called.
; *
; * (C) Texas Instruments 1999
; *
; *****************************************************************************/

;
;/* Define constants used in low-level initialization.  */
;

LOCKOUT         .equ    00C0h               ; Interrupt lockout value
MODE_MASK       .equ    001Fh               ; Processor Mode Mask
SUP_MODE        .equ    0013h               ; Supervisor Mode (SVC)

SYSTEM_SIZE     .equ     1024               ; Define the system stack size

                .ref    _sta_select_application
                .ref    _INT_Initialize    

                .ref    end                 ; Ending address of BSS section


                .sect   ".text"        

                .def _INT_Bootloader_Start



addrCS0	      	.word	0xfffffb00		;CS0 address space


          .if   BOARD = 6        ; EVA4
          .if CHIPSET != 12
CS0_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS1_MEM_REG   .short  0x281  ; 1 Dummy Cycle  8 bit 1 WS SW BP enable
CS2_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS3_MEM_REG   .short  0x283  ; 1 Dummy Cycle  8 bit 3 WS SW BP enable
CS4_MEM_REG   .short  0xe85  ; default reset value
          .endif

            .if CHIPSET = 3
CS6_MEM_REG   .short  0x2c0  ; 1 Dummy Cycle 32 bit 0 WS SW BP enable

            .elseif CHIPSET = 4
CS6_MEM_REG   .short  0x2c0  ; 1 Dummy Cycle 32 bit 0 WS SW BP enable
CS7_MEM_REG   .short  0x0c0	 ; Internal RAM   init : 0 WS, 32 bits, little, write enable

            .elseif CHIPSET = 5
CS6_MEM_REG   .short  0x2c0  ; 1 Dummy Cycle 32 bit 0 WS SW BP enable

            .elseif CHIPSET = 6
CS6_MEM_REG   .short  0x2c0  ; 1 Dummy Cycle 32 bit 0 WS SW BP enable

            .elseif CHIPSET = 7
CS6_MEM_REG   .short  0x0c0  ; 0 Dummy Cycle 32 bit 0 WS SW BP enable
CS7_MEM_REG   .short  0x040	 ; Internal BOOT ROM - 0 WS, 32 bits, little, write disable

            .elseif CHIPSET = 8
CS6_MEM_REG   .short  0x0c0  ; 0 Dummy Cycle 32 bit 0 WS SW BP enable
CS7_MEM_REG   .short  0x040	 ; Internal BOOT ROM - 0 WS, 32 bits, little, write disable

            .elseif CHIPSET = 10
CS6_MEM_REG   .short  0x0c0  ; 0 Dummy Cycle 32 bit 0 WS SW BP enable
CS7_MEM_REG   .short  0x040	 ; Internal BOOT ROM - 0 WS, 32 bits, little, write disable

            .elseif CHIPSET = 11
CS6_MEM_REG   .short  0x0c0  ; 0 Dummy Cycle 32 bit 0 WS SW BP enable
CS7_MEM_REG   .short  0x040	 ; Internal BOOT ROM - 0 WS, 32 bits, little, write disable

            .elseif CHIPSET = 12
CS0_MEM_REG   .short  0x2a1  ; CALYPSO PLUS TEST MODE - TO BE ERASED - 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS4_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS5_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
            .endif

          .elseif   BOARD = 7        ; B-Sample
CS0_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS1_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS2_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS3_MEM_REG   .short  0x283  ; 1 Dummy Cycle  8 bit 3 WS SW BP enable
CS4_MEM_REG   .short  0x281  ; 1 Dummy Cycle  8 bit 1 WS SW BP enable

            .if CHIPSET = 3
CS6_MEM_REG   .short  0x2c0  ; 1 Dummy Cycle 32 bit 0 WS SW BP enable

            .elseif CHIPSET = 4
CS6_MEM_REG   .short  0x2c0  ; 1 Dummy Cycle 32 bit 0 WS SW BP enable
CS7_MEM_REG   .short  0x0c0	 ; Internal RAM   init : 0 WS, 32 bits, little, write enable

            .elseif CHIPSET = 5
CS6_MEM_REG   .short  0x2c0  ; 1 Dummy Cycle 32 bit 0 WS SW BP enable

            .elseif CHIPSET = 6
CS6_MEM_REG   .short  0x2c0  ; 1 Dummy Cycle 32 bit 0 WS SW BP enable

            .endif

          .elseif   BOARD = 8        ; C-Sample SRAM CS0
CS0_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 0 WS SW BP enable
CS1_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS2_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS3_MEM_REG   .short  0x283  ; 1 Dummy Cycle  8 bit 3 WS SW BP enable
CS4_MEM_REG   .short  0x281  ; 1 Dummy Cycle  8 bit 1 WS SW BP enable

            .if CHIPSET = 4
CS6_MEM_REG   .short  0x2c0  ; 1 Dummy Cycle 32 bit 0 WS SW BP enable
CS7_MEM_REG   .short  0x0c0  ;Internal RAM   init : 0 WS, 32 bits, little, write enable

            .elseif CHIPSET = 7
CS6_MEM_REG   .short  0x0c0  ; 0 Dummy Cycle 32 bit 0 WS SW BP enable
CS7_MEM_REG   .short  0x040  ; Internal BOOT ROM   init : 0 WS, 32 bits, little, write disable

            .elseif CHIPSET = 8
CS6_MEM_REG   .short  0x0c0  ; 0 Dummy Cycle 32 bit 0 WS SW BP enable
CS7_MEM_REG   .short  0x040	 ; Internal BOOT ROM   init : 0 WS, 32 bits, little, write disable
            .endif

          .elseif   BOARD = 9        ; C-Sample FLASH CS0
CS0_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS1_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS2_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS3_MEM_REG   .short  0x283  ; 1 Dummy Cycle  8 bit 3 WS SW BP enable
CS4_MEM_REG   .short  0x281  ; 1 Dummy Cycle  8 bit 1 WS SW BP enable

            .if CHIPSET = 4
CS6_MEM_REG   .short  0x2c0  ; 1 Dummy Cycle 32 bit 0 WS SW BP enable
CS7_MEM_REG   .short  0x0C0	;Internal RAM   init : 0 WS, 32 bits, little, write enable

            .elseif CHIPSET = 7
CS6_MEM_REG   .short  0x2c0  ; 1 Dummy Cycle 32 bit 0 WS SW BP enable
CS7_MEM_REG   .short  0x040  ; Internal BOOT ROM   init : 0 WS, 32 bits, little, write disable

            .elseif CHIPSET = 8
CS6_MEM_REG   .short  0x0c0  ; 0 Dummy Cycle 32 bit 0 WS SW BP enable
CS7_MEM_REG   .short  0x040	 ; Internal BOOT ROM   init : 0 WS, 32 bits, little, write disable
            .endif

          .elseif   BOARD = 40       ; D-Sample SRAM CS0
CS0_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS1_MEM_REG   .short  0x2a3  ; 1 Dummy Cycle 16 bit 3 WS SW BP enable
CS2_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS3_MEM_REG   .short  0x283  ; 1 Dummy Cycle  8 bit 3 WS SW BP enable
CS4_MEM_REG   .short  0x281  ; 1 Dummy Cycle  8 bit 1 WS SW BP enable

            .if CHIPSET = 8
CS6_MEM_REG   .short  0x0c0  ; 0 Dummy Cycle 32 bit 0 WS SW BP enable
CS7_MEM_REG   .short  0x040	 ; Internal BOOT ROM   init : 0 WS, 32 bits, little, write disable

            .elseif CHIPSET = 10
CS6_MEM_REG   .short  0x0c0  ; 0 Dummy Cycle 32 bit 0 WS SW BP enable
CS7_MEM_REG   .short  0x040	 ; Internal BOOT ROM   init : 0 WS, 32 bits, little, write disable

            .elseif CHIPSET = 11
CS6_MEM_REG   .short  0x0c0  ; 0 Dummy Cycle 32 bit 0 WS SW BP enable
CS7_MEM_REG   .short  0x040	 ; Internal BOOT ROM   init : 0 WS, 32 bits, little, write disable
            .endif

          .elseif   BOARD = 41       ; D-Sample FLASH CS0
CS0_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS1_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS2_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS3_MEM_REG   .short  0x283  ; 1 Dummy Cycle  8 bit 3 WS SW BP enable
CS4_MEM_REG   .short  0x281  ; 1 Dummy Cycle  8 bit 1 WS SW BP enable

            .if CHIPSET = 8
CS6_MEM_REG   .short  0x0c0  ; 0 Dummy Cycle 32 bit 0 WS SW BP enable
CS7_MEM_REG   .short  0x040	 ; Internal BOOT ROM   init : 0 WS, 32 bits, little, write disable

            .elseif CHIPSET = 10
CS6_MEM_REG   .short  0x0c0  ; 0 Dummy Cycle 32 bit 0 WS SW BP enable
CS7_MEM_REG   .short  0x040	 ; Internal BOOT ROM   init : 0 WS, 32 bits, little, write disable

            .elseif CHIPSET = 11
CS6_MEM_REG   .short  0x0c0  ; 0 Dummy Cycle 32 bit 0 WS SW BP enable
CS7_MEM_REG   .short  0x040	 ; Internal BOOT ROM   init : 0 WS, 32 bits, little, write disable
            .endif

          .elseif   BOARD = 43       ; E-Sample - FLASH
            .if CHIPSET != 12
CS0_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS1_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS2_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS3_MEM_REG   .short  0x283  ; 1 Dummy Cycle  8 bit 3 WS SW BP enable
CS4_MEM_REG   .short  0x281  ; 1 Dummy Cycle  8 bit 1 WS SW BP enable

            .else
CS0_MEM_REG   .short  0x2a1  ; CALYPSO PLUS TEST MODE BOARD 43 - TO BE ERASED - 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS4_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS5_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS6_MEM_REG   .short  0x0c0  ; 0 Dummy Cycle 32 bit 0 WS SW BP enable
            .endif             ; CHIPSET = 12

          .elseif   BOARD = 45       ; EVA_CONSO - FLASH
       
            .if CHIPSET != 12
CS0_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS1_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS2_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS3_MEM_REG   .short  0x283  ; 1 Dummy Cycle  8 bit 3 WS SW BP enable
CS4_MEM_REG   .short  0x281  ; 1 Dummy Cycle  8 bit 1 WS SW BP enable
            .else
CS0_MEM_REG   .short  0x2a1  ; CALYPSO PLUS TEST MODE BOARD 43 - TO BE ERASED - 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS4_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS5_MEM_REG   .short  0x2a1  ; 1 Dummy Cycle 16 bit 1 WS SW BP enable
CS6_MEM_REG   .short  0x0c0  ; 0 Dummy Cycle 32 bit 0 WS SW BP enable
            .endif             ; CHIPSET = 12
          .endif ; BOARD = 6 or 7 or 8 or 9 or 40 or 41 or 43 or 45


CTL_MEM_REG   .short  0x02a  ; rhea strobe 0/1 + API access size adaptation

          .if CHIPSET = 4
CNTL_ARM_CLK_REG .word 0xFFFFFD00   ; CNTL_ARM_CLK register address
DPLL_CNTRL_REG   .word 0xFFFF9800   ; DPLL control register address
RHEA_CNTL_REG    .word 0xFFFFF900   ; RHEA control register address

CNTL_ARM_CLK_RST .short  0x1081	  ; Initialization of CNTL_ARM_CLK register
                                  ; Use DPLL, Divide by 1
DPLL_CONTROL_RST .short  0x2006   ; Configure DPLL in default state
RHEA_CONTROL_RST .short  0xFF22   ; Set access factor in order to access the DPLL register
                                  ; independently of the ARM clock

          .elseif CHIPSET = 6
;
; Constants to configure ULYSSE G1 with VTCXO at 26MHz
;
CNTL_ARM_CLK_REG        .word  0xFFFFFD00   ; CNTL_ARM_CLK register address
CNTLCLK_26MHZ_SELECTOR  .short 0x0040       ; VTCXO_26 selector

          .elseif CHIPSET = 7
CNTL_ARM_CLK_REG  .word 0xFFFFFD00   ; CNTL_ARM_CLK register address
DPLL_CNTRL_REG    .word 0xFFFF9800   ; DPLL control register address
EXTRA_CONTROL_REG .word 0xFFFFFB10   ; Extra Control register CONF address
MPU_CTL_REG       .word 0xFFFFFF08   ; MPU_CTL register address

CNTL_ARM_CLK_RST  .short  0x1081	 ; Initialization of CNTL_ARM_CLK register
                                     ; Use DPLL, Divide by 1
DPLL_CONTROL_RST  .short  0x2006     ; Configure DPLL in default state
DISABLE_DU_MASK   .short  0x0800     ; Mask to Disable the DU module
MPU_CTL_RST       .short  0x0000     ; Reset value of MPU_CTL register - All protections disabled

          .elseif CHIPSET = 8
CNTL_ARM_CLK_REG  .word 0xFFFFFD00   ; CNTL_ARM_CLK register address
DPLL_CNTRL_REG    .word 0xFFFF9800   ; DPLL control register address
EXTRA_CONTROL_REG .word 0xFFFFFB10   ; Extra Control register CONF address
MPU_CTL_REG       .word 0xFFFFFF08   ; MPU_CTL register address

CNTL_ARM_CLK_RST  .short  0x1081	   ; Initialization of CNTL_ARM_CLK register
                                     ; Use DPLL, Divide by 1
DPLL_CONTROL_RST  .short  0x2006     ; Configure DPLL in default state
DISABLE_DU_MASK   .short  0x0800     ; Mask to Disable the DU module
MPU_CTL_RST       .short  0x0000     ; Reset value of MPU_CTL register - All protections disabled

          .elseif CHIPSET = 10
CNTL_ARM_CLK_REG  .word 0xFFFFFD00   ; CNTL_ARM_CLK register address
DPLL_CNTRL_REG    .word 0xFFFF9800   ; DPLL control register address
EXTRA_CONTROL_REG .word 0xFFFFFB10   ; Extra Control register CONF address
MPU_CTL_REG       .word 0xFFFFFF08   ; MPU_CTL register address

CNTL_ARM_CLK_RST  .short  0x1081	   ; Initialization of CNTL_ARM_CLK register
                                     ; Use DPLL, Divide by 1
DPLL_CONTROL_RST  .short  0x2006     ; Configure DPLL in default state
DISABLE_DU_MASK   .short  0x0800     ; Mask to Disable the DU module
MPU_CTL_RST       .short  0x0000     ; Reset value of MPU_CTL register - All protections disabled

          .elseif CHIPSET = 11
CNTL_ARM_CLK_REG  .word 0xFFFFFD00   ; CNTL_ARM_CLK register address
DPLL_CNTRL_REG    .word 0xFFFF9800   ; DPLL control register address
EXTRA_CONTROL_REG .word 0xFFFFFB10   ; Extra Control register CONF address
MPU_CTL_REG       .word 0xFFFFFF08   ; MPU_CTL register address

CNTL_ARM_CLK_RST  .short  0x1081	   ; Initialization of CNTL_ARM_CLK register
                                     ; Use DPLL, Divide by 1
DPLL_CONTROL_RST  .short  0x2006     ; Configure DPLL in default state
DISABLE_DU_MASK   .short  0x0800     ; Mask to Disable the DU module
MPU_CTL_RST       .short  0x0000     ; Reset value of MPU_CTL register - All protections disabled

          .elseif CHIPSET = 12
DBG_DMA_P2        .word 0xFFFEF02C   ; DBG_DMA_P2 register address    
CNTL_ARM_CLK_REG  .word 0xFFFFFD00   ; CNTL_ARM_CLK register address
DPLL_CNTRL_REG    .word 0xFFFF9800   ; DPLL control register address
EXTRA_CONTROL_REG .word 0xFFFFFB10   ; Extra Control register CONF address
MPU_CTL_REG       .word 0xFFFFFF08   ; MPU_CTL register address

CNTL_ARM_CLK_RST  .short  0x1081	   ; Initialization of CNTL_ARM_CLK register
                                     ; Use DPLL, Divide by 1
DPLL_CONTROL_RST  .short  0x2006     ; Configure DPLL in default state
DISABLE_DU_MASK   .short  0x0800     ; Mask to Disable the DU module
MPU_CTL_RST       .short  0x0000     ; Reset value of MPU_CTL register - All protections disabled
DBG_DMA_P2_RST    .short  0x0002     ; DBG_DMA_P2 register reset value - GPO2 replaces ADD24

          .endif ; CHIPSET = 4 or 6 or 7 or 8 or 10 or 11 or 12

CLKM_MEM_REG  .equ  0x31	;the same define INIT_CLKM_ARM_CLK = 0x1031 for InitArmAfterReset


_INT_Bootloader_Start

;
;	Basic initializations
;
	
;
;  Configuration of ARM clock and DPLL frequency
;
          .if CHIPSET = 4
;
;  Configure RHEA access factor in order to allow the access of DPLL register
;
       ldr	   r1,RHEA_CNTL_REG          ; Load address of RHEA control register in R1
       ldrh    r2,RHEA_CONTROL_RST       ; Load RHEA configuration value in R2
       strh    r2,[r1]                   ; Store DPLL reset value in RHEA control register
  
;
;  Configure DPLL register with reset value
;
	   ldr     r1,DPLL_CNTRL_REG         ; Load address of DPLL register in R1
	   ldrh    r2,DPLL_CONTROL_RST       ; Load DPLL reset value in R2
	   strh    r2,[r1]                   ; Store DPLL reset value in DPLL register

;
; Wait that DPLL goes in BYPASS mode
;
Wait_DPLL_Bypass
       ldr     r2,[r1]               ; Load DPLL register
       and     r2,r2,#1              ; Perform a mask on bit 0
       cmp     r2,#1                 ; Compare DPLL lock bit
       beq     Wait_DPLL_Bypass      ; Wait Bypass mode (i.e. bit[0]='0')

;
;  Configure CNTL_ARM_CLK register with reset value: DPLL is used to
;  generate ARM clock with division factor of 1.
;
	   ldr     r1,CNTL_ARM_CLK_REG       ; Load address of CNTL_ARM_CLK register in R1
	   ldrh    r2,CNTL_ARM_CLK_RST       ; Load CNTL_ARM_CLK reset value in R2
	   strh    r2,[r1]                   ; Store CNTL_ARM_CLK reset value in CNTL_ARM_CLK register

          .elseif CHIPSET = 6
;
;  Setting of VTCXO_26MHZ bit to '1' in order to divide reference clock for peripherals.
;  This setting is required on ULYSSE G1 with a VTCXO clock to 26MHz.
;
       ldr     r1,CNTL_ARM_CLK_REG       ; Load CLKM base register address in R1
       ldrh    r2,[r1,#2]                ; Load contents of CNTL_CLK register in R2
       ldr     r0,CNTLCLK_26MHZ_SELECTOR ; Load configuration of 26MHz selector
       orr     r0,r0,r2
       strh    r0,[r1,#2]

          .elseif CHIPSET = 7
;
;  Configure DPLL register with reset value
;
	   ldr	   r1,DPLL_CNTRL_REG     ; Load address of DPLL register in R1
	   ldrh	   r2,DPLL_CONTROL_RST   ; Load DPLL reset value in R2
	   strh	   r2,[r1]               ; Store DPLL reset value in DPLL register

;
; Wait that DPLL goes in BYPASS mode
;
Wait_DPLL_Bypass
       ldr     r2,[r1]               ; Load DPLL register
       and     r2,r2,#1              ; Perform a mask on bit 0
       cmp     r2,#1                 ; Compare DPLL lock bit
       beq     Wait_DPLL_Bypass      ; Wait Bypass mode (i.e. bit[0]='0')

;
;  Configure CNTL_ARM_CLK register with reset value: DPLL is used to
;  generate ARM clock with division factor of 1.
;
	   ldr     r1,CNTL_ARM_CLK_REG  ; Load address of CNTL_ARM_CLK register in R1
	   ldrh    r2,CNTL_ARM_CLK_RST  ; Load CNTL_ARM_CLK reset value in R2
	   strh    r2,[r1]              ; Store CNTL_ARM_CLK reset value in CNTL_ARM_CLK register
  
;
;  Disable the DU module by setting bit 11 to '1'
;
       ldr     r1,EXTRA_CONTROL_REG ; Load address of Extra Control register CONF
       ldrh    r2,DISABLE_DU_MASK   ; Load mask to write in Extra Control register CONF
       ldrh    r0,[r1]              ; Load Extra Control register CONF in r0
       orr     r0,r0,r2             ; Disable DU module
       strh    r0,[r1]              ; Store configuration in Extra Control register CONF
  
;
;  Disable all MPU protections
;
       ldr     r1,MPU_CTL_REG       ; Load address of MPU_CTL register
       ldrh    r2,MPU_CTL_RST       ; Load reset value of MPU_CTL register
       strh    r2,[r1]              ; Store reset value of MPU_CTL register

          .elseif CHIPSET = 8
;
;  Configure DPLL register with reset value
;
	   ldr	   r1,DPLL_CNTRL_REG     ; Load address of DPLL register in R1
	   ldrh	   r2,DPLL_CONTROL_RST   ; Load DPLL reset value in R2
	   strh	   r2,[r1]               ; Store DPLL reset value in DPLL register

;
; Wait that DPLL goes in BYPASS mode
;
Wait_DPLL_Bypass
       ldr     r2,[r1]               ; Load DPLL register
       and     r2,r2,#1              ; Perform a mask on bit 0
       cmp     r2,#1                 ; Compare DPLL lock bit
       beq     Wait_DPLL_Bypass      ; Wait Bypass mode (i.e. bit[0]='0')

;
;  Configure CNTL_ARM_CLK register with reset value: DPLL is used to
;  generate ARM clock with division factor of 1.
;
	   ldr     r1,CNTL_ARM_CLK_REG  ; Load address of CNTL_ARM_CLK register in R1
	   ldrh    r2,CNTL_ARM_CLK_RST  ; Load CNTL_ARM_CLK reset value in R2
	   strh    r2,[r1]              ; Store CNTL_ARM_CLK reset value in CNTL_ARM_CLK register
  
;
;  Disable the DU module by setting bit 11 to '1'
;
       ldr     r1,EXTRA_CONTROL_REG ; Load address of Extra Control register CONF
       ldrh    r2,DISABLE_DU_MASK   ; Load mask to write in Extra Control register CONF
       ldrh    r0,[r1]              ; Load Extra Control register CONF in r0
       orr     r0,r0,r2             ; Disable DU module
       strh    r0,[r1]              ; Store configuration in Extra Control register CONF
  
;
;  Disable all MPU protections
;
       ldr     r1,MPU_CTL_REG       ; Load address of MPU_CTL register
       ldrh    r2,MPU_CTL_RST       ; Load reset value of MPU_CTL register
       strh    r2,[r1]              ; Store reset value of MPU_CTL register
          

          .elseif CHIPSET = 10
;
;  Configure DPLL register with reset value
;
	   ldr	   r1,DPLL_CNTRL_REG     ; Load address of DPLL register in R1
	   ldrh	   r2,DPLL_CONTROL_RST   ; Load DPLL reset value in R2
	   strh	   r2,[r1]               ; Store DPLL reset value in DPLL register

;
; Wait that DPLL goes in BYPASS mode
;
Wait_DPLL_Bypass
       ldr     r2,[r1]               ; Load DPLL register
       and     r2,r2,#1              ; Perform a mask on bit 0
       cmp     r2,#1                 ; Compare DPLL lock bit
       beq     Wait_DPLL_Bypass      ; Wait Bypass mode (i.e. bit[0]='0')

;
;  Configure CNTL_ARM_CLK register with reset value: DPLL is used to
;  generate ARM clock with division factor of 1.
;
	   ldr     r1,CNTL_ARM_CLK_REG  ; Load address of CNTL_ARM_CLK register in R1
	   ldrh    r2,CNTL_ARM_CLK_RST  ; Load CNTL_ARM_CLK reset value in R2
	   strh    r2,[r1]              ; Store CNTL_ARM_CLK reset value in CNTL_ARM_CLK register
  
;
;  Disable the DU module by setting bit 11 to '1'
;
       ldr     r1,EXTRA_CONTROL_REG ; Load address of Extra Control register CONF
       ldrh    r2,DISABLE_DU_MASK   ; Load mask to write in Extra Control register CONF
       ldrh    r0,[r1]              ; Load Extra Control register CONF in r0
       orr     r0,r0,r2             ; Disable DU module
       strh    r0,[r1]              ; Store configuration in Extra Control register CONF
  
;
;  Disable all MPU protections
;
       ldr     r1,MPU_CTL_REG       ; Load address of MPU_CTL register
       ldrh    r2,MPU_CTL_RST       ; Load reset value of MPU_CTL register
       strh    r2,[r1]              ; Store reset value of MPU_CTL register

          .elseif CHIPSET = 11
;
;  Configure DPLL register with reset value
;
	   ldr	   r1,DPLL_CNTRL_REG     ; Load address of DPLL register in R1
	   ldrh	   r2,DPLL_CONTROL_RST   ; Load DPLL reset value in R2
	   strh	   r2,[r1]               ; Store DPLL reset value in DPLL register

;
; Wait that DPLL goes in BYPASS mode
;
Wait_DPLL_Bypass
       ldr     r2,[r1]               ; Load DPLL register
       and     r2,r2,#1              ; Perform a mask on bit 0
       cmp     r2,#1                 ; Compare DPLL lock bit
       beq     Wait_DPLL_Bypass      ; Wait Bypass mode (i.e. bit[0]='0')

;
;  Configure CNTL_ARM_CLK register with reset value: DPLL is used to
;  generate ARM clock with division factor of 1.
;
	   ldr     r1,CNTL_ARM_CLK_REG  ; Load address of CNTL_ARM_CLK register in R1
	   ldrh    r2,CNTL_ARM_CLK_RST  ; Load CNTL_ARM_CLK reset value in R2
	   strh    r2,[r1]              ; Store CNTL_ARM_CLK reset value in CNTL_ARM_CLK register
  
;
;  Disable the DU module by setting bit 11 to '1'
;
       ldr     r1,EXTRA_CONTROL_REG ; Load address of Extra Control register CONF
       ldrh    r2,DISABLE_DU_MASK   ; Load mask to write in Extra Control register CONF
       ldrh    r0,[r1]              ; Load Extra Control register CONF in r0
       orr     r0,r0,r2             ; Disable DU module
       strh    r0,[r1]              ; Store configuration in Extra Control register CONF
  
;
;  Disable all MPU protections
;
       ldr     r1,MPU_CTL_REG       ; Load address of MPU_CTL register
       ldrh    r2,MPU_CTL_RST       ; Load reset value of MPU_CTL register
       strh    r2,[r1]              ; Store reset value of MPU_CTL register

          .elseif CHIPSET = 12
         .if BOARD = 6
          ; Configure DBG_DMA_P2 reg => GPO_2 output pin for EVA4
  	        ldr	r1,DBG_DMA_P2         ; Load address of DBG_DMA_P2 register in R1
	        ldrh	r2,DBG_DMA_P2_RST     ; Load DBG_DMA_P2 reset value in R2
	        strh	r2,[r1]               ; Store reset value in register
          ;
          .endif ; BOARD = 6
          ;
          ;  Configure DPLL register with reset value
          ;
	        ldr	  r1,DPLL_CNTRL_REG     ; Load address of DPLL register in R1
	        ldrh	r2,DPLL_CONTROL_RST   ; Load DPLL reset value in R2
	        strh	r2,[r1]               ; Store DPLL reset value in DPLL register

;
; Wait that DPLL goes in BYPASS mode
;
Wait_DPLL_Bypass
          ldr   r2,[r1]               ; Load DPLL register
          and   r2,r2,#1              ; Perform a mask on bit 0
          cmp   r2,#1                 ; Compare DPLL lock bit
          beq   Wait_DPLL_Bypass      ; Wait Bypass mode (i.e. bit[0]='0')

          ;
          ;  Configure CNTL_ARM_CLK register with reset value: DPLL is used to
          ;  generate ARM clock with division factor of 1.
          ;
	        ldr	  r1,CNTL_ARM_CLK_REG  ; Load address of CNTL_ARM_CLK register in R1
	        ldrh	r2,CNTL_ARM_CLK_RST  ; Load CNTL_ARM_CLK reset value in R2
	        strh	r2,[r1]              ; Store CNTL_ARM_CLK reset value in CNTL_ARM_CLK register
  
          ;
          ;  Disable the DU module by setting bit 11 to '1'
          ;
;          ldr   r1,EXTRA_CONTROL_REG ; Load address of Extra Control register CONF
;          ldrh  r2,DISABLE_DU_MASK   ; Load mask to write in Extra Control register CONF
;          ldrh  r0,[r1]              ; Load Extra Control register CONF in r0
;          orr   r0,r0,r2             ; Disable DU module
;          strh  r0,[r1]              ; Store configuration in Extra Control register CONF
  
          ;
          ;  Disable all MPU protections
          ;
          ldr   r1,MPU_CTL_REG       ; Load address of MPU_CTL register
          ldrh  r2,MPU_CTL_RST       ; Load reset value of MPU_CTL register
          strh  r2,[r1]              ; Store reset value of MPU_CTL register

          .endif ; CHIPSET = 4 or 6 or 7 or 8 or 10 or 11 or 12

       ldr     r1,addrCS0

          .if CHIPSET = 12
       ldrh    r2,CS0_MEM_REG			 ; CALYPSO PLUS TEST MODE - TO BE ERASED - ROM initialization
       strh    r2,[r1, #0x00]       ; CS5

       ldrh    r2,CS5_MEM_REG			 ; ROM initialization
       strh    r2,[r1, #0x0A]       ; CS5

       ldrh    r2,CS4_MEM_REG       ; RAM Initialization
       strh    r2,[r1,#0x08]        ; CS4

          .else
       ldrh    r2,CS0_MEM_REG			 ; ROM initialization
       strh    r2,[r1]                   ; CS0

       ldrh    r2,CS1_MEM_REG            ; RAM Initialization
       strh    r2,[r1,#2]		         ; CS1

       ldrh    r2,CS2_MEM_REG            ; RAM Initialization
       strh    r2,[r1,#4]		         ; CS2

       ldrh    r2,CS3_MEM_REG            ; parallel I/O
       strh    r2,[r1,#6]                ; CS3

       ldrh    r2,CS4_MEM_REG            ; Debug Latch
       strh    r2,[r1,#0xa]              ; CS4
          .endif

          .if CHIPSET = 3
	   ldrh    r2,CS6_MEM_REG            ; Ulysse/G0 Internal SRAM initialization
	   strh    r2,[r1,#0xc]	             ; CS6

          .elseif CHIPSET = 4
	   ldrh    r2,CS6_MEM_REG            ; Samson Internal SRAM initialization
	   strh    r2,[r1,#0xc]		         ; CS6
  
	   ldrh    r2,CS7_MEM_REG            ; Internal Boot RAM
	   strh    r2,[r1,#0x8]		         ; CS7

          .elseif CHIPSET = 5
           ldrh    r2,CS6_MEM_REG            ; Ulysse/G1 Internal SRAM initialization
	   strh	   r2,[r1,#0xc]		         ; CS6

          .elseif CHIPSET = 6
	   ldrh    r2,CS6_MEM_REG            ; Ulysse/G1 Internal SRAM initialization
	   strh    r2,[r1,#0xc]		         ; CS6

          .elseif CHIPSET = 7
	   ldrh    r2,CS6_MEM_REG            ; Calypso/G2 Internal SRAM initialization
           strh    r2,[r1,#0xc]              ; CS6

	   ldrh	   r2,CS7_MEM_REG            ; Internal Boot ROM initialization
	   strh	   r2,[r1,#0x8]		         ; CS7

          .elseif CHIPSET = 8
	   ldrh    r2,CS6_MEM_REG            ; Calypso/G2 Internal SRAM initialization
           strh    r2,[r1,#0xc]              ; CS6

	   ldrh	   r2,CS7_MEM_REG            ; Internal Boot ROM initialization
	   strh	   r2,[r1,#0x8]		         ; CS7

          .elseif CHIPSET = 10
	   ldrh    r2,CS6_MEM_REG            ; Calypso/G2 Internal SRAM initialization
           strh    r2,[r1,#0xc]              ; CS6

	   ldrh	   r2,CS7_MEM_REG            ; Internal Boot ROM initialization
	   strh	   r2,[r1,#0x8]		         ; CS7

          .elseif CHIPSET = 11
	   ldrh    r2,CS6_MEM_REG            ; Calypso/G2 Internal SRAM initialization
            strh    r2,[r1,#0xc]              ; CS6

	   ldrh	   r2,CS7_MEM_REG            ; Internal Boot ROM initialization
	   strh	   r2,[r1,#0x8]		         ; CS7

          .endif ; CHIPSET = 3 or 4 or 5 or 6 or 7 or 8 or 10 or 11

       ldrh    r2,CTL_MEM_REG            ; API-RHEA configuration
       strh    r2,[r1,#0xe]

; Initialize the system stack to allow to use the bootloader.
        
        LDR     a1,BSS_End                  ; Pickup the ending address of BSS
        MOV     a2,#SYSTEM_SIZE             ; Pickup system stack size
        SUB     a2,a2,#4                    ; Subtract one word for first addr
        ADD     a3,a1,a2                    ; Build start of system stack area
        BIC     a3,a3,#3                    ; Insure word aligment of stack
        MOV     sp,a3                       ; Setup initial stack pointer


; Call the function which allows to select the bootloader or the user's
; application.

        STMFD   sp!, {a1-a4,R12}
        BL      _sta_select_application
        LDMFD   sp!, {a1-a4,R12}

        B       _INT_Initialize

;    /* Define all the global addresses used in this section */

BSS_End
    .word   end

        .end
        