/*******************************************************************************
 *
 * SERIAL.H
 *
 * This module contains functions to send or receive commands on the USART 8251.
 * Only polled mode is used.
 * 
 * (C) Texas Instruments 1998
 *
 ******************************************************************************/

#ifndef __SERIAL_H__
#define __SERIAL_H__

#include "main/sys_types.h"

/*
 * ser_receive_command and ser_receive_char have 2 modes:
 *      SER_INFINITE : Waits until a command is received.
 *      SER_IMMEDIATE: Returns imediately even if no character is received.
 */

enum {
    SER_INFINITE,
    SER_IMMEDIATE
};

/*
 * Return values of ser_receive_data_for_flash.
 */

enum {
    SER_DATA_READY,
    SER_DATA_ERROR,
    SER_END_OF_FILE
};

extern void ser_wait_no_activity (SYS_UWORD8 device_id);
extern long ser_send_command (SYS_UWORD8 *command, SYS_UWORD8 device_id);
extern SYS_UWORD8 ser_receive_command (SYS_UWORD8 *command, int mode);
extern long ser_receive_data_for_flash (SYS_UWORD32 *address, SYS_UWORD16 *data, SYS_UWORD8 device_id);
extern void ser_initialize_flash_data_detection (void);
extern void ser_initialize_serial_link (void);
extern void ser_wait_last_character_sent (SYS_UWORD8 device_id);

#endif /* __SERIAL_H__ */