/******************************************************************************
 * FLUID (Flash Loader Utility Independent of Device)
 *
 * (C) Delta Technologies 2001.
 * Cleanup, modifications and extensions by Mads Meisner-Jensen, mmj@ti.com.
 *
 * Target/PC protocol definition
 *
 * $Id: protocol.h 1.9 Wed, 31 Oct 2001 11:47:00 +0100 mmj $
 *
 ******************************************************************************/


enum ProtocolChars {
    PROTO_HELLO         = 'H',
    PROTO_BAUDRATE      = 'B',
    PROTO_HARDWARE      = 'H',
    PROTO_QUERY         = 'Q',
    PROTO_QUERY_CHIP    = 'C',
    PROTO_READY         = 'R',
    PROTO_ISEMPTY       = 'I',
    PROTO_DOWNLOAD      = 'L',
    PROTO_DETECT        = 'D',
    PROTO_ERASE         = 'E',
    PROTO_COMPRESS      = 'Z',
    PROTO_PROGRAM       = 'P',
    PROTO_CKSUM         = 'C',
    PROTO_READ          = 'R',
    PROTO_RESET         = '0',
    PROTO_ERROR_CKSUM   = 'X',
    PROTO_ERROR_MEMORY  = 'M',
    PROTO_ERROR_FLASH_TIMEOUT = 'T',
    PROTO_ERROR_FLASH_COMMAND = 'C',
    PROTO_ERROR_FLASH_VPP     = 'P',
    PROTO_ERROR_FLASH_LOCKED  = 'L',
    PROTO_ERROR_VERIFY  = 'V',
    PROTO_CHECKSUM      = 'C',
    PROTO_VERSION       = 'V',
    PROTO_ERROR         = '?',

    PROTO_TRACE         = '$'
};



// Not really part of the protocol but as this header file is included by
// both PC side and target side source code, this is an easy place to put
// these difinitions.
enum ChipIdCodes {
    // Ulysses and Hercules
    CHIP_ID_ULYSSES_0  = 0xB2B5,
    CHIP_ID_ULYSSES_A  = 0xB335,
    CHIP_ID_HERCULES_A = 0xB334, // Correct revision designation?
    CHIP_ID_HERCULES_B = 0xB32C, // Correct revision designation?

    // Samson and Calypso
    CHIP_ID_CALYPSO_A  = 0xB2AC,
    CHIP_ID_CALYPSO_B  = 0xB396
};

