/*******************************************************************************
 *
 * CONVERT.H
 *
 * This module contains functions to convert a command into a string to send on
 * the serial link and to get a command from a string received on the serial
 * link.
 * 
 * (C) Texas Instruments 1998
 *
 ******************************************************************************/

#ifndef __CONVERT_H__
#define __CONVERT_H__

#include "main/sys_types.h"

extern long con_get_command_from_string (SYS_UWORD8 byte_to_analyze, SYS_UWORD8 *command);

extern void con_build_string_from_command (SYS_UWORD8 *command,
                                           SYS_UWORD8 *string,
                                           SYS_UWORD16 *string_length);

extern void con_initialize_conversion (void);

#endif /* __CONVERT_H__ */