/**
 * @file	tut_pool_size.h
 *
 * Declarations of:
 * - the memory bank sizes and their watermark
 * - the SWE stack size
 * - the pool size needed (generally the sum of memory bank and stack sizes)
 *
 * @author	Vincent Oberle
 * @version 0.1
 */

/*
 * History:
 *
 *	Date       	Author					Modification
 *	-------------------------------------------------------------------
 *	07/08/2003	Vincent Oberle			Extracted from rvf_pool_size.h
 *
 * (C) Copyright 2003 by Texas Instruments Incorporated, All Rights Reserved
 */

#ifndef __TUT_POOL_SIZE_H_
#define __TUT_POOL_SIZE_H_


/*
 * Values used in tut_env.h
 */
#define TUT_STACK_SIZE (1024)
#define TUT_MB1_SIZE   (512)
#define TUT_POOL_SIZE  (TUT_STACK_SIZE + TUT_MB1_SIZE)


#endif /*__TUT_POOL_SIZE_H_*/
