#
#       Makefile for TTY Riviera service (ARM compiler) 
#
#       Copyright (c) Texas Instruments 2003
# 
#       Author: Frederic Turgis & Gerard Cauvy
#       Date : 01/27/2003


# Compilation flags
TTY_FLAGS     := $(NODBG) $(16INST) -mn $(CFLAGSSERVICES)
WIN_TTY_FLAGS := $($(TP)CFLAGS) $(CFLAGSSERVICES)


# Libraries definition
LIB_TTY	 := $(OUT_LIB_DIR)/tty.lib
CFG_LIBS += $(LIB_TTY)


# Source definition
COMMON_SRC_TTY += $(SERVICES_DIR)/tty/tty_api.c \
		          $(SERVICES_DIR)/tty/tty_env.c \
		          $(SERVICES_DIR)/tty/tty_task.c \
		          $(SERVICES_DIR)/tty/tty.c 
SRC_TTY        := $(COMMON_SRC_TTY)
WIN_SRC_TTY    := $(COMMON_SRC_TTY)


# Objects and dependencies definition
OBJ_TTY  := $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$($(TP)SRC_TTY)))
CFG_OBJS += $(OBJ_TTY)
CFG_DEPS += $(OBJ_TTY:.obj=.d)


######## LIBRARIES #############
$(LIB_TTY) : $(OBJ_TTY)
	$(MKDIR) $(dir $@)
	$($(TP)LINKER) $($(TP)LFLAGS) $($(TP)LOUTOUT_FLAG)$@ $^

######## OBJECTS #############
$(OBJ_TTY) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.c
	$($(TP)COMPILER) $($(TP)TTY_FLAGS) $($(TP)COUTPUT_FLAG)$(@D)/ $<

