#
#       Makefile for the Test of MKS Riviera service (ARM compiler) 
#
#       Copyright (c) Texas Instruments 2001
# 
#               Author: Laurent Sollier
#       Date : 04 December 2001

# Compilation flags
MKS_TEST_FLAGS     := $(NODBG) $(16INST) -mn $(CFLAGSSERVICES_TESTS)
WIN_MKS_TEST_FLAGS := $($(TP)CFLAGS) $(CFLAGSSERVICES_TESTS)


# Libraries definition
LIB_MKS_TEST   := $(OUT_LIB_DIR)/mks_tests.lib 
CFG_LIBS    += $(LIB_MKS_TEST)


# Source definition
COMMON_SRC_MKS_TEST := $(SERVICES_DIR)/mks/tests/mks_test.c \
                       $(SERVICES_DIR)/mks/tests/mks_test_misc.c 

SRC_MKS_TEST        += $(COMMON_SRC_MKS_TEST)
WIN_SRC_MKS_TEST    += $(COMMON_SRC_MKS_TEST)


# Object definition
OBJ_MKS_TEST := $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$($(TP)SRC_MKS_TEST)))
CFG_OBJS += $(OBJ_MKS_TEST)
CFG_DEPS += $(OBJ_MKS_TEST:.obj=.d)


######## LIBRARIES #############
$(LIB_MKS_TEST) : $(OBJ_MKS_TEST)
	$(MKDIR) $(subst /,\,$(dir $@))
	$($(TP)LINKER) $($(TP)LFLAGS) $($(TP)LOUTOUT_FLAG)$@ $^


######## OBJECTS #############
$(OBJ_MKS_TEST) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.c
	$($(TP)COMPILER) $($(TP)MKS_TEST_FLAGS) $($(TP)COUTPUT_FLAG)$(@D)/ $<


