/********************************************************************************/
/*                                                                              */
/*      File Name:   mks_test_misc.c                                            */
/*                                                                              */
/*      Purpose:   This file gathers miscellaneous tests fot MKS.               */
/*                                                                              */
/*      Notes:      None.                                                       */
/*                                                                              */
/*      Revision History:                                                       */
/*      10/29/01      Laurent Sollier         Create.                           */
/*                                                                              */
/*   (C) Copyright 2000 by Texas Instruments Incorporated, All Rights Reserved  */
/*                                                                              */
/********************************************************************************/

/********************************************************************************/
/*                                                                              */
/*   Include files used for MKS testing.                                        */
/*                                                                              */
/********************************************************************************/

#include "tests/rv/rv_test_filter.h"

#if (MKS_MISC == SW_COMPILED)

#include "mks/mks_api.h"
#include "tests/rv/rv_test_misc.h"
#include "mks/tests/mks_test.h"
#include "r2d/lcd_messages_ti.h"
#include "r2d/lcd_messages.h"
#include "r2d/r2d.h"

#include <stdio.h>
#include <string.h>


/********************************************************************************/
/*                                                                              */
/*      Function Name:   mks_test_misc1                                         */
/*                                                                              */
/*      Notes:         This function executes mks misc test 1.                  */
/*                                                                              */
/*      Revision History:                                                       */
/*      11/05/01      Laurent Sollier         Create.                           */
/*                                                                              */
/********************************************************************************/
T_RV_MISC_RET mks_test_misc1(void)
{
   T_RV_MISC_RET test_verdict   = TEST_PASSED;
   T_MKS_INFOS_KEY_SEQUENCE infos_key_sequence;
   UINT16         received_event;
   T_RV_HDR*      msg_p;
   T_KPD_SUBSCRIBER subscriber_id;
   T_KPD_VIRTUAL_KEY_TABLE notified_keys;
   T_RV_RETURN kpd_return_path;

   BOOL           exit = FALSE;

   /* Test definition */
   mks_test_trace("*** MKS TEST MISC1: Two magic key sequences");
   mks_test_trace("*** MKS TEST MISC1: The first sequence is (1-2-3) and display or hide a message");
   mks_test_trace("*** MKS TEST MISC1: The second sequence is (4-5-6) and wait for three keys");
   mks_test_trace("*** MKS TEST MISC1: Press DISC to exit the test");

   /* Add key sequence 1 */
   infos_key_sequence.nb_key_of_sequence = 3;
   infos_key_sequence.key_id[0] = KPD_KEY_1;
   infos_key_sequence.key_id[1] = KPD_KEY_2;
   infos_key_sequence.key_id[2] = KPD_KEY_3;
   strcpy(infos_key_sequence.name, "TEST_SEQ1");
   infos_key_sequence.completion_type = MKS_SEQUENCE_COMPLETED;
   infos_key_sequence.nb_key_for_post_sequence = 0; /* useless because completion_type=MKS_SEQUENCE_COMPLETED */
   infos_key_sequence.return_path.callback_func = 0;
   infos_key_sequence.return_path.addr_id = (UINT16) (mks_test_path.addr_id);

   mks_add_key_sequence(&infos_key_sequence);

   /* Add key sequence 2 */
   infos_key_sequence.nb_key_of_sequence = 3;
   infos_key_sequence.key_id[0] = KPD_KEY_4;
   infos_key_sequence.key_id[1] = KPD_KEY_5;
   infos_key_sequence.key_id[2] = KPD_KEY_6;
   strcpy(infos_key_sequence.name, "TEST_SEQ2");
   infos_key_sequence.completion_type = MKS_POST_SEQUENCE;
   infos_key_sequence.nb_key_for_post_sequence = 3;
   infos_key_sequence.return_path.callback_func = 0;
   infos_key_sequence.return_path.addr_id = (UINT16) (mks_test_path.addr_id);

   mks_add_key_sequence(&infos_key_sequence);

   /* Add keypad subscriber in order to be able to exit the test */
   kpd_return_path.addr_id = (UINT16) (mks_test_path.addr_id);
   kpd_return_path.callback_func = 0;
   notified_keys.nb_notified_keys = KPD_NB_PHYSICAL_KEYS;
   kpd_subscribe (&subscriber_id, KPD_DEFAULT_MODE,
                  &notified_keys, kpd_return_path);

      /* loop to process messages */
   while (!exit)
   {
      /* Wait for the necessary events (infinite wait for a msg in the mailbox 0). */
      received_event = rvf_wait(RVF_TASK_MBOX_0_EVT_MASK,0);

      if (received_event & RVF_TASK_MBOX_0_EVT_MASK)
      {
         /* Read the message */
         msg_p = (T_RV_HDR *) rvf_read_mbox(0);

         if (msg_p != 0)
         {
            switch (msg_p->msg_id)
            {
               case MKS_SEQUENCE_COMPLETED_MSG:
                  {
                     T_MKS_SEQUENCE_COMPLETED_MSG* msg_key_event_p = (T_MKS_SEQUENCE_COMPLETED_MSG*) msg_p;

                     if (!(strcmp(msg_key_event_p->name, "TEST_SEQ1")))
                     {
                        static UINT8 loop = 0;
                        if (loop == 0)
                        {
                           LCD_WriteString(2,0,"Key seq. 1     ", NORMAL);
                           loop++;
                        }
                        else
                        {
                           LCD_WriteString(2,0,"              ", NORMAL);
                           loop = 0;
                        }
                     }
                     else if (!(strcmp(msg_key_event_p->name, "TEST_SEQ2")))
                     {
                        static char texte[10] = {0};
                        static UINT8 pos = 0;
                        T_MKS_SEQUENCE_COMPLETED_MSG* msg_key_event_p = (T_MKS_SEQUENCE_COMPLETED_MSG*) msg_p;
                        char* caracter;

                        kpd_get_ascii_key_code(msg_key_event_p->key_pressed,
                                               KPD_DEFAULT_MODE,
                                               &caracter);
                        texte[pos] = caracter[0];
                        pos++;
                        if (pos == 3)
                        {
                           LCD_WriteString(3,0, texte, NORMAL);
                           pos = 0;
                        }
                     }
                     break;
                  }

               case KPD_KEY_EVENT_MSG :
                  {
                     T_KPD_KEY_EVENT_MSG* msg_key_event_p = (T_KPD_KEY_EVENT_MSG*) msg_p;

                     if (msg_key_event_p->key_info.virtual_key_id == KPD_KEY_DISCONNECT)
                     {
                        kpd_unsubscribe(&subscriber_id);
                        mks_remove_key_sequence("TEST_SEQ1");
                        mks_remove_key_sequence("TEST_SEQ2");
                        /* Wait that MKS SWE has time to process the two messages */
                        rvf_delay(RVF_MS_TO_TICKS(100));

                        exit = TRUE;
                     }
                     break;
                  }

               default :
                  break;

            }
            rvf_free_buf(msg_p);
         }
      }
   }


   return test_verdict;
}


/********************************************************************************/
/*                                                                              */
/*      Function Name:   mks_test_misc2                                         */
/*                                                                              */
/*      Notes:         This function executes mks misc test 2.                  */
/*                                                                              */
/*      Revision History:                                                       */
/*      11/05/01      Laurent Sollier         Create.                           */
/*                                                                              */
/********************************************************************************/
T_RV_MISC_RET mks_test_misc2(void)
{
   T_RV_MISC_RET test_verdict   = TEST_PASSED;
   T_MKS_INFOS_KEY_SEQUENCE infos_key_sequence;
   UINT16         received_event;
   T_RV_HDR*      msg_p;
   T_KPD_SUBSCRIBER subscriber_id;
   T_KPD_VIRTUAL_KEY_TABLE notified_keys;
   T_RV_RETURN kpd_return_path;

   BOOL           exit = FALSE;

   /* Test definition */
   mks_test_trace("*** MKS TEST MISC1: Three magic key sequences");
   mks_test_trace("*** MKS TEST MISC1: The first sequence is (1-2-3) and display or hide a message");
   mks_test_trace("*** MKS TEST MISC1: The second sequence is (4-5-6) and wait for three keys");
   mks_test_trace("*** MKS TEST MISC1: The third sequence is (7-8-9) and remove the first key sequence");
   mks_test_trace("*** MKS TEST MISC1: Press DISC to exit the test");


   /* Add key sequence 1 */
   infos_key_sequence.nb_key_of_sequence = 3;
   infos_key_sequence.key_id[0] = KPD_KEY_1;
   infos_key_sequence.key_id[1] = KPD_KEY_2;
   infos_key_sequence.key_id[2] = KPD_KEY_3;
   strcpy(infos_key_sequence.name, "TEST_SEQ1");
   infos_key_sequence.completion_type = MKS_SEQUENCE_COMPLETED;
   infos_key_sequence.nb_key_for_post_sequence = 0; /* useless because completion_type=MKS_SEQUENCE_COMPLETED */
   infos_key_sequence.return_path.callback_func = 0;
   infos_key_sequence.return_path.addr_id = (UINT16) (mks_test_path.addr_id);

   mks_add_key_sequence(&infos_key_sequence);

   /* Add key sequence 2 */
   infos_key_sequence.nb_key_of_sequence = 3;
   infos_key_sequence.key_id[0] = KPD_KEY_4;
   infos_key_sequence.key_id[1] = KPD_KEY_5;
   infos_key_sequence.key_id[2] = KPD_KEY_6;
   strcpy(infos_key_sequence.name, "TEST_SEQ2");
   infos_key_sequence.completion_type = MKS_POST_SEQUENCE;
   infos_key_sequence.nb_key_for_post_sequence = 3;
   infos_key_sequence.return_path.callback_func = 0;
   infos_key_sequence.return_path.addr_id = (UINT16) (mks_test_path.addr_id);

   mks_add_key_sequence(&infos_key_sequence);

   /* Add key sequence 3 */
   infos_key_sequence.nb_key_of_sequence = 3;
   infos_key_sequence.key_id[0] = KPD_KEY_7;
   infos_key_sequence.key_id[1] = KPD_KEY_8;
   infos_key_sequence.key_id[2] = KPD_KEY_9;
   strcpy(infos_key_sequence.name, "TEST_SEQ3");
   infos_key_sequence.completion_type = MKS_SEQUENCE_COMPLETED;
   infos_key_sequence.nb_key_for_post_sequence = 0; /* useless because completion_type=MKS_SEQUENCE_COMPLETED */
   infos_key_sequence.return_path.callback_func = 0;
   infos_key_sequence.return_path.addr_id = (UINT16) (mks_test_path.addr_id);

   mks_add_key_sequence(&infos_key_sequence);

   /* Add keypad subscriber in order to be able to exit the test */
   kpd_return_path.addr_id = (UINT16) (mks_test_path.addr_id);
   kpd_return_path.callback_func = 0;
   notified_keys.nb_notified_keys = KPD_NB_PHYSICAL_KEYS;
   kpd_subscribe (&subscriber_id, KPD_DEFAULT_MODE,
                  &notified_keys, kpd_return_path);


      /* loop to process messages */
   while (!exit)
   {
      /* Wait for the necessary events (infinite wait for a msg in the mailbox 0). */
      received_event = rvf_wait(RVF_TASK_MBOX_0_EVT_MASK,0);

      if (received_event & RVF_TASK_MBOX_0_EVT_MASK)
      {
         /* Read the message */
         msg_p = (T_RV_HDR *) rvf_read_mbox(0);

         if (msg_p != 0)
         {
            switch (msg_p->msg_id)
            {
               case MKS_SEQUENCE_COMPLETED_MSG:
                  {
                     T_MKS_SEQUENCE_COMPLETED_MSG* msg_key_event_p = (T_MKS_SEQUENCE_COMPLETED_MSG*) msg_p;

                     if (!(strcmp(msg_key_event_p->name, "TEST_SEQ1")) )
                     {
                        static UINT8 loop = 0;
                        if (loop == 0)
                        {
                           LCD_WriteString(2,0,"Key seq. 1     ", NORMAL);
                           loop++;
                        }
                        else
                        {
                           LCD_WriteString(2,0,"              ", NORMAL);
                           loop = 0;
                        }
                     }
                     else if (!(strcmp(msg_key_event_p->name, "TEST_SEQ2")) )
                     {
                        static char texte[10] = {0};
                        static UINT8 pos = 0;
                        T_MKS_SEQUENCE_COMPLETED_MSG* msg_key_event_p = (T_MKS_SEQUENCE_COMPLETED_MSG*) msg_p;
                        char* caracter;

                        kpd_get_ascii_key_code(msg_key_event_p->key_pressed,
                                               KPD_DEFAULT_MODE,
                                               &caracter);
                        texte[pos] = caracter[0];
                        pos++;
                        if (pos == 3)
                        {
                           LCD_WriteString(3,0, texte, NORMAL);
                           pos = 0;
                        }
                     }
                     else if (!(strcmp(msg_key_event_p->name, "TEST_SEQ3")) )
                     {
                        mks_remove_key_sequence("TEST_SEQ1");
                     }
                     break;
                  }

               case KPD_KEY_EVENT_MSG :
                  {
                     T_KPD_KEY_EVENT_MSG* msg_key_event_p = (T_KPD_KEY_EVENT_MSG*) msg_p;

                     if (msg_key_event_p->key_info.virtual_key_id == KPD_KEY_DISCONNECT)
                     {
                        kpd_unsubscribe(&subscriber_id);
                        mks_remove_key_sequence("TEST_SEQ1");
                        mks_remove_key_sequence("TEST_SEQ2");
                        mks_remove_key_sequence("TEST_SEQ3");
                        /* Wait that MKS SWE has time to process the two messages */
                        rvf_delay(RVF_MS_TO_TICKS(100));

                        exit = TRUE;
                     }
                     break;
                  }

               default :
                  break;

            }
            rvf_free_buf(msg_p);
         }
      }
   }


   return test_verdict;
}


/********************************************************************************/
/*                                                                              */
/*      Function Name:   mks_test_misc3                                         */
/*                                                                              */
/*      Notes:         This function executes mks misc test 3.                  */
/*                                                                              */
/*      Revision History:                                                       */
/*      11/05/01      Laurent Sollier         Create.                           */
/*                                                                              */
/********************************************************************************/
T_RV_MISC_RET mks_test_misc3(void)
{
   T_RV_MISC_RET test_verdict   = TEST_PASSED;

   return test_verdict;
}


/********************************************************************************/
/*                                                                              */
/*      Function Name:   mks_test_misc                                          */
/*                                                                              */
/*      Notes:         This function executes MKS misc tests.                   */
/*                                                                              */
/*      Revision History:                                                       */
/*      10/29/01      Laurent Sollier         Create.                           */
/*                                                                              */
/********************************************************************************/

T_RV_MISC_RET mks_test_misc (T_RV_MISC_TEST_NBR test_number)
{
   T_RV_MISC_RET test_verdict   = TEST_PASSED;

   LCD_Clear ();
   rvf_dump_mem();
   rvf_dump_tasks();

   switch (test_number)
   {
   case 1:
      test_verdict = mks_test_misc1();
      break;

   case 2:
      test_verdict = mks_test_misc2();
      break;

   case 3:
      test_verdict = mks_test_misc3();
      break;

   default:
      mks_test_trace("Test not available");

   }
   rvf_dump_mem();
   rvf_dump_tasks();

   return (test_verdict);   
}

/************************ Stop mks_test_misc function ***********************/

#endif /* #if (MKS_MISC == SW_COMPILED) */