/********************************************************************************/
/*                                                                              */
/*      File Name:   mks_test.h                                                 */
/*                                                                              */
/*      Purpose:   This file contains MKS test generic definitions.             */
/*                                                                              */
/*      Note:      None.                                                        */
/*                                                                              */
/*      Revision History:                                                       */
/*      11/21/2001      Laurent Sollier      Create.                            */
/*                                                                              */
/*   (C) Copyright 2001 by Texas Instruments Incorporated, All Rights Reserved  */
/*                                                                              */
/********************************************************************************/

#ifndef _MKS_TEST_H_
#define _MKS_TEST_H_

#include "tests/rv/rv_test_filter_redirect.h"
#include "tests/rv/rv_test.h"

#if (MKS_TEST == SW_COMPILED)


extern T_RVF_MB_ID mb_mks_test;
extern T_RV_RETURN mks_test_path;

/********************************************************************************/
/*                                                                              */
/*      MACRO Name:      mks_test_trace                                         */
/*                                                                              */
/*      Purpose:      This macro is called to trace msg in MKS tests.           */
/*                                                                              */
/*      Note:         None.                                                     */
/*                                                                              */
/*      Revision History:                                                       */
/*      11/21/01      Laurent Sollier         Create.                           */
/*                                                                              */
/********************************************************************************/
#define mks_test_trace(msg)\
{\
   rvf_send_trace ( msg, sizeof(msg)-1, NULL_PARAM, RV_TRACE_LEVEL_DEBUG_HIGH, TRACE_RVTEST);\
}

/********************************************************************************/
/*                                                                              */
/*      MACRO Name:      mks_test_error                                         */
/*                                                                              */
/*      Purpose:      This macro is called to trace ERROR msg in MKS tests.     */
/*                                                                              */
/*      Note:         None.                                                     */
/*                                                                              */
/*      Revision History:                                                       */
/*      10/29/01      Laurent Sollier         Create.                           */
/*                                                                              */
/********************************************************************************/
#define mks_test_error(msg)\
{\
   rvf_send_trace ( msg, sizeof(msg)-1, NULL_PARAM, RV_TRACE_LEVEL_ERROR, TRACE_RVTEST);\
}



#endif /* #if (_MKS_TEST_H_ == SW_COMPILED) */
#endif