#
#       Makefile for MKS Riviera service (ARM compiler) 
#
#       Copyright (c) Texas Instruments 2001
# 
#               Author: Laurent Sollier
#       Date : 04 December 2001

# Compilation flags
MKS_FLAGS     = $(NODBG) $(16INST) -mn $(CFLAGSSERVICES)
WIN_MKS_FLAGS = $($(TP)CFLAGS) $(CFLAGSSERVICES)


# Libraries definition
LIB_MKS	    := $(OUT_LIB_DIR)/mks.lib 
CFG_LIBS    += $(LIB_MKS)


# Source definition
ifdef MKS_SOURCE
COMMON_SRC_MKS += $(SERVICES_DIR)/mks/mks_env.c \
                  $(SERVICES_DIR)/mks/mks_api.c \
                  $(SERVICES_DIR)/mks/mks_functions.c \
                  $(SERVICES_DIR)/mks/mks_handle_message.c \
                  $(SERVICES_DIR)/mks/mks_handle_timer.c \
                  $(SERVICES_DIR)/mks/mks_task.c
SRC_MKS        += $(COMMON_SRC_MKS)
WIN_SRC_MKS    += $(COMMON_SRC_MKS)
endif


# Objects and dependencies definition
OBJ_MKS  := $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$($(TP)SRC_MKS)))
CFG_OBJS += $(OBJ_MKS)
CFG_DEPS += $(OBJ_MKS:.obj=.d)


######## LIBRARIES #############
$(LIB_MKS) : $(OBJ_MKS)
	$(MKDIR) $(dir $@)
	$($(TP)LINKER) $($(TP)LFLAGS) $($(TP)LOUTOUT_FLAG)$@ $^

######## OBJECTS #############
$(OBJ_MKS) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.c
	$($(TP)COMPILER) $($(TP)MKS_FLAGS) $($(TP)COUTPUT_FLAG)$(@D)/ $<

