#
#       Makefile for the Test of LLS Riviera service (ARM compiler) 
#
#       Copyright (c) Texas Instruments 2002
# 
#               Author: Laurent Sollier
#       Date : 12 March 2002

# Compilation flags
LLS_TEST_FLAGS     = $(NODBG) $(16INST) -mn $(CFLAGSSERVICES_TESTS) 
WIN_LLS_TEST_FLAGS = $($(TP)CFLAGS) $(CFLAGSSERVICES_TESTS)

# Libraries definition
LIB_LLS_TEST   := $(OUT_LIB_DIR)/lls_tests.lib 
CFG_LIBS    += $(LIB_LLS_TEST)


# Source definition
COMMON_SRC_LLS_TEST := $(SERVICES_DIR)/lls/tests/lls_test.c \
                       $(SERVICES_DIR)/lls/tests/lls_test_misc.c

SRC_LLS_TEST        := $(COMMON_SRC_LLS_TEST)
WIN_SRC_LLS_TEST    := $(COMMON_SRC_LLS_TEST)


# Objects and dependencies definition
OBJ_LLS_TEST := $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$($(TP)SRC_LLS_TEST)))
CFG_OBJS += $(OBJ_LLS_TEST)
CFG_DEPS += $(OBJ_LLS_TEST:.obj=.d)


######## LIBRARIES #############
$(LIB_LLS_TEST) : $(OBJ_LLS_TEST)
	$(MKDIR) $(dir $@)
	$($(TP)LINKER) $($(TP)LFLAGS) $($(TP)LOUTOUT_FLAG)$@ $^

######## OBJECTS #############
$(OBJ_LLS_TEST) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.c
	$($(TP)COMPILER) $($(TP)LLS_TEST_FLAGS) $($(TP)COUTPUT_FLAG)$(@D)/ $<

