/********************************************************************************/
/*                                                                              */
/*      File Name:   lls_test_misc.c                                            */
/*                                                                              */
/*      Purpose:   This file gathers miscellaneous tests fot LLS.               */
/*                                                                              */
/*      Notes:      None.                                                       */
/*                                                                              */
/*      Revision History:                                                       */
/*      03/12/2002      Laurent Sollier         Create.                         */
/*                                                                              */
/*   (C) Copyright 2002 by Texas Instruments Incorporated, All Rights Reserved  */
/*                                                                              */
/********************************************************************************/

/********************************************************************************/
/*                                                                              */
/*   Include files used for LLS testing.                                        */
/*                                                                              */
/********************************************************************************/

#include "tests/rv/rv_test_filter.h"

#if (LLS_MISC == SW_COMPILED)

#include "lls/lls_api.h"
#include "tests/rv/rv_test_misc.h"
#include "lls/tests/lls_test.h"


/********************************************************************************/
/*                                                                              */
/*      Function Name:   lls_test_misc1                                         */
/*                                                                              */
/*      Notes:         This function executes lls misc test 1.                  */
/*                                                                              */
/*      Revision History:                                                       */
/*      03/12/2002      Laurent Sollier         Create.                         */
/*                                                                              */
/********************************************************************************/
T_RV_MISC_RET lls_test_misc1(void)
{
   T_RV_MISC_RET test_verdict   = TEST_PASSED;

   lls_test_trace("*** LLS TEST MISC1: Switch ON LED A for 3 sec, then switch OFF LED A");
   lls_test_trace("*** LLS TEST MISC1: Switch ON LED B for 3 sec, then switch OFF LED A");
   lls_test_trace("*** LLS TEST MISC1: Switch ON LED C for 3 sec, then switch OFF LED A");
   lls_test_trace("*** LLS TEST MISC1: Wait 3 sec");
   lls_test_trace("*** LLS TEST MISC1: Switch ON LED A, LED B, LED C for 3 sec, then switch OFF all LEDs");

   lls_switch_on(LLS_LED_A);
   rvf_delay(RVF_MS_TO_TICKS(3000));
   lls_switch_off(LLS_LED_A);

   lls_switch_on(LLS_BACKLIGHT);
   rvf_delay(RVF_MS_TO_TICKS(3000));
   lls_switch_off(LLS_BACKLIGHT);

   lls_switch_on(LLS_PRECHARGE_LED);
   rvf_delay(RVF_MS_TO_TICKS(3000));
   lls_switch_off(LLS_PRECHARGE_LED);

   rvf_delay(RVF_MS_TO_TICKS(3000));

   lls_switch_on(LLS_LED_A);
   lls_switch_on(LLS_BACKLIGHT);
   lls_switch_on(LLS_PRECHARGE_LED);
   rvf_delay(RVF_MS_TO_TICKS(3000));
   lls_switch_off(LLS_LED_A);
   lls_switch_off(LLS_BACKLIGHT);
   lls_switch_off(LLS_PRECHARGE_LED);


   return test_verdict;
}


/********************************************************************************/
/*                                                                              */
/*      Function Name:   lls_test_misc2                                         */
/*                                                                              */
/*      Notes:         This function executes lls misc test 2.                  */
/*                                                                              */
/*      Revision History:                                                       */
/*      03/12/2002      Laurent Sollier         Create.                         */
/*                                                                              */
/********************************************************************************/
T_RV_MISC_RET lls_test_misc2(void)
{
   T_RV_MISC_RET test_verdict   = TEST_PASSED;

   return test_verdict;
}


/********************************************************************************/
/*                                                                              */
/*      Function Name:   lls_test_misc3                                         */
/*                                                                              */
/*      Notes:         This function executes lls misc test 3.                  */
/*                                                                              */
/*      Revision History:                                                       */
/*      03/12/2002      Laurent Sollier         Create.                         */
/*                                                                              */
/********************************************************************************/
T_RV_MISC_RET lls_test_misc3(void)
{
   T_RV_MISC_RET test_verdict   = TEST_PASSED;

   return test_verdict;
}


/********************************************************************************/
/*                                                                              */
/*      Function Name:   lls_test_misc                                          */
/*                                                                              */
/*      Notes:         This function executes LLS misc tests.                   */
/*                                                                              */
/*      Revision History:                                                       */
/*      03/12/2002      Laurent Sollier         Create.                         */
/*                                                                              */
/********************************************************************************/

T_RV_MISC_RET lls_test_misc (T_RV_MISC_TEST_NBR test_number)
{
   T_RV_MISC_RET test_verdict   = TEST_PASSED;

   rvf_dump_mem();
   rvf_dump_tasks();

   switch (test_number)
   {
   case 1:
      test_verdict = lls_test_misc1();
      break;

   case 2:
      test_verdict = lls_test_misc2();
      break;

   case 3:
      test_verdict = lls_test_misc3();
      break;

   default:
      lls_test_trace("Test not available");

   }
   rvf_dump_mem();
   rvf_dump_tasks();

   return (test_verdict);   
}

/************************ Stop lls_test_misc function ***********************/

#endif /* #if (LLS_MISC == SW_COMPILED) */