/********************************************************************************/
/*                                                                              */
/*      File Name:   lls_test.h                                                 */
/*                                                                              */
/*      Purpose:   This file contains LLS test generic definitions.             */
/*                                                                              */
/*      Note:      None.                                                        */
/*                                                                              */
/*      Revision History:                                                       */
/*      03/12/2002      Laurent Sollier      Create.                            */
/*                                                                              */
/*   (C) Copyright 2002 by Texas Instruments Incorporated, All Rights Reserved  */
/*                                                                              */
/********************************************************************************/

#ifndef _LLS_TEST_H_
#define _LLS_TEST_H_

#include "tests/rv/rv_test_filter_redirect.h"
#include "tests/rv/rv_test.h"

#if (LLS_TEST == SW_COMPILED)


extern T_RVF_MB_ID mb_lls_test;
extern T_RV_RETURN lls_test_path;

/********************************************************************************/
/*                                                                              */
/*      MACRO Name:      lls_test_trace                                         */
/*                                                                              */
/*      Purpose:      This macro is called to trace msg in LLS tests.           */
/*                                                                              */
/*      Note:         None.                                                     */
/*                                                                              */
/*      Revision History:                                                       */
/*      03/12/2002      Laurent Sollier         Create.                         */
/*                                                                              */
/********************************************************************************/
#define lls_test_trace(msg)\
{\
   rvf_send_trace ( msg, sizeof(msg)-1, NULL_PARAM, RV_TRACE_LEVEL_DEBUG_HIGH, TRACE_RVTEST);\
}

/********************************************************************************/
/*                                                                              */
/*      MACRO Name:      lls_test_error                                         */
/*                                                                              */
/*      Purpose:      This macro is called to trace ERROR msg in LLS tests.     */
/*                                                                              */
/*      Note:         None.                                                     */
/*                                                                              */
/*      Revision History:                                                       */
/*      03/12/2002      Laurent Sollier         Create.                         */
/*                                                                              */
/********************************************************************************/
#define lls_test_error(msg)\
{\
   rvf_send_trace ( msg, sizeof(msg)-1, NULL_PARAM, RV_TRACE_LEVEL_ERROR, TRACE_RVTEST);\
}



#endif /* #if (_LLS_TEST_H_ == SW_COMPILED) */
#endif