/********************************************************************************/
/*                                                                              */
/*      File Name:   lls_test.c                                                 */
/*                                                                              */
/*      Purpose:   This file contains LLS test generic functions.               */
/*                                                                              */
/*      Note:      None.                                                        */
/*                                                                              */
/*      Revision History:                                                       */
/*      03/12/2002      Laurent Sollier      Create.                            */
/*                                                                              */
/*   (C) Copyright 2002 by Texas Instruments Incorporated, All Rights Reserved  */
/*                                                                              */
/********************************************************************************/

#include "tests/rv/rv_test_filter_redirect.h"
#include "tests/rv/rv_test.h"

#if (LLS_TEST == SW_COMPILED)


/********************************************************************************/
/*   Global variables for tests                                                 */
/********************************************************************************/

T_RVF_MB_ID mb_lls_test;
T_RV_RETURN lls_test_path;

/********************************************************************************/
/*                                                                              */
/*      Function Name:   lls_test_set_mb_id                                     */
/*                                                                              */
/*      Purpose:      This function is called to set LLS test MB IDs.           */
/*                                                                              */
/*      Note:         None.                                                     */
/*                                                                              */
/*      Revision History:                                                       */
/*      03/12/2002      Laurent Sollier         Create.                         */
/*                                                                              */
/********************************************************************************/
void lls_test_set_mb_id (T_RVF_MB_ID mb_id[])
{
   mb_lls_test         = mb_id[0];
   lls_test_path.callback_func = NULL;
   lls_test_path.addr_id   = rvf_get_taskid();
}
/********************* End of lls_test_set_mb_id function *********************/



/********************************************************************************/
/*                                                                              */
/*      Function Name:   fix_lls_test_verdict                                   */
/*                                                                              */
/*      Purpose:      The purpose of this function is to fix test_verdict       */
/*                  param value depending on error_type param value.            */
/*                                                                              */
/*      Note:         None.                                                     */
/*                                                                              */
/*      Revision History:                                                       */
/*      03/12/2002      Laurent Sollier         Create.                         */
/*                                                                              */
/********************************************************************************/
   
T_RV_TEST_RET fix_lls_test_verdict (T_RV_TEST_ERR_TYPE *error_type)
{
   T_RV_TEST_RET test_verdict;
   
/******************** fix_lls_test_verdict function begins ********************/

   switch (*error_type)
   {
   case NO_ERR:
      {
         test_verdict = TEST_PASSED;
         break;
      }
   case NO_EVENT_RECV:
      {
         test_verdict = TEST_IRRECOVERABLY_FAILED;
         break;
      }
   case BAD_EVENT_RECV:
      {
         test_verdict = TEST_IRRECOVERABLY_FAILED;
         break;
      }
   case EVENT_PARAM_ERROR:
      {
         test_verdict = TEST_IRRECOVERABLY_FAILED;
         break;
      }
   case DATA_ERROR:
      {
         test_verdict = TEST_IRRECOVERABLY_FAILED;
         break;
      }
   case MEMORY_ERROR:
      {
         test_verdict = TEST_IRRECOVERABLY_FAILED;
         break;
      }
   default:
      {
         rvf_send_trace ("!!! ERROR !!! Wrong error_type value", 
                     36, 
                     NULL_PARAM, 
                     RV_TRACE_LEVEL_ERROR, 
                     TRACE_RVTEST);
         test_verdict = TEST_IRRECOVERABLY_FAILED;
         break;
      }
   } /* End of "switch (*error_type)" */

   return (test_verdict);
}

/******************** End of fix_lls_test_verdict function ********************/
#else

/*  Add a dummy function in order to allow compilation of the LLS test lib on
 ARM V1.22 compiler */
void lls_test_dummy(void)
{
}
#endif /* #if (LLS_TEST == SW_COMPILED) */