/**
 * @file   lls_api.c
 *
 * Implementation of Functions.
 *
 * @author   Laurent Sollier (l-sollier@ti.com)
 * @version 0.1
 */

/*
 * History:
 *
 *   Date          Author       Modification
 *  ----------------------------------------
 *  03/12/2002     L Sollier    Create
 *
 *
 * (C) Copyright 2002 by Texas Instruments Incorporated, All Rights Reserved
 */

#ifndef _WINDOWS
   #include "l1sw.cfg"
   #include "chipset.cfg"
#endif

#include "lls/lls_api.h"
#include "lls/lls_env.h"
#include "lls/lls_i.h"


/** External declaration */
extern T_LLS_ENV_CTRL_BLK* lls_env_ctrl_blk;


/**
 * @name Functions implementation
 *
 */
/*@{*/


/**
 * function: lls_switch_on
 */
T_RV_RET lls_switch_on(T_LLS_EQUIPMENT equipment_sort)
{
#if (ANLG_FAM == 2)
   T_RV_RET ret = RV_OK;
   UINT8 equipment_index;

   /* Check if initialization has been correctly done */
   if ( (lls_env_ctrl_blk == 0) || (lls_env_ctrl_blk->swe_is_initialized == FALSE) )
   {
      LLS_SEND_TRACE("LLS: Initialization is not yet done or failed", RV_TRACE_LEVEL_ERROR);
      return RV_INTERNAL_ERR;
   }

   LLS_SEND_TRACE_PARAM("LLS: Switch ON request for equipment", equipment_sort, RV_TRACE_LEVEL_DEBUG_HIGH);

   /* Retrieve index of the equipment in the table */
   ret = lls_search_index(equipment_sort, &equipment_index);

   if (ret != RV_OK)
   {
      LLS_SEND_TRACE("LLS: Equipment is unknow", RV_TRACE_LEVEL_ERROR);
      return ret;
   }

   ret = lls_manage_equipment(equipment_index, SWITCH_ON);

   return ret;

#else
   return RV_NOT_SUPPORTED;
#endif
}

/**
 * function: lls_switch_off
 *
 */
T_RV_RET lls_switch_off(T_LLS_EQUIPMENT equipment_sort)
{
#if (ANLG_FAM == 2)
   T_RV_RET ret = RV_OK;
   UINT8 equipment_index;

   /* Check if initialization has been correctly done */
   if ( (lls_env_ctrl_blk == 0) || (lls_env_ctrl_blk->swe_is_initialized == FALSE) )
   {
      LLS_SEND_TRACE("LLS: Initialization is not yet done or failed", RV_TRACE_LEVEL_ERROR);
      return RV_INTERNAL_ERR;
   }

   LLS_SEND_TRACE_PARAM("LLS: Switch OFF request for equipment", equipment_sort, RV_TRACE_LEVEL_DEBUG_HIGH);

   /* Retrieve index of the equipment in the table */
   ret = lls_search_index(equipment_sort, &equipment_index);

   if (ret != RV_OK)
   {
      LLS_SEND_TRACE("LLS: Equipment is unknow", RV_TRACE_LEVEL_ERROR);
      return ret;
   }

   ret = lls_manage_equipment(equipment_index, SWITCH_OFF);
   
   return ret;

#else
   return RV_NOT_SUPPORTED;
#endif
}


/*@}*/
