#
#       Makefile for LLS Riviera service (ARM compiler) 
#
#       Copyright (c) Texas Instruments 2002
# 
#               Author: Laurent Sollier
#       Date : 12 March 2002

# Compilation flags
LLS_FLAGS     = $(NODBG) $(16INST) -mn $(CFLAGSSERVICES)
WIN_LLS_FLAGS = $($(TP)CFLAGS) $(CFLAGSSERVICES)


# Libraries definition
LIB_LLS	    := $(OUT_LIB_DIR)/lls.lib 
CFG_LIBS    += $(LIB_LLS)


# Source definition
ifdef LLS_SOURCE
COMMON_SRC_LLS := $(SERVICES_DIR)/lls/lls_env.c \
                  $(SERVICES_DIR)/lls/lls_api.c \
                  $(SERVICES_DIR)/lls/lls_functions.c
SRC_LLS        := $(COMMON_SRC_LLS)
WIN_SRC_LLS    := $(COMMON_SRC_LLS)
endif


# Objects and dependencies definition
OBJ_LLS     := $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$($(TP)SRC_LLS)))
CFG_OBJS += $(OBJ_LLS)
CFG_DEPS += $(OBJ_LLS:.obj=.d)


######## LIBRARIES #############
$(LIB_LLS) : $(OBJ_LLS)
	$(MKDIR) $(dir $@)
	$($(TP)LINKER) $($(TP)LFLAGS) $($(TP)LOUTOUT_FLAG)$@ $^

######## OBJECTS #############
$(OBJ_LLS) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.c
	$($(TP)COMPILER) $($(TP)LLS_FLAGS) $($(TP)COUTPUT_FLAG)$(@D)/ $<
