#
#       Makefile for ETM Riviera service (ARM compiler) 
#
#       Copyright (c) Texas Instruments 2001
# 
#               Author: Stephanie Gerthoux
#       Date : 24 october 2001


# Compilation flags
ETM_FLAGS   := $(NODBG) $(16INST) -mn $(CFLAGSSERVICES)
WIN_ETM_FLAGS = $($(TP)CFLAGS) $(CFLAGSSERVICES)


# Libraries definition
LIB_ETM	    := $(OUT_LIB_DIR)/etm.lib 
CFG_LIBS    += $(LIB_ETM)


# Source definition
ifdef ETM_SOURCE
COMMON_SRC_ETM := $(SERVICES_DIR)/etm/etm_task.c \
                  $(SERVICES_DIR)/etm/etm_env.c \
                  $(SERVICES_DIR)/etm/etm_api.c \
                  $(SERVICES_DIR)/etm/etm_trace.c \
                  $(SERVICES_DIR)/etm/etm_at.c \
                  $(SERVICES_DIR)/etm/etm_audio.c \
                  $(SERVICES_DIR)/etm/etm_tmcore.c \
                  $(SERVICES_DIR)/etm/etm_tmpwr.c
SRC_ETM        := $(COMMON_SRC_ETM)
WIN_SRC_ETM    := $(COMMON_SRC_ETM)
endif


# Objects and dependencies definition
OBJ_ETM := $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$($(TP)SRC_ETM)))
CFG_OBJS += $(OBJ_ETM)
CFG_DEPS += $(OBJ_ETM:.obj=.d)


######## LIBRARIES #############
$(LIB_ETM) : $(OBJ_ETM)
	$(MKDIR) $(dir $@)
	$($(TP)LINKER) $($(TP)LFLAGS) $($(TP)LOUTOUT_FLAG)$@ $^

######## OBJECTS #############
$(OBJ_ETM) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.c
	$($(TP)COMPILER) $($(TP)ETM_FLAGS) $($(TP)COUTPUT_FLAG)$(@D)/ $<

