/**
 * @file    dcfg_pool_size.h
 *
 * Declarations of:
 * - the memory bank sizes and their watermark
 * - the SWE stack size
 * - the pool size needed (generally the sum of memory bank and stack sizes)
 *
 * @author	Pascal Pompei
 * @version 0.1
 */

/*
 * History:
 *
 *  Date       	Author                  Modification
 *  -------------------------------------------------------------------
 *  09/09/2003  Pascal Pompei           Extracted from rvf_pool_size.h
 *
 * (C) Copyright 2003 by Texas Instruments Incorporated, All Rights Reserved
 */

#ifndef __DCFG_POOL_SIZE_H_
#define __DCFG_POOL_SIZE_H_


/*
 * Values used in dcfg_env.h
 */
#define DCFG_STACK_SIZE                          (1024)
#define DCFG_MB1_SIZE                            (24)
#define DCFG_POOL_SIZE                           (DCFG_STACK_SIZE + DCFG_MB1_SIZE)


#endif /*__DCFG_POOL_SIZE_H_*/
