#
#       Makefile for the Test of DAR Riviera service (ARM compiler) 
#
#       Copyright (c) Texas Instruments 2001
# 
#               Author: Stephanie Gerthoux
#       Date : 25 october 2001

# Compilation flags
DAR_TEST_FLAGS     := $(NODBG) $(16INST) -mn $(CFLAGSSERVICES_TESTS)
WIN_DAR_TEST_FLAGS := $($(TP)CFLAGS) $(CFLAGSSERVICES_TESTS)

# Libraries definition
LIB_DAR_TEST   := $(OUT_LIB_DIR)/dar_tests.lib 
CFG_LIBS    += $(LIB_DAR_TEST)

# Source definition
COMMON_SRC_DAR_TEST := $(SERVICES_DIR)/dar/tests/dar_test.c \
                       $(SERVICES_DIR)/dar/tests/dar_test_regr.c \
		               $(SERVICES_DIR)/dar/tests/dar_test_misc.c

SRC_DAR_TEST        := $(COMMON_SRC_DAR_TEST)
WIN_SRC_DAR_TEST    := $(COMMON_SRC_DAR_TEST)


# Objects and dependencies definition
OBJ_DAR_TEST := $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$($(TP)SRC_DAR_TEST)))
CFG_OBJS += $(OBJ_DAR_TEST)
CFG_DEPS += $(OBJ_DAR_TEST:.obj=.d)


######## LIBRARIES #############
$(LIB_DAR_TEST) : $(OBJ_DAR_TEST)
	$(MKDIR) $(dir $@)
	$($(TP)LINKER) $($(TP)LFLAGS) $($(TP)LOUTOUT_FLAG)$@ $^

######## OBJECTS #############
$(OBJ_DAR_TEST) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.c
	$($(TP)COMPILER) $($(TP)DAR_TEST_FLAGS) $($(TP)COUTPUT_FLAG)$(@D)/ $<

