/********************************************************************************/
/*                                                                              */
/*   File Name:   dar_test_regr.c                                               */
/*                                                                              */
/*   Purpose:   This file gathers non regression tests for DAR.                 */
/*                                                                              */
/*   Note:    None.                                                             */
/*                                                                              */
/*   Version    0.1                                                             */
/*                                                                              */
/*   Date                      Modification                                     */
/*   ---------------------------------------------------------------------------*/
/*   27 September 2001   Create                                                 */
/*                                                                              */
/*   Author         Stephanie Gerthoux                                          */
/*                                                                              */
/* (C) Copyright 2001 by Texas Instruments Incorporated, All Rights Reserved    */
/********************************************************************************/

/********************************************************************************/
/*                                                                              */
/*   Include files used for Diaagnose riviera testing.                          */
/*                                                                              */
/********************************************************************************/

#include "dar/tests/dar_test.h"
#include "rv/rv_defined_swe.h"

#ifdef RVM_DAR_SWE
#if (DAR_REGR == SW_COMPILED) 

   #include "rv/rv_general.h"
   #include "rvm/rvm_use_id_list.h"
   #include "rvm/rvm_gen.h"
   #include "dar/tests/dar_test_regr.h"
   #include "dar/dar_api.h"
   #include "dar/dar_structs_i.h"
   #include "dar/dar_messages_i.h"
   #include "rvf/rvf_target.h"
   #include "dar/dar_const_i.h"
   #include "dar/dar_error_hdlr_i.h"
   #include "dar/dar_macro_i.h"

   /**** Global variables ****/
   /* Define a pointer to the Global Environment Control block   */
   extern T_DAR_ENV_CTRL_BLK *dar_gbl_var_p;



   /********************************************************************************/
   /*                                                                              */
   /*   Declare function prototype used for Riviera DAR testing.                   */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_test_regr_return_verdict ( T_RV_REGR_ERR_TYPE error_type);


   /* global variable to detect if the call back function was called */
   INT8    dar_call_back_called = 1;

   extern char dar_write_buffer[DAR_MAX_BUFFER_SIZE];

   /********************************************************************************/
   /*                                                                              */
   /*                                DAR CALLBACK FUNCTION                         */
   /*                                                                              */
   /* Description: call back funtion used for the DAR test                         */
   /*                                                                              */
   /*                                                                              */
   /********************************************************************************/
   T_RV_RET dar_callback_test_function (T_DAR_BUFFER buffer_p)
   {
      rvf_free_buf((T_RVF_BUFFER *)buffer_p);
      RV_TEST_TRACE_LOW ("DAR TEST REGR:DAR CALLBACK FUNCTION");
      return(RV_OK);
   }
   /********************* End of dar_callback_function *****************************/

   /********************************************************************************/
   /*                                                                              */
   /*                              DAR STORE RECOVERY DATA FUNCTION                */
   /*                                                                              */
   /* Decription: Store data before a reset                                        */
   /*                                                                              */
   /*                                                                              */
   /********************************************************************************/
    T_RV_RET dar_store_recovery_data(T_DAR_BUFFER buffer_p,UINT16 length)
    {
       UINT8 i=0;
       for(i=0;i<length;i++)
       {
          buffer_p[i] = 9;
       }
       return(RV_OK);
    }

   /********************************************************************************/
   /*                                                                              */
   /*                             DAR TEST REGISTER                                */
   /*                                                                              */
   /* Decription: test register funtion used to save the return path               */
   /*                                                                              */
   /*                                                                              */
   /********************************************************************************/
   T_RV_RET dar_test_register (T_RV_RETURN return_path)
   {
      if (return_path.callback_func == NULL)
      {
         dar_gbl_var_p->return_path.addr_id = return_path.addr_id;
         dar_gbl_var_p->return_path.callback_func = NULL;
      }
      else
      {
         dar_gbl_var_p->return_path.callback_func = return_path.callback_func;
      }
      return(RV_OK);
   }
   /********************* End of dar_test_register   ********************************/

   /********************************************************************************/
   /*                                                                              */
   /*                            DAR NON REGRESSION TEST 1                         */
   /*                                                                              */
   /* Decription: Test the dar filter function.                                    */
   /*             Add a group		                                               */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_1 (T_RV_REGR_ERR_TYPE *error_type)
   {
      T_RVM_USE_ID       filter_use_id;
      T_RV_RETURN         return_path;
      UINT8                  i;

      /* initalize the return path, for this test the return path is a message */
      return_path.callback_func = NULL;
      return_path.addr_id          = rvf_get_taskid();

      /*----------------------------------------------------------------------------*/
      /* start the dar filter                                                       */
      /*----------------------------------------------------------------------------*/
      /* fill the filter parameter */
      filter_use_id = KPD_USE_ID; 
      
      /* start the dar filter - Add the group */
      if (dar_diagnose_swe_filter(filter_use_id, DAR_DEBUG) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /* wait 1s */
      rvf_delay(RVF_MS_TO_TICKS(1000));

      for (i=0; i<DAR_MAX_GROUP_NB; i++)
      {
          DAR_SEND_TRACE_PARAM("filter_array group test",dar_gbl_var_p ->dar_filter_array[i].group_nb,RV_TRACE_LEVEL_DEBUG_HIGH);
          DAR_SEND_TRACE_PARAM("filter_array warning test",dar_gbl_var_p ->dar_filter_array[i].mask_warning,RV_TRACE_LEVEL_DEBUG_HIGH);
          DAR_SEND_TRACE_PARAM("filter_array debug test",dar_gbl_var_p ->dar_filter_array[i].mask_debug,RV_TRACE_LEVEL_DEBUG_HIGH);
      }
    
      rvf_delay(RVF_MS_TO_TICKS(3000));

      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_1 function ***************************/

   /********************************************************************************/
   /*                                                                              */
   /*                                          DAR NON REGRESSION TEST 2           */
   /*                                                                              */
   /* Decription: Test the dar filter function.                                    */
   /*             Search a group                                                   */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_2 (T_RV_REGR_ERR_TYPE *error_type)
   {
      T_RVM_USE_ID       filter_use_id1;
      T_RVM_USE_ID       filter_use_id2;
      T_RV_RETURN        return_path;
      UINT8              i;

      /* initalize the return path, for this test the return path is a message */
      return_path.callback_func = NULL;
      return_path.addr_id       = rvf_get_taskid();

      /*----------------------------------------------------------------------------*/
      /* start the dar filter                                                       */
      /*----------------------------------------------------------------------------*/
      /* fill the filter parameter use1 */
      filter_use_id1 = KPD_USE_ID; 
      
      /* start the dar filter use1 */
      if (dar_diagnose_swe_filter(filter_use_id1, DAR_WARNING) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /* Wait 1s */
      rvf_delay(RVF_MS_TO_TICKS(1000));

      /*----------------------------------------------------------------------------*/
      /* Add the dar filter 2                                                       */
      /*----------------------------------------------------------------------------*/
      /* fill the filter parameter */
      filter_use_id2 = RTC_USE_ID;
      
      /* start the dar filter - Warning level*/
      if (dar_diagnose_swe_filter(filter_use_id2, DAR_WARNING) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /* Wait 1s */
      rvf_delay(RVF_MS_TO_TICKS(1000));

      for (i=0; i<DAR_MAX_GROUP_NB; i++)
      {
          DAR_SEND_TRACE_PARAM("filter_array group test",dar_gbl_var_p ->dar_filter_array[i].group_nb,RV_TRACE_LEVEL_DEBUG_HIGH);
          DAR_SEND_TRACE_PARAM("filter_array warning test",dar_gbl_var_p ->dar_filter_array[i].mask_warning,RV_TRACE_LEVEL_DEBUG_HIGH);
          DAR_SEND_TRACE_PARAM("filter_array debug test",dar_gbl_var_p ->dar_filter_array[i].mask_debug,RV_TRACE_LEVEL_DEBUG_HIGH);
      }

      /* start the dar filter - Debug level*/
      if (dar_diagnose_swe_filter(filter_use_id2, DAR_DEBUG) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /* Wait 1s */
      rvf_delay(RVF_MS_TO_TICKS(1000));

      for (i=0; i<DAR_MAX_GROUP_NB; i++)
      {
          DAR_SEND_TRACE_PARAM("filter_array group test",dar_gbl_var_p ->dar_filter_array[i].group_nb,RV_TRACE_LEVEL_DEBUG_HIGH);
          DAR_SEND_TRACE_PARAM("filter_array warning test",dar_gbl_var_p ->dar_filter_array[i].mask_warning,RV_TRACE_LEVEL_DEBUG_HIGH);
          DAR_SEND_TRACE_PARAM("filter_array debug test",dar_gbl_var_p ->dar_filter_array[i].mask_debug,RV_TRACE_LEVEL_DEBUG_HIGH);
      }
         
      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_2 function ***************************/

   /********************************************************************************/
   /*                                                                              */
   /*                DAR NON REGRESSION TEST 3                                     */
   /*                                                                              */
   /* Decription: Test the dar filter function.                                    */
   /*             DELETE a group		                                           */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_3 (T_RV_REGR_ERR_TYPE *error_type)
   {
      T_RVM_USE_ID       filter_use_id;
      T_RV_RETURN         return_path;
      UINT8                  i;

      /* initalize the return path, for this test the return path is a message */
      return_path.callback_func = NULL;
      return_path.addr_id       = rvf_get_taskid();

      /*----------------------------------------------------------------------------*/
      /* start the dar filter                                                       */
      /*----------------------------------------------------------------------------*/
      /* fill the filter parameter */
      filter_use_id = KPD_USE_ID; 
      
      /* start the dar filter */
      /* Add the Debug level (Add Debug + Warning level */
      if (dar_diagnose_swe_filter(filter_use_id, DAR_DEBUG) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /* Wait 1s*/
      rvf_delay(RVF_MS_TO_TICKS(1000));

      for (i=0; i<DAR_MAX_GROUP_NB; i++)
         {
          DAR_SEND_TRACE_PARAM("filter_array group test",dar_gbl_var_p ->dar_filter_array[i].group_nb,RV_TRACE_LEVEL_DEBUG_HIGH);
          DAR_SEND_TRACE_PARAM("filter_array warning test",dar_gbl_var_p ->dar_filter_array[i].mask_warning,RV_TRACE_LEVEL_DEBUG_HIGH);
          DAR_SEND_TRACE_PARAM("filter_array debug test",dar_gbl_var_p ->dar_filter_array[i].mask_debug,RV_TRACE_LEVEL_DEBUG_HIGH);
         }

      /* Delete the Warning level */
      /* It deletes the Warning and Debug Level */
      if (dar_diagnose_swe_filter(filter_use_id, DAR_WARNING) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /* Wait 1s */
      rvf_delay(RVF_MS_TO_TICKS(1000));

      for (i=0; i<DAR_MAX_GROUP_NB; i++)
         {
          DAR_SEND_TRACE_PARAM("filter_array group test",dar_gbl_var_p ->dar_filter_array[i].group_nb,RV_TRACE_LEVEL_DEBUG_HIGH);
          DAR_SEND_TRACE_PARAM("filter_array warning test",dar_gbl_var_p ->dar_filter_array[i].mask_warning,RV_TRACE_LEVEL_DEBUG_HIGH);
          DAR_SEND_TRACE_PARAM("filter_array debug test",dar_gbl_var_p ->dar_filter_array[i].mask_debug,RV_TRACE_LEVEL_DEBUG_HIGH);
         }
 
      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_3 function ***************************/

   /********************************************************************************/
   /*                                                                              */
   /*                          DAR NON REGRESSION TEST 4                           */
   /*                                                                              */
   /* Decription: Test the dar filter function.                                    */
   /*                   add more than DAR max number group                         */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_4 (T_RV_REGR_ERR_TYPE *error_type)
   {
      T_RVM_USE_ID      filter_use_id0;
      T_RVM_USE_ID      filter_use_id1;
      T_RVM_USE_ID      filter_use_id2;
      T_RVM_USE_ID      filter_use_id3;
      T_RVM_USE_ID      filter_use_id4;
      T_RV_RETURN         return_path;
      UINT8                  i;

      /* initalize the return path, for this test the return path is a message */
      return_path.callback_func = NULL;
      return_path.addr_id       = rvf_get_taskid();

      /*----------------------------------------------------------------------------*/
      /* start the dar filter                                                       */
      /*----------------------------------------------------------------------------*/
      /* fill the filter parameter */
      filter_use_id0 = RVM_USE_ID; 

      filter_use_id1 = KPD_USE_ID; 
   
      filter_use_id2 = HCI_USE_ID; 

      filter_use_id3 = AUDIO_USE_ID; 

      filter_use_id4 = MKS_USE_ID; 
       
      /* start the dar filter */
      if (dar_diagnose_swe_filter(filter_use_id0, DAR_WARNING) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }
      rvf_delay(RVF_MS_TO_TICKS(1000));

      if (dar_diagnose_swe_filter(filter_use_id1, DAR_WARNING) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }
      rvf_delay(RVF_MS_TO_TICKS(1000));

      if (dar_diagnose_swe_filter(filter_use_id2, DAR_WARNING) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }
      rvf_delay(RVF_MS_TO_TICKS(1000));

      if (dar_diagnose_swe_filter(filter_use_id3, DAR_WARNING) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }
      rvf_delay(RVF_MS_TO_TICKS(1000));

      if (dar_diagnose_swe_filter(filter_use_id4, DAR_WARNING) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }
      rvf_delay(RVF_MS_TO_TICKS(1000));

      for (i=0; i<DAR_MAX_GROUP_NB; i++)
         {
          //DAR_SEND_TRACE_PARAM("filter_array group test",dar_gbl_var_p ->dar_filter_array[i].group_nb,RV_TRACE_LEVEL_DEBUG_HIGH);
          //DAR_SEND_TRACE_PARAM("filter_array warning test",dar_gbl_var_p ->dar_filter_array[i].mask_warning,RV_TRACE_LEVEL_DEBUG_HIGH);
          //DAR_SEND_TRACE_PARAM("filter_array debug test",dar_gbl_var_p ->dar_filter_array[i].mask_debug,RV_TRACE_LEVEL_DEBUG_HIGH);
         }
   
      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_4 function ***************************/

   /********************************************************************************/
   /*                                                                              */
   /*                            DAR NON REGRESSION TEST 5                         */
   /*                                                                              */
   /* Decription: Test the dar write function.                                     */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_5 (T_RV_REGR_ERR_TYPE *error_type)
   {
      T_RVM_USE_ID       filter_use_id; /* Use ID */
      T_RVM_USE_ID       filter_use_id_2; /* Use ID */
      T_RV_RETURN        return_path;
      UINT16              i;
      T_DAR_INFO         *buffer_p= "KPD test"; /* diagnose data to store */
      T_DAR_INFO         *buffer_2_p= "KPD +1 test"; /* diagnose data to store */
      T_DAR_INFO         *buffer_3_p= "Warning Audio without filter"; /* diagnose data to store */


      /* initalize the return path, for this test the return path is a message */
      return_path.callback_func = NULL;
      return_path.addr_id       = rvf_get_taskid();

      /*----------------------------------------------------------------------------*/
      /* start the dar filter                                                       */
      /*----------------------------------------------------------------------------*/
      /* fill the filter parameter use1 */
      filter_use_id = KPD_USE_ID; 
      filter_use_id_2 = (KPD_USE_ID + 0x60); 
       
      /* start the dar filter */
      if (dar_diagnose_swe_filter(filter_use_id, DAR_WARNING) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /* start the dar filter */
      if (dar_diagnose_swe_filter(filter_use_id_2, DAR_DEBUG) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /* Wait 1s */
      rvf_delay(RVF_MS_TO_TICKS(1000));

      for (i=0; i<DAR_MAX_GROUP_NB; i++)
         {
          DAR_SEND_TRACE_PARAM("filter_array group test",dar_gbl_var_p ->dar_filter_array[i].group_nb,RV_TRACE_LEVEL_DEBUG_HIGH);
          DAR_SEND_TRACE_PARAM("filter_array warning test",dar_gbl_var_p ->dar_filter_array[i].mask_warning,RV_TRACE_LEVEL_DEBUG_HIGH);
          DAR_SEND_TRACE_PARAM("filter_array debug test",dar_gbl_var_p ->dar_filter_array[i].mask_debug,RV_TRACE_LEVEL_DEBUG_HIGH);
         }

      /* start the dar diagnose write function */
      for (i=0; i<1000; i++)
      {
			if ( dar_diagnose_write( buffer_p,
		                           DAR_ASCII_FORMAT,
			                       DAR_WARNING,
				                   filter_use_id) != RV_OK)
			{
				*error_type = FUNCTION_ERROR;
				return (dar_test_regr_return_verdict(*error_type));
			}
	  }
      rvf_delay(RVF_MS_TO_TICKS(1000));
      
      /* start the dar diagnose write function */
      if ( dar_diagnose_write( buffer_2_p,
                               DAR_ASCII_FORMAT,
                               DAR_WARNING,
                               filter_use_id_2) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      rvf_delay(RVF_MS_TO_TICKS(1000));
      
      /* Audio warning without filtering */
      rvf_send_trace (buffer_3_p,(sizeof("Warning Audio without filter")-1),NULL_PARAM,RV_TRACE_LEVEL_WARNING,AUDIO_USE_ID);

      //for (i=0; i<DAR_MAX_BUFFER_SIZE; i++)
      //{
      //   DAR_SEND_TRACE_PARAM("Diagnose write test",dar_write_buffer[i],RV_TRACE_LEVEL_DEBUG_HIGH);
      //}

      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_5 function ***************************/

   /********************************************************************************/
   /*                                                                              */
   /*                     DAR NON REGRESSION TEST 6                                */
   /*                                                                              */
   /* Decription: Test the dar write function with a bad mask level.               */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_6 (T_RV_REGR_ERR_TYPE *error_type)
   {
      T_RVM_USE_ID       filter_use_id; /* Use ID */
      T_RV_RETURN         return_path;
      UINT8                  i;
      T_DAR_INFO          *buffer_p= "Diagnose Test"; /* diagnose data to store */


      /* initalize the return path, for this test the return path is a message */
      return_path.callback_func = NULL;
      return_path.addr_id          = rvf_get_taskid();

      /*----------------------------------------------------------------------------*/
      /* start the dar filter                                                       */
      /*----------------------------------------------------------------------------*/
      /* fill the filter parameter use1 */
      filter_use_id = AUDIO_USE_ID; 

      /* start the dar filter */
      if (dar_diagnose_swe_filter(filter_use_id, DAR_DEBUG) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /* Wait 1s */
      rvf_delay(RVF_MS_TO_TICKS(1000));

      for (i=0; i<DAR_MAX_GROUP_NB; i++)
         {
          //DAR_SEND_TRACE_PARAM("filter_array group test",dar_gbl_var_p ->dar_filter_array[i].group_nb,RV_TRACE_LEVEL_DEBUG_HIGH);
          //DAR_SEND_TRACE_PARAM("filter_array warning test",dar_gbl_var_p ->dar_filter_array[i].mask_warning,RV_TRACE_LEVEL_DEBUG_HIGH);
          //DAR_SEND_TRACE_PARAM("filter_array debug test",dar_gbl_var_p ->dar_filter_array[i].mask_debug,RV_TRACE_LEVEL_DEBUG_HIGH);
         }

      /* start the dar diagnose write function */
      if ( dar_diagnose_write( buffer_p,
                               DAR_ASCII_FORMAT,
                               DAR_DEBUG,
                               filter_use_id) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      rvf_delay(RVF_MS_TO_TICKS(1000));

      //for (i=0; i<DAR_MAX_BUFFER_SIZE; i++)
      //{
         //DAR_SEND_TRACE_PARAM("Diagnose write test",dar_write_buffer[i],RV_TRACE_LEVEL_DEBUG_HIGH);
      //}

      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_6 function ***************************/


   /***********************************************************************************/
   /*                                                                                 */
   /*                                          DAR NON REGRESSION TEST 7              */
   /*                                                                                 */
   /* Decription: Test the dar write function.                                        */
   /*                   Write more data than DAR Buffer max size in order to test the */
   /*                   circular buffer.                                              */
   /*                                                                                 */
   /***********************************************************************************/
   T_RV_REGR_RET dar_regr_test_7 (T_RV_REGR_ERR_TYPE *error_type)
   {
      T_RVM_USE_ID    filter_use_id; /* Use ID */
      T_RV_RETURN     return_path;
      UINT8           i;
      /* diagnose data to store */
      T_DAR_INFO      *buffer_p= "DAR circular buffer tested "; 

      /* initalize the return path, for this test the return path is a message */
      return_path.callback_func = NULL;
      return_path.addr_id       = rvf_get_taskid();

      /*----------------------------------------------------------------------------*/
      /* start the dar filter                                                       */
      /*----------------------------------------------------------------------------*/
      /* fill the filter parameter use1 */
      filter_use_id = AUDIO_USE_ID; 
       
      /* start the dar filter */
      if (dar_diagnose_swe_filter(filter_use_id, DAR_WARNING) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      rvf_delay(RVF_MS_TO_TICKS(1000));

      /* start the dar diagnose write function */
      if ( dar_diagnose_write( buffer_p,
                               DAR_ASCII_FORMAT,
                               DAR_WARNING,
                               filter_use_id) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /* Wait 1s */
      rvf_delay(RVF_MS_TO_TICKS(1000));

      //for (i=0; i<DAR_MAX_BUFFER_SIZE; i++)
        // {
            //DAR_SEND_TRACE_PARAM("Diagnose write test",dar_write_buffer[i],RV_TRACE_LEVEL_DEBUG_HIGH);
         //}

      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_7 function ***************************/

   /********************************************************************************/
   /*                                                                              */
   /*                          DAR NON REGRESSION TEST 8                           */
   /*                                                                              */
   /* Decription: Test the dar write function.                                     */
   /*                   Store 2 string                                             */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_8 (T_RV_REGR_ERR_TYPE *error_type)
   {
      T_RVM_USE_ID  filter_use_id1; /* Use ID1 */
      T_RVM_USE_ID  filter_use_id2; /* Use ID2 */
      T_RV_RETURN   return_path;
      UINT8         i;
      T_DAR_INFO    *buffer_p_1= "Diagnose test"; /* diagnose data to store */
      T_DAR_INFO    *buffer_p_2= "DAR";           /* diagnose data to store */



      /* initalize the return path, for this test the return path is a message */
      return_path.callback_func = NULL;
      return_path.addr_id       = rvf_get_taskid();

      /*------------------------------------------------------------------------------*/
      /* start the dar filter 1                                                       */
      /*------------------------------------------------------------------------------*/
      /* fill the filter parameter use1 */
      filter_use_id1= AUDIO_USE_ID; 
       
      /* start the dar filter */
      if (dar_diagnose_swe_filter(filter_use_id1, DAR_WARNING) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /*------------------------------------------------------------------------------*/
      /* start the dar filter 2                                                       */
      /*------------------------------------------------------------------------------*/
      /* fill the filter parameter use2 */
      filter_use_id2 = KPD_USE_ID; 
       
      /* start the dar filter */
      if (dar_diagnose_swe_filter(filter_use_id2, DAR_DEBUG) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /* Wait 1s */
      rvf_delay(RVF_MS_TO_TICKS(1000));

      for (i=0; i<DAR_MAX_GROUP_NB; i++)
      {
          //DAR_SEND_TRACE_PARAM("filter_array group test",dar_gbl_var_p ->dar_filter_array[i].group_nb,RV_TRACE_LEVEL_DEBUG_HIGH);
          //DAR_SEND_TRACE_PARAM("filter_array warning test",dar_gbl_var_p ->dar_filter_array[i].mask_warning,RV_TRACE_LEVEL_DEBUG_HIGH);
          //DAR_SEND_TRACE_PARAM("filter_array debug test",dar_gbl_var_p ->dar_filter_array[i].mask_debug,RV_TRACE_LEVEL_DEBUG_HIGH);
      }

      /*------------------------------------------------------------------------------*/
      /* start the dar diagnose write                                                 */
      /*------------------------------------------------------------------------------*/

      /* start the dar_filter_1 diagnose write function */
      if ( dar_diagnose_write( buffer_p_1,
                               DAR_ASCII_FORMAT,
                               DAR_WARNING,
                               filter_use_id1) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /* start the dar_filter_2 diagnose write function */
      if ( dar_diagnose_write( buffer_p_2,
                               DAR_ASCII_FORMAT,
                               DAR_DEBUG,
                               filter_use_id2) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      rvf_delay(RVF_MS_TO_TICKS(1000));

     // for (i=0; i<DAR_MAX_BUFFER_SIZE; i++)
      //{
         //DAR_SEND_TRACE_PARAM("Diagnose write test",dar_write_buffer[i],RV_TRACE_LEVEL_DEBUG_HIGH);
      //}

      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_8 function ***************************/

   /********************************************************************************/
   /*                                                                              */
   /*                       DAR NON REGRESSION TEST 9                              */
   /*                                                                              */
   /* Decription: Test the dar write function.                                     */
   /*                   Test the DAR_NO_DIAGNOSE message                           */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_9 (T_RV_REGR_ERR_TYPE *error_type)
   {
      T_RVM_USE_ID   filter_use_id1; /* Use ID1 */
      T_RV_RETURN    return_path;
      UINT8          i;
      T_DAR_INFO     *buffer_p_1= "Diagnose test"; /* diagnose data to store */
      
      /* initalize the return path, for this test the return path is a message */
      return_path.callback_func = NULL;
      return_path.addr_id       = rvf_get_taskid();

      /*------------------------------------------------------------------------------*/
      /* start the dar filter 1                                                       */
      /*------------------------------------------------------------------------------*/
      /* fill the filter parameter use1 */
      filter_use_id1= AUDIO_USE_ID; 
       
      /* start the dar filter with debiug level */
      if (dar_diagnose_swe_filter(filter_use_id1, DAR_DEBUG) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /* Wait 1s */
      rvf_delay(RVF_MS_TO_TICKS(1000));

      /*------------------------------------------------------------------------------*/
      /* start the dar diagnose write                                                                         */
      /*------------------------------------------------------------------------------*/

      /* start the dar_filter_1 diagnose write function wih debug level */
      if ( dar_diagnose_write( buffer_p_1,
                               DAR_ASCII_FORMAT,
                               DAR_DEBUG,
                               filter_use_id1) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /* wait 1s */
      rvf_delay(RVF_MS_TO_TICKS(1000));

      //for (i=0; i<DAR_MAX_BUFFER_SIZE; i++)
      //{
         //DAR_SEND_TRACE_PARAM("Diagnose write test",dar_write_buffer[i],RV_TRACE_LEVEL_DEBUG_HIGH);
      //}

      /*------------------------------------------------------------------------------*/
      /* start the dar filter 1                                                       */
      /*------------------------------------------------------------------------------*/
      /* fill the filter parameter use1 */
      filter_use_id1 = AUDIO_USE_ID; 
       
      /* start the dar filter with no_diagnose level*/
      if (dar_diagnose_swe_filter(filter_use_id1, DAR_NO_DIAGNOSE) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /* Wait 1s */
      rvf_delay(RVF_MS_TO_TICKS(1000));

      for (i=0; i<DAR_MAX_GROUP_NB; i++)
      {
          //DAR_SEND_TRACE_PARAM("filter_array group test",dar_gbl_var_p ->dar_filter_array[i].group_nb,RV_TRACE_LEVEL_DEBUG_HIGH);
          //DAR_SEND_TRACE_PARAM("filter_array warning test",dar_gbl_var_p ->dar_filter_array[i].mask_warning,RV_TRACE_LEVEL_DEBUG_HIGH);
          //DAR_SEND_TRACE_PARAM("filter_array debug test",dar_gbl_var_p ->dar_filter_array[i].mask_debug,RV_TRACE_LEVEL_DEBUG_HIGH);
      }

      /* start the dar_filter_1 diagnose write function with debug level */
      /* The dar filter has been started with no_diagnose_level. So an error must be occured*/
      if ( dar_diagnose_write( buffer_p_1,
                               DAR_ASCII_FORMAT,
                               DAR_DEBUG,
                               filter_use_id1) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      rvf_delay(RVF_MS_TO_TICKS(1000));

      //for (i=0; i<DAR_MAX_BUFFER_SIZE; i++)
      //{
         //DAR_SEND_TRACE_PARAM("Diagnose write test",dar_write_buffer[i],RV_TRACE_LEVEL_DEBUG_HIGH);
      //}

      /* Wait 1s */
      rvf_delay(RVF_MS_TO_TICKS(1000));

      for (i=0; i<DAR_MAX_GROUP_NB; i++)
      {
          //DAR_SEND_TRACE_PARAM("filter_array group test",dar_gbl_var_p ->dar_filter_array[i].group_nb,RV_TRACE_LEVEL_DEBUG_HIGH);
          //DAR_SEND_TRACE_PARAM("filter_array warning test",dar_gbl_var_p ->dar_filter_array[i].mask_warning,RV_TRACE_LEVEL_DEBUG_HIGH);
          //DAR_SEND_TRACE_PARAM("filter_array debug test",dar_gbl_var_p ->dar_filter_array[i].mask_debug,RV_TRACE_LEVEL_DEBUG_HIGH);
      }

      /* start the dar_filter_1 diagnose write function with warning level*/
      /* The dar filter has been started with no_diagnose_level. So an error must be occured*/
      if ( dar_diagnose_write( buffer_p_1,
                               DAR_ASCII_FORMAT,
                               DAR_WARNING,
                               filter_use_id1) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      rvf_delay(RVF_MS_TO_TICKS(1000));

      //for (i=0; i<DAR_MAX_BUFFER_SIZE; i++)
      //{
         //DAR_SEND_TRACE_PARAM("Diagnose write test",dar_write_buffer[i],RV_TRACE_LEVEL_DEBUG_HIGH);
      //}

      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_9 function ***************************/

   /********************************************************************************/
   /*                                                                              */
   /*                          DAR NON REGRESSION TEST 10                          */
   /*                                                                              */
   /* Decription: Test the dar emergency function.                                 */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_10 (T_RV_REGR_ERR_TYPE *error_type)
   {
      T_RVM_USE_ID  filter_use_id; /* Use ID */
      T_RV_RETURN   return_path;
      UINT8         i;
      T_DAR_INFO    *buffer_p= "DAR emergency"; /* diagnose data to store */


      /* initalize the return path, for this test the return path is a message */
      return_path.callback_func = NULL;
      return_path.addr_id       = rvf_get_taskid();

      /* call the dar recovery config */
      dar_recovery_config(dar_store_recovery_data);

      /*----------------------------------------------------------------------------*/
      /* start the dar emergency                                                    */
      /*----------------------------------------------------------------------------*/
      /* fill the filter parameter use1 */
      filter_use_id= AUDIO_USE_ID; 

      DAR_SEND_TRACE("The system will be reset",RV_TRACE_LEVEL_DEBUG_HIGH);
      rvf_delay(RVF_MS_TO_TICKS(1000));
       
      /* start the dar diagnose write function */
      if ( dar_diagnose_generate_emergency( buffer_p,
                                            DAR_ASCII_FORMAT,
                                            filter_use_id) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      rvf_delay(RVF_MS_TO_TICKS(1000));

      //for (i=0; i<DAR_MAX_BUFFER_SIZE; i++)
      //{
         //DAR_SEND_TRACE_PARAM("Diagnose emergency test",(UINT8)dar_write_buffer[i],RV_TRACE_LEVEL_DEBUG_HIGH);
      //}

      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_10 function ***************************/
   
 
   /********************************************************************************/
   /*                                                                              */
   /*                             DAR NON REGRESSION TEST 11                       */
   /*                                                                              */
   /* Decription: Test the dar_reccovery_get_status after a power ON/OFF           */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_11 (T_RV_REGR_ERR_TYPE *error_type)
   {
      T_DAR_RECOVERY_STATUS status=0;

      /* call the dar recovery config */
      dar_recovery_config(dar_store_recovery_data);

      /*------------------------------------------------------------------------------*/
      /* start the dar_recovery_get_status                                            */
      /*------------------------------------------------------------------------------*/

      /* Get the status */
      if (dar_recovery_get_status(&status)!= RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }
   
      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_11 function ***************************/

   /********************************************************************************/
   /*                                                                              */
   /*                            DAR NON REGRESSION TEST 12                        */
   /*                                                                              */
   /* Decription: Test the dar_reset_system                                        */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_12 (T_RV_REGR_ERR_TYPE *error_type)
   {
      /* call the dar recovery config */
      dar_recovery_config(dar_store_recovery_data);

      DAR_SEND_TRACE("The system will be reset",RV_TRACE_LEVEL_DEBUG_HIGH);
      rvf_delay(RVF_MS_TO_TICKS(1000));

      /*---------------------------------------------------------------------------*/
      /* start the dar_reset_system                                                */
      /*---------------------------------------------------------------------------*/
      if (dar_reset_system()!= RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }
      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_12 function ***************************/

   /********************************************************************************/
   /*                                                                              */
   /*                            DAR NON REGRESSION TEST 13                        */
   /*                                                                              */
   /* Decription: Test the Dar_diagnose_generate_emergency.                        */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_13 (T_RV_REGR_ERR_TYPE *error_type)
   {
      T_RVM_USE_ID   filter_use_id; /* Use ID */
      T_DAR_INFO     *buffer_p= "DAR EMERGENCY "; /* diagnose data to store */

      /* call the dar recovery config */
      dar_recovery_config(dar_store_recovery_data);

      /*----------------------------------------------------------------------------*/
      /* start the dar emergency                                                    */
      /*----------------------------------------------------------------------------*/
      /* fill the filter parameter use1 */
      filter_use_id = AUDIO_USE_ID; 

       DAR_SEND_TRACE("The system will be reset",RV_TRACE_LEVEL_DEBUG_HIGH);
      rvf_delay(RVF_MS_TO_TICKS(1000));


      /* Generate an emergency */
      if (dar_diagnose_generate_emergency(buffer_p,DAR_ASCII_FORMAT, filter_use_id)!= RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_13 function ***************************/

   /********************************************************************************/
   /*                                                                              */
   /*                           DAR NON REGRESSION TEST 14                         */
   /*                                                                              */
   /* Decription: Test the dar_start_watchdog_timer.                               */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_14 (T_RV_REGR_ERR_TYPE *error_type)
   {
      UINT16 timer = 3000; /* 3000 millisecondes before the timer expires */

      /* call the dar recovery config */
      dar_recovery_config(dar_store_recovery_data);

      /*----------------------------------------------------------------------------*/
      /* start the dar_start_watchdog_timer                                         */
      /*----------------------------------------------------------------------------*/

      if (dar_start_watchdog_timer(timer)!= RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_14 function **************************/

   /********************************************************************************/
   /*                                                                              */
   /*                             DAR NON REGRESSION TEST 15                       */
   /*                                                                              */
   /* Decription: Test the dar_reload_watchdog_timer.                              */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_15 (T_RV_REGR_ERR_TYPE *error_type)
   {
      UINT16 timer = 3000; /* 3000 millisecondes before the timer expires */

      /* call the dar recovery config */
      dar_recovery_config(dar_store_recovery_data);
      
      /*----------------------------------------------------------------------------*/
      /* start the dar_start_watchdog_timer                                         */
      /*----------------------------------------------------------------------------*/

      if (dar_start_watchdog_timer(timer)!= RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /*----------------------------------------------------------------------------*/
      /* start the dar_reload_watchdog_timer                                        */
      /*----------------------------------------------------------------------------*/
      /* wait 1 s*/
      rvf_delay(RVF_MS_TO_TICKS(1000));

      /* reload the Watchdog timer */
      if (dar_reload_watchdog_timer()!= RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /* wait 1 s*/
      rvf_delay(RVF_MS_TO_TICKS(1000));

      /* reload the Watchdog timer */
      if (dar_reload_watchdog_timer()!= RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /* wait 1 s*/
      rvf_delay(RVF_MS_TO_TICKS(1000));

      DAR_SEND_TRACE("The system will be reset",RV_TRACE_LEVEL_DEBUG_HIGH);
      rvf_delay(RVF_MS_TO_TICKS(1000));

      /* reload the Watchdog timer */
      if (dar_reload_watchdog_timer()!= RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_15 function ***************************/

   /********************************************************************************/
   /*                                                                              */
   /*                          DAR NON REGRESSION TEST 16                          */
   /*                                                                              */
   /* Decription: Test the dar_start_watchdog_timer and then generate an infinite  */
   /*             loop                                                             */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_16 (T_RV_REGR_ERR_TYPE *error_type)
   {
      UINT16 timer = 3000; /* 3000 millisecondes before the timer expires */

      /* call the dar recovery config */
      dar_recovery_config(dar_store_recovery_data);
      
      /*----------------------------------------------------------------------------*/
      /* start the dar_start_watchdog_timer                                         */
      /*----------------------------------------------------------------------------*/

      if (dar_start_watchdog_timer(timer)!= RV_OK) 
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /* Wait 1s */
      rvf_delay(RVF_MS_TO_TICKS(1000));

      DAR_SEND_TRACE("The system will be reset",RV_TRACE_LEVEL_DEBUG_HIGH);
      rvf_delay(RVF_MS_TO_TICKS(1000));

      /* Generate an infinite loop */
      #ifndef _WINDOWS
         while (1)
         {
         }
      #endif

      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_16 function ***************************/

   /********************************************************************************/
   /*                                                                              */
   /*                           DAR NON REGRESSION TEST 17                         */
   /*                                                                              */
   /* Decription: Test the dar_start_watchdog_timer, Stop it and generate a        */
   /*                   voluntary reset                                            */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_17 (T_RV_REGR_ERR_TYPE *error_type)
   {
      UINT8 timer = 3; /* 3 secondes before the timer expires */
 
      DAR_SEND_TRACE("The system will be reset",RV_TRACE_LEVEL_DEBUG_HIGH);
      rvf_delay(RVF_MS_TO_TICKS(1000));

      /* call the dar recovery config */
      dar_recovery_config(dar_store_recovery_data);

      /*---------------------------------------------------------------------------*/
      /* start the dar_start_watchdog_timer                                        */
      /*---------------------------------------------------------------------------*/

      if (dar_start_watchdog_timer(timer)!= RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /* Wait 1s */
      rvf_delay(RVF_MS_TO_TICKS(1000));

      
      /*----------------------------------------------------------------------------*/
      /* stop the watchdog timer                                                    */
      /*----------------------------------------------------------------------------*/
      if (dar_stop_watchdog_timer()!= RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      DAR_SEND_TRACE("The system will be reset",RV_TRACE_LEVEL_DEBUG_HIGH);
      rvf_delay(RVF_MS_TO_TICKS(1000));

      /*----------------------------------------------------------------------------*/
      /* start the dar_reset_system                                                 */
      /*----------------------------------------------------------------------------*/
      if (dar_reset_system()!= RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_17 function ***************************/

   /********************************************************************************/
   /*                                                                              */
   /*                           DAR NON REGRESSION TEST 18                         */
   /*                                                                              */
   /* Decription: Test the exceptions                                              */
   /*             Jump to an unknow address in order to generate an exception      */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_18 (T_RV_REGR_ERR_TYPE *error_type)
   {
      /*---------------------------------------------------------------------------*/
      /*jump to an unreferenced address in order to crash the board                */
      /*---------------------------------------------------------------------------*/
      
      /* Jump to address 3000000 where nothing is defined */
      /* an exception must be generated */ 
      #ifndef _WINDOWS
         /* Variable declaration */
         void (*jump_address)() = (void (*)()) ((unsigned)0x2000000);

         rvf_delay(RVF_MS_TO_TICKS(2000));

         /* call the dar recovery config */
         if (dar_recovery_config(dar_store_recovery_data)!= RV_OK)
         {
            *error_type = FUNCTION_ERROR;
            return (dar_test_regr_return_verdict(*error_type));
         }
         
         (*jump_address)();
      #endif

      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_18 function ***************************/

   /********************************************************************************/
   /*                                                                              */
   /*                              DAR NON REGRESSION TEST 19                      */
   /*                                                                              */
   /* Decription: Test the exceptions                                              */
   /*                   Jump to an address that contains variables in order        */
   /*                   to generate an exception                                   */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_19 (T_RV_REGR_ERR_TYPE *error_type)
   {
      /*--------------------------------------------------------------------------*/
      /*jump to an unreferenced address in order to crash the board               */
      /*--------------------------------------------------------------------------*/
      
      /* Jump to address 1000000 which contains variables */
      /* an exception must be generated */ 
      #ifndef _WINDOWS
         /* Variable declaration */
         void (*jump_address)() = (void (*)()) ((unsigned)0x1000000);

         /* call the dar recovery config */
         if (dar_recovery_config(dar_store_recovery_data)!= RV_OK)
         {
            *error_type = FUNCTION_ERROR;
            return (dar_test_regr_return_verdict(*error_type));
         }

         (*jump_address)();
      #endif

      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_19 function **************************/

   /********************************************************************************/
   /*                                                                              */
   /*                          DAR NON REGRESSION TEST 20                          */
   /*                                                                              */
   /* Description: Give the status and the recovery data                           */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_20 (T_RV_REGR_ERR_TYPE *error_type)
   {
      /* Declare local variables */
      T_DAR_RECOVERY_STATUS   status    = 0;
      T_DAR_BUFFER            buffer_p  = NULL;
      UINT8                   i         = 0;
      T_RVF_MB_STATUS         mb_status = RVF_GREEN;

      /* allocate the memory for the buffer_p */
      mb_status =rvf_get_buf (dar_gbl_var_p->mb_dar,
                              DAR_RECOVERY_DATA_MAX_BUFFER_SIZE,
                              (T_RVF_BUFFER **) (&buffer_p));

      /* If insufficient resources, then report a memory error and abort.          */
      if (mb_status == RVF_YELLOW)
      {
         /* deallocate the memory */
         rvf_free_buf((T_RVF_BUFFER *)buffer_p);
         dar_error_trace(DAR_ENTITY_NO_MEMORY);
         return (RV_NOT_SUPPORTED);
      }
      else
      if (mb_status == RVF_RED)
      {
         dar_error_trace(DAR_ENTITY_NO_MEMORY);
         return (RV_MEMORY_ERR);
      }

      /*----------------------------------------------------------------------------*/
      /* start the dar_recovery_get_status                                          */
      /*----------------------------------------------------------------------------*/

      /* Get the status */
      if (dar_recovery_get_status(&status)!= RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /*----------------------------------------------------------------------------*/
      /* start the dar_get_recovery_data                                            */
      /*----------------------------------------------------------------------------*/

      /* Retrieve data that have been stored in the buffer_p just before reset*/      
      if ( dar_get_recovery_data(buffer_p,DAR_RECOVERY_DATA_MAX_BUFFER_SIZE)!= RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      /* Trace the buffer - used for Debug */
      //for (i=0;i<DAR_RECOVERY_DATA_MAX_BUFFER_SIZE;i++)
      //{
         //DAR_SEND_TRACE_PARAM("Dar recovery buffer before reset",buffer_p[i],RV_TRACE_LEVEL_DEBUG_HIGH);
      //}
   
      /* free the Header of the message */
      rvf_free_buf((T_RVF_BUFFER *)buffer_p);

      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_20 function **************************/

   /********************************************************************************/
   /*                                                                              */
   /*                              DAR NON REGRESSION TEST 21                      */
   /*                                                                              */
   /* Decription: Test the branch to 0, if the callback is NULL                    */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_21 (T_RV_REGR_ERR_TYPE *error_type)
   {
      T_DAR_RECOVERY_STATUS status=0;

      /* call the dar recovery config */
      dar_recovery_config(NULL);

      /*----------------------------------------------------------------------------*/
      /* start the dar_recovery_get_status                                          */
      /*----------------------------------------------------------------------------*/
      DAR_SEND_TRACE("The system will be reset",RV_TRACE_LEVEL_DEBUG_HIGH);
      rvf_delay(RVF_MS_TO_TICKS(1000));

      /* Get the status */
      if (dar_recovery_get_status(&status)!= RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }
   
      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_21 function **************************/

   /********************************************************************************/
   /*                                                                              */
   /*                            DAR NON REGRESSION TEST 22                        */
   /*                                                                              */
   /* Decription: Redirect trace(Warning/Debug) to DAR                             */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_22 (T_RV_REGR_ERR_TYPE *error_type)
   {
      T_RVM_USE_ID       filter_use_id_1;
      T_RVM_USE_ID       filter_use_id_2;
      T_RV_RETURN        return_path;

      /* initalize the return path, for this test the return path is a message */
      return_path.callback_func = NULL;
      return_path.addr_id          = rvf_get_taskid();

      /*----------------------------------------------------------------------------*/
      /* start the dar filter                                                       */
      /*----------------------------------------------------------------------------*/
      /* fill the filter parameter */
      filter_use_id_1 = KPD_USE_ID; 
      filter_use_id_2 = DAR_USE_ID; 
      
      /* start the dar filter - Add the group */
      if (dar_diagnose_swe_filter(filter_use_id_1, DAR_DEBUG) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }
      if (dar_diagnose_swe_filter(filter_use_id_2, DAR_WARNING) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      rvf_send_trace ("KPD warning",(sizeof("KPD warning")-1),NULL_PARAM,RV_TRACE_LEVEL_WARNING,filter_use_id_1);
      rvf_send_trace ("KPD debug",(sizeof("KPD debug")-1),NULL_PARAM,RV_TRACE_LEVEL_DEBUG_HIGH,filter_use_id_1);
      rvf_send_trace ("DAR warning",(sizeof("DAR warning")-1),NULL_PARAM,RV_TRACE_LEVEL_WARNING,filter_use_id_2);
      rvf_send_trace ("DAR debug",(sizeof("DAR debug")-1),NULL_PARAM,RV_TRACE_LEVEL_DEBUG_HIGH,filter_use_id_2);
         
      rvf_delay(RVF_MS_TO_TICKS(3000));

      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_22 function ***************************/

   /********************************************************************************/
   /*                                                                              */
   /*                            DAR NON REGRESSION TEST 23                        */
   /*                                                                              */
   /* Decription: Redirect trace(Warning/Error) to DAR                             */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_23 (T_RV_REGR_ERR_TYPE *error_type)
   {
      T_RVM_USE_ID       filter_use_id_1;
      T_RVM_USE_ID       filter_use_id_2;
      T_RV_RETURN        return_path;

      /* initalize the return path, for this test the return path is a message */
      return_path.callback_func = NULL;
      return_path.addr_id          = rvf_get_taskid();

      /*----------------------------------------------------------------------------*/
      /* start the dar filter                                                       */
      /*----------------------------------------------------------------------------*/
      /* fill the filter parameter */
      filter_use_id_1 = AUDIO_USE_ID; 
      filter_use_id_2 = DAR_USE_ID; 
      
      /* start the dar filter - Add the group */
      if (dar_diagnose_swe_filter(filter_use_id_1, DAR_WARNING) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }
      if (dar_diagnose_swe_filter(filter_use_id_2, DAR_DEBUG) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      rvf_send_trace ("AUDIO warning",(sizeof("AUDIO warning")-1),NULL_PARAM,RV_TRACE_LEVEL_WARNING,filter_use_id_1);
      rvf_send_trace ("AUDIO debug",(sizeof("AUDIO debug")-1),NULL_PARAM,RV_TRACE_LEVEL_DEBUG_HIGH,filter_use_id_1);
      rvf_send_trace ("DAR warning",(sizeof("DAR warning")-1),NULL_PARAM,RV_TRACE_LEVEL_WARNING,filter_use_id_2);
      rvf_send_trace ("DAR debug",(sizeof("DAR debug")-1),NULL_PARAM,RV_TRACE_LEVEL_DEBUG_HIGH,filter_use_id_2);
      rvf_send_trace ("ETM error",(sizeof("ETM error")-1),NULL_PARAM,RV_TRACE_LEVEL_ERROR,ETM_USE_ID);
         
      rvf_delay(RVF_MS_TO_TICKS(3000));

      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_23 function ***************************/


   
   /********************************************************************************/
   /*                                                                              */
   /*                            DAR NON REGRESSION TEST 24                        */
   /*                                                                              */
   /* Decription: Redirect trace(Error/Warning) to DAR                             */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_regr_test_24 (T_RV_REGR_ERR_TYPE *error_type)
   {
      T_RVM_USE_ID       filter_use_id_1;
      T_RVM_USE_ID       filter_use_id_2;
      T_RV_RETURN        return_path;

      /* initalize the return path, for this test the return path is a message */
      return_path.callback_func = NULL;
      return_path.addr_id          = rvf_get_taskid();

      /*----------------------------------------------------------------------------*/
      /* start the dar filter                                                       */
      /*----------------------------------------------------------------------------*/
      /* fill the filter parameter */
      filter_use_id_1 = AUDIO_USE_ID; 
      filter_use_id_2 = DAR_USE_ID; 
      
      /* start the dar filter - Add the group */
      if (dar_diagnose_swe_filter(filter_use_id_1, DAR_WARNING) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }
      if (dar_diagnose_swe_filter(filter_use_id_2, DAR_DEBUG) != RV_OK)
      {
         *error_type = FUNCTION_ERROR;
         return (dar_test_regr_return_verdict(*error_type));
      }

      rvf_send_trace ("ETM error",(sizeof("ETM error")-1),NULL_PARAM,RV_TRACE_LEVEL_ERROR,ETM_USE_ID);
      rvf_send_trace ("AUDIO warning",(sizeof("AUDIO warning")-1),NULL_PARAM,RV_TRACE_LEVEL_WARNING,filter_use_id_1);
      rvf_send_trace ("AUDIO debug",(sizeof("AUDIO debug")-1),NULL_PARAM,RV_TRACE_LEVEL_DEBUG_HIGH,filter_use_id_1);
      rvf_send_trace ("DAR warning",(sizeof("DAR warning")-1),NULL_PARAM,RV_TRACE_LEVEL_WARNING,filter_use_id_2);
      rvf_send_trace ("DAR debug",(sizeof("DAR debug")-1),NULL_PARAM,RV_TRACE_LEVEL_DEBUG_HIGH,filter_use_id_2);
         
      rvf_delay(RVF_MS_TO_TICKS(3000));

      return(TEST_PASSED);
   }
   /******************** End of dar_regr_test_24 function ***************************/ 

   /**********************************************************************************/
   /*                                                                                */
   /*      Function Name:    dar_test_regr_return_verdict                            */
   /*                                                                                */
   /*      Purpose:   The purpose of this function is to return the DAR test verdict */
   /*                     coresponding to the type of error.                         */
   /*                                                                                */
   /*      Input Parameters:                                                         */
   /*            error_type               : type_of_error                            */
   /*                                                                                */
   /*      Output Parameters:                                                        */
   /*            verdict of the test.                                                */
   /*                                                                                */
   /*      Note:                                                                     */
   /*            None.                                                               */
   /*                                                                                */
   /*      Revision History:                                                         */
   /*            19 October 2001    Stephanie Gerthoux: Creation.                    */
   /*                                                                                */
   /**********************************************************************************/
   T_RV_REGR_RET dar_test_regr_return_verdict ( T_RV_REGR_ERR_TYPE error_type)
   {
      /******************** dar_test_regr_return_verdict function begins ************/

      switch(error_type)
      {
         case NO_EVENT_RECV:
         case BAD_EVENT_RECV:
         case EVENT_PARAM_ERROR:
         case FUNCTION_ERROR:
         {
            return(TEST_FAILED);
            break;
         }

         case MEMORY_ERROR:
         {
            return(TEST_IRRECOVERABLY_FAILED);
            break;
         }

         default:
         {
            return(TEST_IRRECOVERABLY_FAILED);
            break;
         }
      } /* switch(error_type) */
   }

   /******************** End of dar_test_regr_return_verdict function **************/

   /********************************************************************************/
   /*                                                                              */
   /*      Function Name:    trace_dar_test_verdict                                */
   /*                                                                              */
   /*      Purpose:   The purpose of this function is to trace test verdict.       */
   /*                                                                              */
   /*      Input Parameters:                                                       */
   /*            test_verdict         : verdict of the test                        */
   /*            nb_of_test_in_list   : number of test to pass                     */
   /*            nb_of_test_succeeded : number of the test passed                  */
   /*            error_flag           : error flag of the test                     */
   /*                                                                              */
   /*      Output Parameters:                                                      */
   /*            None.                                                             */
   /*                                                                              */
   /*      Note:                                                                   */
   /*            None.                                                             */
   /*                                                                              */
   /*      Revision History:                                                       */
   /*            19 October 2001    Stephanie Gerthoux: Creation.                  */
   /*                                                                              */
   /********************************************************************************/
   T_RV_RET trace_dar_test_verdict ( T_RV_TEST_RET   test_verdict, 
                                     T_RV_REGR_TEST_TOT nb_of_test_in_list, 
                                     T_RV_REGR_TEST_TOT nb_of_test_succeeded, 
                                     T_RV_REGR_ERR_TYPE *error_type)
   {
      /******************** trace_dar_test_verdict function begins ******************/
      if (nb_of_test_succeeded != nb_of_test_in_list)
      {
         switch (test_verdict)
         {
            case TEST_PASSED:
            {
               RV_TEST_TRACE_HIGH ("PASS DAR TEST");
               break;
            }
            case TEST_FAILED:
            {
               RV_TEST_TRACE_HIGH ("FAIL DAR TEST");

               switch(*error_type)
               {
                  case NO_EVENT_RECV:
                  {
                     RV_TEST_TRACE_HIGH ("Received no event from DAR entity");
                     break;
                  }
                  case BAD_EVENT_RECV:
                  {
                     RV_TEST_TRACE_HIGH ("Received event not waited in DAR entity");
                     break;
                  }
                  case EVENT_PARAM_ERROR:
                  {
                     RV_TEST_TRACE_HIGH ("Received event with wrong parameters in DAR entity");
                     break;
                  }
                  case FUNCTION_ERROR:
                  {
                     RV_TEST_TRACE_HIGH ("A DAR API function has been called and an unexpected error occurred");
                     break;
                  }
                  case MEMORY_ERROR:
                  {
                     RV_TEST_TRACE_HIGH ("A memory error occurs in the DAR entity");
                     break;
                  }
               }

               break;
            }

            case TEST_IRRECOVERABLY_FAILED:
            {
               RV_TEST_TRACE_HIGH ("FAIL DAR TEST");

               switch(*error_type)
               {
                  case NO_EVENT_RECV:
                  {
                     RV_TEST_TRACE_HIGH ("Received no event from DAR entity");
                     break;
                  }
                  case BAD_EVENT_RECV:
                  {
                     RV_TEST_TRACE_HIGH ("DAR entity received event not waited ");
                     break;
                  }
                  case EVENT_PARAM_ERROR:
                  {
                     RV_TEST_TRACE_HIGH ("Received event with wrong parameters");
                     break;
                  }
                  case FUNCTION_ERROR:
                  {
                     RV_TEST_TRACE_HIGH ("A DAR API function has been called and an unexpected error occurred");
                     break;
                  }
                  case MEMORY_ERROR:
                  {
                     RV_TEST_TRACE_HIGH ("A memory error occurs in the DAR entity");
                     break;
                  }
               }

               break;
            }

            default:
            {
               RV_TEST_TRACE_ERROR ("!!! DAR ERROR !!! Wrong test_verdict value");
               break;
            }

         } /* switch(test_verdict) */
      } /* if (nb_of_test_succeeded != nb_of_test_in_list) */

      else /* (nb_of_test_succeeded == nb_of_test_in_list) -> All tests performed */
      {
         if (*error_type != NO_ERR)
         {
            RV_TEST_TRACE_HIGH ("!!! ERROR !!! DAR NON REGRESSION PERFORMED WITH ERROR(S)");
         }
         else
         {
            RV_TEST_TRACE_HIGH ("DAR NON REGRESSION PERFORMED WITH NO ERROR");
         }
      
         RV_TEST_TRACE_HIGH ("*************** END OF DAR NON REGRESSION ***************");
      }

      return (RV_OK);
   }

   /******************** End of trace_dar_test_verdict function ********************/

   /********************************************************************************/
   /*                                                                              */
   /*      Function Name:    dar_test_rgr                                          */
   /*                                                                              */
   /*      Purpose:   This function executes the DAR non regression tests.         */
   /*                                                                              */
   /*      Input Parameters:                                                       */
   /*            None.                                                             */
   /*                                                                              */
   /*      Output Parameters:                                                      */
   /*            None.                                                             */
   /*                                                                              */
   /*      Note:                                                                   */
   /*            None.                                                             */
   /*                                                                              */
   /*      Revision History:                                                       */
   /*            27 September 2001    Stephanie Gerthoux: Creation.                */
   /*                                                                              */
   /********************************************************************************/
   T_RV_REGR_RET dar_test_regr ( T_RV_REGR_TEST_LIST list[],
                                 T_RV_REGR_TEST_TOT   nb_of_test_in_list,
                                 T_RV_REGR_TEST_OCC   test_occ)
   {
      T_RV_REGR_ERR_TYPE   error_type   = NO_ERR;
      T_RV_REGR_RET        test_verdict = TEST_PASSED;
      T_RV_REGR_TEST_TOT   i            = 0;
	  T_RV_REGR_TEST_OCC   j            = 0;

      /************************* Start dar_test_regr function ***********************/

      RV_TEST_TRACE_HIGH ("**************** START DAR NON REGRESSION **************");
    
      /************************************************************************/
      /*                                                                      */
      /*   Memory dump -> check memory and stack used before testing.         */
      /*                                                                      */
      /************************************************************************/
      rvf_dump_mem ();
      rvf_dump_tasks();

      for (i=0; i<nb_of_test_in_list; i++)
      {
         for (j=0; j<test_occ; j++)
         {
            if (test_verdict != TEST_IRRECOVERABLY_FAILED)
            {
               switch (list[i].list_nbr)
               {
                  case 1:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 1: Dar filter start- add a group");
                     test_verdict = dar_regr_test_1 (&error_type);
                     break;
                  }
                  case 2:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 2: Dar filter start- search a group");
                     test_verdict = dar_regr_test_2 (&error_type);
                     break;
                  }
                  case 3:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 3: Dar filter start- delete a group");
                     test_verdict = dar_regr_test_3 (&error_type);
                     break;
                  }

                  case 4:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 4: DAR filter - add more than DAR max number group ");
                     test_verdict = dar_regr_test_4 (&error_type);
                     break;
                  }

                  case 5:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 5: DAR write function ");
                     test_verdict = dar_regr_test_5 (&error_type);
                     break;
                  }

                  case 6:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 6: DAR write function with bad debug level");
                     test_verdict = dar_regr_test_6 (&error_type);
                     break;
                  }
                  
                  case 7:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 7: DAR write function - Long data ");
                     test_verdict = dar_regr_test_7 (&error_type);
                     break;
                  }

                  case 8:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 8: DAR write function - Store 2 string");
                     test_verdict = dar_regr_test_8 (&error_type);
                     break;
                  }
                  
                  case 9:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 9: DAR write function - DAR_NO_DIAGNOSE message");
                     test_verdict = dar_regr_test_9 (&error_type);
                     break;
                  }
                  
                  case 10:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 10: DAR emergency function ( PC)");
                     test_verdict = dar_regr_test_10 (&error_type);
                     break;
                  }
                                    
                  case 11:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 11: DAR recovery get status after a reset or an ON/OFF");
                     test_verdict = dar_regr_test_11 (&error_type);
                     break;
                  }

                  case 12:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 12: DAR reset system");
                     test_verdict = dar_regr_test_12 (&error_type);
                     break;
                  }

                  case 13:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 13: DAR diagnose generate emergency (board)");
                     test_verdict = dar_regr_test_13 (&error_type);
                     break;
                  }

                  case 14:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 14: DAR start watchdog timer");
                     test_verdict = dar_regr_test_14 (&error_type);
                     break;
                  }

                  case 15:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 15: DAR reload watchdog timer");
                     test_verdict = dar_regr_test_15 (&error_type);
                     break;
                  }

                  case 16:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 16: DAR start watchdog timer + infinite loop");
                     test_verdict = dar_regr_test_16 (&error_type);
                     break;
                  }

                  case 17:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 17: DAR start watchdog timer + stop + voluntary reset");
                     test_verdict = dar_regr_test_17 (&error_type);
                     break;
                  }

                  case 18:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 18: DAR Exception: Jump to unknown address ");
                        

                     test_verdict = dar_regr_test_18 (&error_type);
                     break;
                  }

                  case 19:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 19: DAR Exception : Jump to variables address");
                     /* call the dar recovery config */
                     dar_recovery_config(dar_store_recovery_data);
                     test_verdict = dar_regr_test_19 (&error_type);
                     break;
                  }

                  case 20:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 20: DAR recovery get status and get recovery data");
                     test_verdict = dar_regr_test_20 (&error_type);
                     break;
                  }

                  case 21:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 21: DAR - Branch to 0 with a callback = NULL ");
                     test_verdict = dar_regr_test_21 (&error_type);
                     break;
                  }
                  
                  case 22:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 22: Redirect trace(Warning/Debug) to DAR");
                     test_verdict = dar_regr_test_22 (&error_type);
                     break;
                  }
                 
                  case 23:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 23: Redirect trace(Warning/Error) to DAR");
                     test_verdict = dar_regr_test_23 (&error_type);
                     break;
                  }
                  
                  case 24:
                  {
                     RV_TEST_TRACE_HIGH ("**DAR TEST REGR 24: Redirect trace(Error/Warning) to DAR");
                     test_verdict = dar_regr_test_24 (&error_type);
                     break;
                  }

                  default:
                  {
                     RV_TEST_TRACE_ERROR ("!!! ERROR !!! Invalid DAR test_number value for REGR test_type");
                     test_verdict = TEST_IRRECOVERABLY_FAILED;
                     break;
                  }
               }

               trace_dar_test_verdict (test_verdict,
                                                   nb_of_test_in_list,
                                                   i,
                                                   &error_type);
            } /* End of "if (test_verdict != TEST_IRRECOVERABLY_FAILED)" */

         } /* End of "for (j = 0; j < test_occ; j ++)" */

      } /* End of "for (i = 0; i < nb_of_test_in_list; i ++)" */

      trace_dar_test_verdict (test_verdict,
                              nb_of_test_in_list,
                              nb_of_test_in_list,
                              &error_type);

      /************************************************************************/
      /*                                                                      */
      /*   Memory dump -> check memory and stack used before testing.         */
      /*                                                                      */
      /************************************************************************/
      rvf_dump_mem ();
      rvf_dump_tasks();

      return (test_verdict);
   }

   /**************************   dar_test_regr function *************************/
 #endif
#endif /* ((DAR_REGR == SW_COMPILED) || (DAR_MISC == SW_COMPILED)) */



/********************************************************************************/
/*                                                                              */
/*          ------------------------------------------------                    */
/*         |          WARNING          -         IMPORTANT   |                  */
/*          ------------------------------------------------                    */
/*                                                                              */
/*                                                                              */
/*      Function Name:    dar_lib_test                                          */
/*                                                                              */
/*      Purpose:   This function is only used in order to have a function in the*/ 
/*                      dar_lib when the DAR is NOT_COMPILED                    */
/*                                                                              */
/*      Input Parameters:                                                       */
/*             None                                                             */
/*                                                                              */
/*      Output Parameters:                                                      */
/*             NONE                                                             */
/*                                                                              */
/********************************************************************************/
void dar_lib_test(void)
{
}
