/********************************************************************************/
/*                                                                              */
/*   File Name:   dar_test_misc.c                                               */
/*                                                                              */
/*   Purpose:   This file gathers misc tests for DAR.                           */
/*                                                                              */
/*   Note:    None.                                                             */
/*                                                                              */
/*   Version    0.1                                                             */
/*                                                                              */
/*   Date            Modification                                               */
/*   ---------------------------------------------------------------------------*/
/*   5 November 2001   Create                                                   */
/*                                                                              */
/*   Author         Stephanie Gerthoux                                          */
/*                                                                              */
/* (C) Copyright 2001 by Texas Instruments Incorporated, All Rights Reserved    */
/********************************************************************************/

/********************************************************************************/
/*                                                                              */
/*   Include files used for DAR riviera testing.                                */
/*                                                                              */
/********************************************************************************/

#include "rv/rv_defined_swe.h"
#include "dar/tests/dar_test.h"

#ifdef RVM_DAR_SWE
#if (DAR_MISC == SW_COMPILED)

   #include "rv/rv_general.h"
   #include "rvm/rvm_gen.h"
   #include "dar/tests/dar_test_regr.h"
   #include "dar/tests/dar_test_misc.h"
   #include "dar/dar_api.h"
   #include "dar/dar_structs_i.h"
   #include "dar/dar_messages_i.h"
   #include "rvf/rvf_target.h"
   #include "dar/dar_const_i.h"
   #include "dar/dar_error_hdlr_i.h"
   #include "dar/dar_macro_i.h"

   /********************************************************************************/
   /*                                                                              */
   /*      Function Name:    dar_test_misc                                         */
   /*                                                                              */
   /*      Purpose:   This function executes the DAR misc tests.                   */
   /*                                                                              */
   /*      Input Parameters:                                                       */
   /*            test number.                                                      */
   /*                                                                              */
   /*      Output Parameters:                                                      */
   /*            None.                                                             */
   /*                                                                              */
   /*      Note:                                                                   */
   /*            None.                                                             */
   /*                                                                              */
   /*      Revision History:                                                       */
   /*            5 November 2001    Stephanie Gerthoux: Creation.                  */
   /*                                                                              */
   /********************************************************************************/
   
   T_RV_MISC_RET dar_test_misc (T_RV_MISC_TEST_NBR test_number)
   {

      T_RV_MISC_ERR_TYPE   error_type   = NO_ERR;
      T_RV_MISC_RET        test_verdict = TEST_PASSED;
   

      /************************* Start dar_test_misc function *************************/

      RV_TEST_TRACE_HIGH ("**************** START DAR MISC ****************");

      /************************************************************************/
      /*                                                                      */
      /*   Memory dump -> check memory and stack used before testing.         */
      /*                                                                      */
      /************************************************************************/
      rvf_dump_mem ();
      rvf_dump_tasks();

      switch (test_number)
      {
         case 1:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 1: Dar filter start- add a group");
            test_verdict = dar_regr_test_1 (&error_type);
            break;
         }
         case 2:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 2: Dar filter start- search a group");
            test_verdict = dar_regr_test_2 (&error_type);
            break;
         }
         case 3:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 3: Dar filter start- delete a group");
            test_verdict = dar_regr_test_3 (&error_type);
            break;
         }

         case 4:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 4: DAR filter - add more than DAR max number group ");
            test_verdict = dar_regr_test_4 (&error_type);
            break;
         }

         case 5:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 5: DAR write function ");
            test_verdict = dar_regr_test_5 (&error_type);
            break;
         }

         case 6:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 6: DAR write function with bad debug level");
            test_verdict = dar_regr_test_6 (&error_type);
            break;
         }
         
         case 7:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 7: DAR write function - Long data ");
            test_verdict = dar_regr_test_7 (&error_type);
            break;
         }

         case 8:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 8: DAR write function - Store 2 string");
            test_verdict = dar_regr_test_8 (&error_type);
            break;
         }
         
         case 9:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 9: DAR write function - DAR_NO_DIAGNOSE message");
            test_verdict = dar_regr_test_9 (&error_type);
            break;
         }
         
         case 10:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 10: DAR emergency function ( PC)");
            test_verdict = dar_regr_test_10 (&error_type);
            break;
         }
                           
         case 11:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 11: DAR recovery get status after an ON/OFF");
            test_verdict = dar_regr_test_11 (&error_type);
            break;
         }

         case 12:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 12: DAR reset system");
            test_verdict = dar_regr_test_12 (&error_type);
            break;
         }

         case 13:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 13: DAR diagnose generate emergency (board)");
            test_verdict = dar_regr_test_13 (&error_type);
            break;
         }

         case 14:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 14: DAR start watchdog timer");
            test_verdict = dar_regr_test_14 (&error_type);
            break;
         }

         case 15:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 15: DAR reload watchdog timer");
            test_verdict = dar_regr_test_15 (&error_type);
            break;
         }

         case 16:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 16: DAR start watchdog timer + infinite loop");
            test_verdict = dar_regr_test_16 (&error_type);
            break;
         }

         case 17:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 17: DAR start watchdog timer + stop + infinite loop");
            test_verdict = dar_regr_test_17 (&error_type);
            break;
         }

         case 18:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 18: DAR Exception: Jump to unknown address ");
            test_verdict = dar_regr_test_18 (&error_type);
            break;
         }

         case 19:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 19: DAR Exception : Jump to variables address");
            test_verdict = dar_regr_test_19 (&error_type);
            break;
         }

         case 20:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 20: DAR recovery get status and get recovery data");
            test_verdict = dar_regr_test_20 (&error_type);
            break;
         }
 
         case 21:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 21: DAR - Branch to 0 with a callback = NULL ");
            test_verdict = dar_regr_test_21 (&error_type);
            break;
         }

         case 22:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 22: Redirect trace(Warning/Error) to DAR");
            test_verdict = dar_regr_test_22 (&error_type);
            break;
         }

         case 23:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 23: Redirect trace(Warning/Error) to DAR");
            test_verdict = dar_regr_test_23 (&error_type);
            break;
         }
         
         case 24:
         {
            RV_TEST_TRACE_HIGH ("**DAR TEST REGR 24: Redirect trace(Error/Warning) to DAR");
            test_verdict = dar_regr_test_24 (&error_type);
            break;
         }                  

         default:
         {
            RV_TEST_TRACE_ERROR ("!!! ERROR !!! Invalid DAR test_number value for misc test_type");
            test_verdict = TEST_IRRECOVERABLY_FAILED;
            break;
         }
      
      } /* switch */

      trace_dar_test_verdict (test_verdict,
                              0,
                              test_number,
                              &error_type);

      trace_dar_test_verdict (test_verdict,
                              test_number,
                              test_number,
                              &error_type);
      /************************************************************************/
      /*                                                                      */
      /*   Memory dump -> check memory and stack used before testing          */
      /*                                                                      */
      /************************************************************************/
      rvf_dump_mem ();
      rvf_dump_tasks();

      return (test_verdict);
   }

   /************************** Stop dar_test_misc function *************************/

 #endif /* #ifdef RVM_DAR_SWE */
#endif /* #if (DAR_MISC == SW_COMPILED) */

   