/******************************************************************************/
/*                                                                            */
/*   File Name:   dar_test.c                                                  */
/*                                                                            */
/*   Purpose: This file contains Diagnose And Recovery test generic functions.*/
/*                                                                            */
/*   Note:    None.                                                           */
/*                                                                            */
/*   Version    0.1                                                           */
/*                                                                            */
/*   Date                      Modification                                   */
/*   ------------------------------------------------------------------------ */
/*   26 September 2001   Create                                               */
/*                                                                            */
/*   Author          Stephanie Gerthoux                                       */
/*                                                                            */
/* (C) Copyright 2001 by Texas Instruments Incorporated, All Rights Reserved  */
/******************************************************************************/

#include "tests/rv/rv_test_filter.h"

#if ((DAR_REGR == SW_COMPILED) || (DAR_MISC == SW_COMPILED))
#include "dar/tests/dar_test.h"
      
   /* Define the global variables used with DAR test level */
   T_RVF_MB_ID mb_dar_test;

   /**********************************************************************************/
   /*                                                                                */
   /*      Function Name:    dar_test_set_mb_id                                      */
   /*                                                                                */
   /*      Purpose:   This function is called to set DAR test MBs IDs and initialize */
   /*                     the pointer to the global variable.                        */
   /*                                                                                */
   /*      Input Parameters:                                                         */
   /*                  memory bank list                                              */
   /*                                                                                */
   /*      Output Parameters:                                                        */
   /*            None.                                                               */
   /*                                                                                */
   /*      Note:                                                                     */
   /*            None.                                                               */
   /*                                                                                */
   /*      Revision History:                                                         */
   /*            26 september 2001      Stephanie Gerthoux: Creation.                */
   /*                                                                                */
   /**********************************************************************************/
   void dar_test_set_mb_id (T_RVF_MB_ID mb_id[])
   {
      /********************** Start dar_test_set_mb_id function ***********************/
      mb_dar_test = mb_id[0];
   }

   /*********************** Stop dar_test_set_mb_id function ***********************/

#endif /* #if (DAR_TEST == SW_COMPILED) */