#
#       Makefile for DAR Riviera service (ARM compiler) 
#
#       Copyright (c) Texas Instruments 2001
# 
#               Author: Stephanie Gerthoux
#       Date : 24 october 2001

# Compilation flags
DAR_FLAGS     = $(NODBG) $(16INST) -mn $(CFLAGSSERVICES)
WIN_DAR_FLAGS = $($(TP)CFLAGS) $(CFLAGSSERVICES)

# Libraries definition
LIB_DAR         := $(OUT_LIB_DIR)/dar.lib 
LIB_DAR_GBL_VAR := $(OUT_LIB_DIR)/dar_gbl_var.lib
CFG_LIBS += $(LIB_DAR)

ifneq ($(GSMLITE),1)
    CFG_LIBS += $(LIB_DAR_GBL_VAR)
endif


# Source definition
ifdef DAR_SOURCE
COMMON_SRC_DAR  += $(SERVICES_DIR)/dar/dar_env.c \
                   $(SERVICES_DIR)/dar/dar_api.c \
                   $(SERVICES_DIR)/dar/dar_task.c \
                   $(SERVICES_DIR)/dar/dar_handle_message.c \
                   $(SERVICES_DIR)/dar/dar_diagnose.c \
                   $(SERVICES_DIR)/dar/dar_error_hdlr.c \
                   $(SERVICES_DIR)/dar/dar_msg_ft.c \
                   $(SERVICES_DIR)/dar/dar_watchdog.c \
                   $(SERVICES_DIR)/dar/dar_emergency.c

SRC_DAR         += $(COMMON_SRC_DAR)
WIN_SRC_DAR     += $(COMMON_SRC_DAR)

COMMON_SRC_DAR_GBL_VAR := $(SERVICES_DIR)/dar/dar_gbl_var.c
SRC_DAR_GBL_VAR        := $(COMMON_SRC_DAR_GBL_VAR)
WIN_SRC_DAR_GBL_VAR    := $(COMMON_SRC_DAR_GBL_VAR)
endif


# Objects and dependencies definition
OBJ_DAR         := $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$($(TP)SRC_DAR)))
OBJ_DAR_GBL_VAR := $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$($(TP)SRC_DAR_GBL_VAR)))
CFG_OBJS += $(OBJ_DAR)
CFG_DEPS += $(OBJ_DAR:.obj=.d)

ifneq ($(GSMLITE),1)
  CFG_OBJS += $(OBJ_DAR_GBL_VAR)
  CFG_DEPS += $(OBJ_DAR_GBL_VAR:.obj=.d)
endif


######## LIBRARIES #############
$(LIB_DAR) : $(OBJ_DAR)
	$(MKDIR) $(dir $@)
	$($(TP)LINKER) $($(TP)LFLAGS) $($(TP)LOUTOUT_FLAG)$@ $^

ifneq ($(GSMLITE),1)
$(LIB_DAR_GBL_VAR) : $(OBJ_DAR_GBL_VAR)
	$(MKDIR) $(dir $@)
	$($(TP)LINKER) $($(TP)LFLAGS) $($(TP)LOUTOUT_FLAG)$@ $^
endif


######## OBJECTS #############
$(OBJ_DAR) $(OBJ_DAR_GBL_VAR): $(TEMPORARY_FILE_DIR)/%.obj: ../%.c
	$($(TP)COMPILER) $($(TP)DAR_FLAGS) $($(TP)COUTPUT_FLAG)$(@D)/ $<
