#
#       Makefile for CST service (ARM compiler) 
#
#       Copyright (c) Texas Instruments 2001
# 
#               Author: Laurent Sollier
#       Date : 11 February 2002

# Compilation flags
CST_DEFS      := -dNTRACE -d_TARGET_ -dNEW_ENTITY -uFF_EM_MODE -dSHARED_VSI -dSMI -dNWARN -dOPTION_MULTITHREAD -dNEW_FRAME
#   Compilation flag for memory supervision
#CST_DEFS    := -dNTRACE -d_TARGET_ -dNEW_ENTITY -uFF_EM_MODE -dSHARED_VSI -dSMI -dNWARN -dOPTION_MULTITHREAD -dNEW_FRAME -dMEMORY_SUPERVISION

CST_IP        := -i$(ICDG) -i$(CONDAT_BASE_DIR)/ms/src/aci
CST_FLAGS     := $(NODBG) $(LENDIAN) $(16INST) -o2 $(INL) $(ALGN) $(CST_DEFS) $(CST_IP) $(CFLAGSSERVICES) -I$(ICDG)
WIN_CST_FLAGS :=

# Libraries definition
LIB_CST    := $(OUT_LIB_DIR)/cst.lib
#   Name of the lib for memory supervision
#LIB_CST     := $(OUT_LIB_DIR)/cst$(NPMODE)$(NCHP)$(NBRD)$(NNF)$(NNTRC)$(NWCP)_ps.lib 
CFG_LIBS    += $(LIB_CST)

# Source definition
COMMON_SRC_CST += $(SERVICES_DIR)/cst/cst_csf.c \
                  $(SERVICES_DIR)/cst/cst_exts.c \
                  $(SERVICES_DIR)/cst/cst_pei.c \
                  $(SERVICES_DIR)/cst/cst_stack.c
SRC_CST        += $(COMMON_SRC_CST)
WIN_SRC_CST    += $(COMMON_SRC_CST)

# Objects and dependencies definition
OBJ_CST  := $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$($(TP)SRC_CST)))
CFG_OBJS += $(OBJ_CST)
#Generation of dependencies is not performed for CST
#CFG_DEPS += $(OBJ_CST:.obj=.d)


######## LIBRARIES #############
$(LIB_CST) : $(OBJ_CST)
	$(MKDIR) $(dir $@)
	$($(TP)LINKER) $($(TP)LFLAGS) $($(TP)LOUTOUT_FLAG)$@ $^

######## OBJECTS #############
$(OBJ_CST) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.c
	$(MKDIR) -q $(dir $@)
	$($(TP)COMPILER) $($(TP)CST_FLAGS) $($(TP)COUTPUT_FLAG)$(@D)/ $<
