/********************************************************************************/
/*                                                                              */
/*    File Name:         atp_uart_env.h                                         */
/*                                                                              */
/*    Purpose:           This header file contains the prototypes used to:      */
/*                          - get some information about the ATP-UART           */
/*                            interface, such as its name or the memory         */
/*                            requirements,                                     */
/*                          - set the memory bank identifier dedicated to the   */
/*                            ATP-UART interface,                               */
/*                          - initialize the ATP-UART interface,                */
/*                          - activate the ATP-UART interface,                  */
/*                          - prepare the termination of the ATP-UART           */
/*                            interface,                                        */
/*                          - kill the ATP-UART interface.                      */
/*                                                                              */
/*    Note:              None.                                                  */
/*                                                                              */
/*    Revision History:                                                         */
/*       10/04/01        Pascal Pompei                                          */
/*                          - Create.                                           */
/*                                                                              */
/* (C) Copyright 2001 by Texas Instruments Incorporated, All Rights Reserved.   */
/*                                                                              */
/********************************************************************************/
#ifndef _ATP_UART_ENV_
#define _ATP_UART_ENV_

#include "atp/atp_pool_size.h"	/* Stack & Memory Bank sizes definitions */

/****************************** MEMORY REQUIREMENTS *****************************/
/*                                                                              */
/* Define the memory requirements of the ATP-UART interface.                    */
#define ATP_UART_MB_PRIM_SIZE          ATP_UART_MB1_SIZE
#define ATP_UART_MB_PRIM_WATERMARK     (ATP_UART_MB_PRIM_SIZE - 256)


/*************************** LOCAL FUNCTION PROTOTYPES **************************/
/*                                                                              */
/* Define the local fonction prototypes.                                        */
T_RVM_RETURN atp_uart_get_info (T_RVM_INFO_SWE  *info_software_entity_p);

T_RVM_RETURN atp_uart_set_info (T_RVF_ADDR_ID  addr_id,
								T_RV_RETURN    return_path_p[],
								T_RVF_MB_ID    *mb_id_p,
								T_RVM_CB_FUNC  error_function_p);

T_RVM_RETURN atp_uart_init (void);

T_RVM_RETURN atp_uart_core (void);

T_RVM_RETURN atp_uart_stop (void);

T_RVM_RETURN atp_uart_kill (void);
#endif
