/********************************************************************************/
/*                                                                              */
/*    File Name:         atp_uart_api.h                                         */
/*                                                                              */
/*    Purpose:           This header file contains the external constants and   */
/*                       prototypes related to the ATP-UART interface.          */
/*                                                                              */
/*    Note:              None.                                                  */
/*                                                                              */
/*    Revision History:                                                         */
/*       10/04/01        Pascal Pompei                                          */
/*                          - Create.                                           */
/*                                                                              */
/* (C) Copyright 2001 by Texas Instruments Incorporated, All Rights Reserved.   */
/*                                                                              */
/********************************************************************************/
#ifndef _ATP_UART_API_
#define _ATP_UART_API_

#include "rv/rv_general.h"

#ifdef __cplusplus
extern "C"
{
#endif


/**************************** ATP-UART INTERFACE NAME ***************************/
/*                                                                              */
/* Define the name assigned to the ATP-UART interface.                          */
#define ATP_UART_NAME                                 ("ATP-UART")

	
/***************************** INTERNAL ERROR CODES *****************************/
/*                                                                              */
/* Define the internal error codes.                                             */
typedef T_RV_RET  T_ATP_UART_ERROR_CODES;


/********************************** EVENTS MASK *********************************/
/*                                                                              */
/* Define a mask used to uniquely identify the events associated with the       */
/* ATP-UART interface.                                                          */
#define ATP_UART_EVENTS_MASK                          (0x8000)


/******************************* COM PORT SETTINGS ******************************/
/*                                                                              */
/* Define the COM port number.                                                  */
typedef enum
{
	ATP_UART_COM_PORT_1 = 0x00000001,
	ATP_UART_COM_PORT_2,
	ATP_UART_COM_PORT_3,
	ATP_UART_COM_PORT_4
} T_ATP_UART_COM_PORT;

/* Define the baud rate (in bits per second).                                   */
typedef enum
{
	ATP_UART_BAUD_RATE_9600   = 9600,
	ATP_UART_BAUD_RATE_19200  = 19200,
	ATP_UART_BAUD_RATE_38400  = 38400,
	ATP_UART_BAUD_RATE_57600  = 57600,
	ATP_UART_BAUD_RATE_115200 = 115200
} T_ATP_UART_BAUD_RATE;


/****************************** COM PORT ACTIVATION *****************************/
/*                                                                              */
/* Define a structure used to instruct the ATP-UART interface to open the COM   */
/* port.                                                                        */
/*                                                                              */
/* Opcode: ATP_UART_OPEN_COM_PORT.                                              */
#define ATP_UART_OPEN_COM_PORT                        (0x001C | ATP_UART_EVENTS_MASK)

typedef struct
{
	T_RV_HDR              os_header;
	T_ATP_UART_COM_PORT   com_port;
	T_ATP_UART_BAUD_RATE  baud_rate;
} T_ATP_UART_OPEN_COM_PORT;


/******************************** GSM ACTIVATION ********************************/
/*                                                                              */
/* Define a structure used to instruct the ATP-UART interface to initiate using */
/* the GSM protocol stack.                                                      */
/*                                                                              */
/* Opcode: ATP_UART_START_GSM.                                                  */
#define ATP_UART_START_GSM                            (0x002C | ATP_UART_EVENTS_MASK)

typedef struct
{
	T_RV_HDR  os_header;
} T_ATP_UART_START_GSM;


/*************************** LOCAL FUNCTION PROTOTYPES **************************/
/*                                                                              */
/* Define the local fonction prototypes.                                        */
T_ATP_UART_ERROR_CODES atp_uart_open_com_port (T_ATP_UART_COM_PORT   com_port,
											   T_ATP_UART_BAUD_RATE  baud_rate);

T_ATP_UART_ERROR_CODES atp_uart_start_gsm (void);

#ifdef __cplusplus
}
#endif

#endif
