/*******************************************************************************
*
* File Name : atp_spp_api_i.h
*
* Internal Definitions for the interface between ATP and SPP SW entity
*
* (C) Texas Instruments, all rights reserved
*
* Version number	: 0.1      Date : 16-Marsh-2000
*
* History			: 0.1  - Created by E. Baissus
*
*
* Author			: Eric Baissus : e-baissus@ti.com
*
*   (C) Copyright 2000 by Texas Instruments Incorporated, All Rights Reserved
******************************************************************************/
#ifndef ATP_SPP_API_I_H
#define ATP_SPP_API_I_H


#include "rv/rv_general.h"
#include "rvf/rvf_api.h"
#include "spp_general.h"
#include "spp_up_interface.h"

// Structure used to store the 'open pending port' information


typedef struct 
{
	T_ATP_SW_ENTITY_ID initiator_id;
	T_ATP_PORT_NB port_nb;
	T_SPP_HANDLE handle;
} T_ATP_SPP_PENDING_PORT_INFO;


typedef enum
{
	ATP_SPP_IS_IND,
	ATP_SPP_IS_CFM
} T_ATP_SPP_IS_IND_OR_CFM;


void atp_spp_to_spp_if_ft(void * message_p);
T_RV_RET atp_spp_open_port_rqst(T_ATP_OPEN_PORT_IND * open_port_ind_p);
T_RV_RET atp_spp_open_port_rsp(void * spp_open_port_rsp_p,T_ATP_SPP_IS_IND_OR_CFM cfm_or_ind);
T_RV_RET atp_spp_port_closed_from_atp(T_ATP_PORT_CLOSED * close_port_p);
T_RV_RET atp_spp_send_to_spp_buffer_nc(T_ATP_NO_COPY_DATA_RDY * atp_no_copy_p);
void atp_spp_from_spp_if_ft(void * message_p);
T_RV_RET atp_spp_reg(void);
T_RV_RET atp_spp_set_atp_signals(T_SPP_LINE_STS * message_p);
T_RV_RET atp_spp_set_spp_signals(T_ATP_SIGNAL_CHANGED * message_p);


#endif

