/*******************************************************************************
*
* File Name : atp_spp_api.h
*
* Definitions for the interface between ATP and SPP SW entity
*
* (C) Texas Instruments, all rights reserved
*
* Version number	: 0.1      Date : 16-Marsh-2000
*
* History			: 0.1  - Created by E. Baissus
*
*
* Author			: Eric Baissus : e-baissus@ti.com
*
*   (C) Copyright 2000 by Texas Instruments Incorporated, All Rights Reserved
******************************************************************************/
#ifndef ATP_SPP_API_H
#define ATP_SPP_API_H


#include "rv/rv_general.h"
#include "rvf/rvf_api.h"
#include "l2cap_gen.h"
#include "spp_general.h"
#include "atp/atp_api.h"

#define SPP_ALL_THE_EVENTS (0xFF)
#define SPP_RX_HEAD_SIZE (SPP_TX_OFFSET)
#define SPP_RX_TRAIL_SIZE (SPP_TX_LENGTH-(SPP_TX_OFFSET))


/* Types and definition used between ATP and SPP */
typedef enum
{
	ATP_IS_SERVER,
	ATP_IS_CLIENT
} T_ATP_IS_SERVER;


/* Custom information used during a new open port request to spp */
typedef enum
{
	ATP_PAYLOAD_LENGTH_RENEG_ON,
	ATP_PAYLOAD_LENGTH_RENEG_OFF
} T_ATP_PAYLOAD_LENTH_RENEG_EN;

typedef enum
{
	ATP_AUTOMATIC_FLOW_CTRL_ON,
	ATP_AUTOMATIC_FLOW_CTRL_OFF
} T_ATP_SPP_FLOW_CONTROL_MODE;

typedef struct
{
	T_ATP_CUSTOM_TYPE custom_type;
	T_BD_ADDR bd_addr;
	UINT16 server_channel;
	UINT16 max_payload_length; // max = 32 KBytes
	T_ATP_PAYLOAD_LENTH_RENEG_EN max_payload_length_reneg_en;
	T_RVF_MB_ID rx_mb;
	T_ATP_SPP_FLOW_CONTROL_MODE flow_ctrl_mode;
	T_ATP_IS_SERVER is_server;
} T_ATP_CUSTOM_TO_SPP_INFO;

/* Custom information used during a new open port response by spp */
typedef struct
{
	T_ATP_CUSTOM_TYPE custom_type;
	T_BD_ADDR bd_addr;
	UINT16 max_payload_length;
} T_ATP_CUSTOM_FROM_SPP_INFO;

/* Custom Commands exchanged with SPP : see atp_send_cmd and ATP_CMD_RDY definitions*/
#define ATP_FROM_SPP_MAX_PAYLOAD_IND_CMD (0) // custom info is the payload value (UINT32)
#define ATP_FROM_SPP_REG_SERVER_ERROR (1) // No custom info
 

extern T_RV_RET atp_spp_init(T_RVF_ADDR_ID addr_id, T_RVF_MB_ID mb_id);
extern T_RV_RET atp_spp_start(void);

#endif

