/*******************************************************************************
 *
 * File Name : atp_gsm_gsm_api.h
 *
 * Definition used by atp_gsm_gsm_api.c
 *
 * (C) Texas Instruments, all rights reserved
 *
 * Version number	: 0.1      Date : 10-Jully-2000
 *
 * History			: 0.1  - Created by E. Baissus
 *
 *
 * Author           : 
 *
 *   (C) Copyright 2000 by Texas Instruments Incorporated 
 ******************************************************************************/

#ifndef ATP_GSM_GSM_API_H
#define ATP_GSM_GSM_API_H


#include "atp/atp_gsm_bt_api.h"
#include "atp/bti_at.h"

#include "rvm/rvm_api.h"
#define AAA_SWE_FROM_GSM	// define for new parameter to send to GSM PS


/* functions define in GSM side and called by BT side */
void bti_at_init_cnf(T_BTI_ACK ack); 
void bti_at_deinit_ind(void);  
void bti_at_open_port_ind(T_BTI_PORT_NB gsm_port_nb,T_BTI_BT_PORT_INFO bt_custom_info);
void bti_at_close_port_ind(T_BTI_PORT_NB gsm_port_nb);
void bti_at_cmd_ind(T_BTI_PORT_NB gsm_port_nb,char * cmd);
void bti_at_cmd_cnf(T_BTI_PORT_NB gsm_port_nb);
void bti_at_abort_ind(T_BTI_PORT_NB gsm_port_nb);
void bti_data_ready_ind(T_BTI_PORT_NB port_nb,unsigned long nb_of_data);
void bti_get_gsm_data(T_BTI_PORT_NB port_nb,char * buffer, unsigned long nb_of_data);
void bti_data_ready_cnf(T_BTI_PORT_NB port_nb);

/* Custom information between GSM and ATP */
typedef struct
{
	T_ATP_CUSTOM_TYPE custom_type;
	UINT32 optimal_gsm_max_packet_size; /* Indication of what would be the optimal size of packet received by GSM */
										/* 0 Means do not care */
} T_ATP_CUSTOM_FROM_GSM_INFO;


typedef struct
{
	T_ATP_CUSTOM_TYPE custom_type;
	UINT32 bt_max_payload; /* Maximum size of data that can be sent from GSM to Bluetooth (in bytes)*/								
						   /* Should be equal to MFS - overhead due to RFCOMM...*/
#ifdef AAA_SWE_FROM_GSM
	T_RVM_USE_ID rnet_use_id;
#endif
} T_ATP_CUSTOM_TO_GSM_INFO;


#endif


