/*******************************************************************************
 *
 * File Name : atp_gsm_bt_api.h
 *
 * Definition used by atp_gsm_bt_api.c
 *
 * (C) Texas Instruments, all rights reserved
 *
 * Version number	: 0.1      Date : 10-Jully-2000
 *
 * History			: 0.1  - Created by E. Baissus
 *
 *
 * Author           : Eric Baissus : e-baissus@ti.com
 *
 ******************************************************************************/

#ifndef ATP_GSM_BT_API_H
#define ATP_GSM_BT_API_H

#include "atp/bti_at.h" 


/* Extern function for GSM definition */
/******************************************************************************
* Function name: bti_at_init_req
*
* Description : This function is called by GSM in order to register GSM to BT PS.
*				
*
* Parameters :  None
*
* Return     :   None // function bti_at_init_cnf() used to issue result
*
* History			: 0.1 (10-Jully-2000)
*					  0.2 (01-Jan-2001) 
*
******************************************************************************/
void bti_at_init_req(void);


/******************************************************************************
* Function name: bti_at_deinit_ind
*
* Description : This function is called by GSM to de-register GSM from BT PS
*				Not Used
*
* Parameters :  None
*
* Return     :   None
*				
*
* History			: 0.1 (10-Jully-2000)
*					  0.2 (01-Jan-2001) 
*
******************************************************************************/
void bti_at_deinit_req(void);


/******************************************************************************
* Function name: bti_at_open_port_res
*
* Description : This function is called by GSM to accept or refuse
*				an open port request issued by BT side
*
*
* Parameters :  gsm_port_nb = number of the gsm port
*				bti_gsm_port_info = custom information to open a GSM/GPRS port
*				result	= BTI_ACK or BTI_NAK 
*
* Return     :   None
*				
*
* History			: 0.1 (10-Jully-2000)
*					  0.2 (01-Jan-2001) 
*
******************************************************************************/
void bti_at_open_port_res(T_BTI_PORT_NB gsm_port_nb,
						  T_BTI_GSM_PORT_INFO gsm_port_info,
						  T_BTI_ACK ack);


/******************************************************************************
* Function name: bti_at_close_port_res
*
* Description : Not used by BT PS - Port is always closed whatever the 
*				acknowledge is
*
* Parameters :  gsm_port_nb = number of the gsm port
*
* Return     :   None
*				
*
* History			: 0.1 (10-Jully-2000)
*
******************************************************************************/
void  bti_at_close_port_res(T_BTI_PORT_NB gsm_port_nb);


/******************************************************************************
* Function name: bti_at_cmd_req
*
* Description : This function is called by GSM to provide unsollicited code
*				or information text to BT PS 
*
* Parameters :  gsm_port_nb = number of the gsm port
*				cmd = command in text format
*
* Return     :   None
*				
*
* History			: 0.1 (10-Jully-2000) 
*
******************************************************************************/
void  bti_at_cmd_req(T_BTI_PORT_NB gsm_port_nb,
					 char * cmd);


/******************************************************************************
* Function name: bti_at_cmd_res
*
* Description : This function is called by GSM to provide result code to BT
*
* Parameters :  gsm_port_nb = number of the gsm port
*				cmd = command in text format
*
* Return     :   None
*				
*
* History			: 0.1 (10-Jully-2000) 
*
******************************************************************************/
void  bti_at_cmd_res(T_BTI_PORT_NB gsm_port_nb,
					 char * cmd);


/******************************************************************************
* Function name: bti_at_abort_res
*
* Description : This function is called by GSM to comfirm a command abort
*			
*
* Parameters :  gsm_port_nb = number of the gsm port
*
* Return     :   None
*				
*
* History		: 0.1 (10-Jully-2000) 
*
******************************************************************************/
void  bti_at_abort_res(T_BTI_PORT_NB gsm_port_nb);



/******************************************************************************
* Function name: bti_get_bt_data
*
* Description : This function is called by GSM to get data from BT side . 
*				Copy is processed by BT side
*
* Parameters :  gsm_port_nb = number of the gsm port
*				data_buffer = pointer on a buffer in which data can be copied  
*				nb_bytes_to_copy = number of bytes to copy into data_buffer
*
* Return     :  None 
*			
*
* History			: 0.1 (10-Jully-2000) 
*					  0.2 (01-Jan-2001) 
*
******************************************************************************/
void bti_get_bt_data (T_BTI_PORT_NB gsm_port_nb,
					  char * data_buffer,
					  unsigned long nb_bytes_to_copy);



/******************************************************************************
* Function name: bti_data_ready_req
*
* Description : This function is called by GSM to indicate that data are 
*				available for BT PS.
*				 				
*
* Parameters :  gsm_port_nb = number of the gsm port
*				nb_bytes_available = number of bytes of data available
*
* Return     :  None
*
* History			: 0.1 (10-Jully-2000) 
*					  0.2 (01-Jan-2001) 
*
******************************************************************************/
void bti_data_ready_req (T_BTI_PORT_NB gsm_port_nb,
						 unsigned long  nb_bytes_available);


/******************************************************************************
* Function name: bti_data_ready_res
*
* Description : This function is called by GSM to indicate that it can receive 
*				new data from BT PS
*				 				
*
* Parameters :  gsm_port_nb = number of the gsm port
*
* Return     :  None
*
* History			: 0.1 (10-Jully-2000) 
*					  0.2 (01-Jan-2001) 
*
******************************************************************************/
void bti_data_ready_res (T_BTI_PORT_NB gsm_port_nb);


/******************************************************************************
* Function name: bti_at_signal_change_req
*
* Description : This function is called by GSM to provide a new signal line status 
*				to BT
*				 				
*
* Parameters :  gsm_port_nb = number of the gsm port
*				dce_signal = signal value
*				ring_type_1 = voice, data or fax
*				ring_type_2 = not used
*
* Return     :  None
*
* History			: 0.1 (01-Jan-2001) 
*
******************************************************************************/
void bti_at_signal_change_req (T_BTI_PORT_NB gsm_port_nb,
							   T_BTI_AT_DCE_SIGNAL dce_signal,
							   T_BTI_AT_RING_TYPE ring_type_1,
							   T_BTI_AT_RING_TYPE ring_type_2);


#endif
