#
#       Makefile for the ATP (Agnostic TransPort) Riviera service (ARM compiler) 
#
#       Copyright (c) Texas Instruments 2001
# 
#               Author: Cristian Livadiotti
#       Date : 12 December 2001


# Compilation flags
ATP_FLAGS     = $(NODBG) $(16INST) -mn $(CFLAGSSERVICES_ATP)
WIN_ATP_FLAGS = $($(TP)CFLAGS) $(CFLAGSSERVICES_ATP)


# Libraries definition
LIB_ATP   := $(OUT_LIB_DIR)/atp.lib
CFG_LIBS  += $(LIB_ATP)


# Source definition
ifdef ATP_SOURCE
COMMON_SRC_ATP := $(SERVICES_DIR)/atp/atp_cmd.c \
                  $(SERVICES_DIR)/atp/atp_env.c \
                  $(SERVICES_DIR)/atp/atp_services.c \
                  $(SERVICES_DIR)/atp/atp_sw_ent.c \
                  $(SERVICES_DIR)/atp/atp_port.c \
                  $(SERVICES_DIR)/atp/atp_gsm_bt_api.c

SRC_ATP        += $(COMMON_SRC_ATP) \
                  $(SERVICES_DIR)/atp/atp_gsm_bt_api_misc.c
ifdef BLUETOOTH
SRC_ATP        += $(SERVICES_DIR)/atp/atp_spp_api.c
endif

WIN_SRC_ATP    += $(COMMON_SRC_ATP) \
                  $(SERVICES_DIR)/atp/atp_gsm_gsm_api_dummy.c \
                  $(SERVICES_DIR)/atp/atp_uart.c \
                  $(SERVICES_DIR)/atp/atp_uart_api.c \
                  $(SERVICES_DIR)/atp/atp_uart_env.c \
                  $(SERVICES_DIR)/atp/atp_uart_handle_msg.c
endif


# Objects and dependencies definition
OBJ_ATP  := $(patsubst ../%.c,$(TEMPORARY_FILE_DIR)/%.obj,$(filter %.c,$($(TP)SRC_ATP)))
CFG_OBJS += $(OBJ_ATP)
CFG_DEPS += $(OBJ_ATP:.obj=.d)


######## LIBRARIES #############
$(LIB_ATP) : $(OBJ_ATP)
	$(MKDIR) $(dir $@)
	$($(TP)LINKER) $($(TP)LFLAGS) $($(TP)LOUTOUT_FLAG)$@ $^

######## OBJECTS #############
$(OBJ_ATP) : $(TEMPORARY_FILE_DIR)/%.obj: ../%.c
	$($(TP)COMPILER) $($(TP)ATP_FLAGS) $($(TP)COUTPUT_FLAG)$(@D)/ $<

