/*******************************************************************************
 *
 * File Name : bti_at.h
 *
 * Common definition used by GSM PS and BT PS 
 *
 * (C) Texas Instruments, all rights reserved
 *
 * Version number	: 0.1      Date : 02-Jan-2001
 *
 ******************************************************************************/


#ifndef BTI_AT_H
#define BTI_AT_H



/* Acknowledgment */
typedef enum
{
  BTI_NAK   = 0, /* failure */
  BTI_ACK   = 1  /* success */
}T_BTI_ACK;

/* Port Number */
typedef unsigned char  T_BTI_PORT_NB;

/* Custom information provided by GSM when opening a port */
typedef struct 
{
	unsigned long optimal_gsm_max_packet_size; 
	// GSM indicates in this parameter the best maximum packet size that should be used by BT
	// 0 means do not care
} T_BTI_GSM_PORT_INFO; // Information provided by GSM related to the port 


/* Custom information provided by BT when opening a port */
typedef struct 
{
	unsigned long optimal_bt_max_packet_size;
	// BT indicates in this parameter the best maximum packet size that should be used by GSM
	// 0 means do not care
} T_BTI_BT_PORT_INFO; // Information provided by BT related to the port

/* Ring type */
typedef enum
{
  BTI_AT_RING_NotPresent, /* no bearer cap available */
  BTI_AT_RING_Async, /* transparent data */
  BTI_AT_RING_Sync, /* currently not used */
  BTI_AT_RING_RelAsync, /* non transparent data */
  BTI_AT_RING_RelSync, /* currently not used */
  BTI_AT_RING_Fax,
  BTI_AT_RING_Voice,
  BTI_AT_RING_AuxVoice,
  BTI_AT_RING_GPRS
}T_BTI_AT_RING_TYPE;

/* Line status information from DCE (ie GSM) */
typedef unsigned char  T_BTI_AT_DCE_SIGNAL;
#define BTI_AT_RING_OFF (0)
#define BTI_AT_RING_ON (1)
#define BTI_AT_RING_MASK (1)
#define BTI_AT_DCD_OFF (0)
#define BTI_AT_DCD_ON (2)
#define BTI_AT_DCD_MASK (2)

#endif
